<?php 
namespace Catalog\Attribute\Admin\Controller;
use WebsiteControl\Base\AbstractModule;
use Base\Db\DataTable as DataTable;

class IndexController extends AbstractModule
{
	function __construct()
	{
		
	}
	
	public function AddEditAttributeAction()
	{
		if(count($_POST)>0)
		{
			$AttributeObj = new DataTable(TABLE_ATTRIBUTE);
			$SeoObj = new DataTable(TABLE_SEO);
			$AttributeID = isset($_GET['AttributeID'])?$_GET['AttributeID']:0;


			$DataArray = array();
			$DataArray['Active'] = isset($_POST['Active'])?$_POST['Active']:0;
			
			$DataArray['AttributeName'] = isset($_POST['AttributeName'])?$_POST['AttributeName']:"";
			
			if(isset($_POST['Template']) && $_POST['Template'] !="")
				$DataArray['Template'] = $_POST['Template'];
			
			$DataArray['Description'] = isset($_POST['Description'])?$_POST['Description']:"";
			/* image added*/
			$DataArray['Image'] = $this->getClass("Cms\Pages\Image")->AddEditFile("Upload","catalog_attribute",'attribute',$DataArray['AttributeName']);
			/* image end*/
			
			if($AttributeID > 0)
			{
				
				$AttributeObj->where[] = array('=',array('AttributeID' => $AttributeID));
				$AttributeObj->tableUpdate($DataArray);
				$this->getSession()->setArrVar("alert",array("success","Attribute updated successfully."));
				
			}
			else 
			{
							
				$AttributeObj->where ="1";
				$Position = $AttributeObj->getMax("Position") + 1;
				
				$DataArray['Position'] = $Position;
				$DataArray['CreatedDate'] =date('Y-m-d H:i:s');
				
				$AttributeID = $AttributeObj->tableInsert($DataArray);		
				$this->getSession()->setArrVar("alert",array("success","Attribute added successfully."));
				
			}
			
			if(isset($_POST['AttributeValue'])){
				$AttributeValueIDArr = $this->getAllAttrbuteValuesIDs($AttributeID);
				$UpdatedAttributeValueIDArr = array();
				
				foreach ($_POST['AttributeValue'] as $k=>$v){
					$AttributeValueObj = new DataTable(TABLE_ATTRIBUTE_VALUE);
					$SubDataArray = array();
					$AttributeValueID = $_POST['AttributeValueID'][$k]?:0;
					$SubDataArray['AttributeValue'] =$_POST['AttributeValue'][$k]?? "";
					$SubDataArray['AttributeLine'] =$_POST['AttributeLine'][$k]?? "";
					$SubDataArray['Active'] = $_POST['AttributeActive'][$k]?: "0"; 
					$SubDataArray['Position'] = $_POST['Position'][$k]?: "0";  
					$SubDataArray['Image'] = $this->getClass("Cms\Pages\Image")->AddEditFile("ImageUpload[".$k."]","catalog_attribute",'attribute',$SubDataArray['AttributeValue']);
					
					
					if($SubDataArray['AttributeValue'] != ""){
						if($AttributeValueID > 0){
							$UpdatedAttributeValueIDArr[] = $AttributeValueID;
							$AttributeValueObj->where[] = array('=',array('AttributeID' => $AttributeID));
							$AttributeValueObj->where[] = array('=',array('AttributeValueID' => $AttributeValueID));
							$AttributeValueObj->tableUpdate($SubDataArray);
							
						}
						else{
							$SubDataArray['AttributeID'] =$AttributeID;
							$SubDataArray['CreatedDate'] =date('Y-m-d H:i:s');
							$AttributeValueObj->tableInsert($SubDataArray);
						}
					}
					//var_dump($AttributeValueID,$SubDataArray,"<hr>");
					
				}
				
				/* Delete AttributeValueIds*/
				$DeletedAttributeValueIDArr = array_diff($AttributeValueIDArr,$UpdatedAttributeValueIDArr);
				if(is_array($DeletedAttributeValueIDArr) && count($DeletedAttributeValueIDArr) > 0){
					foreach($DeletedAttributeValueIDArr as $DeleteID){
						$AttributeValueObj = new DataTable(TABLE_ATTRIBUTE_VALUE);
						$AttributeValueObj->where[] = array('=',array('AttributeValueID' => $DeleteID));
						$AttributeValueObj->tableDelete();
					}
				}
				/* Delete AttributeValueIds END*/
				
			}
		
			if(isset($_POST['Continue'])){	
				MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=AddEditAttribute&AttributeID=$AttributeID");
				exit;
		    }
			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&AttributeID=$AttributeID");
		    exit;
		}
		
	}
	public function UpdateAttributeAction()
	{
		if(count($_POST)>0)
		{
			
			for ($i=1;$i <$_POST['Count'];$i++)
			{
				$AttributeObj = new DataTable(TABLE_ATTRIBUTE);
				$AttributeID =$_POST['AttributeID_'.$i];
				$DataArray = array();
				$DataArray['Active'] = isset($_POST['Active_'.$i])?$_POST['Active_'.$i]:0;
				$DataArray['Position'] = (isset($_POST['Position_'.$i]) && $_POST['Position_'.$i] > 0)?$_POST['Position_'.$i]:0;
				$AttributeObj->where[] = array('=',array('AttributeID' => $AttributeID));
				$AttributeObj->tableUpdate($DataArray);
				
			}
			$this->getSession()->setArrVar("alert",array("success","Attribute updated successfully."));
			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&PageNo=".$this->origin->PageNo);
			 exit;
		}
	}
	
	public function DeleteAttributeAction()
	{
		$AttributeID = isset($_GET['AttributeID'])?$_GET['AttributeID']:0;
		if($AttributeID > 0)
		{
			$AttributeObj = new DataTable(TABLE_ATTRIBUTE);
			$AttributeObj->where[] = array('=',array('AttributeID' => $AttributeID));
			$AttributeObj->tableDelete();								
			
			$SeoObj = new DataTable(TABLE_SEO);
			$SeoObj->where = "ReferenceID = ".$AttributeID." AND MCode ='catalog_Attribute' ";
			$SeoObj->tableDelete();		
		}			
		
		$this->getSession()->setArrVar("alert",array("success","Attribute deleted successfully."));
		MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&ParentID=".$this->origin->ParentID);
		 exit;
	}
	public function getList()
	{
		$AttributeObj = new DataTable(TABLE_ATTRIBUTE);
		$AttributeObj->where="1";
		
		$AttributeObj->AllowPaging =true;
		$AttributeObj->PageSize=100;
		$AttributeObj->PageTotalDisplay = 15; 
		$AttributeObj->PageNo =isset($_GET['PageNo'])?$_GET['PageNo']:1;	
		$this->paging = $AttributeObj;
		return $AttributeObj->tableSelectAll(array("*"),array("Position ASC","AttributeName ASC"));
	
	}
	public function getAllAttrbuteValues($AttributeID)
	{
		$AttributeValueObj = new DataTable(TABLE_ATTRIBUTE_VALUE);
		$AttributeValueObj->where[] = array('=',array('AttributeID' => $AttributeID));
		
		return $AttributeValueObj->tableSelectAll(array("*"),array("Position ASC","AttributeValueID ASC"));
	
	}
	public function getAllAttrbuteValuesIDs($AttributeID)
	{
		$AttributeValueObj = new DataTable(TABLE_ATTRIBUTE_VALUE);
		$AttributeValueObj->where[] = array('=',array('AttributeID' => $AttributeID));		
		$AttributeValueObj->columnExpression = true;
		$Obj  = (object)$AttributeValueObj->tableSelectOne(array("GROUP_CONCAT(AttributeValueID) as AttributeValueIDs"));
		return explode(",",$Obj->AttributeValueIDs);
	
	}
	
	public function productCount($AttributeID)
	{
		$ProductAttributeObj = new DataTable(TABLE_PRODUCT_RELATION);
		$ProductAttributeObj->where="Relationtype='Attribute' AND RelationID ='".(int)$AttributeID."'";
		$ProductAttributeObj->columnExpression=true;
		$Obj = $ProductAttributeObj->tableSelectOne(array('Total'=>'Count(*)'));
		
		return $Obj['Total'] > 0?$Obj['Total']:0;
	}
	
	public function getDetail($AttributeID)
	{
		if($AttributeID > 0)
		{
			$AttributeObj = new DataTable(array('p'=>TABLE_ATTRIBUTE));
			$AttributeObj->where[] = array('=',array('p.AttributeID' => $AttributeID));
			return (object)$AttributeObj->tableSelectOne();
		
		}
		return ;
	
	}
	
	public function imageAttribute($Image)
	{
		if(isset($Image) && $Image !="" && file_exists(DIR_FS_SITE_UPLOADS."attribute/".$Image))
			return DIR_FS_SITE_UPLOADS."attribute/".$Image;
		
		return false;
	}
	
	public function imageAttributeURL($Image)
	{
		if(isset($Image) && $Image !="" && file_exists(DIR_FS_SITE_UPLOADS."attribute/".$Image))
			return DIR_WS_SITE_UPLOADS."attribute/".$Image;
		
		return false;
	}
	
	public function pageTitle()
	{
		return "Attributes";
	}
	
	public function pageRight()
	{
		return '<div class="title_right">
					<div class="pull-right">
						  <a class="btn btn-primary" href="'.DIR_WS_SITE_CONTROL.'index.php?m='.$this->module.'&view=AddEditAttribute">Add Attribute</a>
					</div>
              </div>		
			   ';
	}
	
	
}	