<?php 
namespace Catalog\Product\ProductType;
use Frontend\Base\AbstractModule;
use Base\Db\DataTable as DataTable;
use Base\Currency\CurrencyHandler as CurrencyHandler;
use Base\File\FileHandle as FileHandle;
use Laminas\Db\Sql\Where;

class Attribute_2D extends AbstractModule 
{
	function __construct()
	{
		
	}
	function AddProductInTmpCart($ID,$Qty=1,$Attribute1 ="",$PostArray = array())
	{
		$AlertArray = array();
		$SessionID = $this->getSession()->getCurrentSID();
		$MasterID =	$ID;
		$ProductObj = new DataTable(TABLE_PRODUCT);
		$ProductObj->where[] = array('=',array('ProductID' => $MasterID));
		if(isset($GLOBALS['UserIDByAdmin']) && $GLOBALS['UserIDByAdmin'] != "")
		{
				//$ProductObj->where[] = array('=',array('Active' => "1"));
		}
		else
		{
			$ProductObj->where[] = array('=',array('Active' => "1"));
		}
		
		$CurrentProduct = (object)$ProductObj->tableSelectOne(array("ProductType","ProductID","MasterID","TaxClass","ProductName","ModelNo","Weight",
																	"VirtualProduct","FreeShippingStatus","GiftVoucherStatus",
																	"Stock","StockStatus","StockTotal","EndStock",
																	"PurchaseOnline","NotForSale","SignedIn","ShippingProductID"));																	
		
		
		
		
		if(!isset($CurrentProduct->ProductID))
			$AlertArray[] = array("danger","Something went wrong");
		
		 if($arr==NULL || count($arr)==0)	{
			/* add Attribute_2D product section start */
			if(isset($CurrentProduct->ProductType) && $CurrentProduct->ProductType == "Attribute_2D"){
				
				 $PriceArray = $this->getClass('Catalog\Product\Common')->GetProductPriceNStock($CurrentProduct->ProductID,$Qty,$PostArray);
				 $L = isset($PostArray['LongSide'])?$PostArray['LongSide']:"";
				 $W = isset($PostArray['ShortSide'])?$PostArray['ShortSide']:"";
				  
				$TotalLength = 2*(($L+$W)/1000);
				$Price = (isset($PriceArray['Array']['Price'])?$PriceArray['Array']['Price']:"0");
				$RaisedPrice = (isset($PriceArray['Array']['RaisedPrice'])?$PriceArray['Array']['RaisedPrice']:"0");
				$PriceRaiseBy = (isset($PriceArray['Array']['PriceRaiseBy'])?$PriceArray['Array']['PriceRaiseBy']/1000:"0");
				$SecondPrice = (isset($PriceArray['Array']['SecondPrice'])?$PriceArray['Array']['SecondPrice']:"0");
				$SecondRaisedPrice = (isset($PriceArray['Array']['SecondRaisedPrice'])?$PriceArray['Array']['SecondRaisedPrice']:"0");
				$SecondPriceRaiseBy = (isset($PriceArray['Array']['SecondPriceRaiseBy'])?$PriceArray['Array']['SecondPriceRaiseBy']/1000:"0");
				$ThirdPartyPrice = (isset($PriceArray['Array']['ThirdPartyPrice'])?$PriceArray['Array']['ThirdPartyPrice']:"0");
				
				$LoyaltyDiscountActive = (isset($PriceArray['LoyaltyDiscountActive'])?$PriceArray['LoyaltyDiscountActive']:"0");
				$DiscountPercent = (isset($PriceArray['DiscountPercent'])?$PriceArray['DiscountPercent']:"0");
				$TaxInPrice = (isset($PriceArray['TaxInPrice'])?$PriceArray['TaxInPrice']:"0");
				$TaxPercent = (isset($PriceArray['TaxPercent'])?$PriceArray['TaxPercent']:"0");
				$TaxPrice = 0;
				
				if($TotalLength >= 5){
					$ExtraLength = $TotalLength -5;
					$MeasurementPrice = $SecondPrice + ($SecondRaisedPrice*($ExtraLength/$SecondPriceRaiseBy)); 
					
					
				}
				else{
					$ExtraLength = $TotalLength -1;
					$MeasurementPrice = $Price + ($RaisedPrice*($ExtraLength/$PriceRaiseBy));  
				}
				$TotalPrice = $MeasurementPrice + $ThirdPartyPrice;
				if($LoyaltyDiscountActive==1 && $DiscountPercent > 0){
					$DiscountPrice = ($DiscountPercent * $TotalPrice)/100;
					$TotalPrice = $TotalPrice - $DiscountPrice;
				}
				
				$TotalPriceWithTax = $TotalPrice;
				if($TaxInPrice==0 && $TaxPercent > 0){
					$TaxPrice = ($TaxPercent * $TotalPrice)/100;
					$TotalPriceWithTax = $TotalPrice + $TaxPrice;
				}
				
				 $ItemStatus ="Normal";
				 $ItemType ="Product";
				 $ItemName = isset($CurrentProduct->ProductName)?$CurrentProduct->ProductName:"";
				 $ItemNo = isset($CurrentProduct->ModelNo)?$CurrentProduct->ModelNo:"";
				 $ReferenceID = isset($CurrentProduct->ProductID)?$CurrentProduct->ProductID:"";
				 $ProductID = isset($CurrentProduct->ProductID)?$CurrentProduct->ProductID:"";
				 $Comments = isset($PostArray['Comments'])?$PostArray['Comments']:"";
				
			
				$ItemID = uniqid("Item_");
				$DataArray = array();
				$DataArray['ItemID'] = $ItemID;
				$DataArray['ItemType'] = $ItemType;
				$DataArray['ItemStatus'] = $ItemStatus;
				$DataArray['ReferenceID'] = $ReferenceID;
				$DataArray['ItemName'] = $ItemName;
				$DataArray['ItemNo'] =$ItemNo;
				$DataArray['Attribute1'] = md5(serialize($PostArray));
				$DataArray['Attribute2'] = serialize($PostArray);
				
				$DataArray['Width'] = (isset($CurrentProduct->Width) && $CurrentProduct->Width > 0)?$CurrentProduct->Width:"0";
				$DataArray['Height'] = (isset($CurrentProduct->Height) && $CurrentProduct->Height > 0)?$CurrentProduct->Height:"0";
				$DataArray['Length'] = (isset($CurrentProduct->Length) && $CurrentProduct->Length > 0)?$CurrentProduct->Length:"0";
				$DataArray['Weight'] = (isset($CurrentProduct->Weight) && $CurrentProduct->Weight > 0)?$CurrentProduct->Weight:"0";
				
				$DataArray['UnitPrice'] = $TotalPrice;
				$DataArray['TaxPercent'] = $TaxPercent;
				$DataArray['Price'] = 	   $TotalPrice;
				$DataArray['TaxPrice'] = $TaxPrice;
				$DataArray['VoucherAmount'] = "0";
				$DataArray['VoucherText'] = "";
				$DataArray['VoucherCode'] = "";
				
				$DataArray['ActualPrice'] = $DataArray['Price'];
				$DataArray['ActualPriceWithTax'] = $DataArray['Price'] + $DataArray['TaxPrice'];
				
				$DataArray['TaxPrice'] = (($DataArray['Price']  * $DataArray['TaxPercent'])/100);
				$DataArray['PriceWithTax'] = $DataArray['Price'] + $DataArray['TaxPrice'];
				$DataArray['Qty'] = isset($PriceArray['Qty'])?$PriceArray['Qty']:"";
				$DataArray['Total'] = $DataArray['Price'] * $DataArray['Qty'];
				$DataArray['TotalWithTax'] = $DataArray['PriceWithTax'] * $DataArray['Qty'];
										
				
				$DataArray['Comments'] = $Comments;		
				$DataArray['SessionInfo'] = base64_encode(serialize($PostArray));		
				$DataArray['SessionID'] = $SessionID;

				//echo "<pre>";var_dump($DataArray);exit;	
				
				$TmpCartObj = new DataTable(TABLE_TMPCART);
				$TmpCartObj->where[] = array('=',array('SessionID' => $SessionID));
				$TmpCartObj->where[] = array('=',array('ItemName' => $DataArray['ItemName']));
				$TmpCartObj->where[] = array('=',array('Attribute1' => $DataArray['Attribute1']));
				$TmpCartObj->where[] = array('=',array('ItemType' => $DataArray['ItemType']));
				$TmpCartObj->where[] = array('=',array('ReferenceID' => $DataArray['ReferenceID']));
				$CurrentCart = (object)$TmpCartObj->tableSelectOne();
				if(isset($CurrentCart->TmpCartID) && $CurrentCart->TmpCartID !=""){
					if(isset($CurrentCart->ModifyPrice) && $CurrentCart->ModifyPrice =="1"){
						/* nothing update*/
					}
					else{
						
						$DelTmpCartObj = new DataTable(TABLE_TMPCART);
						$DelTmpCartObj->where[] = array('=',array('ParentItemID' => $CurrentCart->ItemID));
						$DelTmpCartObj->where[] = array('=',array('SessionID' => $SessionID));
						$DelTmpCartObj->tableDelete();
						$TmpCartObj->tableUpdate($DataArray);
					}
				}
				else{
					$DataArray['CreatedDate'] = date('Y-m-d H:i:s');	
					$TmpCartObj->tableInsert($DataArray);
				}
				
				$SubItemID = uniqid("Item_");
				$SubDataArray = array();
				$SubDataArray['ItemID'] = $SubItemID;
				$SubDataArray['ParentItemID'] = $ItemID;
				$SubDataArray['ItemType'] = "Dimension";
				$SubDataArray['ItemStatus'] = $ItemStatus;
				$SubDataArray['ReferenceID'] = $L."x".$W;
				$SubDataArray['ItemName'] = "Length (".$L."mm) X Width (".$W."mm)";
				$SubDataArray['ItemNo'] = "";	
				
				
				$SubDataArray['UnitPrice'] = 0;
				$SubDataArray['TaxPercent'] = 0;
				$SubDataArray['Price'] = 0;
				$SubDataArray['TaxPrice'] = (($SubDataArray['Price']  * $SubDataArray['TaxPercent'])/100);
				$SubDataArray['VoucherAmount'] =0;
				$SubDataArray['VoucherText'] = "";
				$SubDataArray['VoucherCode'] = "";

				$SubDataArray['ActualPrice'] = $SubDataArray['Price'];
				$SubDataArray['ActualPriceWithTax'] = $SubDataArray['Price'] + $SubDataArray['TaxPrice'];

				if($SubDataArray['VoucherAmount'] > 0){
					$SubDataArray['Price'] = $SubDataArray['Price'] - $SubDataArray['VoucherAmount'];
				}

				$SubDataArray['TaxPrice'] = (($SubDataArray['Price']  * $SubDataArray['TaxPercent'])/100);
				$SubDataArray['PriceWithTax'] = $SubDataArray['Price'] + $SubDataArray['TaxPrice'];
				$SubDataArray['Qty'] = $Qty;
				$SubDataArray['Total'] = $SubDataArray['Price'] * $SubDataArray['Qty'];
				$SubDataArray['TotalWithTax'] = $SubDataArray['PriceWithTax'] * $SubDataArray['Qty'];
				
				
				$SubDataArray['SessionID'] = $SessionID;	
				
				$TmpCartObj = new DataTable(TABLE_TMPCART);
				$TmpCartObj->where[] = array('=',array('SessionID' => $SessionID));
				$TmpCartObj->where[] = array('=',array('ItemName' => $SubDataArray['ItemName']));
				$TmpCartObj->where[] = array('=',array('ItemType' => $SubDataArray['ItemType']));
				$TmpCartObj->where[] = array('=',array('ReferenceID' => $SubDataArray['ReferenceID']));
				$TmpCartObj->where[] = array('=',array('ItemNo' => $SubDataArray['ItemNo']));
				$CurrentSubCart = (object)$TmpCartObj->tableSelectOne();
				if(isset($CurrentSubCart->TmpCartID) && $CurrentSubCart->TmpCartID !="" && false){
					$TmpCartObj->tableUpdate($SubDataArray);
				}
				else{
					$DataArray['CreatedDate'] = date('Y-m-d H:i:s');	
					$TmpCartObj->tableInsert($SubDataArray);
				}
				
				if(isset($PostArray['AttributeID']) && is_array($PostArray['AttributeID']) && count($PostArray['AttributeID']) > 0){
					foreach($PostArray['AttributeID'] as $AttributeID=>$AttributeValueID){
						if($AttributeValueID !="")
						{
							$OptionObj = new DataTable(TABLE_ATTRIBUTE);
							$OptionObj->where[] = array('=',array('AttributeID' => $AttributeID));
							$CurrentAttribute = (object)$OptionObj->tableSelectOne();
							
							$OptionObj = new DataTable(TABLE_ATTRIBUTE_VALUE);
							$OptionObj->where[] = array('=',array('AttributeValueID' => $AttributeValueID));
							$CurrentOption = (object)$OptionObj->tableSelectOne();
							if(isset($CurrentOption->AttributeValueID) && $CurrentOption->AttributeValueID !="")
							{
								
								$SubItemID = uniqid("Item_");
								$SubDataArray = array();
								$SubDataArray['ItemID'] = $SubItemID;
								$SubDataArray['ParentItemID'] = $ItemID;
								$SubDataArray['ItemType'] = "Option";
								$SubDataArray['ItemStatus'] = $ItemStatus;
								$SubDataArray['ReferenceID'] = $CurrentOption->AttributeValueID;
								$SubDataArray['ItemName'] = $CurrentAttribute->AttributeName.": ".$CurrentOption->AttributeValue."";
								$SubDataArray['ItemNo'] = $CurrentOption->ModelNo;	
								
								
								$SubDataArray['UnitPrice'] = 0;
								$SubDataArray['TaxPercent'] = 0;
								$SubDataArray['Price'] = 0;
								$SubDataArray['TaxPrice'] = (($SubDataArray['Price']  * $SubDataArray['TaxPercent'])/100);
								$SubDataArray['VoucherAmount'] =0;
								$SubDataArray['VoucherText'] = "";
								$SubDataArray['VoucherCode'] = "";

								$SubDataArray['ActualPrice'] = $SubDataArray['Price'];
								$SubDataArray['ActualPriceWithTax'] = $SubDataArray['Price'] + $SubDataArray['TaxPrice'];

								if($SubDataArray['VoucherAmount'] > 0){
									$SubDataArray['Price'] = $SubDataArray['Price'] - $SubDataArray['VoucherAmount'];
								}

								$SubDataArray['TaxPrice'] = (($SubDataArray['Price']  * $SubDataArray['TaxPercent'])/100);
								$SubDataArray['PriceWithTax'] = $SubDataArray['Price'] + $SubDataArray['TaxPrice'];
								$SubDataArray['Qty'] = $Qty;
								$SubDataArray['Total'] = $SubDataArray['Price'] * $SubDataArray['Qty'];
								$SubDataArray['TotalWithTax'] = $SubDataArray['PriceWithTax'] * $SubDataArray['Qty'];
								
								
								$SubDataArray['SessionID'] = $SessionID;	
								
								$TmpCartObj = new DataTable(TABLE_TMPCART);
								$TmpCartObj->where[] = array('=',array('SessionID' => $SessionID));
								$TmpCartObj->where[] = array('=',array('ItemName' => $SubDataArray['ItemName']));
								$TmpCartObj->where[] = array('=',array('ItemType' => $SubDataArray['ItemType']));
								$TmpCartObj->where[] = array('=',array('ReferenceID' => $SubDataArray['ReferenceID']));
								$TmpCartObj->where[] = array('=',array('ItemNo' => $SubDataArray['ItemNo']));
								$CurrentSubCart = (object)$TmpCartObj->tableSelectOne();
								if(isset($CurrentSubCart->TmpCartID) && $CurrentSubCart->TmpCartID !="" && false){
									$TmpCartObj->tableUpdate($SubDataArray);
								}
								else{
									$DataArray['CreatedDate'] = date('Y-m-d H:i:s');	
									$TmpCartObj->tableInsert($SubDataArray);
								}
							}
						}
					}
				}
			
			
				$this->getClass('Sale\Cart\Common')->AddCartInCookie();	
			}
			
			/* add Attribute_2D product section end */
			 return "1";
			 /* add product end*/
		 }
		 else{
			 return $AlertArray;
		 }	
	
		var_dump("Attribute_2D------in the class");exit;
		
	}
	
	

	
	
}	