<?php 
namespace Catalog\Product\ProductType;
use Frontend\Base\AbstractModule;
use Base\Db\DataTable as DataTable;
use Base\Currency\CurrencyHandler as CurrencyHandler;
use Base\File\FileHandle as FileHandle;
use Laminas\Db\Sql\Where;

class Attribute extends AbstractModule 
{
	function __construct()
	{
		
	}
	function AddProductInTmpCart($ID,$Qty=1,$Attribute1 ="",$PostArray = array())
	{
		//var_dump("<pre>",$PostArray);exit;
		$AlertArray = array();
		$SessionID = $this->getSession()->getCurrentSID();
		$MasterID =	$ID;
		$ProductObj = new DataTable(TABLE_PRODUCT);
		$ProductObj->where[] = array('=',array('ProductID' => $MasterID));
		if(isset($GLOBALS['UserIDByAdmin']) && $GLOBALS['UserIDByAdmin'] != "")
		{
				//$ProductObj->where[] = array('=',array('Active' => "1"));
		}
		else
		{
			$ProductObj->where[] = array('=',array('Active' => "1"));
		}
		
		$CurrentProduct = (object)$ProductObj->tableSelectOne(array("ProductType","ProductID","MasterID","TaxClass","ProductName","ModelNo","Weight",
																	"VirtualProduct","FreeShippingStatus","GiftVoucherStatus",
																	"Stock","StockStatus","StockTotal","EndStock",
																	"PurchaseOnline","NotForSale","SignedIn","ShippingProductID"));																	
		
		
		
		
		if(!isset($CurrentProduct->ProductID))
			$AlertArray[] = array("danger","Something went wrong");
		
			
		 if($AlertArray==NULL || count($AlertArray)==0)	{
			/* add Attribute_2D product section start */
			if(isset($CurrentProduct->ProductType) && $CurrentProduct->ProductType == "Attribute"){
				
					foreach($PostArray['ChQty'] as $ChildProductID=>$ChQty){
						if($ChQty > 0){
							$ChildProductArray[$ChildProductID] = (int)$PostArray['ChQty'][$ChildProductID];
						}
					}
					//var_dump($ChildProductArray);exit;
				
				if(isset($ChildProductArray) && is_array($ChildProductArray) && count($ChildProductArray) > 0){
				foreach($ChildProductArray as $ChildProductID=>$ChQty){
				if($ChQty > 0){
					$ProductObj = new DataTable(TABLE_PRODUCT);
					$ProductObj->where[] = array('=',array('ProductID' => $ChildProductID));
					$ProductObj->where[] = array('=',array('MasterID' => $CurrentProduct->ProductID));
					$ProductObj->where[] = array('=',array('Active' => "1"));
					$CurrentChild = (object)$ProductObj->tableSelectOne(array("ProductType","ProductID","MasterID","TaxClass","ProductName","ModelNo","Weight",
																				"VirtualProduct","FreeShippingStatus","GiftVoucherStatus",
																				"PurchaseOnline","NotForSale","SignedIn","ShippingProductID"));																	

					
					$ChildAlertArray = array();
					if(isset($CurrentChild->NotForSale) && $CurrentChild->NotForSale == "1")
							$ChildAlertArray[] = array("danger","Currently this product is not available for sale.");
						
						if(isset($CurrentChild->EndStock) && $CurrentChild->EndStock == "1" && $Qty > $CurrentChild->Stock){
								$ChildAlertArray[] = array("danger","Currently this product is out of stock.");
						}
							

						if(isset($CurrentChild->SignedIn) && $CurrentChild->SignedIn == "1")
						{
							if(d("FRONT_SIDE_INCLUDE")==true){
								$ChildAlertArray[] = array("danger","Currently this product is available for registered customers.");
							}
						}
						
						if(isset($CurrentChild->ProductID) && $CurrentChild->ProductID != "" && count($ChildAlertArray)==0){
						 $ItemStatus ="Normal";
						 $ItemType ="ProductChild";
						 $ItemName = isset($CurrentChild->ProductName)?str_replace("'","",$CurrentChild->ProductName):"";
						 $ItemNo = isset($CurrentChild->ModelNo)?$CurrentChild->ModelNo:"";
						 $ReferenceID = isset($CurrentChild->MasterID)?$CurrentChild->MasterID:"";
						  $ItemTotal =0;
						  
						 if($CurrentChild->FreeShippingStatus =="1")
							$ItemStatus ="FreeShipping";
						if($CurrentChild->VirtualProduct =="1")
							$ItemStatus ="Download";
						
						
						$PriceSubArray = $this->getClass('Catalog\Product\Common')->GetProductPriceNStock($CurrentChild->ProductID,$ChQty,$PostArray);
						$SubItemID = uniqid("Item_");
						$SubDataArray = array();
						$SubDataArray['ItemID'] = $SubItemID;
						$SubDataArray['ParentItemID'] = "";
						$SubDataArray['ItemType'] = $ItemType;
						$SubDataArray['ItemStatus'] = $ItemStatus;
						$SubDataArray['ReferenceID'] = $ReferenceID;
						$SubDataArray['ItemName'] =$ItemName;
						$SubDataArray['ItemNo'] = $ItemNo;	
						
						$SubDataArray['Attribute1'] = $CurrentChild->ProductID;
						
						$SubDataArray['Width'] = (isset($CurrentChild->Width) && $CurrentChild->Width > 0)?$CurrentChild->Width:"0";
						$SubDataArray['Height'] = (isset($CurrentChild->Height) && $CurrentChild->Height > 0)?$CurrentChild->Height:"0";
						$SubDataArray['Length'] = (isset($CurrentChild->Length) && $CurrentProduct->Length > 0)?$CurrentProduct->Length:"0";
						$SubDataArray['Weight'] = (isset($CurrentChild->Weight) && $CurrentChild->Weight > 0)?$CurrentChild->Weight:"0";
						
						$SubDataArray['UnitPrice'] = isset($PriceSubArray['UnitPrice'])?$PriceSubArray['UnitPrice']:"";
						$SubDataArray['TaxPercent'] = isset($PriceSubArray['TaxPercent'])?$PriceSubArray['TaxPercent']:"";
						$SubDataArray['Price'] = isset($PriceSubArray['Price'])?$PriceSubArray['Price']:"";
						$SubDataArray['TaxPrice'] = (($SubDataArray['Price']  * $SubDataArray['TaxPercent'])/100);
						$SubDataArray['VoucherAmount'] = isset($PriceSubArray['Discount'])?$PriceSubArray['Discount']:"";
						$SubDataArray['VoucherText'] = "";
						$SubDataArray['VoucherCode'] = "";
						
						$SubDataArray['ActualPrice'] = $SubDataArray['Price'];
						$SubDataArray['ActualPriceWithTax'] = $SubDataArray['Price'] + $SubDataArray['TaxPrice'];
						
						if($SubDataArray['VoucherAmount'] > 0){
							$SubDataArray['Price'] = $SubDataArray['Price'] - $SubDataArray['VoucherAmount'];
						}
						
						$SubDataArray['TaxPrice'] = (($SubDataArray['Price']  * $SubDataArray['TaxPercent'])/100);
						$SubDataArray['PriceWithTax'] = $SubDataArray['Price'] + $SubDataArray['TaxPrice'];
						$SubDataArray['Qty'] = isset($PriceSubArray['Qty'])?$PriceSubArray['Qty']:"";
						$SubDataArray['Total'] = $ItemTotal = $SubDataArray['Price'] * $SubDataArray['Qty'];
						$SubDataArray['TotalWithTax'] = $SubDataArray['PriceWithTax'] * $SubDataArray['Qty'];
										
				
						$SubDataArray['Comments'] = isset($Comments)?$Comments:"";		
						$PostArray["ChQty"] = array();
						$PostArray["ChQty"][$SubDataArray['Attribute1']] = $SubDataArray['Qty'];
						$SubDataArray['SessionInfo'] = base64_encode(serialize($PostArray));		
						$SubDataArray['SessionID'] = $SessionID;
						$SubDataArray['Attribute2'] = isset($PostArray['CartUniqueID'])?$PostArray['CartUniqueID']:"";
						
					
						$TmpCartObj = new DataTable(TABLE_TMPCART);
						$TmpCartObj->where[] = array('=',array('SessionID' => $SessionID));
						$TmpCartObj->where[] = array('=',array('ItemName' => $SubDataArray['ItemName']));
						$TmpCartObj->where[] = array('=',array('ItemType' => $SubDataArray['ItemType']));
						$TmpCartObj->where[] = array('=',array('Attribute1' => $SubDataArray['Attribute1']));
						$TmpCartObj->where[] = array('=',array('Attribute2' => $SubDataArray['Attribute2']));
						$TmpCartObj->where[] = array('=',array('ReferenceID' => $SubDataArray['ReferenceID']));
						$TmpCartObj->where[] = array('=',array('ItemNo' => $SubDataArray['ItemNo']));
						$CurrentSubCart = (object)$TmpCartObj->tableSelectOne();
						
						if(isset($CurrentSubCart->TmpCartID) && $CurrentSubCart->TmpCartID !=""){
							$TmpCartObj->tableUpdate($SubDataArray);
						}
						else{
							$DataArray['CreatedDate'] = date('Y-m-d H:i:s');	
							$TmpCartObj->tableInsert($SubDataArray);
						}
						
						
						
					}
					else{
						return $ChildAlertArray;
					}
					
				}		
					
				}
			}
				
				//var_dump("<pre>",$PostArray);exit;
				$this->getClass('Sale\Cart\Common')->AddCartInCookie();	
				//var_dump("<pre>",$CurrentChild,$SubDataArray);exit;
			
			}
			
			/* add Attribute product section end */
			 return "1";
			 /* add product end*/
		 }
		 else{
			 return $AlertArray;
		 }	
		
	}
	
	

	
	
}	