<?php if(isset($CurrentProduct->ProductType) && $CurrentProduct->ProductType=="Bundle"):?>
<?php $bundleRows = $this->getClass("Catalog\Product\Common")->getProductBundleActive($CurrentProduct->ProductID);?>
	<?php if(count($bundleRows) > 0):?>
		<h3>Select products for the bundle below and click 'Add to cart' button.</h3>
		<?php $TotalItem = 0;?>
		<?php foreach( $bundleRows as $CurrentBundle):?>
		<?php $TotalItem = $TotalItem + $CurrentBundle->MaxProduct?>
		<div class="row border border-danger mt-4">
			<h2 class="bg-danger p-2 col-sm-12"><?php echo MyStripSlashes($CurrentBundle->BundleName);?></h2>
			<?php $rowProducts = $this->getClass("Catalog\Product\Common")->getProductByIds($CurrentBundle->RelatedProducts,"1",true)?>
			<?php if(count($rowProducts) > 0):?>
				 <div class="Grid text-center">
					 <div class="row List justify-content">
					<?php foreach($rowProducts as $CurrentRecord):?>
						<?php /* Bundle product item start*/?>
						<?php $PriceArray = $this->getClass("Catalog\Product\Common")->GetProductPriceNStock($CurrentRecord->ProductID,1,true);?>
						<div class="ProductItem col-xs-12 col-sm-6 col-lg-3 col-xl-3">
							<div class="Block">
								<figure class="figure d-flex align-items-center justify-content-center align-self-center">
									<a href="<?php echo SKSEOURL('catalog_product','Detail',$CurrentRecord->ProductID)?>">
										<?php if($CurrentRecord->Image !="" && file_exists(DIR_FS_SITE_UPLOADS."product/".$CurrentRecord->Image)):?>
											<img src="<?php echo SKImgDisplay(DIR_FS_SITE_UPLOADS."product/".$CurrentRecord->Image,"240,240,true")?>" alt="<?php echo isset($CurrentRecord->ProductName)?MyStripSlashes($CurrentRecord->ProductName):""?>" class="img-fluid figure-img" />
										<?php elseif ($CurrentRecord->Image !="" && stristr($CurrentRecord->Image,"http")):?>
											<img src="<?=str_replace("http:","https:",$CurrentRecord->Image)?>" alt="<?php echo isset($CurrentRecord->ProductName)?MyStripSlashes($CurrentRecord->ProductName):""?>" class="img-fluid figure-img" />
										<?php else:?>
											<img src="<?php echo SKImgDisplay(DIR_FS_SITE_UPLOADS."product/".$CurrentRecord->Image,"240,240,true")?>" alt="<?php echo isset($CurrentRecord->ProductName)?MyStripSlashes($CurrentRecord->ProductName):""?>" class="img-fluid figure-img" />
										<?php endif;?>
									</a>
								</figure>
								<div class="Info">
								<?php echo $ControllerObj->getProductCommon()->SKStarRatingSummary($CurrentRecord->ProductID);?>
								<h4><a href="<?php echo SKSEOURL('catalog_product','Detail',$CurrentRecord->ProductID)?>"><?php echo isset($CurrentRecord->ProductName)?MyStripSlashes($CurrentRecord->ProductName):""?></a></h4>
									<?php if(isset($CurrentRecord->NotForSale) && $CurrentRecord->NotForSale=="1"):?>
										<div class="Price"></div>
									<?php else:?>
										<div class="Price"><?php echo isset($PriceArray['DisplayPrice'])?$PriceArray['DisplayPrice']:"";?></div>
									<?php endif;?>
									<?php if(isset($PriceArray['StockArray']['StockStatus']) && $PriceArray['StockArray']['StockStatus'] =="1"):?>
										<div class="sk_product_precent" rel="<?php echo $PriceArray['StockArray']['Percent']?>"><div></div></div>
									<?php else:?>
										<div class="sk_product_precent_zero"></div>
									<?php endif;?>
									
								</div>
								<div class="button-bar"><label><input class="chkBundle" data-key="<?php echo $CurrentBundle->BundleID?>" data-max="<?php echo $CurrentBundle->MaxProduct?>" name="BundleProductID[<?php echo $CurrentBundle->BundleID?>][]" type="checkbox" value="<?php echo $CurrentRecord->ProductID?>"> Add to Bundle</label></div>
							</div>
						</div>
						<?php /* Bundle product item end*/?>
					<?php endforeach;?>	
					</div>
				</div>
			<?php endif;?>
		</div>
		<?php endforeach;?>
		<div class="text-center mt-4"><button type="button" class="bundleSubmit btn btn-default btn-cart ml-0 my-3 my-md-0 ml-md-3"><i class="fa fa-shopping-cart"></i> Add to Cart</button></div>
		<script type="text/javascript">
		jQuery(document).ready(function($){
			$(".chkBundle").bind("click",function(){
				MaxItem = $(this).attr("data-max");
				KeyItem = $(this).attr("data-key");
				CountItem = $( "input[data-key='"+KeyItem+"']:checked").length;
				if(parseInt(CountItem) > parseInt(MaxItem)){
					alert("You can select maximum "+ MaxItem+" products from this section");
					$(this).prop( "checked", false);
				}
			});	
			
			$(".bundleSubmit").bind("click",function(){
				MaxItem = "<?php echo $TotalItem?>";
				CountItem = $( ".chkBundle:checked").length;
				if(parseInt(CountItem) > 0 && parseInt(CountItem) == parseInt(MaxItem)){
					 $("#ProductForm").submit();
					 return true;
				}
				else{
					alert("Please select maximum "+ MaxItem+" products from this section");
					return false;
				}
			});	
		
		});	
		
		
		
	</script>
	<?php endif;?>	
<?php endif;?>


