<?php 
namespace Catalog\Product\Front\Controller;
use Frontend\Base\AbstractModule;
use Base\Db\DataTable as DataTable;
use Catalog\Category\Common as CategoryCommon;
use Catalog\Product\Common as ProductCommon;
use Laminas\Db\Sql\Where;

class SearchController extends AbstractModule
{
	var $MinPrice = 0; 
	var $MaxPrice = 200; 
	
	function __construct()
	{
		
	}
	
	public function getCategoryCommon()
	{
		$obj = new CategoryCommon();
		return $obj;
	}
	
	public function getProductCommon()
	{
		$obj = new ProductCommon();
		return $obj;
	}
	
	function settings()
	{
		$arr = $this->moduleParam;
		if($arr['code'] && $arr['code'] != "")
		{
			$MainObj = new DataTable(TABLE_SEO);
			$MainObj->where[] = array('=',array('MCode' => $arr['code']));
			$MainObj->where[] = array('=',array('MView' => $arr['view']));
			$obj = (object)$MainObj->tableSelectOne();
			if(isset($obj->URLID))
			{
				$this->origin->setMetaTitle($obj->MetaTitle); 	
				$this->origin->setMetaKeywords($obj->MetaKeyword); 	
				$this->origin->setMetaDescription($obj->MetaDescription); 	
			}
			
			
		}
	}
	
	public function getProductlist()
	{
		$ps = (isset($_GET['ps']) && $_GET['ps'] > 0)?(int)$_GET['ps']:"12";
		$sb = isset($_GET['sb'])?$_GET['sb']:"21";
		$Keyword = isset($_REQUEST['k'])?$_REQUEST['k']:"";
		$KeywordArr =  explode(" ",$Keyword);
		//$OrderBy = "p.CreatedDate DESC";
		$OrderBy = "p.UploadType='' DESC,p.UploadType='MurphyScriptStreaming' DESC,IF(p.StockStatus='0' && p.Stock >= 0,p.Stock,-111) DESC,p.ProductID DESC";
		$SortByArray = $this->getSortByArray();
		
		if(isset($SortByArray[$sb]['column']) && $SortByArray[$sb]['column'] != "")
			$OrderBy = $SortByArray[$sb]['column'];
		
		/* Min Max Start*/
		/*
		$ProductMinMaxObj = new DataTable(array('p'=>TABLE_PRODUCT));
		$minMaxwhere = new Where();
		$minMaxwhere->notEqualTo('p.ProductType','Child');
		$minMaxwhere->equalTo('p.Active',"1");
		
		if(count($KeywordArr) > 0)
		{
			foreach ($KeywordArr as $Key=>$Value)
			{
				$minMaxwhere->NEST//start braket
						->like('ProductName','%'.$Value.'%')->OR
						->like('ModelNo','%'.$Value.'%')->OR
						->like('ProductLine','%'.$Value.'%')->OR
						->UNNEST;
			}
		}
		$ProductMinMaxObj->where = $minMaxwhere;
	
		$ProductMinMaxObj->columnExpression = true;
		//$ProductMinMaxObj->displayQuery =true;
		$Obj = (object)$ProductMinMaxObj->tableSelectOne(array("MinPrice"=>"MIN(p.IdxMinPrice)",
												"MaxPrice"=>"MAX(p.IdxMaxPrice)"
											   ));
		$this->MinPrice = $Obj->MinPrice;
		$this->MaxPrice = $Obj->MaxPrice;
		*/
		/* Min Max End*/
		
		$where = new Where();
		$ProductObj = new DataTable(array('p'=>TABLE_PRODUCT));
		$where->notEqualTo('p.ProductType','Child');
		$where->equalTo('p.Active',"1");
		
		if(count($KeywordArr) > 0)
		{
			foreach ($KeywordArr as $Key=>$Value)
			{
				if(trim($Value) != ""){
				$where->NEST//start braket
						->like('ProductName','%'.$Value.'%')->OR
						->like('ModelNo','%'.$Value.'%')->OR
						->like('ProductLine','%'.$Value.'%')->OR
						->UNNEST;
				}
			}
		}
		
		if(isset($_GET['FromPrice']) && $_GET['FromPrice'] > 0){
			$where->expression('p.IdxMinPrice >= '.(float)$_GET['FromPrice']);
			
		}
		if(isset($_GET['ToPrice']) && $_GET['ToPrice'] > 0){
			$where->expression('p.IdxMaxPrice <= '.(float)$_GET['ToPrice']);
		}
		$ProductObj->where = $where;
	
		$ProductObj->joinExpression = true;
		$ProductObj->joinArray[] = array('name'=>array('pr'=>TABLE_PRODUCT_PRICES),
									  'on'=>"(pr.ProductID=p.ProductID and (pr.QtyMin='0' OR pr.QtyMin='1') AND UserTypeID='1')",
									  'columns'=>array("Price","SalePrice","SaleActive"),
									  'type'=>'left'
									  );
		
		
		if(isset($_GET['FT']) && is_array($_GET['FT'])){
			foreach($_GET['FT'] as $FilterID=>$FilterVal){
			if($FilterID=="BID"){
				$FilterValArr = array_filter(explode(",",preg_replace("/[^0-9,]/", "",$FilterVal)));
				if(is_array($FilterValArr) && count($FilterValArr) > 0){
					$where->in('p.BrandID',$FilterValArr);
				}
			}
			else{
				$FilterValArr = array_filter(explode(",",preg_replace("/[^0-9,]/", "",$FilterVal)));
				if(is_array($FilterValArr) && count($FilterValArr) > 0){
					$ProductObj->joinArray[] = array('name'=>array("ft_".$FilterID=>TABLE_PRODUCT_RELATION_FILTER),
											  'on'=>"(ft_".$FilterID.".ProductID=p.ProductID AND ft_".$FilterID.".FilterValueID IN (".implode(",",$FilterValArr).")
													  )",
											  'columns'=>NULL,
											  'type'=>''
											  );
					}
				}
			}	
			
			
			
		}
		
		//$ProductObj->displayQuery =true;
		$ProductObj->AllowPaging =true;
		if(isset($_GET['ps']) && $_GET['ps']=="ALL")
			$ProductObj->AllowPaging =false;
			
		$ProductObj->PageSize=$ps;
		$ProductObj->PagingPrefix="";
		$ProductObj->PageTotalDisplay = 5; 
		$ProductObj->PageNo =isset($_GET['PageNo'])?(int)abs($_GET['PageNo']):1;	
		$this->paging = $ProductObj;
		$ProductObj->orderExpression=true;
		return $ProductObj->tableSelectAll(array("*"),$OrderBy);
			 
	}
	
	public function BrandCount($BrandID)
	{
		//$CategoryID = $this->currentObj->CategoryID;
		$Keyword = isset($_REQUEST['k'])?$_REQUEST['k']:"";
		$KeywordArr =  explode(" ",$Keyword);
		
		$where = new Where();
		$ProductObj = new DataTable(array('p'=>TABLE_PRODUCT));
		$where->notEqualTo('p.ProductType','Child');
		$where->equalTo('p.Active',"1");
		
		if(count($KeywordArr) > 0)
		{
			foreach ($KeywordArr as $Key=>$Value)
			{
				if(trim($Value) != ""){
				$where->NEST//start braket
						->like('ProductName','%'.$Value.'%')->OR
						->like('ModelNo','%'.$Value.'%')->OR
						->like('ProductLine','%'.$Value.'%')->OR
						->UNNEST;
				}
			}
		}
		
		$where->equalTo('p.BrandID',$BrandID);
		
		$ProductObj->where = $where;
		
		if(isset($_GET['FT']) && is_array($_GET['FT'])){
			foreach($_GET['FT'] as $FilterID=>$FilterVal){
				if($FilterID != "BID"){
					$FilterValArr = array_filter(explode(",",preg_replace("/[^0-9,]/", "",$FilterVal)));
					if(is_array($FilterValArr) && count($FilterValArr) > 0){
					$ProductObj->joinArray[] = array('name'=>array("ft_".$FilterID=>TABLE_PRODUCT_RELATION_FILTER),
											  'on'=>"(ft_".$FilterID.".ProductID=p.ProductID AND ft_".$FilterID.".FilterValueID IN (".implode(",",$FilterValArr).")
													  )",
											  'columns'=>NULL,
											  'type'=>''
											  );
					}
				}
			
			}
			
		}
		
		//$ProductObj->displayQuery =true;
		$rows = $ProductObj->tableSelectAll(array('ProductID'));
		return count($rows) > 0?count($rows):0;
		
			 
	}
	
	public function ResetFilters($FilterArr)
	{
		$ResetFilter = array();
		$Keyword = isset($_REQUEST['k'])?$_REQUEST['k']:"";
		$KeywordArr =  explode(" ",$Keyword);
		
		$dir = $this->getClass("Base\File\FileHandle")->CheckPrivateLogDirectory("cache");
		$dir = $this->getClass("Base\File\FileHandle")->CheckPrivateLogDirectory("cache/category_filter");
		$filename=$dir.md5("search_".$Keyword).".txt";
		if(file_exists($filename) && d("CACHE_IMPLEMENT")=="1")
		{
			$FilterArr = unserialize(file_get_contents($filename));
			return $FilterArr;
		}
		else{
			
			foreach($FilterArr as $FilterID => $Arr){
				foreach($Arr['Values'] as $FilterValueID=>$ArVaArr){	
					$where = new Where();
					$ProductObj = new DataTable(array('p'=>TABLE_PRODUCT));
					$where->notEqualTo('p.ProductType','Child');
					$where->equalTo('p.Active',"1");
					
					if(count($KeywordArr) > 0)
					{
						foreach ($KeywordArr as $Key=>$Value)
						{
							if(trim($Value) != ""){
							$where->NEST//start braket
									->like('ProductName','%'.$Value.'%')->OR
									->like('ModelNo','%'.$Value.'%')->OR
									->like('ProductLine','%'.$Value.'%')->OR
									->UNNEST;
							}
						}
					}	
				
										  
			$ProductObj->joinExpression = true;
			$ProductObj->joinArray[] = array('name'=>array("ft_".$FilterID=>TABLE_PRODUCT_RELATION_FILTER),
									  'on'=>"(ft_".$FilterID.".ProductID=p.ProductID AND ft_".$FilterID.".FilterValueID = '".(int)$FilterValueID."'
											  )",
									  'columns'=>NULL,
									  'type'=>''
									  );

					$ProductObj->where = $where;
					$Obj = (object)$ProductObj->tableSelectOne(array('ProductID'));		
					if(!isset($Obj->ProductID)){
						unset($FilterArr[$FilterID]['Values'][$FilterValueID]);
					}					
					
				}		
			}
			
			$fp2 = fopen($filename, "w");
			fputs($fp2,serialize($FilterArr));	
			fclose($fp2);
			return $FilterArr;
		}
			 
	}
	
	
	public function FilterCount($FilterID,$FilterValueID)
	{
		$Keyword = isset($_REQUEST['k'])?$_REQUEST['k']:"";
		$KeywordArr =  explode(" ",$Keyword);
		
		$where = new Where();
		$ProductObj = new DataTable(array('p'=>TABLE_PRODUCT));
		$where->notEqualTo('p.ProductType','Child');
		$where->equalTo('p.Active',"1");
		
		if(count($KeywordArr) > 0)
		{
			foreach ($KeywordArr as $Key=>$Value)
			{
				if(trim($Value) != ""){
				$where->NEST//start braket
						->like('ProductName','%'.$Value.'%')->OR
						->like('ModelNo','%'.$Value.'%')->OR
						->like('ProductLine','%'.$Value.'%')->OR
						->UNNEST;
				}
			}
		}
		
		$ProductObj->where = $where;
		
		if($FilterID > 0 && $FilterValueID > 0){
			$ProductObj->joinExpression = true;
			$ProductObj->joinArray[] = array('name'=>array("ft_".$FilterID=>TABLE_PRODUCT_RELATION_FILTER),
									  'on'=>"(ft_".$FilterID.".ProductID=p.ProductID AND ft_".$FilterID.".FilterValueID = '".(int)$FilterValueID."'
											  )",
									  'columns'=>NULL,
									  'type'=>''
									  );
		}
		
		//$ProductObj->displayQuery =true;
		$rows = $ProductObj->tableSelectAll(array('ProductID'));
		return count($rows) > 0?count($rows):0;
		
			 
	}
	
	public function getSortByArray()
	{
		return  array(
					//"00"=>array("display"=>"Default","column"=>"p.CreatedDate DESC"),
					"21"=>array("display"=>"Price (Low &gt; High)","column"=>"p.IdxMinPrice ASC"),
					"22"=>array("display"=>"Price (High &gt; Low)","column"=>"p.IdxMaxPrice DESC"),
					"00"=>array("display"=>"Sort by Part No.","column"=>"p.ModelNo ASC,p.CreatedDate DESC"),
					"11"=>array("display"=>"Name (A - Z)","column"=>"p.ProductName ASC"),
					"12"=>array("display"=>"Name (Z - A)","column"=>"p.ProductName DESC"),
					
					//"31"=>array("display"=>"Date (Latest)","column"=>"p.CreatedDate DESC"),
					//"32"=>array("display"=>"Date (Oldest)","column"=>"p.CreatedDate ASC"),
					);
	}
	
	function pageTitle()
	{
		echo "Search Results";
	}
	
	function directFile()
	{
		if($this->origin->ajax=="1")
			return true;
		else
			return false;
		
	}
	
	
	
}	