<?php 
namespace Catalog\Product\Front\Controller;
use Frontend\Base\AbstractModule;
use Base\Db\DataTable as DataTable;
use Catalog\Category\Common as CategoryCommon;
use Catalog\Product\Common as ProductCommon;
use Laminas\Db\Sql\Where;

class LastChanceController extends AbstractModule
{
	function __construct()
	{
		
	}
	
	public function getCategoryCommon()
	{
		$obj = new CategoryCommon();
		return $obj;
	}
	
	public function getProductCommon()
	{
		$obj = new ProductCommon();
		return $obj;
	}
	
	function settings()
	{
		$arr = $this->moduleParam;
		if($arr['code'] && $arr['code'] != "")
		{
			$MainObj = new DataTable(TABLE_SEO);
			$MainObj->where[] = array('=',array('MCode' => $arr['code']));
			$MainObj->where[] = array('=',array('MView' => $arr['view']));
			$obj = (object)$MainObj->tableSelectOne();
			if(isset($obj->URLID))
			{
				$this->origin->setMetaTitle($obj->MetaTitle); 	
				$this->origin->setMetaKeywords($obj->MetaKeyword); 	
				$this->origin->setMetaDescription($obj->MetaDescription); 	
			}
			
			
		}
	}
	
	public function getProductlist()
	{
		$OrderBy = "RAND()";
		$where = new Where();
		$ProductObj = new DataTable(array('p'=>TABLE_PRODUCT));
		$where->notEqualTo('p.ProductType','Child');
		$where->equalTo('ptc.RelationID','0');
		$where->equalTo('p.Active',"1");
		$ProductObj->where = $where;
	
		$ProductObj->joinExpression = true;
		$ProductObj->joinArray[] = array('name'=>array('ptc'=>TABLE_PRODUCT_RELATION),
									  'on'=>"(ptc.ProductID=p.ProductID and ptc.RelationType='last_chance')",
									  'columns'=>array("RelationID","SortOrder"),
									  'type'=>''
									  );
		
		$ProductObj->joinExpression = true;
		$ProductObj->joinArray[] = array('name'=>array('pr'=>TABLE_PRODUCT_PRICES),
									  'on'=>"(pr.ProductID=p.ProductID and (pr.QtyMin='0' OR pr.QtyMin='1') AND UserTypeID='1')",
									  'columns'=>array("Price","SalePrice","SaleActive"),
									  'type'=>'left'
									  );
		//$ProductObj->displayQuery =true;
		$ProductObj->orderExpression =true;
		return $ProductObj->tableSelectAll(array("*"),$OrderBy,4);
			 
	}
	
	
	
	function pageTitle()
	{
		echo "Last Chance?";
	}
	
	
	
}	