<?php 
namespace Catalog\Product;
use Frontend\Base\AbstractModule;
use Base\Db\DataTable as DataTable;
use Base\Currency\CurrencyHandler as CurrencyHandler;
use Base\File\FileHandle as FileHandle;
use Laminas\Db\Sql\Where;

class Common extends AbstractModule 
{
	function __construct()
	{
		
	}
	
	function getProductRelationArray()
	{
		return array(
				'product_related'=>array('name'=>'Related','desc'=>'Related Products'),
				'product_similar'=>array('name'=>'Similar','desc'=>'Items regularly purchased together'),
				//'product_upsell'=>array('name'=>'Up-Sell','desc'=>'Up-Sell Products'),
				//'product_crosssell'=>array('name'=>'Cross-Sell','desc'=>'Cross-Sell Products'),
		);
	}
	
	function getProductFavouriteArray()
	{
		return array(
				'fav_homepage'=>array('name'=>'Homepage','desc'=>'Best Sellers Products'),
				'fav_featured'=>array('name'=>'Featured','desc'=>'Featured Products'),
				//'fav_bestseller'=>array('name'=>'Best Seller','desc'=>'Best Seller Products'),				
		);
	}
	
	function getProductAttributeTypeArray()
	{
		return array(
				'select'=>array('name'=>'OptionBox'),
				'checkbox'=>array('name'=>'CheckBox'),
				//'radio'=>array('name'=>'RadioBox'),
				//'text'=>array('name'=>'Text'),
				//'textarea'=>array('name'=>'TextArea'),
				//'file'=>array('name'=>'File'),
				//'date'=>array('name'=>'Date'),
				//'datetime'=>array('name'=>'DateTime'),
							
		);
	}
	
	function SKMaxGetProductSortOrder($RelationID,$RelationType='catalog_category')
	{
		$SortOrder = 0;
		$ProductRelationObj = new DataTable(TABLE_PRODUCT_RELATION);
		$ProductRelationObj->where = array(array('=',array('RelationType' => $RelationType)),
												  array('=',array('RelationID' => $RelationID))											  
												  );
		
		$SortOrder = $ProductRelationObj->getMax("SortOrder");
		return $SortOrder;
	}
	
	public function checkMurphyProduct($ProductID)
	{
		$return = false;
		$Obj = new DataTable(array('p'=>TABLE_PRODUCT));
		$Obj->where[] = array('=',array('p.ProductID' => $ProductID));
		$RecObj = (object)$Obj->tableSelectOne(array("UploadType"));
		
		if(isset($RecObj->UploadType) && $RecObj->UploadType=="MurphyScript")
			$return = true;
			
		return $return;
	}
	public function getProductlistByCategoryID($CategoryID,$Limit)
	{
		$OrderBy = "ptc.SortOrder ASC,p.CreatedDate DESC";
		
		$where = new Where();
		$ProductObj = new DataTable(array('p'=>TABLE_PRODUCT));
		$where->notEqualTo('p.ProductType','Child');
		$where->equalTo('ptc.RelationID',$CategoryID);
		$where->equalTo('ptc.RelationType','catalog_category');
		$where->equalTo('p.Active',"1");
		$ProductObj->where = $where;
	
		$ProductObj->joinExpression = true;
		$ProductObj->joinArray[] = array('name'=>array('ptc'=>TABLE_PRODUCT_RELATION),
									  'on'=>"(ptc.ProductID=p.ProductID)",
									  'columns'=>array("RelationID","SortOrder"),
									  'type'=>''
									  );
		$ProductObj->joinArray[] = array('name'=>array('pr'=>TABLE_PRODUCT_PRICES),
									  'on'=>"(pr.ProductID=p.ProductID and (pr.QtyMin='0' OR pr.QtyMin='1') AND UserTypeID='1')",
									  'columns'=>array("Price","SalePrice","SaleActive"),
									  'type'=>'left'
									  );
		//$ProductObj->displayQuery =true;
		$ProductObj->orderExpression=true;
		return $ProductObj->tableSelectAll(array("*"),$OrderBy,$Limit);
			 
	}
	
	function getProductRelatedContent($ProductID,$Type="product_related",$Title="Related Products",$template="product_related")
	{
			$relatedRows = $this->getProductRelatedByType($ProductID,$Type);
			if(count($relatedRows) > 0){
				include(dirname(__FILE__)."/Front/View/templates/product_extra/".$template.".php");
			}
			
	}
	function getProductRelatedByType($ProductID,$Type="product_related")
	{
		if($ProductID > 0)
		{
			$Obj = new DataTable(array('p'=>TABLE_PRODUCT));
			$Obj->joinExpression = true;
			$Obj->joinArray[] = array('name'=>array('ptc'=>TABLE_PRODUCT_RELATION),
										  'on'=>"(ptc.RelationID=p.ProductID)",
										  'columns'=>array("id","RelationID","SortOrder"),
										  'type'=>''
										  );
										  
			$Obj->where[] = array('=',array('ptc.RelationType' => $Type));
			$Obj->where[] = array('=',array('ptc.ProductID' => $ProductID));
			$Obj->where[] = array('=',array('p.Active' => '1'));
			return $Obj->tableSelectAll(array("ProductName","Image","ProductID"),array("SortOrder ASC"));									
			
		}
		return ;
	
	}
	
	function SKMaxGetRelatedSortOrder($ProductID,$RelationType='product_related')
	{
		$SortOrder = 0;
		$ProductRelationObj = new DataTable(TABLE_PRODUCT_RELATION);
		$ProductRelationObj->where = array(array('=',array('RelationType' => $RelationType)),
												  array('=',array('ProductID' => $ProductID))											  
												  );
		
		$SortOrder = $ProductRelationObj->getMax("SortOrder");
		return $SortOrder;
	}
	
	function getDemoVideos()
	{
		return FileHandle::getFileListing(DIR_FS_SITE_DEMO_VIDEO);
	}
	function getDownloadFiles()
	{
		return FileHandle::getFileListing(DIR_FS_SITE_SECURE_DOWNLOAD);
	}
	
	function SKDisplayPrdInfo($CurrentInfo)
	{
		global $MobileDetectObj;
		$Return = '';
		if(isset($CurrentInfo->InfoType) && $CurrentInfo->InfoType !="")
		{
			$Return .= '<div id="Div_Info_'.$CurrentInfo->InfoID.'" title="'.$CurrentInfo->TabTitle.'" class="Bn_dis">';
			switch ($CurrentInfo->InfoType)
			{
				case "WMV":
				 if ($CurrentInfo->Description !="" && stristr($CurrentInfo->Description,"http"))
				 {
					if(stristr($CurrentInfo->Description,"murphysmagicsupplies"))
					 $VideoURL =str_replace(array("/clips/",".wmv"),array("/clips_mp4fs/",".mp4"),$CurrentInfo->Description);
					 else
						 $VideoURL =$CurrentInfo->Description;
				 }
				 else
				 {					 
					$VideoURL =DIR_WS_SITE_DEMO_VIDEO.MyStripSlashes($CurrentInfo->Description);
				 }
				  
				  $ArrayType = explode(".",$VideoURL);
				  $Type=$ArrayType[count($ArrayType)-1];
				  
				//echo $VideoURL;
				switch(strtolower($Type))
				{
					case "mp4":
						$Return .= '<div align="center" class="embed-responsive embed-responsive-16by9">
										<video class="embed-responsive-item" controls>
											<source src="'.$VideoURL.'" type="video/mp4">
										</video>
									</div>';
					break;
					case "wmv":
					/*
					$Return .= '<video width="400" height="300" controls>
								  <source src="'.$VideoURL.'" type="video/wmv">
								</video>';
					*/			
					$Return .= '<object width="400" height="300" codebase="http://www.microsoft.com/Windows/Downloads/Contents/MediaPlayer/" classid="CLSID:6BF52A52-394A-11D3-B153-00C04F79FAA6" selthis="selThis">
						<param name="URL" value="'.$VideoURL.'" />
						<param name="autoStart" value="false" />
						<param name="uiMode" value="full" />
						<param name="playCount" value="32767" />
						<embed type="application/x-mplayer2" pluginspage="http://www.microsoft.com/Windows/Downloads/Contents/MediaPlayer/" src="'.$VideoURL.'" filename="<?php echo $VideoURL?>" autostart="0" showcontrols="1" showstatusbar="0" showdisplay="0" autorewind="1" height="300" width="400">
					</object>';
					break;
					
				}
					
				  
				break;
				case "HTML":
				default:
					 $Return .= MyStripSlashes($CurrentInfo->Description);
				break;
				
			}
			$Return .= '</div>';
		}
		return $Return;
	}
	
	function getProductTaxClasses()
	{
		$Obj = new DataTable(TABLE_TAX_CLASS);
		$Obj->rowType="array";
		$rows = $Obj->tableSelectAll(array("*"),array("TaxClassID ASC"));
		return $rows;
		
	}
	function getProductShippingGroup()
	{
		$Obj = new DataTable(TABLE_SHIPPING_PRODUCT_GROUP);
		$Obj->rowType="array";
		$rows = $Obj->tableSelectAll(array("*"),array("Position ASC"));
		return $rows;
		
	}
	
	function getProductShippingType()
	{
		$Obj = new DataTable(TABLE_SHIPPING_RZS_TYPES);
		$Obj->rowType="array";
		$rows = $Obj->tableSelectAll(array("*"),array("Position ASC"));
		return $rows;
		
	}
	
	function getUserTypeByProductPrices()
	{
		$Obj = new DataTable(TABLE_USER_TYPE);
		$Obj->rowType="array";
		$Obj->where[] = array('!=',array('UserType' => 2));
		$Obj->where[] = array('!=',array('UserType' => 3));
			
		$rows = $Obj->tableSelectAll(array("*"),array("SortOrder ASC"));
		return $rows;
	}
	
	function getProductPriceTypes()
	{
		$rows = array();
		$rows["Unit"] = "Per item";
		//$rows["Percentage"] = "Percentage(%)";
		return $rows;
	}
	
	public function UserProductPrice($ProductID,$UserTypeID,$ReturnType="array")
	{
		if($ProductID > 0)
		{
			$Obj = new DataTable(TABLE_PRODUCT_PRICES);
			$Obj->where[] = array('=',array('ProductID' => $ProductID));
			$Obj->where[] = array('=',array('UserTypeID' => $UserTypeID));
			if(strtolower($ReturnType)=="array")
				$Obj->rowType="array";
		
			return $Obj->tableSelectAll(array("*"),array("QtyMin ASC","ProductPriceID ASC"));;
	
		}
		return ;
	
	}
	
	public function UserProductDiscountPercent($UserTypeID,$ReturnType="array")
	{
		if($UserTypeID > 0)
		{
			$Obj = new DataTable(TABLE_PRODUCT_DISCOUNT);
			$Obj->where[] = array('=',array('UserTypeID' => $UserTypeID));
			if(strtolower($ReturnType)=="array")
				$Obj->rowType="array";
		
			return $Obj->tableSelectAll(array("*"),array("QtyMin ASC","DiscountID ASC"));;
	
		}
		return false;
	
	}
	
	public function getProductFilters($ProductID,$Active="ALL")
	{
		if($ProductID > 0)
		{
		
			$Obj = new DataTable(array("p"=>TABLE_PRODUCT));
			$Obj->joinExpression = true;
			$Obj->joinArray[] = array('name'=>array('ptc'=>TABLE_PRODUCT_RELATION_FILTER),
								  'on'=>"(p.ProductID=ptc.ProductID)",
								  'columns'=>NULL,
								  'type'=>''
								  );
										  
			$Obj->where[] = array('=',array('ptc.ProductID' => $ProductID));
			if($Active=="1")
				$Obj->where[] = array('=',array('p.Active' => "1"));
			if($Active=="0")
				$Obj->where[] = array('=',array('p.Active' => "0"));
				
			//$Obj->displayQuery = true;
			$Obj->columnExpression=true;
			$Cobj = (object)$Obj->tableSelectOne(array("GROUP_CONCAT(DISTINCT FilterValueID ORDER BY FilterValueID ASC SEPARATOR ',') as RelationIDs"));
			return isset($Cobj->RelationIDs)?explode(",",$Cobj->RelationIDs):array();
		}
		return array();
	
	}
	
	public function getCategoryNames($ProductID,$Active="ALL")
	{
		if($ProductID > 0)
		{
		
			$Obj = new DataTable(array("c"=>TABLE_CATEGORY));
			$Obj->joinExpression = true;
			$Obj->joinArray[] = array('name'=>array('ptc'=>TABLE_PRODUCT_RELATION),
								  'on'=>"(c.CategoryID=ptc.RelationID and ptc.RelationType='catalog_category')",
								  'columns'=>NULL,
								  'type'=>''
								  );
										  
			$Obj->where[] = array('=',array('ptc.ProductID' => $ProductID));
			//$Obj->groupBy = array("c.CategoryID");
			$Obj->columnExpression=true;
			$Cobj = (object)$Obj->tableSelectOne(array("GROUP_CONCAT(DISTINCT CategoryName ORDER BY CategoryName ASC SEPARATOR ', ') as CategoryNames"));
			return isset($Cobj->CategoryNames)?$Cobj->CategoryNames:"";
		}
		return ;
	
	}
	
	function getDownloadData($Key,$Data,$Murphy=false,$AcademyAfterShow=false,$AcademyOnline=false,$dStyle="default")
	{
		foreach($Data as $ProductID=>$CurrentProduct){
			
			if($Murphy===true && isset($CurrentProduct->FeedID) && $CurrentProduct->FeedID != "" && $CurrentProduct->UploadType =="MurphyScriptStreaming"){
					$this->getMurphyDownloadData($Key,$CurrentProduct,$dStyle);
			}
			if($AcademyAfterShow===false && $AcademyOnline== false){
					
				$Obj = new DataTable(TABLE_PRODUCT_DOWNLOAD);
				$where = new Where();
				
				$where->NEST//start braket
					->equalTo('AcademyAfterShow','')
					->OR
					->equalTo('AcademyAfterShow','0')
					->OR
					->isNull('AcademyAfterShow')
					->OR
					->notEqualTo('AcademyAfterShow','1')
				->UNNEST;	
			 
   			  $where->NEST//start braket
					->equalTo('AcademyOnline','')
					->OR
					->equalTo('AcademyOnline','0')
					->OR
					->isNull('AcademyOnline')
					->OR
					->notEqualTo('AcademyOnline','1')
				->UNNEST;	
			  
				
				//$where->notEqualTo('AcademyAfterShow','1');
				//$where->notEqualTo('AcademyOnline','1');
				
				$where->equalTo('ProductID',$ProductID);
				$Obj->where = $where;
				$downloadRows = $Obj->tableSelectAll(array("*"),array("DownloadID ASC"));
			}
			else if($AcademyAfterShow===true){
				$Obj = new DataTable(TABLE_PRODUCT_DOWNLOAD);
				$where = new Where();
				$where->equalTo('AcademyAfterShow','1');
				$where->equalTo('ProductID',$ProductID);
				$Obj->where = $where;
				$downloadRows = $Obj->tableSelectAll(array("*"),array("DownloadID ASC"));
			}
			else if($AcademyOnline===true){
				$Obj = new DataTable(TABLE_PRODUCT_DOWNLOAD);
				$where = new Where();
				$where->equalTo('AcademyOnline','1');
				$where->equalTo('ProductID',$ProductID);
				$Obj->where = $where;
				$downloadRows = $Obj->tableSelectAll(array("*"),array("DownloadID ASC"));
			}
			
			if(isset($downloadRows) && count($downloadRows) > 0){
				
				$this->getDisplayDownloadData($Key,$CurrentProduct,$downloadRows,$Murphy,$dStyle);
			}		
			
		}
	}
	function getMurphyDownloadData($Key,$CurrentProduct,$dStyle)
	{
		if(isset($CurrentProduct->ProductID)){
			include(dirname(__FILE__)."/Front/View/download/murphy.php");	
		}
	}
	function displayBulkProduct($CategoryID,$File="products_table_view.php")
	{
		if($CategoryID > 0){
			include(dirname(__FILE__)."/Front/View/templates/product_extra/".$File);	
		}
	}
	function getDisplayDownloadData($Key,$CurrentProduct,$downloadRows,$Murphy,$dStyle)
	{
		if(isset($CurrentProduct->ProductID) && count($downloadRows) > 0){
			if(file_exists(dirname(__FILE__).'/Front/View/download/default-'.$dStyle.'.php'))
				include(dirname(__FILE__).'/Front/View/download/default-'.$dStyle.'.php');	
			else
				include(dirname(__FILE__).'/Front/View/download/default.php');	
		}
	}
	
	function getProductData($CurrentProduct,$file="default",$ControllerObj = "")
	{
		if(isset($CurrentProduct->ProductID))
		{
			if(!is_object($ControllerObj))
				$ControllerObj = new \Catalog\Product\Front\Controller\IndexController;
			
			if(strtolower($file)=="detail"){
				if(file_exists(dirname(__FILE__)."/Front/View/templates/".basename(strtolower($CurrentProduct->ProductType)).".php"))
					include(dirname(__FILE__)."/Front/View/templates/".basename(strtolower($CurrentProduct->ProductType)).".php");
				else
					include(dirname(__FILE__)."/Front/View/templates/detail.php");
			}
			else{
				if(file_exists(dirname(__FILE__)."/Front/View/templates/".basename($file).".php"))
					include(dirname(__FILE__)."/Front/View/templates/".basename($file).".php");
				else
					include(dirname(__FILE__)."/Front/View/templates/default.php");
			}
		}
			
	}
	
	public function getChildProductBySKU($MasterID,$ModelNo,$ColumnArray = array("ProductID","ProductName","ProductAttribute"))
	{
		$where = new Where();
		$ProductObj = new DataTable(array('p'=>TABLE_PRODUCT));
		$where->equalTo('MasterID',$MasterID);
		$where->equalTo('ModelNo',$ModelNo);
		$ProductObj->where = $where;
		$result = (object)$ProductObj->tableSelectOne($ColumnArray,array("CreatedDate DESC"));
			return $result;
	}
	
	public function getProductFieldsById($ID,$ColumnArray = array("ProductID","ProductName"))
	{
		$where = new Where();
		$ProductObj = new DataTable(array('p'=>TABLE_PRODUCT));
		$where->equalTo('ProductID',$ID);
		$ProductObj->where = $where;
		$result = (object)$ProductObj->tableSelectOne($ColumnArray,array("CreatedDate DESC"));
			return $result;
	}
	
	public function getProductByIds($IDs,$Active="1",$AllColumns=false,$Limit=false)
	{
		if(isset($IDs) && is_array($IDs) && count($IDs) > 0)
			$IDs = implode(",",$IDs);
		
		if($IDs != "")
			$IDArray = explode(",",$IDs);
		
		if(isset($IDArray) && is_array($IDArray) && count($IDArray) > 0){
			$where = new Where();
			$ProductObj = new DataTable(array('p'=>TABLE_PRODUCT));
			$where->notEqualTo('p.ProductType','Child');
			if($Active=="1")
				$where->equalTo('p.Active',"1");
			
			$where->in('p.ProductID',$IDArray);
			$ProductObj->where = $where;
			//$ProductObj->displayQuery = true;
			
			$ColumnArray = array("ProductID","ProductName");
			if($AllColumns==true)
				$ColumnArray = array("*");
				
			if((int)$Limit > 0)
				$rows = $ProductObj->tableSelectAll($ColumnArray,array("CreatedDate DESC"),$Limit);
			else
				$rows = $ProductObj->tableSelectAll($ColumnArray,array("CreatedDate DESC"));
			return $rows;
		}
		else{
			return array();
		}
			 
	}
	
	public function getProductBundleActive($ProductID)
	{
		if($ProductID > 0)
		{
			$Obj = new DataTable(TABLE_PRODUCT_BUNDLES);
			$Obj->where[] = array('=',array('ProductID' => $ProductID));
			$Obj->where[] = array('=',array('Active' => '1'));
			return $Obj->tableSelectAll(array("*"),array("Position ASC","BundleID ASC"));;
		}
		return ;
	
	}
	
	public function getHomepageProductlist($limit=6)
	{
		
		$OrderBy = "RAND()";
		$where = new Where();
		$ProductObj = new DataTable(array('p'=>TABLE_PRODUCT));
		$where->notEqualTo('p.ProductType','Child');
		$where->equalTo('ptc.RelationID','0');
		$where->equalTo('p.Active',"1");
		$where->equalTo('ptc.Custom',"1");
		$ProductObj->where = $where;
	
		$ProductObj->joinExpression = true;
		$ProductObj->joinArray[] = array('name'=>array('ptc'=>TABLE_PRODUCT_RELATION),
									  'on'=>"(ptc.ProductID=p.ProductID and ptc.RelationType='Homepage')",
									  'columns'=>array("RelationID","SortOrder"),
									  'type'=>''
									  );
		
		return $ProductObj->tableSelectAll(array("*"),array("ptc.SortOrder"),$limit);
	
	}
	
	public function getProducFavourite($RelationType,$limit=12)
	{
		$where = new Where();
		$ProductObj = new DataTable(array('p'=>TABLE_PRODUCT));
		$where->notEqualTo('p.ProductType','Child');
		$where->equalTo('p.Active',"1");
		$where->equalTo('ptc.RelationID','0');
		$where->equalTo('ptc.RelationType',$RelationType);
		$ProductObj->where = $where;
	
		$ProductObj->joinExpression = true;
		$ProductObj->joinArray[] = array('name'=>array('ptc'=>TABLE_PRODUCT_RELATION),
									  'on'=>"(ptc.ProductID=p.ProductID)",
									  'columns'=>array("RelationID","SortOrder"),
									  'type'=>''
									  );
		//$ProductObj->displayQuery =true;
		return $ProductObj->tableSelectAll(array("ProductID","ProductName","ModelNo","Image"),array("SortOrder ASC, p.ProductID DESC"),$limit);
	}
	
	public function IsProductFavourite($ProductID,$RelationType)
	{
		if($ProductID > 0)
		{
			$Obj = new DataTable(TABLE_PRODUCT_RELATION);
			$Obj->where[] = array('=',array('ProductID' => $ProductID));
			$Obj->where[] = array('=',array('RelationType' => $RelationType));
			$TmpObj = (object)$Obj->tableSelectOne(array("ProductID"));
			if(isset($TmpObj->ProductID))
			return true;
	
		}
		return false;
	}
	
	public function getFeaturedProductlist($limit=12)
	{
		
		$where = new Where();
		$ProductObj = new DataTable(array('p'=>TABLE_PRODUCT));
		$where->notEqualTo('p.ProductType','Child');
		$where->equalTo('p.Active',"1");
		$where->equalTo('p.Featured',"1");
		$ProductObj->where = $where;
		return $ProductObj->tableSelectAll(array("*"),array("CreatedDate DESC"),$limit);
			 
	}
	
	public function getProductAdditions($ProductID)
	{
		$Obj = new DataTable(TABLE_PRODUCT_ADDITIONS);
		$Obj->where[] = array('=',array('ProductID' => $ProductID));
		$Obj->columnExpression = true;
		return $Obj->tableSelectAll(array("DISTINCT(AttributeName) as AttributeName","AttributeType as AttributeType","Position as Position"),array("Position ASC"));;
		
			
	}
	
	public function getProductAdditionValues($ProductID,$AttributeName)
	{
		if($ProductID > 0)
		{
			$Obj = new DataTable(TABLE_PRODUCT_ADDITIONS);
			$Obj->where[] = array('=',array('ProductID' => $ProductID));
			$Obj->where[] = array('=',array('AttributeName' => $AttributeName));
			return $Obj->tableSelectAll(array("*"),array("AttributeValueSort ASC","ProductAdditionID ASC"));;
	
		}
		return ;
	
	}
	
	
	function SKStarRating($r=0)
	{
		if($r > 0)
		{
			$ReturnString ='<div class="star-rating">';
			for ($i=1;$i<=5;$i++)
			{
				if($r >=$i)
					$ReturnString .='<span class="fa fa-star"></span>';
				else 
					$ReturnString .='<span class="far fa-star"></span>';
			}
			$ReturnString .='</div>';
			
			return $ReturnString;
		}
		return '<div class="no-rating"></div>';
	}
	
	function SKStarRatingSummary($ProductID)
	{
		 return $this->SKStarRating($this->SKStarRatingSummaryNumber($ProductID));
	}
	
	
	function SKStarRatingSummaryNumber($ProductID)
	{
		 $Obj = new DataTable(TABLE_PRODUCT_REVIEWS);
		 $Obj->where[] = array('=',array('ProductID' => $ProductID));
		 $Obj->where[] = array('=',array('Active' => '1'));
		 $Obj->columnExpression = true;
		 $Rating = (object)$Obj->tableSelectOne(array("SUM(Rating) as Rating","COUNT(*) as Total"));
		 
		 $r= 0;
		 if(isset($Rating->Total) && $Rating->Total >0)
         	$r = number_format($Rating->Rating/$Rating->Total,0);
         
		 return $r;
	}
	function GetDiscountedPrice($MainPrice,$Percentage,$Return='Price')
	{
		$DiscountPrice = ($Percentage/100) * $MainPrice;
		if($Return=="Discount")
			return $DiscountPrice;
		else
			return $MainPrice - $DiscountPrice;
			
		
	}
	
	
	
	function GetProductDifficultyRating($r)
	{
		if($r > 0)
		{
			$ReturnString ='<div class="difficulty-rating">';
			for ($i=1;$i<=5;$i++)
			{
				if($r >=$i)
					$ReturnString .='<span class="difficulty-1"></span>';
				else 
					$ReturnString .='<span class="difficulty-0"></span>';
			}
			$ReturnString .='</div>';
			
			return $ReturnString;
		}
		return d("DIFFICULTY_RATING_MSG");
	}
	
	public function getProductWithDiscounted($ProductID)
	{
		if($ProductID > 0)
		{
			$Obj = new DataTable(array('p'=>TABLE_PRODUCT));
			$Obj->joinExpression = true;
			$Obj->joinArray[] = array('name'=>array('ptc'=>TABLE_PRODUCT_RELATION),
										  'on'=>"(ptc.RelationID=p.ProductID and ptc.RelationType='product_discounted')",
										  'columns'=>array("id","RelationID","Custom","SortOrder"),
										  'type'=>''
										  );
										  
			$Obj->where[] = array('=',array('ptc.ProductID' => $ProductID));
			$Obj->where[] = array('=',array('p.Active' => '1'));
			return $Obj->tableSelectAll(array("ProductName","Image","ProductID"),array("SortOrder ASC"));									
			
		}
		return ;
	
	}
	
	function GetTaxPercentByTaxClassID($TaxClass,$CountryTax = "",$Force=0)
	{
		$Return =array();
		$TaxPercent =0;
		/*$IsCurrentUser = $this->getClass('Customer\Login\Common')->IsUserLogin();
		if($CountryTax ==""){
			$CountryTax = d("DEFINE_DEFAULT_COUNTRY");
			if($this->getSession()->getVar("TaxCountry") != "")	
			  $CountryTax = $this->getSession()->getVar("TaxCountry");
			else if(isset($IsCurrentUser->Country) && $IsCurrentUser->Country !="")
				$CountryTax = $IsCurrentUser->Country;
		}
		else{
			
		}
		*/
		
		$CountryTax = d("DEFINE_DEFAULT_COUNTRY"); /* Set default tax*/
		if($CountryTax != "")
		{
			$dir = FileHandle::CheckPrivateLogDirectory("cache");
			$filename=$dir."tax_".md5(serialize(array("TaxClass"=>$TaxClass,"CountryTax"=>$CountryTax,"Force"=>$Force))).".txt";
			if(file_exists($filename) && d("CACHE_IMPLEMENT")=="1" && false){
				$Return =unserialize(file_get_contents($filename));
			}
			else{
				if(strlen($CountryTax) > 2)
				$CountryTax = SKGetCountryCodeByCountry($CountryTax,2);
			
				$TaxClassCalcObj = new DataTable(array('tc'=>TABLE_TAX_CLASS_CALC));
				$TaxClassCalcObj->joinExpression = true;
				$TaxClassCalcObj->joinArray[] = array('name'=>array('c'=>TABLE_COUNTRIES),
										  'on'=>"(tc.CountryID=c.CountryID)",
										  'columns'=>array("CountryID"),
										  'type'=>"left",
										  );
				//$TaxClassCalcObj->displayQuery = true;	
				$where = new Where();
				$where->equalTo('tc.TaxClassID',(int)$TaxClass);
				$where->equalTo('c.CountryISOCode1',substr($CountryTax,0,3));
				$where->NEST//start braket
					->equalTo('tc.RegionID','0')
					->OR
					->equalTo('tc.RegionID','')
					->OR
					->ISNULL('tc.RegionID')
					->UNNEST;
				
				$TaxClassCalcObj->where = $where;			
				$CurrentTaxCal = (object)$TaxClassCalcObj->tableSelectOne(array("*"));
				
				if(isset($CurrentTaxCal->TaxPercent) && $CurrentTaxCal->TaxPercent > 0)
				{
					$TaxPercent = $CurrentTaxCal->TaxPercent;
					$Return['Object'] = $CurrentTaxCal;
				}
				$Return['TaxPercent'] = $TaxPercent;
			}
			
			
			if(d("CACHE_IMPLEMENT")=="1"){
				$fp2 = fopen($filename, "w");
				fputs($fp2,serialize($Return));	
				fclose($fp2);
			}
				
		}
		
		/* Customer Vat Exempt start*/
		if(isset($IsCurrentUser->VATExempt) && $IsCurrentUser->VATExempt == "1" && $Force != "1"){
			$TaxPercent = 0;
			$Return['Object'] = (object)array("TaxPercent" => "0",
											  "TaxClassID" => (isset($CurrentTaxCal->TaxClassID)?$CurrentTaxCal->TaxClassID:""),
											  "CountryID" => (isset($CurrentTaxCal->CountryID)?$CurrentTaxCal->CountryID:""),
											  "RegionID" => (isset($CurrentTaxCal->RegionID)?$CurrentTaxCal->RegionID:""),
									  );
			$Return['TaxPercent'] = $TaxPercent;							  
		}
		/* Customer Vat Exempt end*/
			
		return $Return;
		
	}
	
	function GetTaxPercentByTaxClassID_old2222($TaxClass,$CountryTax = "",$Force=0)
	{
		$Return =array();
		$TaxPercent =0;
		$IsCurrentUser = $this->getClass('Customer\Login\Common')->IsUserLogin();
		if($CountryTax ==""){
			$CountryTax = d("DEFINE_DEFAULT_COUNTRY");
			if($this->getSession()->getVar("TaxCountry") != "")	
			  $CountryTax = $this->getSession()->getVar("TaxCountry");
			else if(isset($IsCurrentUser->Country) && $IsCurrentUser->Country !="")
				$CountryTax = $IsCurrentUser->Country;
		}
		else{
			
		}
		
		
		
		if($CountryTax != "")
		{
			$dir = FileHandle::CheckPrivateLogDirectory("cache");
			$filename=$dir."cache.tax_".md5(serialize(array($TaxClass,$CountryTax,$Force))).".txt";
			if(file_exists($filename) && d("CACHE_IMPLEMENT")=="1"){
				$Return =unserialize(file_get_contents($filename));
			}
			else{
				if(strlen($CountryTax) > 2)
				$CountryTax = SKGetCountryCodeByCountry($CountryTax,2);
			
				$TaxClassCalcObj = new DataTable(array('tc'=>TABLE_TAX_CLASS_CALC));
				$TaxClassCalcObj->joinExpression = true;
				$TaxClassCalcObj->joinArray[] = array('name'=>array('c'=>TABLE_COUNTRIES),
										  'on'=>"(tc.CountryID=c.CountryID)",
										  'columns'=>array("CountryID"),
										  'type'=>"left",
										  );
				//$TaxClassCalcObj->displayQuery = true;	
				$where = new Where();
				$where->equalTo('tc.TaxClassID',(int)$TaxClass);
				$where->equalTo('c.CountryISOCode1',substr($CountryTax,0,3));
				$where->NEST//start braket
					->equalTo('tc.RegionID','0')
					->OR
					->equalTo('tc.RegionID','')
					->OR
					->ISNULL('tc.RegionID')
					->UNNEST;
				
				$TaxClassCalcObj->where = $where;			
				$CurrentTaxCal = (object)$TaxClassCalcObj->tableSelectOne(array("*"));
				
				if(isset($CurrentTaxCal->TaxPercent) && $CurrentTaxCal->TaxPercent > 0)
				{
					$TaxPercent = $CurrentTaxCal->TaxPercent;
					$Return['Object'] = $CurrentTaxCal;
				}
				$Return['TaxPercent'] = $TaxPercent;
			}
				
			
			if(d("CACHE_IMPLEMENT")=="1"){
				$fp2 = fopen($filename, "w");
				fputs($fp2,serialize($Return));	
				fclose($fp2);
			}
				
		}
		
		/* Customer Vat Exempt start*/
		if(isset($IsCurrentUser->VATExempt) && $IsCurrentUser->VATExempt == "1" && $Force != "1"){
			$TaxPercent = 0;
			$Return['Object'] = (object)array("TaxPercent" => "0",
											  "TaxClassID" => (isset($CurrentTaxCal->TaxClassID)?$CurrentTaxCal->TaxClassID:""),
											  "CountryID" => (isset($CurrentTaxCal->CountryID)?$CurrentTaxCal->CountryID:""),
											  "RegionID" => (isset($CurrentTaxCal->RegionID)?$CurrentTaxCal->RegionID:""),
									  );
			$Return['TaxPercent'] = $TaxPercent;							  
		}
		/* Customer Vat Exempt end*/
			
		return $Return;
		
	}
	
	function getPriceWithoutTax($Price,$TaxClass,$InPrice)
	{
		 $TaxArray = $this->GetTaxPercentByTaxClassID($TaxClass,d("DEFINE_DEFAULT_COUNTRY"),"1");
		 $TaxPercent = isset($TaxArray['TaxPercent'])?$TaxArray['TaxPercent']:"0";
		 if($InPrice=="1" && $TaxPercent > 0){
			$TaxPrice = ($Price  * $TaxPercent)/(100+$TaxPercent) ;
			$PriceWithoutTax = $Price - $TaxPrice;
			return $PriceWithoutTax;
		}
		else{
			return $Price;
		}
			
	}

	function GetOutletTotal($ProductID,$AttributeValueID="")
	{
		$TmpObjCl = new DataTable(TABLE_PRODUCT);
		$where = new Where();
		$where->equalTo('MasterID',$ProductID);
		$where->equalTo('Active',1);
		$where->equalTo('Clearance',1);
		if($AttributeValueID > 0){
			$where->like('ProductAttribute','%='.$AttributeValueID.'%');
		}
		 $TmpObjCl->where = $where;
		 $TmpObjCl->columnExpression = true;
		 //$TmpObjCl->displayQuery = true;
		 $ClearanceObj = (object)$TmpObjCl->tableSelectOne(array("COUNT(*) as Total"));
		 return $ClearanceObj->Total;
		 
	}
	function IndexProductSearch($ProductID)
	{
		$ProductObj = new DataTable(array('p'=>TABLE_PRODUCT));
		$ProductDiscountObj = new DataTable(array('pd'=>TABLE_PRODUCT_DISCOUNT));
		$PercentObj = (object)$ProductDiscountObj->tableSelectOne(array("DiscountPercent"),array("DiscountPercent DESC"));	
		
		$where = new Where();
		$where->equalTo('p.ProductID',$ProductID);
		$ProductObj->where = $where;								  
		//$ProductObj->displayQuery = true;
		$CurrentProduct = (object)$ProductObj->tableSelectOne(array("ProductID","MasterID","TaxClass","ProductType"));		
		/* type:attribute start*/
		if(in_array(strtolower($CurrentProduct->ProductType),array("attribute"))){
			$ChildIDArr = $this->getProductChildrenIDsActive($CurrentProduct->ProductID);
			if(is_array($ChildIDArr) && count($ChildIDArr) > 0){
				
				$IdxSearch = "";
				$IdxFilter = "";
				$IdxClearance = 0;
				
				$TmpObjCl = new DataTable(TABLE_PRODUCT);
				$where = new Where();
				$where->in('ProductID',$ChildIDArr);
				$where->equalTo('Active',1);
				$where->equalTo('Clearance',1);
				 $TmpObjCl->where = $where;
				 $TmpObjCl->columnExpression = true;
				 $ClearanceObj = (object)$TmpObjCl->tableSelectOne(array("COUNT(*) as Total"));
				 
				 if(isset($ClearanceObj->Total) && $ClearanceObj->Total == count($ChildIDArr)){
					$IdxClearance =1;
				 }
				
		 
				$TmpObj2 = new DataTable(TABLE_PRODUCT);
				$where = new Where();
				$where->in('ProductID',$ChildIDArr);
				$where->equalTo('Active',1);
				$TmpObj2->where = $where;
				$TmpObj2->columnExpression=true;
				//$TmpObj->displayQuery = true;
				$Pobj = (object)$TmpObj2->tableSelectOne(array("GROUP_CONCAT(DISTINCT ModelNo ORDER BY ModelNo ASC SEPARATOR ' ') as ModelNos"));
				$IdxSearch .= " ".(isset($Pobj->ModelNos)?$Pobj->ModelNos:"");
			
				$TmpObj3 = new DataTable(array("f"=>TABLE_FILTER_VALUE));
				$TmpObj3->joinExpression = true;
				$TmpObj3->joinArray[] = array('name'=>array('pr'=>TABLE_PRODUCT_RELATION_FILTER),
								  'on'=>"(f.FilterValueID=pr.FilterValueID)",
								  'type'=>''
								  );
				$where = new Where();
				$where->equalTo('pr.ProductID',$ProductID);
				$where->equalTo('f.Active',1);
				$TmpObj3->where = $where;
				$TmpObj3->columnExpression=true;
				//$TmpObj3->displayQuery = true;
				$Fobj = (object)$TmpObj3->tableSelectOne(array("GROUP_CONCAT(DISTINCT f.FilterValue ORDER BY FilterValue ASC SEPARATOR ' ') as FilterValues"));
				$IdxSearch .= " ".(isset($Fobj->FilterValues)?$Fobj->FilterValues:"");
				
				$FobjIds = (object)$TmpObj3->tableSelectOne(array("GROUP_CONCAT(DISTINCT f.FilterValueID ORDER BY FilterValue ASC SEPARATOR ',') as FilterValueIDs"));
				$IdxFilter .= " ".(isset($FobjIds->FilterValueIDs)?trim($FobjIds->FilterValueIDs):"");
				
				$TmpObj4 = new DataTable(array("a"=>TABLE_ATTRIBUTE_VALUE));
				$TmpObj4->joinExpression = true;
				$TmpObj4->joinArray[] = array('name'=>array('pr'=>TABLE_PRODUCT_RELATION),
								  'on'=>"(a.AttributeValueID=pr.RelationID and pr.RelationType='attribute_child')",
								  'type'=>''
								  );
				$where = new Where();
				$where->in('pr.ProductID',$ChildIDArr);
				$where->equalTo('pr.RelationType','attribute_child');
				$where->equalTo('a.Active',1);
				$TmpObj4->where = $where;
				$TmpObj4->columnExpression=true;
				//$TmpObj4->displayQuery = true;
				$Aobj = (object)$TmpObj4->tableSelectOne(array("GROUP_CONCAT(DISTINCT a.AttributeValue ORDER BY AttributeValue ASC SEPARATOR ' ') as AttributeValues"));
				$IdxSearch .= " ".(isset($Aobj->AttributeValues)?$Aobj->AttributeValues:"");
				
				
				$TmpObj = new DataTable(TABLE_PRODUCT_PRICES);
				$where = new Where();
				$where->in('ProductID',$ChildIDArr);
				$where->equalTo('UserTypeID',1);
				$TmpObj->where = $where;
				$TmpObj->columnExpression=true;
				//$TmpObj->displayQuery = true;
				$ChPObj = (object)$TmpObj->tableSelectOne(array('MinPrice'=>'MIN( IF(SaleActive=1, SalePrice, Price) )','MaxPrice'=>'Max( IF(SaleActive=1, SalePrice, Price) )'));
				
				$DataArray = array();
				$DataArray['Clearance'] = $IdxClearance;
				if(isset($IdxFilter) && trim($IdxFilter) != "")
					$DataArray['IdxFilter'] = substr($IdxFilter,0,250);
				if(isset($IdxSearch) && trim($IdxSearch) != "")
					$DataArray['IdxSearch'] = substr($IdxSearch,0,250);
				if(isset($IdxSearch) && trim($ChPObj->MinPrice > 0) != "")
					$DataArray['IdxSearch'] = substr($IdxSearch,0,250);
				if(isset($ChPObj->MinPrice) && $ChPObj->MinPrice > 0){
					if(isset($PercentObj->DiscountPercent) && $PercentObj->DiscountPercent > 0)
						$GridDiscountPrice = ($PercentObj->DiscountPercent/100) * $ChPObj->MinPrice;
					
					$DataArray['IdxMinPrice'] = $ChPObj->MinPrice - $GridDiscountPrice;
				}
				if(isset($ChPObj->MaxPrice) && $ChPObj->MaxPrice > 0){
					$DataArray['IdxMaxPrice'] = $ChPObj->MaxPrice;
				}
				if(count($DataArray) > 0){
					$ProductObj = new DataTable(TABLE_PRODUCT);
					$ProductObj->where="ProductID ='".(int)$ProductID."'";
					$ProductObj->tableUpdate($DataArray);
				}
				if($IdxClearance =="1"){
					$this->ResetProductCategories($ProductID);
					$this->AssignCategories($ProductID,array(2));
				}
			
			}
			else{
				$MasterArray = array();
				$MasterArray['Active'] ="0";
				$MasterObj = new DataTable(TABLE_PRODUCT);  
				$MasterObj->where[] = array('=',array('ProductID' => $ProductID));
				$MasterObj->tableUpdate($MasterArray);
			}
			
			
			
		}
		/* type:attribute end*/
		/* type:simple,child start*/
		if(in_array(strtolower($CurrentProduct->ProductType),array("child","simple")) ){
			
				$IdxSearch = "";
				$IdxFilter = "";
				
				$TmpObj3 = new DataTable(array("f"=>TABLE_FILTER_VALUE));
				$TmpObj3->joinExpression = true;
				$TmpObj3->joinArray[] = array('name'=>array('pr'=>TABLE_PRODUCT_RELATION_FILTER),
								  'on'=>"(f.FilterValueID=pr.FilterValueID)",
								  'type'=>''
								  );
				$where = new Where();
				$where->equalTo('pr.ProductID',$ProductID);
				$where->equalTo('f.Active',1);
				$TmpObj3->where = $where;
				$TmpObj3->columnExpression=true;
				//$TmpObj3->displayQuery = true;
				$Fobj = (object)$TmpObj3->tableSelectOne(array("GROUP_CONCAT(DISTINCT f.FilterValue ORDER BY FilterValue ASC SEPARATOR ' ') as FilterValues"));
				$IdxSearch .= " ".(isset($Fobj->FilterValues)?$Fobj->FilterValues:"");
				
			
			$TmpObj = new DataTable(TABLE_PRODUCT_PRICES);
			$where = new Where();
			$where->in('ProductID',array($ProductID));
			$where->equalTo('UserTypeID',1);
			$TmpObj->where = $where;
			$TmpObj->columnExpression=true;
			//$TmpObj->displayQuery = true;
			$ChPObj = (object)$TmpObj->tableSelectOne(array('MinPrice'=>'MIN( IF(SaleActive=1, SalePrice, Price) )','MaxPrice'=>'Max( IF(SaleActive=1, SalePrice, Price) )'));
			
			$DataArray = array();
			if(isset($IdxFilter) && trim($IdxFilter) != "")
					$DataArray['IdxFilter'] = substr($IdxFilter,0,250);
			if(isset($IdxSearch) && trim($IdxSearch) != "")
					$DataArray['IdxSearch'] = substr($IdxSearch,0,250);
			if(isset($ChPObj->MinPrice) && $ChPObj->MinPrice > 0)
				$DataArray['IdxMinPrice'] = $ChPObj->MinPrice;
			if(isset($ChPObj->MaxPrice) && $ChPObj->MaxPrice > 0)
				$DataArray['IdxMaxPrice'] = $ChPObj->MaxPrice;
			if(count($DataArray) > 0){
				$ProductObj = new DataTable(TABLE_PRODUCT);
				$ProductObj->where="ProductID ='".(int)$ProductID."'";
				$ProductObj->tableUpdate($DataArray);
			}
				
				
		}
		/* type:simple,child end*/
		
	}
	public function BTCResetClearance()
	{
		$ProductObj = new DataTable(TABLE_PRODUCT);
		$DataArray = array();
		$DataArray['Clearance'] ="0";
		$ProductObj->where="1";
		$ProductObj->tableUpdate($DataArray);
		
		$ProductCategoryObj = new DataTable(TABLE_PRODUCT_RELATION);
		$ProductCategoryObj->where = array(array('=',array('RelationType' => "catalog_category")),
										  array('=',array('RelationID' => 2)));
		$ProductCategoryObj->tableDelete();	
		
		
	}
	function ResetProductCategories($ProductID)
	{
		$ProductCategoryObj = new DataTable(TABLE_PRODUCT_RELATION);
		$ProductCategoryObj->where = array(array('=',array('RelationType' => "catalog_category")),
										  array('=',array('ProductID' => $ProductID)));
		$ProductCategoryObj->tableDelete();	
		
	}
	function AssignCategories($ProductID,$CategoriesIDs)
	{
		if(is_array($CategoriesIDs) && count($CategoriesIDs) > 0){
			
			$ProductCategoryObj = new DataTable(TABLE_PRODUCT_RELATION);
			foreach($CategoriesIDs as $CategoryID){
				$DBObj = new DataTable(TABLE_PRODUCT_RELATION);
				$where = new Where();
				$where->equalTo('ProductID',$ProductID);
				$where->equalTo('RelationID',$CategoryID);
				$where->equalTo('RelationType','catalog_category');
				$DBObj->where = $where;
				$Singleobj = (object)$DBObj->tableSelectOne(array("RelationID"),"RelationID ASC");
				if(isset($Singleobj->RelationID)){
				
				}
				else{
					$DataArray = array();
					$DataArray['ProductID'] = $ProductID;
					$DataArray['RelationID'] = $CategoryID;
					$DataArray['RelationType'] = "catalog_category";
					$DataArray['SortOrder'] = $this->getClass("Catalog\Product\Common")->SKMaxGetProductSortOrder($CategoryID,"catalog_category") + 1;
					$ProductCategoryObj->tableInsert($DataArray);
				}
			
			
			}
		}
		
	}
	
	function GetProductPriceNStock($ProductID,$Qty = 1,$OptionArray = array())
	{
		if(filter_var($Qty, FILTER_VALIDATE_INT)==false)
			$Qty = 1;
		
		$CurrencyObj = new CurrencyHandler();
		
		$IsCurrentUser = $this->getClass('Customer\Login\Common')->IsUserLogin();
		$SessPriceDisplay = $this->getSession()->getVar("SessPriceDisplay");;
		$ReturnArray = array("Qty"=>$Qty,
							 "Stock"=>0,
							"RetailPrice"=>0,
							"Price"=>0,
							"UnitPrice"=>0,
							"PriceWithTax"=>0,
							"PriceWithoutTax"=>0,
							"DisplayPrice"=>0,
							"DisplayPriceIncVat"=>0,
							"DisplayPriceExcVat"=>0,
							"DisplayPriceDetails"=>"",
							"DefaultDisplayPriceDetails"=>"",
							"TaxPrice"=>0,
							"TaxPercent"=>0,
							"TaxInPrice"=>0,
							"Discount"=>0,
							"LoyaltyDiscountActive"=>0,
							"DiscountPercent"=>0,
							"GridPrice"=>"",
							"GridHoverPrice"=>"",
							"TaxIncVAT"=>"(Inc VAT)",
							"TaxExcVAT"=>"(Ex VAT)",
							"PriceSuffix"=>"",
							"DefaultCurrencyFormat"=>"",
							"CurrentCurrencyFormat"=>"",
							"DefaultObject"=>"",
							"Object"=>"",
							"DefaultArray"=>"",
							"Array"=>"",
							);
			
		$ReturnArray['DefaultCurrencyFormat'] = $CurrencyObj->Change2DefaultCurrency(0);
		$ReturnArray['CurrentCurrencyFormat'] = $CurrencyObj->Change2CurrentCurrency(0);
		$ReturnArray['PriceSuffix'] = $ReturnArray['TaxExcVAT'];
		if($SessPriceDisplay=="INC")
			$ReturnArray['PriceSuffix'] = $ReturnArray['TaxIncVAT'];
		
		
		$TaxInPrice = "0";
		if(d("VAT_ADDED_PRICE")=="1")
			$TaxInPrice = "1";
		
		if(isset($IsCurrentUser->LoyaltyDiscountActive) && $IsCurrentUser->LoyaltyDiscountActive == "1"){
			$ReturnArray['LoyaltyDiscountActive'] = $IsCurrentUser->LoyaltyDiscountActive;		
			$ReturnArray['DiscountPercent'] = (isset($IsCurrentUser->DiscountPercent) && $IsCurrentUser->DiscountPercent > 0)?$IsCurrentUser->DiscountPercent:0;		
		
		}
		/* Default Price Start*/
		$ProductObj = new DataTable(array('p'=>TABLE_PRODUCT));
		$ProductObj->joinExpression = true;
		$ProductObj->joinArray[] = array('name'=>array('pr'=>TABLE_PRODUCT_PRICES),
									  'on'=>"(pr.ProductID = p.ProductID)",
									  'columns'=>array("*"),
									  'type'=>"left",
									  );
		
		$ProductObj->joinArray[] = array('name'=>array('ut'=>TABLE_USER_TYPE),
									  'on'=>"(ut.UserTypeID = pr.UserTypeID AND IsDefault=1)",
										  'columns'=>array("UserTypeID","IsDefault"),
										  'type'=>"left",
										  );
										  
		$where = new Where();
		$where->equalTo('p.ProductID',$ProductID);
		$where->equalTo('ut.IsDefault','1');
		$where->greaterThanOrEqualTo('QtyMax',$Qty);
		$where->lessThanOrEqualTo('QtyMin',$Qty);
		$ProductObj->where = $where;								  
		//$ProductObj->displayQuery = true;
		$CurrentProduct = (object)$ProductObj->tableSelectOne(array("ProductID","MasterID","ModelNo","TaxClass","ProductType","GDiscountOff","Stock","StockStatus","StockTotal","EndStock"),array("QtyMin ASC"));		
		
		$TaxArray = $this->GetTaxPercentByTaxClassID($CurrentProduct->TaxClass);
		$TaxPercent = isset($TaxArray['TaxPercent'])?$TaxArray['TaxPercent']:"0";
		$TaxPrice = 0;
		if(!isset($CurrentProduct->ProductID)){
			//die("Product not found");
		}
		/* Attribute Product Start*/
		if(strtolower($CurrentProduct->ProductType)=="attribute"){
			$ProductObj = new DataTable(array('p'=>TABLE_PRODUCT));
			$ProductObj->where[] = array('=',array('p.MasterID' => $CurrentProduct->ProductID));
			$ProductObj->where[] = array('=',array('p.ProductType' => 'Child'));
			$ProductObj->where[] = array('=',array('p.Active' => '1'));
			//$ProductObj->displayQuery = true;
			$Obj  = (object)$ProductObj->tableSelectOne(array("ProductID"));
			if(isset($Obj->ProductID))
				return $this->GetProductPriceNStock($Obj->ProductID,$Qty,$OptionArray);
		}
		/* Attribute Product End*/
		
		$ReturnArray['Object'] =  $ReturnArray['DefaultObject'] = $CurrentProduct;		
		$ReturnArray['Array'] =  $ReturnArray['DefaultArray'] = (array)$CurrentProduct;	
		
		if(strtolower($CurrentProduct->ProductType)=="child")
		{
			$MasterObj = new DataTable(array('p'=>TABLE_PRODUCT));
			$where = new Where();
			$where->equalTo('p.ProductID',$CurrentProduct->MasterID);
			$MasterObj->where = $where;								  
			$CurrentMaster = (object)$MasterObj->tableSelectOne(array("ProductID","MasterID","IdxMinPrice","IdxMaxPrice","TaxClass","ProductType","GDiscountOff"));		
			if(!isset($CurrentProduct->TaxClass)){
				if($CurrentMaster->TaxClass != "")
					$CurrentProduct->TaxClass = $CurrentMaster->TaxClass;
			}
			
			$TaxArray = $this->GetTaxPercentByTaxClassID($CurrentProduct->TaxClass);
			$TaxPercent = isset($TaxArray['TaxPercent'])?$TaxArray['TaxPercent']:"0";
			
		
			if(isset($CurrentMaster->IdxMinPrice)){
				$MinPrice = $this->getPriceWithoutTax($CurrentMaster->IdxMinPrice,$CurrentProduct->TaxClass,$TaxInPrice);
				$ReturnArray['Array']['MinPriceWithTax'] = $ReturnArray['Array']['MinPriceWithoutTax'] = $ReturnArray['Array']['MinPrice'] = $MinPrice;
				if($TaxPercent > 0)
					$ReturnArray['Array']['MinPriceWithTax'] = $MinPrice + ($MinPrice*($TaxPercent/100));
			}
			if(isset($CurrentMaster->IdxMaxPrice)){
				$MaxPrice = $this->getPriceWithoutTax($CurrentMaster->IdxMaxPrice,$CurrentProduct->TaxClass,$TaxInPrice);
				$ReturnArray['Array']['MaxPriceWithTax'] = $ReturnArray['Array']['MaxPriceWithoutTax'] = $ReturnArray['Array']['MaxPrice'] = $MaxPrice;
				if($TaxPercent > 0)
					$ReturnArray['Array']['MaxPriceWithTax'] = $MaxPrice + ($MaxPrice*($TaxPercent/100));
			}
			
			//$DisplayMinMaxPriceExcVat = '<div class="DivMainPrice" data-currency="'.$CurrencyObj->Change2CurrentCurrency(0).'"><span class="ExVat">From <span class="norm_price">'.$CurrencyObj->Change2CurrentCurrency($ReturnArray['Array']['MinPriceWithoutTax']).' - '.$CurrencyObj->Change2CurrentCurrency($ReturnArray['Array']['MaxPriceWithoutTax']).' '.$ReturnArray['TaxExcVAT'].'</span></span></div>';
			//$DisplayMinMaxPriceIncVat = '<div class="DivMainPrice" data-currency="'.$CurrencyObj->Change2CurrentCurrency(0).'"><span class="IncVat">From <span class="norm_price">'.$CurrencyObj->Change2CurrentCurrency($ReturnArray['Array']['MinPriceWithTax']).' - '.$CurrencyObj->Change2CurrentCurrency($ReturnArray['Array']['MaxPriceWithTax']).' '.$ReturnArray['TaxIncVAT'].'</span></span></div>';
			
			$DisplayMinMaxPriceExcVat = '<div class="DivMainPrice" data-currency="'.$CurrencyObj->Change2CurrentCurrency(0).'"><span class="ExVat">From <span class="norm_price">'.$CurrencyObj->Change2CurrentCurrency($ReturnArray['Array']['MinPriceWithoutTax']).' '.$ReturnArray['TaxExcVAT'].'</span></span></div>';
			$DisplayMinMaxPriceIncVat = '<div class="DivMainPrice" data-currency="'.$CurrencyObj->Change2CurrentCurrency(0).'"><span class="IncVat">From <span class="norm_price">'.$CurrencyObj->Change2CurrentCurrency($ReturnArray['Array']['MinPriceWithTax']).' '.$ReturnArray['TaxIncVAT'].'</span></span></div>';
			
			$DisplayMinMaxPrice = $DisplayMinMaxPriceExcVat;
			if($SessPriceDisplay=="INC")
				$DisplayMinMaxPrice = $DisplayMinMaxPriceIncVat;
			
			$ReturnArray['Array']['DisplayMinMaxPrice'] = $DisplayMinMaxPrice;
			
			
		}
		
			
		
		
		
		
		/* Stock Mange Start*/
		$StockArray = array();
		$StockArray['Status'] = true;
		$StockArray['Manage'] = "0";
		$StockArray['EndStock'] = isset($CurrentProduct->EndStock)?$CurrentProduct->EndStock:0;
		$StockArray['StockStatus'] = isset($CurrentProduct->StockStatus)?$CurrentProduct->StockStatus:0;
		if(isset($CurrentProduct->EndStock) && $CurrentProduct->EndStock == "1")
		{
			$LeftStock = $CurrentProduct->Stock;
			$SoldStock = $CurrentProduct->StockTotal - $CurrentProduct->Stock;
			$StockArray['Manage'] = $StockArray['EndStock'];
			$StockArray['Total'] = $CurrentProduct->StockTotal;
			$StockArray['Left'] = $LeftStock;
			$StockArray['Sold'] = $SoldStock;
			$StockArray['Percent'] = "0";
			if($CurrentProduct->StockTotal > 0){
					$StockArray['Percent'] = round(($CurrentProduct->Stock/$CurrentProduct->StockTotal)*100);
			if($StockArray['Percent'] < 0)
					$StockArray['Percent'] = 0;
			}
			
			if($LeftStock > 0 || @$CurrentProduct->EndStock==0)
			{
				$StockArray['Status'] = true;
			}
			else 
			{
				$StockArray['Status'] = false;
			}
		}
		/* Stock Mange End*/
		
	    	
		$RetailPrice =  $UnitPrice  = $Price = $SpecialPrice = $MainPrice =  $this->getPriceWithoutTax($CurrentProduct->Price,$CurrentProduct->TaxClass,$TaxInPrice);
		
		if((in_array(strtolower($CurrentProduct->ProductType),array("simple","child","bundle"))) && $CurrentProduct->SaleActive=="1")
		{
			$UnitPrice  = $Price = $SpecialPrice = $MainPrice = $this->getPriceWithoutTax($CurrentProduct->SalePrice,$CurrentProduct->TaxClass,$TaxInPrice);
		}
		
		/* Flash sale check */
		/*
		$FlashProductObj = new DataTable(array('p'=>TABLE_PRODUCT));
		$FlashProductObj->joinExpression = true;
		$FlashProductObj->joinArray[] = array('name'=>array('pr'=>TABLE_PRODUCT_PRICES),
									  'on'=>"(pr.ProductID = p.ProductID)",
									  'columns'=>array("*"),
									  'type'=>"left",
									  );
		
										  
		$where = new Where();
		$where->equalTo('p.ProductID',$ProductID);
		$where->equalTo('pr.UserTypeID','10');
		$where->equalTo('pr.SaleActive','1');
		$where->NEST//start braket
				->expression('(? BETWEEN SaleStartDate AND SaleEndDate)',date('Y-m-d'))
				//->OR
				//->expression("(SaleStartDate =? OR SaleEndDate =?)",array('0000-00-00','0000-00-00'))
				->OR
					->NEST//start braket
					->ISNULL('SaleStartDate')
					->AND
					->ISNULL('SaleEndDate')
					->UNNEST
			  ->UNNEST;
		$where->greaterThanOrEqualTo('QtyMax',$Qty);
		$where->lessThanOrEqualTo('QtyMin',$Qty);
		$FlashProductObj->where = $where;								  
		//$FlashProductObj->displayQuery = true;
		$FlashProduct = (object)$FlashProductObj->tableSelectOne(array("ProductID"),array("QtyMin ASC"));	
		$FlashSale = 0;
		if(isset($FlashProduct->ProductID) && isset($FlashProduct->SalePrice) && $FlashProduct->SalePrice > 0 && $FlashProduct->SaleActive=="1")
		{
			$FlashSale = "1";
			 $UnitPrice  = $Price = $SpecialPrice = $MainPrice = $this->getPriceWithoutTax($FlashProduct->SalePrice,$CurrentProduct->TaxClass,$TaxInPrice);
		}
		*/
		/* Flash sale check */
		if((isset($IsCurrentUser->UserTypeID) && $IsCurrentUser->UserTypeID=="1") || !isset($IsCurrentUser->UserTypeID)){
			$UserTypeID =1;	
			
			$DefaultUserDetailRows = $this->UserProductPrice($CurrentProduct->ProductID,$UserTypeID);
			if(isset($DefaultUserDetailRows) && count($DefaultUserDetailRows) > 1){
			
			$DefaultDisplayPriceDetails = '<div class="table-responsive mt-md-5 mt-4 mb-3">
											<table class="table text-center fw-medium fs-17 caption-top table-bordered">
												<thead>
												  <tr>
													<th colspan="'.count($DefaultUserDetailRows).'" class="text-center bg-light py-2 fs-20 fw-bold">Unit Price</th>
												  </tr>
												</thead>';
			$DefaultDisplayPriceDetails .= '<tr class="PriceValueTR">';
			$i=0;
			foreach( $DefaultUserDetailRows as $CurrentUPrice){
				$i++;
				if($TaxPercent > 0){
					$CurrentUPrice['SalePriceWithTax'] =  $CurrentUPrice['SalePrice'] + ($CurrentUPrice['SalePrice']*($TaxPercent/100));
					$CurrentUPrice['PriceWithTax'] =  $CurrentUPrice['Price'] + ($CurrentUPrice['Price']*($TaxPercent/100));
				}
				else{
					$CurrentUPrice['SalePriceWithTax'] =  $CurrentUPrice['SalePrice'];
					$CurrentUPrice['PriceWithTax'] =  $CurrentUPrice['Price'];
				}
				if($CurrentUPrice['QtyMin']==0)
					$CurrentUPrice['QtyMin'] =1;
				
				if($CurrentUPrice['QtyMin']==$CurrentUPrice['QtyMax'])
					$CurrentUPrice['QtyMax'] = "";
				elseif(count($DefaultUserDetailRows)==$i)
					$CurrentUPrice['QtyMax'] = "+";
				else
					$CurrentUPrice['QtyMax'] = "-".$CurrentUPrice['QtyMax'];
				
				$DefaultDisplayPriceDetails .= '<td align="left" class="py-4">
												<span class="d-block">'.(isset($CurrentUPrice['QtyMin'])?$CurrentUPrice['QtyMin']:"").(isset($CurrentUPrice['QtyMax'])?$CurrentUPrice['QtyMax']:"").'</span>';
				if($SessPriceDisplay=="INC"){
					if($CurrentUPrice['SaleActive']=="1")
						$DefaultDisplayPriceDetails .= '<span class="sale-price">'.(isset($CurrentUPrice['SalePriceWithTax'])?$CurrencyObj->Change2CurrentCurrency($CurrentUPrice['SalePriceWithTax']):"").' '.$ReturnArray['TaxIncVAT'].'</span>';
					else
						$DefaultDisplayPriceDetails .= '<span class="price">'.(isset($CurrentUPrice['PriceWithTax'])?$CurrencyObj->Change2CurrentCurrency($CurrentUPrice['PriceWithTax']):"").' '.$ReturnArray['TaxIncVAT'].'</span>';
					
				}
				else{
					if($CurrentUPrice['SaleActive']=="1")
						$DefaultDisplayPriceDetails .= '<span class="sale-price">'.(isset($CurrentUPrice['SalePrice'])?$CurrencyObj->Change2CurrentCurrency($CurrentUPrice['SalePrice']):"").' '.$ReturnArray['TaxExcVAT'].'</span>';
					else
						$DefaultDisplayPriceDetails .= '<span class="price">'.(isset($CurrentUPrice['Price'])?$CurrencyObj->Change2CurrentCurrency($CurrentUPrice['Price']):"").' '.$ReturnArray['TaxExcVAT'].'</span>';
				}
				$DefaultDisplayPriceDetails .= '</td>';
			}
			$DefaultDisplayPriceDetails .= '</tr>';
			$DefaultDisplayPriceDetails .= '</table></div>';	
		}
			
			
		}
		
		/* VIPStatus Start*/
		if(isset($IsCurrentUser->VIPStatus) && $IsCurrentUser->VIPStatus=="1" && $CurrentProduct->VIPStatus=="1"){
			$UserTypeID =3;			
			/* VIPStatus check */
			$UserProductObj = new DataTable(array('p'=>TABLE_PRODUCT));
			$UserProductObj->joinExpression = true;
			$UserProductObj->joinArray[] = array('name'=>array('pr'=>TABLE_PRODUCT_PRICES),
										  'on'=>"(pr.ProductID = p.ProductID)",
										  'columns'=>array("*"),
										  'type'=>"left",
										  );
			
											  
			$where = new Where();
			$where->equalTo('p.ProductID',$ProductID);
			$where->equalTo('pr.UserTypeID',$UserTypeID);
			$where->greaterThanOrEqualTo('QtyMax',$Qty);
			$where->lessThanOrEqualTo('QtyMin',$Qty);
			$UserProductObj->where = $where;								  
			//$UserProductObj->displayQuery = true;
			$CurrentProductPrice = (object)$UserProductObj->tableSelectOne(array("ProductID"),array("QtyMin ASC"));	
			$ReturnArray['Object'] =  $CurrentProductPrice;		
			$ReturnArray['Array'] =  (array)$CurrentProductPrice;		
		
			if(isset($CurrentProductPrice->Price) && $CurrentProductPrice->Price  != 0)
			{
				$FlashSale = 1;
				if(isset($CurrentProductPrice->PriceType) && $CurrentProductPrice->PriceType =="Percentage")
					$UserPrice = ($CurrentProductPrice->Price/100)*$CurrentProduct->Price;
				else 
					$UserPrice = $CurrentProductPrice->Price;
			
				$RetailPrice =  $UnitPrice  = $Price = $SpecialPrice = $MainPrice =  $this->getPriceWithoutTax($UserPrice,$CurrentProduct->TaxClass,$TaxInPrice);	
				
				if(strtolower($CurrentProduct->ProductType)=="simple" && $CurrentProductPrice->SaleActive=="1")
				{
					if(isset($CurrentProductPrice->PriceType) && $CurrentProductPrice->PriceType =="Percentage")
						$UserSalePrice = ($CurrentProductPrice->SalePrice/100)*$CurrentProduct->Price;
					else 
						$UserSalePrice = $CurrentProductPrice->SalePrice;
					
					$UnitPrice  = $Price =  $SpecialPrice = $MainPrice = $this->getPriceWithoutTax($UserSalePrice,$CurrentProduct->TaxClass,$TaxInPrice);
				}				
				
			}
			$UserDetailRows = $this->UserProductPrice($CurrentProduct->ProductID,$UserTypeID);
		}
		/* VIPStatus end*/
		
		/* WholeSaler Start*/
		if(isset($IsCurrentUser->WholeSaler) && $IsCurrentUser->WholeSaler=="1"){
			$UserTypeID =2;
			/* WholeSaler check */
			$UserProductObj = new DataTable(array('p'=>TABLE_PRODUCT));
			$UserProductObj->joinExpression = true;
			$UserProductObj->joinArray[] = array('name'=>array('pr'=>TABLE_PRODUCT_PRICES),
										  'on'=>"(pr.ProductID = p.ProductID)",
										  'columns'=>array("*"),
										  'type'=>"left",
										  );
			
											  
			$where = new Where();
			$where->equalTo('p.ProductID',$ProductID);
			$where->equalTo('pr.UserTypeID',$UserTypeID);
			$where->greaterThanOrEqualTo('QtyMax',$Qty);
			$where->lessThanOrEqualTo('QtyMin',$Qty);
			$UserProductObj->where = $where;								  
			//$FlashProductObj->displayQuery = true;
			$CurrentProductPrice = (object)$UserProductObj->tableSelectOne(array("ProductID"),array("QtyMin ASC"));	
			$ReturnArray['Object'] =  $CurrentProductPrice;		
			$ReturnArray['Array'] =  (array)$CurrentProductPrice;		
			if(isset($CurrentProductPrice->Price) && $CurrentProductPrice->Price  != 0)
			{
				$FlashSale = 1;
				if(isset($CurrentProductPrice->PriceType) && $CurrentProductPrice->PriceType =="Percentage")
					$UserPrice = ($CurrentProductPrice->Price/100)*$CurrentProduct->Price;
				else 
					$UserPrice = $CurrentProductPrice->Price;
			
				$RetailPrice =  $UnitPrice  = $Price = $SpecialPrice = $MainPrice =  $this->getPriceWithoutTax($UserPrice,$CurrentProduct->TaxClass,$TaxInPrice);	
				
				if(strtolower($CurrentProduct->ProductType)=="simple" && $CurrentProductPrice->SaleActive=="1")
				{
					if(isset($CurrentProductPrice->PriceType) && $CurrentProductPrice->PriceType =="Percentage")
						$UserSalePrice = ($CurrentProductPrice->SalePrice/100)*$CurrentProduct->Price;
					else 
						$UserSalePrice = $CurrentProductPrice->SalePrice;
					
					$UnitPrice  = $Price =  $SpecialPrice = $MainPrice = $this->getPriceWithoutTax($UserSalePrice,$CurrentProduct->TaxClass,$TaxInPrice);
				}				
				
			}
			
			$UserDetailRows = $this->UserProductPrice($CurrentProduct->ProductID,$UserTypeID);
		}
		/* WholeSaler end*/
		if(d("GLOBAL_PRODUCT_DISCOUNT_STATUS")=="1" && d("GLOBAL_PRODUCT_DISCOUNT_VALUE") >0 && $CurrentProduct->GDiscountOff != "1" && $FlashSale != "1")
		{
			$GlobalDiscountPrice = (d("GLOBAL_PRODUCT_DISCOUNT_VALUE")/100) * $MainPrice;
			$UnitPrice  = $Price =  $SpecialPrice =  $MainPrice- $GlobalDiscountPrice;
		}
		
		/* DiscountPercent check start */
			$ProductDiscountObj = new DataTable(array('pd'=>TABLE_PRODUCT_DISCOUNT));
			$where = new Where();
			$where->equalTo('pd.UserTypeID',$UserTypeID);
			$where->greaterThanOrEqualTo('QtyMax',$Qty);
			$where->lessThanOrEqualTo('QtyMin',$Qty);
			$ProductDiscountObj->where = $where;								  
			$CurrentProductPrice = (object)$ProductDiscountObj->tableSelectOne(array("DiscountPercent"),array("QtyMin ASC"));	
			if(isset($CurrentProductPrice->DiscountPercent) && $CurrentProductPrice->DiscountPercent  != 0)
			{
				/* calculate on cart page runtime
				$FlashSale = 1;
				$UserPrice = $CurrentProduct->Price - ($CurrentProductPrice->DiscountPercent/100)*$CurrentProduct->Price;
				$RetailPrice =  $UnitPrice  = $Price = $SpecialPrice = $MainPrice =  $this->getPriceWithoutTax($UserPrice,$CurrentProduct->TaxClass,$TaxInPrice);	
				*/
				
			}
		/* DiscountPercent check end*/
		
		
		
		/* bundle price check start*/
		if(strtolower($CurrentProduct->ProductType)=="bundle") 
		{
			/* under constructions*/
		}
		/* bundle price check end*/
		
		
		
		
		
		/* additional attribute price start*/
		 if(isset($OptionArray) && is_array($OptionArray) && count($OptionArray) > 0)
		 {
			 if(isset($OptionArray['ProductAdditionID']) && $OptionArray['ProductAdditionID'] != "")
			 {
				$ProductAdditionObj = new DataTable(TABLE_PRODUCT_ADDITIONS);
				$ProductAdditionObj->where[] = array('=',array('ProductAdditionID' => (int)$OptionArray['ProductAdditionID']));
				$ProductAdditionObj->where[] = array('=',array('ProductID' => (int)$CurrentProduct->ProductID));
				$CurrentAddition = (object)$ProductAdditionObj->tableSelectOne();
				if($CurrentAddition->ProductID && $CurrentAddition->ProductID !="")
				{
					if($CurrentAddition->Price >0){
						if($CurrentAddition->PriceSet=="+")
							$RetailPrice =  $UnitPrice  = $Price = $MainPrice = $this->getPriceWithoutTax($CurrentAddition->Price,$CurrentProduct->TaxClass,$TaxInPrice);
						else if($CurrentAddition->PriceSet=="-")
							$RetailPrice =  $UnitPrice  = $Price = $MainPrice = - $this->getPriceWithoutTax($CurrentAddition->Price,$CurrentProduct->TaxClass,$TaxInPrice);
						
					}
					else{
						$RetailPrice =  $UnitPrice  = $Price = $MainPrice = 0;
					}
				}
			 }
		 }
		 /* additional attribute price start*/		
		
		
		if($TaxPercent > 0){

			$TaxPrice = ($MainPrice*($TaxPercent/100)) ;
			
			$RetailPriceWithoutTax = $RetailPrice;
			$UnitPriceWithoutTax =  $UnitPrice;
			$PriceWithoutTax = $Price;
			$MainPriceWithoutTax  = $MainPrice;
			$SpecialPriceWithoutTax = $SpecialPrice;
			
			$RetailPriceWithTax = $RetailPrice + ($RetailPrice*($TaxPercent/100));
			$UnitPriceWithTax =  $UnitPrice + ($UnitPrice*($TaxPercent/100));
			$PriceWithTax = $Price + ($Price*($TaxPercent/100));
			$MainPriceWithTax  = $MainPrice + ($MainPrice*($TaxPercent/100));
			$SpecialPriceWithTax = $SpecialPrice + ($SpecialPrice*($TaxPercent/100));
			
		}
		else{
			
			$RetailPriceWithTax = $RetailPriceWithoutTax = $RetailPrice;
			$UnitPriceWithTax = $UnitPriceWithoutTax =  $UnitPrice;
			$PriceWithTax = $PriceWithoutTax = $Price;
			$MainPriceWithTax = $MainPriceWithoutTax  = $MainPrice;
			$SpecialPriceWithTax = $SpecialPriceWithoutTax = $SpecialPrice;
		}
		
		if($UserTypeID > 0)
		{
			$GridPrice = "";
			$GridHoverPrice = "";
			$GridDetailRows = $this->UserProductDiscountPercent($UserTypeID);
			if(isset($GridDetailRows) && count($GridDetailRows) > 1){
				
			$GridDisplayPriceDetails = '<div class="table-responsive">
											<table class="table text-center fw-medium fs-17 caption-top p-0 table-bordered">
												';
			$GridDisplayPriceDetails .= '<tr class="PriceValueTR">';
			$GridHoverPrice .= '<div class="rows">';
			$i=0;
			foreach( $GridDetailRows as $CurrentGridPrice){
				$i++;
				if($CurrentGridPrice['QtyMin']==0)
					$CurrentGridPrice['QtyMin'] =1;
				
				if($CurrentGridPrice['QtyMin']==$CurrentGridPrice['QtyMax'])
					$CurrentGridPrice['QtyMax'] = "";
				elseif(count($GridDetailRows)==$i)
					$CurrentGridPrice['QtyMax'] = "+";
				else
					$CurrentGridPrice['QtyMax'] = "-".$CurrentGridPrice['QtyMax'];
				
				
				$GridDiscountPrice = ($CurrentGridPrice['DiscountPercent']/100) * $MainPrice;
				$GridUnitPrice = $UnitPriceWithoutTax - ($CurrentGridPrice['DiscountPercent']/100) * $UnitPriceWithoutTax;
				if($SessPriceDisplay=="INC"){
					$GridUnitPrice = $UnitPriceWithTax - ($CurrentGridPrice['DiscountPercent']/100) * $UnitPriceWithTax;
				}
				
				//$GridDisplayPriceDetails .= '<td align="left" class="py-4 PriceHD fw-bold"><span class="d-block">'.(isset($CurrentGridPrice['QtyMin'])?$CurrentGridPrice['QtyMin']:"").(isset($CurrentGridPrice['QtyMax'])?$CurrentGridPrice['QtyMax']:"").'</span>';
				$GridDisplayPriceDetails .= '<td align="left" class="p-0 text-center"><span class="d-block  PriceHD fw-bold">'.(isset($CurrentGridPrice['QtyMin'])?$CurrentGridPrice['QtyMin']:"").'+</span>';
				$GridDisplayPriceDetails .= '<span class="price fs-12">'.($CurrencyObj->Change2CurrentCurrency($GridUnitPrice)).'</span>';
				$GridDisplayPriceDetails .= '</td>';
				
				$GridHoverPrice .= '<span class="d-block  PriceHD fw-bold">'.(isset($CurrentGridPrice['QtyMin'])?$CurrentGridPrice['QtyMin']:"").'+</span>
									<span class="price fs-12">'.($CurrencyObj->Change2CurrentCurrency($GridUnitPrice)).'</span>
									';
			}
			$GridDisplayPriceDetails .= '</tr>';
			$GridDisplayPriceDetails .= '</table></div>';
			$GridPrice = $GridDisplayPriceDetails;
			$GridHoverPrice .= '</div>';	
			}
			
		}
		
		$DisplayPriceExcVat = '<div class="DivMainPrice" data-currency="'.$CurrencyObj->Change2CurrentCurrency(0).'" data-price="'.$SpecialPriceWithoutTax.'"><span class="ExVat">From <span class="norm_price">'.$CurrencyObj->Change2CurrentCurrency($SpecialPriceWithoutTax).' '.$ReturnArray['TaxExcVAT'].'</span></span></div>';
		$DisplayPriceIncVat = '<div class="DivMainPrice" data-currency="'.$CurrencyObj->Change2CurrentCurrency(0).'" data-price="'.$SpecialPriceWithTax.'"<span class="IncVat">From <span class="norm_price">'.$CurrencyObj->Change2CurrentCurrency($SpecialPriceWithTax).' '.$ReturnArray['TaxIncVAT'].'</span></span></div>';
		if(number_format($RetailPriceWithTax,2) > number_format($SpecialPriceWithTax,2))
		{
				$DisplayPriceExcVat = '<div class="DivMainPrice" data-currency="'.$CurrencyObj->Change2CurrentCurrency(0).'" data-price="'.$SpecialPriceWithoutTax.'"><span class="ExVat">From <span class="norm_price"><del>'.$CurrencyObj->Change2CurrentCurrency($RetailPriceWithoutTax).'</del></span> 
									   <span  class="sale_price">'.$CurrencyObj->Change2CurrentCurrency($SpecialPriceWithoutTax).' '.$ReturnArray['TaxExcVAT'].'</span></span>
									  </div>';
				$DisplayPriceIncVat = '<div class="DivMainPrice" data-currency="'.$CurrencyObj->Change2CurrentCurrency(0).'" data-price="'.$SpecialPriceWithTax.'"><span class="IncVat">From <span class="norm_price"><del>'.$CurrencyObj->Change2CurrentCurrency($RetailPriceWithTax).'</del></span> 
									   <span  class="sale_price">'.$CurrencyObj->Change2CurrentCurrency($SpecialPriceWithTax).' '.$ReturnArray['TaxIncVAT'].'</span></span>
								      </div>';				 
		}
		
		if(isset($UserDetailRows) && count($UserDetailRows) > 0){
			
			$DisplayPriceDetails = '<table  class="table-userprice table responsive table-responsive-md table-bordered table-striped">
										  <thead>
												<th align="left">Qty Min</th>
												<th align="left">Qty Max</th>
												<th align="left">Price</th>
											</thead>';
			foreach( $UserDetailRows as $CurrentUPrice){
				
				$DisplayPriceDetails .= '<tr class="PriceValueTR">';
				$DisplayPriceDetails .= '<td align="left">'.(isset($CurrentUPrice['QtyMin'])?$CurrentUPrice['QtyMin']:"").'</td>';
				$DisplayPriceDetails .= '<td align="left">'.(isset($CurrentUPrice['QtyMax'])?$CurrentUPrice['QtyMax']:"").'</td>';
				if($CurrentUPrice['SaleActive']=="1")
					$DisplayPriceDetails .= '<td align="left">'.(isset($CurrentUPrice['SalePrice'])?$CurrencyObj->Change2CurrentCurrency($CurrentUPrice['SalePrice']):"").'</td>';
				else
					$DisplayPriceDetails .= '<td align="left">'.(isset($CurrentUPrice['Price'])?$CurrencyObj->Change2CurrentCurrency($CurrentUPrice['Price']):"").'</td>';
				$DisplayPriceDetails .= '</tr>';
			}
			
			$DisplayPriceDetails .= '</table>';	
		}
		
		
		$DisplayPrice = $DisplayPriceExcVat;
		
		if($SessPriceDisplay=="INC")
			$DisplayPrice = $DisplayPriceIncVat;
		
		$JsPrice = $MainPriceWithoutTax;	
		if($SessPriceDisplay=="INC")
			$JsPrice = 	$MainPriceWithTax;
		
		$ReturnArray = array("Qty"=>$Qty,
							 "Array"=>$ReturnArray['Array'],
							 "DefaultArray"=>$ReturnArray['DefaultArray'],
							 "Object"=>$ReturnArray['Object'],
							 "DefaultObject"=>$ReturnArray['DefaultObject'],
							 "DefaultCurrencyFormat"=>$ReturnArray['DefaultCurrencyFormat'],
							 "CurrentCurrencyFormat"=>$ReturnArray['CurrentCurrencyFormat'],
							 "TaxIncVAT"=>$ReturnArray['TaxIncVAT'],
							 "TaxExcVAT"=>$ReturnArray['TaxExcVAT'],
							 "PriceSuffix"=>$ReturnArray['PriceSuffix'],
							 
							 "Stock"=>isset($Stock)?$Stock:"",
							 
							 "RetailPriceWithTax"=>isset($RetailPriceWithTax)?$RetailPriceWithTax:"",
							 "RetailPriceWithoutTax"=>isset($RetailPriceWithoutTax)?$RetailPriceWithoutTax:"",
							 "RetailPrice"=>isset($RetailPrice)?$RetailPrice:"",
							 
							 "UnitPriceWithTax"=>isset($UnitPriceWithTax)?$UnitPriceWithTax:"",
							 "UnitPriceWithoutTax"=>isset($UnitPriceWithoutTax)?$UnitPriceWithoutTax:"",
							 "UnitPrice"=>isset($UnitPrice)?$UnitPrice:"",
							 
							 "PriceWithTax"=>isset($PriceWithTax)?$PriceWithTax:"",
							 "PriceWithoutTax"=>isset($PriceWithoutTax)?$PriceWithoutTax:"",
							 "Price"=>isset($Price)?$Price:"",
							 
							 "MainPriceWithTax"=>isset($MainPriceWithTax)?$MainPriceWithTax:"",
							 "MainPriceWithoutTax"=>isset($MainPriceWithoutTax)?$MainPriceWithoutTax:"",
							 "MainPrice"=>isset($MainPrice)?$MainPrice:"",
							 "JsPrice"=>isset($JsPrice)?$JsPrice:"",
							 "GridPrice"=>isset($GridPrice)?$GridPrice:"",
							 "GridHoverPrice"=>isset($GridHoverPrice)?$GridHoverPrice:"",
							 
							 "SpecialPriceWithTax"=>isset($SpecialPriceWithTax)?$SpecialPriceWithTax:"",
							 "SpecialPriceWithoutTax"=>isset($SpecialPriceWithoutTax)?$SpecialPriceWithoutTax:"",
							 "SpecialPrice"=>isset($SpecialPrice)?$SpecialPrice:"",
							 
							 "TaxInPrice"=>isset($TaxInPrice)?$TaxInPrice:"0",
							 "TaxPrice"=>isset($TaxPrice)?$TaxPrice:"",
							 "TaxPercent"=>isset($TaxPercent)?$TaxPercent:"",
							 
							 "DisplayPrice"=>isset($DisplayPrice)?$DisplayPrice:"",
							 "DisplayPriceIncVat"=>isset($DisplayPriceIncVat)?$DisplayPriceIncVat:"",
							 "DisplayPriceExcVat"=>isset($DisplayPriceExcVat)?$DisplayPriceExcVat:"",
							 "DisplayPriceDetails"=>isset($DisplayPriceDetails)?$DisplayPriceDetails:"",
							 "DefaultDisplayPriceDetails"=>isset($DefaultDisplayPriceDetails)?$DefaultDisplayPriceDetails:"",
							 "Discount"=>"0",
							 "LoyaltyDiscountActive"=>$ReturnArray['LoyaltyDiscountActive'],
							 "DiscountPercent"=>$ReturnArray['DiscountPercent'],
							 "StockArray"=>$StockArray,
							);
		 
		
		 /* Default Price End*/
		
		return $ReturnArray;
	}
	
	
	
	function GetProductStockIcon($ProductID,$CurrentProduct,$RType="")
	{
		
		
		$SessPriceDisplay = $this->getSession()->getVar("SessPriceDisplay");;
		$ReturnArray = array("Qty"=>0,
							 "TotalAllQty"=>0,
							 "Stock"=>0,
							);
			
		$AttributeText = "";
		
		/* Default Stock Start*/
		$ProductObj = new DataTable(array('p'=>TABLE_PRODUCT));
		$where = new Where();
		$where->equalTo('p.ProductID',$ProductID);
		$ProductObj->where = $where;								  
		//$ProductObj->displayQuery = true;
		$CurrentProduct = (object)$ProductObj->tableSelectOne(array("ProductID","ProductAttribute","ProductType","Stock","StockStatus","StockTotal","EndStock"));		
		if(!isset($CurrentProduct->ProductID)){
			//die("Product not found");
		}
		
		$ReturnArray['Object'] =  $ReturnArray['DefaultObject'] = $CurrentProduct;		
		$ReturnArray['Array'] =  $ReturnArray['DefaultArray'] = (array)$CurrentProduct;		
		
		
		/* Attribute Product Start*/
		if(strtolower($CurrentProduct->ProductType)=="attribute"){
			
			$AttributeArr = $this->getClass('Catalog\Attribute\Common')->getAttributeArrayWithValues(explode(',',$CurrentProduct->ProductAttribute));
			$chidPrRows = $this->getProductChildren($CurrentProduct->ProductID);
			foreach($AttributeArr as $AttributeID=>$Arr){
				 if($AttributeText=="" && isset($Arr['AttributeName']) && $Arr['AttributeName'] != "")
						$AttributeText = count($chidPrRows)." ". $Arr['AttributeName'];
			 }
			
			$StockArray = array();
			$StockArray['Status'] = true;
			$StockArray['IconStatus'] = "full";
			$StockArray['Manage'] = "0";
			$StockChildArray = array();
			$StockChildArray['empty'] = 0;
			foreach($chidPrRows as $CurrentChild){
				/* Stock Mange Start*/
				$StockChildArray[$CurrentChild->ProductID]['Status'] = true;
				$StockChildArray[$CurrentChild->ProductID]['IconStatus'] = "full";
				$StockChildArray[$CurrentChild->ProductID]['Manage'] = "0";
				$StockChildArray[$CurrentChild->ProductID]['EndStock'] = isset($CurrentChild->EndStock)?$CurrentChild->EndStock:0;
				$StockChildArray[$CurrentChild->ProductID]['StockStatus'] = isset($CurrentChild->StockStatus)?$CurrentChild->StockStatus:0;
				if(isset($CurrentChild->EndStock) && $CurrentChild->EndStock == "1")
				{
					$LeftStock = $CurrentChild->Stock;
					$SoldStock = $CurrentChild->StockTotal - $CurrentChild->Stock;
					$StockChildArray[$CurrentChild->ProductID]['Manage'] = $StockChildArray[$CurrentChild->ProductID]['EndStock'];
					$StockChildArray[$CurrentChild->ProductID]['Total'] = $CurrentChild->StockTotal;
					$StockChildArray[$CurrentChild->ProductID]['Left'] = $LeftStock;
					$StockChildArray[$CurrentChild->ProductID]['Sold'] = $SoldStock;
					$StockChildArray[$CurrentChild->ProductID]['Percent'] = "0";
					if($CurrentChild->StockTotal > 0){
							$StockChildArray[$CurrentChild->ProductID]['Percent'] = round(($CurrentChild->Stock/$CurrentChild->StockTotal)*100);
					if($StockChildArray[$CurrentChild->ProductID]['Percent'] < 0)
							$StockChildArray[$CurrentChild->ProductID]['Percent'] = 0;
					}
					
					if($LeftStock > 0 || @$CurrentChild->EndStock==0)
					{
						$StockChildArray[$CurrentChild->ProductID]['Status'] = true;
						$StockChildArray[$CurrentChild->ProductID]['IconStatus'] = "full";
					}
					else 
					{
						$StockChildArray[$CurrentChild->ProductID]['Status'] = false;
						$StockChildArray[$CurrentChild->ProductID]['IconStatus'] = "empty";
						$StockChildArray['empty']++;
					}
					
					$StockArray['TotalAllQty'] +=$LeftStock;
				}
				/* Stock Mange End*/
			}
			
			if($StockChildArray['empty']==0)
				$StockArray['IconStatus']="full";
			elseif($StockChildArray['empty']==count($chidPrRows))
				$StockArray['IconStatus']="empty";
			else
				$StockArray['IconStatus']="partial";
			
			
		}
		/* Attribute Product End*/
		else{
			/* Stock Mange Start*/
			$StockArray = array();
			$StockArray['Status'] = true;
			$StockArray['IconStatus'] = "full";
			$StockArray['Manage'] = "0";
			$StockArray['EndStock'] = isset($CurrentProduct->EndStock)?$CurrentProduct->EndStock:0;
			$StockArray['StockStatus'] = isset($CurrentProduct->StockStatus)?$CurrentProduct->StockStatus:0;
			if(isset($CurrentProduct->EndStock) && $CurrentProduct->EndStock == "1")
			{
				$LeftStock = $CurrentProduct->Stock;
				$SoldStock = $CurrentProduct->StockTotal - $CurrentProduct->Stock;
				$StockArray['Manage'] = $StockArray['EndStock'];
				$StockArray['Total'] = $CurrentProduct->StockTotal;
				$StockArray['Left'] = $LeftStock;
				$StockArray['Sold'] = $SoldStock;
				$StockArray['Percent'] = "0";
				if($CurrentProduct->StockTotal > 0){
						$StockArray['Percent'] = round(($CurrentProduct->Stock/$CurrentProduct->StockTotal)*100);
				if($StockArray['Percent'] < 0)
						$StockArray['Percent'] = 0;
				}
				
				if($LeftStock > 0 || @$CurrentProduct->EndStock==0)
				{
					$StockArray['Status'] = true;
					$StockArray['IconStatus'] = "full";
				}
				else 
				{
					$StockArray['Status'] = false;
					$StockArray['IconStatus'] = "empty";
				}
				$StockArray['TotalAllQty'] +=$LeftStock;
			}
			/* Stock Mange End*/
		}
		
		if(d("DEFINE_FRONT_SIDE_INCLUDE")){
			if($StockArray['IconStatus']=="full")
				$StockArray['Icon'] = '<div class="stock-icons"><img src="'.$this->getThemeUrl("assest/images/icon-stock-full.png").'" class="img-fluid"></div>';
			if($StockArray['IconStatus']=="partial")
				$StockArray['Icon'] = '<div class="stock-icons"><img src="'.$this->getThemeUrl("assest/images/icon-stock-partial.png").'" class="img-fluid"></div>';
			if($StockArray['IconStatus']=="empty")
				$StockArray['Icon'] = '<div class="stock-icons"><img src="'.$this->getThemeUrl("assest/images/icon-stock-empty.png").'" class="img-fluid"></div>';
		}
		else{
			if($StockArray['IconStatus']=="full")
				$StockArray['Icon'] = '<div class="stock-icons"><span class="btn btn-success btn-xs"><i class="fa fa-check-square-o"></i> </span></div>';
			if($StockArray['IconStatus']=="partial")
				$StockArray['Icon'] = '<div class="stock-icons"><span class="btn btn-warning btn-xs"><i class="fa fa-check-square-o"></i> </span></div>';
			if($StockArray['IconStatus']=="empty")
				$StockArray['Icon'] = '<div class="stock-icons"><span class="btn btn-danger btn-xs"><i class="fa fa-check-square-o"></i> </span></div>';
		}
		
		
			
		$ReturnArray = array("Qty"=>$Qty,
							 "Array"=>$ReturnArray['Array'],
							 "Object"=>$ReturnArray['Object'],
							 "AttributeText"=>isset($AttributeText)?$AttributeText:"",
							 "Stock"=>isset($Stock)?$Stock:"",
							 "Icon"=>isset($StockArray['Icon'])?$StockArray['Icon']:"",
							 "TotalAllQty"=>isset($StockArray['TotalAllQty'])?$StockArray['TotalAllQty']:"0",
							 "StockArray"=>$StockArray,
							);
		 
		 if($RType != "" && isset($ReturnArray[$RType]) && $ReturnArray[$RType] != "")
			return $ReturnArray[$RType]; 
		
		 /* Default Stock End*/
		
		return $ReturnArray;
	}
	
	
	public function UpdateDefaultChildren($MasterID)
	{
		$ProductObj = new DataTable(TABLE_PRODUCT);
		$ProductObj->where[] = array('=',array('ProductID' => $MasterID));
		$CurrentProduct = (object)$ProductObj->tableSelectOne(array("ProductID","WithVat","TaxClass"));
		if(isset($CurrentProduct->ProductID)){
			
			$DataArray = array();
			$DataArray['WithVat'] = $CurrentProduct->WithVat;
			$DataArray['TaxClass'] = $CurrentProduct->TaxClass;
			$DataArray['FreeShippingStatus'] = $CurrentProduct->FreeShippingStatus;
			$DataArray['VirtualProduct'] = $CurrentProduct->VirtualProduct;
			$DataArray['NotForSale'] = $CurrentProduct->NotForSale;
			$DataArray['SignedIn'] = $CurrentProduct->SignedIn;
			$ChProductObj = new DataTable(TABLE_PRODUCT);
			$ChProductObj->where="MasterID ='".(int)$MasterID."'";
			$ChProductObj->tableUpdate($DataArray);
		}
	}
	public function DeleteProduct($MasterID)
	{
		if($MasterID > 0)
		{
			$ChildIDArr = $this->getProductChildrenIDs($MasterID);
			$ChildIDArr[] = $MasterID;
			foreach($ChildIDArr as $ProductID){
				
				$ProductObj = new DataTable(TABLE_PRODUCT);
				$ProductObj->where[] = array('=',array('ProductID' => $ProductID));
				$CurrentProduct = $ProductObj->tableSelectOne(array("ProductID","Image"));
				
				$ProductObj = new DataTable(TABLE_PRODUCT);
				$ProductObj->where[] = array('=',array('ProductID' => $ProductID));
				$ProductObj->tableDelete();								
				
				if(isset($CurrentProduct['Image']))
					$this->getClass("Cms\Pages\Image")->DeleteImage($CurrentProduct['Image']);
		
				$SeoObj = new DataTable(TABLE_SEO);
				$SeoObj->where[] = array('=',array('ReferenceID' => $ProductID));
				$SeoObj->where[] = array('=',array('MCode' => 'catalog_product'));
				$SeoObj->tableDelete();	
				
				$productdir = FileHandle::CheckUploadLogDirectory("product/p-".$MasterID);
				FileHandle::SKDeleteFolderContent($productdir);
				rmdir($productdir);
				
			}			
			
			
		}			
		
	}
	
	public function GetProductColorsList($MasterID)
	{
		$ProductIDs = $this->getProductChildrenIDs($MasterID);
		if(count($ProductIDs)==0) return "";
		
			$ProductRelationObj = new DataTable(array('pr'=>TABLE_PRODUCT_RELATION));
			$ProductRelationObj->joinExpression = true;
			$ProductRelationObj->joinArray[] = array('name'=>array('atv'=>TABLE_ATTRIBUTE_VALUE),
										  'on'=>"(atv.AttributeValueID = pr.RelationID)",
										  //'columns'=>array("AttributeValueID","AttributeValue","Image"),
										  'type'=>"left",
										  );										  
			$where = new Where();
			$where->equalTo('pr.RelationType','attribute_child');
			$where->in('pr.ProductID',$ProductIDs);
			$where->equalTo('pr.Custom','101');
			$ProductRelationObj->where = $where;
			//$ProductRelationObj->groupBy = array("AttributeValueID");
			$ProductRelationObj->columnExpression=true;
			//$ProductRelationObj->displayQuery = true;
			$ImageObj = (object)$ProductRelationObj->tableSelectOne(array("GROUP_CONCAT(DISTINCT atv.Image ORDER BY AttributeValueID ASC SEPARATOR ',') as Images"));
			$ImageText = "";
			if(isset($ImageObj->Images) && $ImageObj->Images != ""){
				foreach(explode(",",$ImageObj->Images) as $k=>$Image){
					if($Image != "" && file_exists(DIR_FS_SITE_UPLOADS."attribute/".$Image))
						$ImageText .= SKSeoImage($Image,"20x20",array("class"=>"me-1"));
				}
			}
			return $ImageText;			
		
	}
	public function getProductChildrenIDs($MasterID,$ReturnType="array")
	{
		$ProductObj = new DataTable(array('p'=>TABLE_PRODUCT));
		$ProductObj->where[] = array('=',array('p.MasterID' => $MasterID));
		$ProductObj->where[] = array('=',array('p.ProductType' => 'Child'));
		$ProductObj->columnExpression = true;
		$Obj  = (object)$ProductObj->tableSelectOne(array("GROUP_CONCAT(p.ProductID) as ProductIDs"));
		if($ReturnType=="string")
			return  $Obj->ProductIDs;
		
		if(isset($Obj->ProductIDs) && $Obj->ProductIDs != "")
			return explode(",",$Obj->ProductIDs);
		
	
	}
	
	public function getProductChildrenIDsActive($MasterID,$ReturnType="array")
	{
		$ProductObj = new DataTable(array('p'=>TABLE_PRODUCT));
		$ProductObj->where[] = array('=',array('p.MasterID' => $MasterID));
		$ProductObj->where[] = array('=',array('p.ProductType' => 'Child'));
		$ProductObj->where[] = array('=',array('p.Active' => '1'));
		$ProductObj->columnExpression = true;
		$Obj  = (object)$ProductObj->tableSelectOne(array("GROUP_CONCAT(p.ProductID) as ProductIDs"));
		if($ReturnType=="string")
			return  $Obj->ProductIDs;
		
		if(isset($Obj->ProductIDs) && $Obj->ProductIDs != "")
			return explode(",",$Obj->ProductIDs);
		
		return array();
	
	}

	public function getProductChildren($MasterID)
	{
		if($MasterID > 0)
		{
			$ProductObj = new DataTable(array('p'=>TABLE_PRODUCT));
			$ProductObj->where[] = array('=',array('p.MasterID' => $MasterID));
			$ProductObj->where[] = array('=',array('p.ProductType' => 'Child'));
			$ProductObj->where[] = array('=',array('p.Active' => '1'));
			$ProductObj->joinExpression = true;
			$ProductObj->joinArray[] = array('name'=>array('pr'=>TABLE_PRODUCT_PRICES),
										  'on'=>"(pr.ProductID=p.ProductID and (pr.QtyMin='0' OR pr.QtyMin='1') AND UserTypeID='1')",
										  'columns'=>array("Price","SalePrice","SaleActive"),
										  'type'=>"left",
										  );
			/*
			$ProductObj->joinArray[] = array('name'=>array('ut'=>TABLE_USER_TYPE),
										  'on'=>"(ut.UserTypeID = pr.UserTypeID AND IsDefault=1)",
										  'columns'=>array("UserTypeID"),
										  'type'=>"left",
										  );
		    */
			//$ProductObj->displayQuery = true;
			return $ProductObj->tableSelectAll(array("ProductID","Stock","StockStatus","StockTotal","EndStock","MasterID","ModelNo","LargeDescription","Image","ProductAttribute","FeedGtin","FeedBarcode","TaxClass"),array("Position ASC","ProductID ASC"));
		}
		
	
		return ;
	}

	public function getChildAttributeValueFromRel($ProductID,$AttributeID)
	{
		if($ProductID > 0 && $AttributeID > 0){
			$ProductRelationObj = new DataTable(array('pr'=>TABLE_PRODUCT_RELATION));
			$ProductRelationObj->where = array(array('=',array('pr.RelationType' => 'attribute_child')),
													  array('=',array('pr.ProductID' => $ProductID)),
													  array('=',array('pr.Custom' => $AttributeID))											  
													  );
													  
			$ProductRelationObj->joinExpression = true;
			$ProductRelationObj->joinArray[] = array('name'=>array('atv'=>TABLE_ATTRIBUTE_VALUE),
										  'on'=>"(atv.AttributeValueID = pr.RelationID)",
										  'columns'=>array("AttributeValueID","AttributeValue"),
										  'type'=>"left",
										  );										  
			//$ProductRelationObj->displayQuery = true;
			return (object)$ProductRelationObj->tableSelectOne(array("RelationID"));
		}
		return ;
							
	}
	public function getSpecificChildProductByAttributeValueID($ProductIDs,$AttributeID,$AttributeValueID)
	{
		if($ProductIDs != "" && $AttributeID > 0){
			$ProductRelationObj = new DataTable(array('pr'=>TABLE_PRODUCT_RELATION));
			$ProductRelationObj->joinExpression = true;
			$ProductRelationObj->joinArray[] = array('name'=>array('atv'=>TABLE_ATTRIBUTE_VALUE),
										  'on'=>"(atv.AttributeValueID = pr.RelationID)",
										  'columns'=>array("AttributeValueID","AttributeValue"),
										  'type'=>"left",
										  );										  
			$where = new Where();
			$where->equalTo('pr.RelationType','attribute_child');
			$where->in('pr.ProductID',$ProductIDs);
			$where->equalTo('pr.Custom',$AttributeID);
			$where->equalTo('pr.RelationID',$AttributeValueID);
			$ProductRelationObj->where = $where;
			//$ProductRelationObj->displayQuery = true;
			$chidPrRows = $ProductRelationObj->tableSelectAll(array("ProductID"));
			$ChidPrArr = array();
			foreach($chidPrRows as $CurrentChild){
					$ChidPrArr[] = $CurrentChild->ProductID;
			}
			return $ChidPrArr;
		}
		return array();
							
	}
	
	
	function getProductTypes()
	{
		$rows = array();
		$rows["Simple"] = "Normal";
		if(d("PRODUCT_ATTRIBUTE_STOCK_STATUS")=="1")
			$rows["Attribute"] = "Attribute";
		
		//$rows["Simple_Role"] = "Normal (Quote Product Roll)";
		//$rows["Attribute_2D"] = "Attribute (Quote Product LxW)";
		
		//if(d("PRODUCT_TYPE_MEASUREMENT_STATUS")=="1")
		//	$rows["Measurement"] = "Measurement";
		
		//$rows["Bundle"] = "Bundle";
		return $rows;
	}
	

	
	
}	