<?php 
namespace Catalog\Product\Admin\Controller;
use WebsiteControl\Base\AbstractModule;
use Base\Db\DataTable as DataTable;
use Catalog\Category\Common as CategoryCommon;
use Catalog\Product\Common as ProductCommon;
use Base\File\FileHandle as FileHandle;
use Laminas\Db\Sql\Where;

class ImportController extends AbstractModule
{
	function __construct()
	{
		
	}
	
	function settings()
	{
		if($this->origin->getView()=="Default")
			$this->origin->setView("FlashSale");
	}
	
	public function getCategoryCommon()
	{
		$obj = new CategoryCommon();
		return $obj;
	}
	
	public function getProductCommon()
	{
		$obj = new ProductCommon();
		return $obj;
	}
	
	public function getHeaderCss()
	{
	}
	
	public function getFooterJs()
	{
	}
	
	public function SampleCSVSaleFileAction()
	{
		if(file_exists(DIR_FS_SITE_PRIVATE."import/sample-sale-file.csv")){
			FileHandle::DownloadFile(DIR_FS_SITE_PRIVATE."import/sample-sale-file.csv");
		}
				
		
		
	}
	
	public function ProcessCSVSaleFileAction()
	{
		set_time_limit(0);
		if(count($_POST) > 0){
			$File = isset($_GET['File'])?$_GET['File']:"";
			$CYRate = isset($_POST['CYRate'])?$_POST['CYRate']:"GBP";
			$CurrencyValue = $this->getClass('Base\Currency\CurrencyHandler')->GetCurrencyRateFromDB($CYRate,"GBP","1");
			
			$SaleStartDate = (isset($_POST['StartDate']) && $_POST['StartDate'] !="")?$_POST['StartDate']:NULL;
			$SaleEndDate = (isset($_POST['EndDate']) && $_POST['EndDate'] != "")?$_POST['EndDate']." 23:59:59":NULL;
			$Percent = (isset($_POST['Percent']) && $_POST['Percent'] != "")?$_POST['Percent']:"0";
			
			$csvdata = $this->getDataFromCSV($File);
			foreach($csvdata as $csv_k=>$data){
				
				
				foreach($this->getProductHeaderInArray() as $key=>$val):
					$index = "DATA_CSV_".strtoupper(str_replace(array(" "),array("_"), trim($val)));
					if(defined($index))
						${$key} = isset($data[constant($index)])?trim($data[constant($index)]):"";
				endforeach;
				
				
					if(isset($SKU) && $SKU != ""){	
						$checkProduct = $this->checkProductbySKU($SKU);
						$ProductID = isset($checkProduct->ProductID)?$checkProduct->ProductID:"0";
						if($ProductID > 0 && isset($SalePrice) && $SalePrice != ""){
							$SalePrice = filter_var($SalePrice, FILTER_SANITIZE_NUMBER_FLOAT, FILTER_FLAG_ALLOW_FRACTION);
							
							if((float)$CurrencyValue >0)
								$SalePrice = (float)$CurrencyValue * $SalePrice;
							
							if($Percent > 0)
								$SalePrice = $SalePrice + ($SalePrice*$Percent/100);
				
							/* update price start here */
							if($SalePrice > 0){
								
								$ProductPriceObj3 = new DataTable(TABLE_PRODUCT_PRICES);
								$ProductPriceObj3->where = "ProductID = ".$ProductID." AND UserTypeID ='1' AND (QtyMin='0' OR QtyMin='1')";
								$BasePrice = (object)$ProductPriceObj3->tableSelectOne(array("Price"));
								
								$UserTypeID = 10;
								
								$SubDataArray = array();
								$SubDataArray['Price'] = isset($BasePrice->Price)?$BasePrice->Price:"";
								$SubDataArray['SalePrice'] = $SalePrice;
								$SubDataArray['SaleStartDate'] = $SaleStartDate;
								$SubDataArray['SaleEndDate'] = $SaleEndDate;
								$SubDataArray['SaleActive'] = "1";
								
								$ProductPriceObj = new DataTable(TABLE_PRODUCT_PRICES);
								$ProductPriceObj->where = "ProductID = ".$ProductID." AND UserTypeID ='".(int)$UserTypeID."' AND (QtyMin='0' OR QtyMin='1')";
								$CurrentPrice = (object)$ProductPriceObj->tableSelectOne(array("ProductPriceID"));
								if(isset($CurrentPrice->ProductPriceID) && $CurrentPrice->ProductPriceID !="")
								{
									$ProductPriceObj->tableUpdate($SubDataArray);
								}
								else 
								{
								
									$SubDataArray['QtyMin'] = "0";
									$SubDataArray['QtyMax'] = d("DEFINE_PRODUCT_QTY_MAX");
									$SubDataArray['PriceType'] = 'Unit';
									$SubDataArray['UserTypeID'] = $UserTypeID;
									$SubDataArray['ProductID'] = $ProductID;
									$ProductPriceObj->tableInsert($SubDataArray);
								}
							}
							/* update price end here */
							/* category assign here */
							if(isset($_POST['CategoryArr']) && $_POST['CategoryArr'] !="" && count($_POST['CategoryArr']) >0)
							{			
								foreach ($_POST['CategoryArr'] as $ck=>$cv)
								{
									$ProductCategoryObj = new DataTable(TABLE_PRODUCT_RELATION);
									if($cv !="")
									{	
										$ProductCategoryObj->where = array(array('=',array('RelationType' => 'catalog_category')),
																  array('=',array('ProductID' => $ProductID)),
																  array('=',array('RelationID' => $cv))											  
																  );
										$CObj = (object)$ProductCategoryObj->tableSelectOne(array("id"));
										if(!isset($CObj->id)){
											$DataArray = array();
											$DataArray['ProductID'] = $ProductID;
											$DataArray['RelationID'] = $cv;
											$DataArray['RelationType'] = "catalog_category";
											$DataArray['SortOrder'] = $this->getProductCommon()->SKMaxGetProductSortOrder($cv,"catalog_category") + 1;
											$ProductCategoryObj = new DataTable(TABLE_PRODUCT_RELATION);
											$ProductCategoryObj->tableInsert($DataArray);
										}
									}
								}
							}
							/* category assign here */
														
						}
						
					}
				
				
			}
		}
		$this->getSession()->setArrVar("alert",array("success","Prices updated successfully."));
		MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=".$this->view);
		exit;
		
	}
	public function UploadCSVSaleFileAction()
	{
		/* attachment Start*/
		if(isset($_FILES['UploadCSV']) && $_FILES['UploadCSV']['name'] !="")
		{
			$ArrayType = explode(".",$_FILES['UploadCSV']['name']);
			$Type=$ArrayType[count($ArrayType)-1];
			
			$dir = FileHandle::CheckPrivateLogDirectory("import");
			$FileName=uniqid("saleprice-".date('Y-m-d')."-").".".$Type;
			copy($_FILES['UploadCSV']['tmp_name'],$dir.$FileName);
		}
		
		MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=".$this->view."&File=".$FileName);
		exit;
		/* attachment End*/
	}
	
	public function getDataFromCSV($CSVFile)
	{
		$row =1;
		$csvdata = array();
		$dir = FileHandle::CheckPrivateLogDirectory("import");
		if(isset($CSVFile) && $CSVFile !="" && file_exists($dir.$CSVFile)){
			if (($handle = fopen($dir.$CSVFile, "r")) !== FALSE) {
				    while (($data = fgetcsv($handle)) !== FALSE) {
						if($row ==1){
							$this->CSVHeaderData($data);
						}
						else{
							$csvdata[] = $data;
						}
						$row++; 
					}
			}
		}
		return $csvdata;
	}
	
	function getProductHeaderInArray()
	{
		$ProductHeader = array("SKU"=>"ItemID",
							   "Status"=>"Status",
							   "ProductName"=>"Description",
							   "FeedID"=>"ItemKey",
							   "WholesalePrice"=>"Wholesale",
							   "RetailPrice"=>"Retail",
							   "SalePrice"=>"SalePrice",
							   //"Qty"=>"QtyAvail",
							   );
					   
		return 	$ProductHeader;		   
	}
	function CSVHeaderData($arr)
	{
			foreach ($arr as $key => $value)
			{
				$prop = "DATA_CSV_".strtoupper(str_replace(array(" "),array("_"), trim($value)));
				if(!defined($prop))	
					define($prop,$key);
			}
			
	}
	
	function checkProductbySKU($ModelNo)
	{
		$ProductObj = new DataTable(TABLE_PRODUCT);
		$ProductObj->where[] = array('=',array('ModelNo' => $ModelNo));
		return (object)$ProductObj->tableSelectOne(array("ProductID"));
	}
	
	function getCurrencyList()
	{
		return $this->getClass('Sale\Currency\Admin\Controller\IndexController')->getList();
	}
	
	public function pageTitle()
	{
		return "Import";
	}
	
	public function pageRight()
	{
		$Html = '';
		return $Html;	   
	}
	
	
}	