<?php 
namespace Catalog\Product\Admin\Controller;
use WebsiteControl\Base\AbstractModule;
use Base\Db\DataTable as DataTable;
use Catalog\Category\Common as CategoryCommon;
use Catalog\Product\Common as ProductCommon;
use Base\File\FileHandle as FileHandle;
use Laminas\Db\Sql\Where;

class ImportController extends AbstractModule
{
	function __construct()
	{
		
	}
	
	function settings()
	{
		if($this->origin->getView()=="Default")
			$this->origin->setView("Import");
	}
	
	public function getCategoryCommon()
	{
		$obj = new CategoryCommon();
		return $obj;
	}
	
	public function getProductCommon()
	{
		$obj = new ProductCommon();
		return $obj;
	}
	
	public function getHeaderCss()
	{
	}
	
	public function getFooterJs()
	{
	}
	
	public function SampleCSVSaleFileAction()
	{
		if(file_exists(DIR_FS_SITE_PRIVATE."import/sample-sale-file.csv")){
			FileHandle::DownloadFile(DIR_FS_SITE_PRIVATE."import/sample-sale-file.csv");
		}
				
		
		
	}
	
	public function ProcessCSVSaleFileAction()
	{
		set_time_limit(0);
		if(count($_POST) > 0){
			$File = isset($_GET['File'])?$_GET['File']:"";
			$CYRate = isset($_POST['CYRate'])?$_POST['CYRate']:"GBP";
			$CurrencyValue = $this->getClass('Base\Currency\CurrencyHandler')->GetCurrencyRateFromDB($CYRate,"GBP","1");
			
			$SaleStartDate = (isset($_POST['StartDate']) && $_POST['StartDate'] !="")?$_POST['StartDate']:NULL;
			$SaleEndDate = (isset($_POST['EndDate']) && $_POST['EndDate'] != "")?$_POST['EndDate']." 23:59:59":NULL;
			$Percent = (isset($_POST['Percent']) && $_POST['Percent'] != "")?$_POST['Percent']:"0";
			
			$csvdata = $this->getDataFromCSV($File);
			foreach($csvdata as $csv_k=>$data){
				
				
				foreach($this->getProductHeaderInArray() as $key=>$val):
					$index = "DATA_CSV_".strtoupper(str_replace(array(" "),array("_"), trim($val)));
					if(defined($index))
						${$key} = isset($data[constant($index)])?trim($data[constant($index)]):"";
				endforeach;
				
				
					if(isset($SKU) && $SKU != ""){	
						$checkProduct = $this->checkProductbySKU($SKU);
						$ProductID = isset($checkProduct->ProductID)?$checkProduct->ProductID:"0";
						if($ProductID > 0 && isset($SalePrice) && $SalePrice != ""){
							$SalePrice = filter_var($SalePrice, FILTER_SANITIZE_NUMBER_FLOAT, FILTER_FLAG_ALLOW_FRACTION);
							
							if((float)$CurrencyValue >0)
								$SalePrice = (float)$CurrencyValue * $SalePrice;
							
							if($Percent > 0)
								$SalePrice = $SalePrice + ($SalePrice*$Percent/100);
				
							/* update price start here */
							if($SalePrice > 0){
								
								$ProductPriceObj3 = new DataTable(TABLE_PRODUCT_PRICES);
								$ProductPriceObj3->where = "ProductID = ".$ProductID." AND UserTypeID ='1' AND (QtyMin='0' OR QtyMin='1')";
								$BasePrice = (object)$ProductPriceObj3->tableSelectOne(array("Price"));
								
								$UserTypeID = 10;
								
								$SubDataArray = array();
								$SubDataArray['Price'] = isset($BasePrice->Price)?$BasePrice->Price:"";
								$SubDataArray['SalePrice'] = $SalePrice;
								$SubDataArray['SaleStartDate'] = $SaleStartDate;
								$SubDataArray['SaleEndDate'] = $SaleEndDate;
								$SubDataArray['SaleActive'] = "1";
								
								$ProductPriceObj = new DataTable(TABLE_PRODUCT_PRICES);
								$ProductPriceObj->where = "ProductID = ".$ProductID." AND UserTypeID ='".(int)$UserTypeID."' AND (QtyMin='0' OR QtyMin='1')";
								$CurrentPrice = (object)$ProductPriceObj->tableSelectOne(array("ProductPriceID"));
								if(isset($CurrentPrice->ProductPriceID) && $CurrentPrice->ProductPriceID !="")
								{
									$ProductPriceObj->tableUpdate($SubDataArray);
								}
								else 
								{
								
									$SubDataArray['QtyMin'] = "0";
									$SubDataArray['QtyMax'] = d("DEFINE_PRODUCT_QTY_MAX");
									$SubDataArray['PriceType'] = 'Unit';
									$SubDataArray['UserTypeID'] = $UserTypeID;
									$SubDataArray['ProductID'] = $ProductID;
									$ProductPriceObj->tableInsert($SubDataArray);
								}
							}
							/* update price end here */
							/* category assign here */
							if(isset($_POST['CategoryArr']) && $_POST['CategoryArr'] !="" && count($_POST['CategoryArr']) >0)
							{			
								foreach ($_POST['CategoryArr'] as $ck=>$cv)
								{
									$ProductCategoryObj = new DataTable(TABLE_PRODUCT_RELATION);
									if($cv !="")
									{	
										$ProductCategoryObj->where = array(array('=',array('RelationType' => 'catalog_category')),
																  array('=',array('ProductID' => $ProductID)),
																  array('=',array('RelationID' => $cv))											  
																  );
										$CObj = (object)$ProductCategoryObj->tableSelectOne(array("id"));
										if(!isset($CObj->id)){
											$DataArray = array();
											$DataArray['ProductID'] = $ProductID;
											$DataArray['RelationID'] = $cv;
											$DataArray['RelationType'] = "catalog_category";
											$DataArray['SortOrder'] = $this->getProductCommon()->SKMaxGetProductSortOrder($cv,"catalog_category") + 1;
											$ProductCategoryObj = new DataTable(TABLE_PRODUCT_RELATION);
											$ProductCategoryObj->tableInsert($DataArray);
										}
									}
								}
							}
							/* category assign here */
							if($ProductID > 0){
								$this->getClass('Catalog\Product\Common')->IndexProductSearch($ProductID);
							}							
						}
						
					}
				
				
			}
		}
		$this->getSession()->setArrVar("alert",array("success","Prices updated successfully."));
		MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=".$this->view);
		exit;
		
	}
	public function UploadCSVSaleFileAction()
	{
		/* attachment Start*/
		if(isset($_FILES['UploadCSV']) && $_FILES['UploadCSV']['name'] !="")
		{
			$ArrayType = explode(".",$_FILES['UploadCSV']['name']);
			$Type=$ArrayType[count($ArrayType)-1];
			
			$dir = FileHandle::CheckPrivateLogDirectory("import");
			$FileName=uniqid("saleprice-".date('Y-m-d')."-").".".$Type;
			copy($_FILES['UploadCSV']['tmp_name'],$dir.$FileName);
		}
		
		MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=".$this->view."&File=".$FileName);
		exit;
		/* attachment End*/
	}
	
	
	public function ProcessCSVFileAction()
	{
		set_time_limit(0);
		if(count($_POST) > 0){
			$File = isset($_GET['File'])?$_GET['File']:"";
			
			$csvdata = $this->getDataFromCSV($File);
			foreach($csvdata as $csv_k=>$data){
				
				
				foreach($this->getCsvHeaderInArray() as $key=>$val):
					$index = "DATA_CSV_".strtoupper(str_replace(array(" "),array("_"), trim($val)));
					if(defined($index)){
						${$key} = isset($data[constant($index)])?trim($data[constant($index)]):"";
					}
				endforeach;
				
					
					
					if(isset($ModelNo) && $ModelNo != ""){
						$checkProduct = $this->checkProductbySKU($ModelNo);
						$ProductID = isset($checkProduct->ProductID)?$checkProduct->ProductID:"0";
						$ProductObj = new DataTable(TABLE_PRODUCT);
						$DataArray = array();
						$NewEntry = false;
						if(!isset($ProductType) || $ProductType=="")
							$ProductType ="Simple";
						
						if(isset($ProductType) && strtolower($ProductType)=="child"){
							/* child product start*/
							if(strtolower($ProductType)=="child" && isset($AttributeNames)){
								  
								  $ProductAttribute = $this->getClass("Catalog\Attribute\Common")->ConvertAttributeNames($AttributeNames,"ids");
								  $ProductAttributeArr = explode("|",$ProductAttribute);
								  $AttributeValueIDs = $this->getClass("Catalog\Attribute\Common")->ConvertAttributeValuesNames($AttributeValues);
								  $AttributeValuesArr = explode("|",$AttributeValueIDs);
									if(isset($ProductAttributeArr) && is_array($ProductAttributeArr)){
									  $AttributeArr = array();
									  foreach($ProductAttributeArr as $k=>$AttID){
										  $AttArr = explode("=",$AttributeValuesArr[$k]); 
										  if(isset($AttArr[0]) && isset($AttArr[1]))
											$AttributeArr[$AttArr[0]] = $AttArr[1];  
									  }
								  }
								  
								}
							if($MasterID > 0 && count($AttributeArr) > 0 && count($AttributeArr) ==count($ProductAttributeArr)){
								/* now we can add into database start*/
								$checkMaster = $this->checkProductbySKU($MasterID);
								$MasterID = isset($checkMaster->ProductID)?$checkMaster->ProductID:"";
								if($MasterID > 0){
									$checkProduct = $this->checkChildProductbySKU($MasterID,$ModelNo);
									$ChildProductID = isset($checkProduct->ProductID)?$checkProduct->ProductID:"0";
									if($ChildProductID==0){
										
										$ProductObj = new DataTable(TABLE_PRODUCT);
										$ProductObj->where[] = array('=',array('MasterID' => $MasterID));
										$Position = $ProductObj->getMax("Position") + 1;
										$BlankData = array();
										$BlankData['ProductType'] = 'Child';
										$BlankData['MasterID'] = $MasterID;
										$BlankData['Position'] = $Position;
										$BlankData['ModelNo'] = $ModelNo;
										//$BlankData['TaxClass'] = 1;
										//$BlankData['ShippingType'] = 1;
										$BlankData['UploadType'] ='BulkImport';
										$BlankData['CreatedDate'] =date('Y-m-d H:i:s');
										$ChildProductID = $ProductObj->tableInsert($BlankData);		
										
									}
									if($ChildProductID > 0){
										$SubDataArray = array();
										
										$ProductRelationObj = new DataTable(TABLE_PRODUCT_RELATION);
										$ProductRelationObj->where = "RelationType='attribute_child' and ProductID='".(int)$ChildProductID."'";
										$ProductRelationObj->tableDelete();	
										
										$ProductAttribute = "";
										$ProductAttributeString = $checkMaster->ProductName." - ".str_replace(array("|","="),array(" - ",": "),$AttributeValues);
										$ModelNoString = $checkMaster->ModelNo;
										foreach($AttributeArr as $AttributeID=>$AttributeValueID){
											$ProductAttribute .= $AttributeID."=".$AttributeValueID.", ";
											$ModelNoString .= "___".$AttributeValueID;
					
											$AttDataArray = array();
											$AttDataArray['ProductID'] = $ChildProductID;
											$AttDataArray['RelationID'] = $AttributeValueID;
											$AttDataArray['RelationType'] = "attribute_child";
											$AttDataArray['Custom'] = $AttributeID;
											$ProductRelationObj->tableInsert($AttDataArray);
											
										}
										
										$SubDataArray['ProductAttribute'] = substr($ProductAttribute,0,-2); 
										$SubDataArray['ProductName'] = $ProductAttributeString;
										$SubDataArray['SmallDescription'] = $ProductAttributeString;
										$SubDataArray['ProductLine'] = $ModelNoString;
				
				
										
										if(isset($Active))
											$SubDataArray['Active'] = ($Active == "1")?1:0;
							
										if(isset($EngravingCost))
										  $SubDataArray['EngravingCost'] =$EngravingCost;
										if(isset($EngravingOption))
											$SubDataArray['EngravingOption'] = ($EngravingOption == "1")?1:0;
										if(isset($MotifOption))
											$SubDataArray['MotifOption'] = ($MotifOption == "1")?1:0;
										if(isset($LogoOption))
											$SubDataArray['LogoOption'] = ($LogoOption == "1")?1:0;
							
										if(isset($SmallDescription))
										  $SubDataArray['SmallDescription'] =$SmallDescription;
										if(isset($LargeDescription))
										  $SubDataArray['LargeDescription'] =$LargeDescription;
										if(isset($ProCheckImageDescription))
										  $SubDataArray['ProCheckImageDescription'] =$ProCheckImageDescription;
										
										if(isset($StockMessage))
										  $SubDataArray['StockMessage'] =$StockMessage;
										if(isset($StockStatus))
											$SubDataArray['StockStatus'] = ($StockStatus == "1")?1:0;
										if(isset($EndStock))
											$SubDataArray['EndStock'] = ($EndStock == "1")?1:0;
										if(isset($StockTotal))
											$SubDataArray['StockTotal'] = ($StockTotal > 0)?$StockTotal:0;
										if(isset($Stock))
											$SubDataArray['Stock'] = ($Stock > 0)?$Stock:0;
										if(isset($Weight))
											$SubDataArray['Weight'] = ($Weight > 0)?$Weight:0;
									
										//if(isset($TaxClass))
										//	$SubDataArray['TaxClass'] = ($TaxClass > 1)?$TaxClass:1;
										
										//if(isset($ShippingType))
										//	$SubDataArray['ShippingType'] = ($ShippingType > 0)?$ShippingType:0;
										
										if(isset($Image) && $Image != ""){
											$ImageAltText = (isset($ImageAltText) && $ImageAltText != "")?$ImageAltText:$SubDataArray['ProductName'];
											$SubDataArray['Image'] = $this->getClass("Cms\Pages\Image")->AddEditImportFile($Image,"catalog_product",'product',$ImageAltText);
											//var_dump($Image,$SubDataArray['Image']);exit;
											
										}
										if(isset($ProCheckImage) && $ProCheckImage != ""){
											$ProCheckImageAltText = (isset($ProCheckImageAltText) && $ProCheckImageAltText != "")?$ProCheckImageAltText:$SubDataArray['ProductName'];
											$SubDataArray['ProCheckImage'] = $this->getClass("Cms\Pages\Image")->AddEditImportFile($ProCheckImage,"catalog_product",'product',$ProCheckImageAltText);
										}
										if(isset($ProAddImage) && $ProAddImage != ""){
											$ProAddImageAltText = (isset($ProAddImageAltText) && $ProAddImageAltText != "")?$ProAddImageAltText:$SubDataArray['ProductName'];
											$SubDataArray['ProAddImage'] = $this->getClass("Cms\Pages\Image")->AddEditImportFile($ProAddImage,"catalog_product",'product',$ProAddImageAltText);
										}
									
										$ProductObj = new DataTable(TABLE_PRODUCT);
										$ProductObj->where[] = array('=',array('ProductID' => $ChildProductID));
										$ProductObj->tableUpdate($SubDataArray);
										
										/* ProductPrice entry start*/
										$UserTypeID ='1';
										$ProductPriceObj =new DataTable(TABLE_PRODUCT_PRICES);
										$ProductPriceObj->where = "ProductID = ".$ChildProductID." AND UserTypeID ='".$UserTypeID."' AND 
																   (QtyMin='0' OR QtyMin='1')";
										$CurrentPrice = (object)$ProductPriceObj->tableSelectOne(array("ProductPriceID"));
										$PriceDataArray = array();
										if(isset($NormalPrice))
											$PriceDataArray['Price'] = ($NormalPrice > 0)?$NormalPrice:0;
										if(isset($NormalSalePrice))
											$PriceDataArray['SalePrice'] = ($NormalSalePrice > 0)?$NormalSalePrice:0;
										if(isset($NormalSaleActive))
											$PriceDataArray['SaleActive'] = ($NormalSaleActive > 0)?$NormalSaleActive:0;

										if(count($PriceDataArray) > 0){
											if(isset($CurrentPrice->ProductPriceID) && $CurrentPrice->ProductPriceID !="")
											{
												$ProductPriceObj->tableUpdate($PriceDataArray);
											}
											else 
											{
												$PriceDataArray['QtyMin'] = "0";
												$PriceDataArray['QtyMax'] = d("DEFINE_PRODUCT_QTY_MAX");
												$PriceDataArray['PriceType'] = 'Unit';
												$PriceDataArray['UserTypeID'] = $UserTypeID;
												$PriceDataArray['ProductID'] = $ChildProductID;
												$ProductPriceObj->tableInsert($PriceDataArray);
											}
										}

										$UserTypeID ='2';
										$ProductPriceObj->where = "ProductID = ".$ChildProductID." AND UserTypeID ='".$UserTypeID."' AND 
																   (QtyMin='0' OR QtyMin='1')";
										$CurrentPrice = (object)$ProductPriceObj->tableSelectOne(array("ProductPriceID"));
										$PriceDataArray = array();
										if(isset($WholeSalePrice))
											$PriceDataArray['Price'] = ($WholeSalePrice > 0)?$WholeSalePrice:0;
										if(isset($WholeSaleSalePrice))
											$PriceDataArray['SalePrice'] = ($WholeSaleSalePrice > 0)?$WholeSaleSalePrice:0;
										if(isset($WholeSaleSaleActive))
											$PriceDataArray['SaleActive'] = ($WholeSaleSaleActive > 0)?$WholeSaleSaleActive:0;



												
										if(count($PriceDataArray) > 0){
											if(isset($CurrentPrice->ProductPriceID) && $CurrentPrice->ProductPriceID !="")
											{
												$ProductPriceObj->tableUpdate($PriceDataArray);
											}
											else 
											{
												$PriceDataArray['QtyMin'] = "0";
												$PriceDataArray['QtyMax'] = d("DEFINE_PRODUCT_QTY_MAX");
												$PriceDataArray['PriceType'] = 'Unit';
												$PriceDataArray['UserTypeID'] = $UserTypeID;
												$PriceDataArray['ProductID'] = $ChildProductID;
												$ProductPriceObj->tableInsert($PriceDataArray);
											}
										}
										/* ProductPriceObj entry end*/
										
										
										
									}
									
									//var_dump($ChildProductID);exit;
									
									if($MasterID > 0){
										$this->getClass('Catalog\Product\Common')->IndexProductSearch($MasterID);
									}
								}
								
								/* now we can add into database end*/
							}
							//var_dump($AttributeArr,$ProductAttributeArr,$ProductAttribute,$AttributeValues);exit;
							/* child product end*/
						}
						if(isset($ProductType) && in_array(strtolower($ProductType),array("attribute","simple")))
						{
							/* simple and attribute product start*/
							if($ProductID==0){
								$DataArray['ProductType'] = (isset($ProductType) && $ProductType !="")?$ProductType:"Simple";
								$ProductObj->where ="1";
								$Position = $ProductObj->getMax("Position") + 1;
								
								$DataArray['ModelNo'] = $ModelNo;
								$DataArray['TaxClass'] = 1;
								$DataArray['ShippingType'] = 1;
								
								$DataArray['Position'] = $Position;
								$DataArray['UploadType'] ='BulkImport';
								$DataArray['CreatedDate'] =date('Y-m-d H:i:s');
								$ProductID = $ProductObj->tableInsert($DataArray);
								$NewEntry = true;
							}
							
							if($ProductID > 0){
							
								if(isset($Active))
									$DataArray['Active'] = ($Active == "1")?1:0;
							
								if(isset($ProductName))
								$DataArray['ProductName'] =$ProductName;
							
								if(isset($ProductType))
								  $DataArray['ProductType'] =$ProductType;
								
								if(strtolower($ProductType)=="attribute" && isset($AttributeNames)){
								  
								  $ProductAttribute = $this->getClass("Catalog\Attribute\Common")->ConvertAttributeNames($AttributeNames,"ids");
								  if($ProductAttribute != "")
									  $DataArray['ProductAttribute'] =str_replace("|",",",$ProductAttribute);
								}
							  
								if(isset($ProductLine))
								  $DataArray['ProductLine'] =$ProductLine;
								if(isset($ProductCartName))
								  $DataArray['ProductCartName'] =$ProductCartName;
								if(isset($PartNumber))
								  $DataArray['PartNumber'] =$PartNumber;
								if(isset($ProColour))
								  $DataArray['ProColour'] =$ProColour;
								if(isset($MakeName))
								  $DataArray['MakeName'] =$MakeName;
								if(isset($TSCPartNumber))
								  $DataArray['TSCPartNumber'] =$TSCPartNumber;
								if(isset($TSCPartNumber))
								  $DataArray['TSCPartNumber'] =$TSCPartNumber;
							
								if(isset($SmallDescription))
								  $DataArray['SmallDescription'] =$SmallDescription;
								if(isset($LargeDescription))
								  $DataArray['LargeDescription'] =$LargeDescription;
								if(isset($ProCheckImageDescription))
								  $DataArray['ProCheckImageDescription'] =$ProCheckImageDescription;
								
								if(isset($StockMessage))
								  $DataArray['StockMessage'] =$StockMessage;
								if(isset($StockStatus))
									$DataArray['StockStatus'] = ($StockStatus == "1")?1:0;
								if(isset($EndStock))
									$DataArray['EndStock'] = ($EndStock == "1")?1:0;
								if(isset($StockTotal))
									$DataArray['StockTotal'] = ($StockTotal > 0)?$StockTotal:0;
								if(isset($Stock))
									$DataArray['Stock'] = ($Stock > 0)?$Stock:0;
								if(isset($Weight))
									$DataArray['Weight'] = ($Weight > 0)?$Weight:0;
							
								if(isset($EngravingOption))
									$DataArray['EngravingOption'] = ($EngravingOption > 0)?$EngravingOption:0;
								if(isset($MotifOption))
									$DataArray['MotifOption'] = ($MotifOption > 0)?$MotifOption:0;
								if(isset($LogoOption))
									$DataArray['LogoOption'] = ($LogoOption > 0)?$LogoOption:0;
							
								if(isset($TaxClass))
									$DataArray['TaxClass'] = ($TaxClass > 1)?$TaxClass:1;
								
								if(isset($ShippingType))
									$DataArray['ShippingType'] = ($ShippingType > 0)?$ShippingType:0;
								
								if(isset($RoleUnit))
									$DataArray['PerRollUnit'] = ($RoleUnit > 0)?$RoleUnit:0;
								
								if(isset($SizeGuide))
								  $DataArray['SizeGuide'] =$SizeGuide;
								
								if(isset($EngravingCost))
								  $DataArray['EngravingCost'] =$EngravingCost;
								
								
								if(isset($YoutubeVideo))
								  $DataArray['YoutubeVideo'] =$YoutubeVideo;
								if(isset($YouTubeVideo2))
								  $DataArray['YouTubeVideo2'] =$YouTubeVideo2;
								
								if(isset($ProductPoints))
									$DataArray['ProductPoints'] = ($ProductPoints > 0)?$ProductPoints:0;
								
								if(isset($NotForSale))
									$DataArray['NotForSale'] = ($NotForSale == "1")?1:0;
								if(isset($SignedIn))
									$DataArray['SignedIn'] = ($SignedIn == "1")?1:0;
								if(isset($DeliveryExempt))
									$DataArray['DeliveryExempt'] = ($DeliveryExempt == "1")?1:0;
								if(isset($VirtualProduct))
									$DataArray['VirtualProduct'] = ($VirtualProduct == "1")?1:0;
								if(isset($FreeShippingStatus))
									$DataArray['FreeShippingStatus'] = ($FreeShippingStatus == "1")?1:0;
								if(isset($GiftVoucherStatus))
									$DataArray['GiftVoucherStatus'] = ($GiftVoucherStatus == "1")?1:0;
									
				
								if(isset($Image) && $Image != ""){
									$ImageAltText = (isset($ImageAltText) && $ImageAltText != "")?$ImageAltText:$DataArray['ProductName'];
									$DataArray['Image'] = $this->getClass("Cms\Pages\Image")->AddEditImportFile($Image,"catalog_product",'product',$ImageAltText);
									
								}
								if(isset($ProCheckImage) && $ProCheckImage != ""){
									$ProCheckImageAltText = (isset($ProCheckImageAltText) && $ProCheckImageAltText != "")?$ProCheckImageAltText:$DataArray['ProductName'];
									$DataArray['ProCheckImage'] = $this->getClass("Cms\Pages\Image")->AddEditImportFile($ProCheckImage,"catalog_product",'product',$ProCheckImageAltText);
								}
								if(isset($ProAddImage) && $ProAddImage != ""){
									$ProAddImageAltText = (isset($ProAddImageAltText) && $ProAddImageAltText != "")?$ProAddImageAltText:$DataArray['ProductName'];
									$DataArray['ProAddImage'] = $this->getClass("Cms\Pages\Image")->AddEditImportFile($ProAddImage,"catalog_product",'product',$ProAddImageAltText);
								}
							
								$ProductObj = new DataTable(TABLE_PRODUCT);
								$ProductObj->where[] = array('=',array('ProductID' => $ProductID));
								$ProductObj->tableUpdate($DataArray);
								
								/* SEO Table start*/
								$SeoObj = new DataTable(TABLE_SEO);
								$SeoObj->where = "ReferenceID = ".$ProductID." AND MCode ='catalog_product' AND MView ='Detail'";
								$CurrentSEO = (object)$SeoObj->tableSelectOne(array("ReferenceID"));
								
								$DataArray = array();
								if(isset($MetaTitle))
									$DataArray['MetaTitle'] =$MetaTitle;
								if(isset($MetaKeyword))
									$DataArray['MetaKeyword'] =$MetaKeyword;
								if(isset($MetaDescription))
									$DataArray['MetaDescription'] =$MetaDescription;
							
								if(isset($CurrentSEO->ReferenceID) && $CurrentSEO->ReferenceID !=""){
									if(isset($URLName) && $URLName != ""){
										$URL = $this->getClass("Cms\Pages\Common")->GetUniqueURL($URLName,'catalog_product','Detail',$ProductID);
										$DataArray['URLName'] = $URL;
									}
									$SeoObj->tableUpdate($DataArray);
								}
								else{
									
									$URL = 	SkURLCreate((isset($URLName) && $URLName !="")?$URLName:$ProductName."-".$ModelNo);
									$URL = $this->getClass("Cms\Pages\Common")->GetUniqueURL($URL,'catalog_product','Detail',$ProductID);
									$DataArray['URLName'] = $URL;			
									$DataArray['MCode'] = "catalog_product";
									$DataArray['MView'] = "Detail";
									$DataArray['ReferenceID'] = $ProductID;
									$SeoObj->tableInsert($DataArray);
								}
								/* SEO Table end*/
								/* Categories Table start*/
								$CategoryArr = $this->getCategoryIDs($Categories,"|");
								if(isset($Categories) && $Categories !="" && count($CategoryArr) > 0)
								{			
									$ProductCategoryObj = new DataTable(TABLE_PRODUCT_RELATION);
									$ProductCategoryObj->where = "RelationType='catalog_category' and ProductID='".(int)$ProductID."'";
									if(implode(",", $CategoryArr) != "")
										 $ProductCategoryObj->where .= "and RelationID NOT IN (".implode(",",$CategoryArr).")";
									
									$ProductCategoryObj->tableDelete();	
									foreach ($CategoryArr as $ck=>$cv)
									{
										if($cv !="")
										{	
											$ProductCategoryObj->where = array(array('=',array('RelationType' => 'catalog_category')),
																	  array('=',array('ProductID' => $ProductID)),
																	  array('=',array('RelationID' => $cv))											  
																	  );
											$CObj = (object)$ProductCategoryObj->tableSelectOne(array("id"));
											if(!isset($CObj->id)){
												$DataArray = array();
												$DataArray['ProductID'] = $ProductID;
												$DataArray['RelationID'] = $cv;
												$DataArray['RelationType'] = "catalog_category";
												$DataArray['SortOrder'] = $this->getClass('Catalog\Product\Common')->SKMaxGetProductSortOrder($cv,"catalog_category") + 1;
												$ProductCategoryObj->tableInsert($DataArray);
											}
										}
									}
								}
								
								/* Categories Table end*/
								
								/* CategoryCode Table start*/
								$CategoryArr = $this->getCategoryIdsByCode($CategoryCode,"|");
								if(isset($CategoryCode) && $CategoryCode !="" && count($CategoryArr) > 0)
								{			
									$ProductCategoryObj = new DataTable(TABLE_PRODUCT_RELATION);
									$ProductCategoryObj->where = "RelationType='catalog_category' and ProductID='".(int)$ProductID."'";
									if(implode(",", $CategoryArr) != "")
										 $ProductCategoryObj->where .= "and RelationID NOT IN (".implode(",",$CategoryArr).")";
									
									$ProductCategoryObj->tableDelete();	
									foreach ($CategoryArr as $ck=>$cv)
									{
										if($cv !="")
										{	
											$ProductCategoryObj->where = array(array('=',array('RelationType' => 'catalog_category')),
																	  array('=',array('ProductID' => $ProductID)),
																	  array('=',array('RelationID' => $cv))											  
																	  );
											$CObj = (object)$ProductCategoryObj->tableSelectOne(array("id"));
											if(!isset($CObj->id)){
												$DataArray = array();
												$DataArray['ProductID'] = $ProductID;
												$DataArray['RelationID'] = $cv;
												$DataArray['RelationType'] = "catalog_category";
												$DataArray['SortOrder'] = $this->getClass('Catalog\Product\Common')->SKMaxGetProductSortOrder($cv,"catalog_category") + 1;
												$ProductCategoryObj->tableInsert($DataArray);
											}
										}
									}
								}
								
								/* CategoryCode Table end*/
							
								/* FilterCode Table start*/
								$FilterArr = $this->getIdsByFilterCode($FilterCode,"|");
								if(isset($FilterArr) && $FilterArr !="" && count($FilterArr) > 0)
								{			
									$ProductFilterObj = new DataTable(TABLE_PRODUCT_RELATION_FILTER);
									$ProductFilterObj->where = "ProductID='".(int)$ProductID."'";
									if(implode(",", $FilterArr) != "")
										 $ProductFilterObj->where .= "and FilterValueID NOT IN (".implode(",",$CategoryArr).")";
									
									$ProductFilterObj->tableDelete();	
									foreach ($FilterArr as $ck=>$f_arr)
									{
										if(isset($f_arr) && is_array($f_arr))
										{	
											$ProductFilterObj->where = array('=',array('ProductID' => $ProductID)),
																	  array('=',array('FilterValueID' => $f_arr['FilterValueID']))											  
																	  );
											$CObj = (object)$ProductFilterObj->tableSelectOne(array("FilterValueID"));
											if(!isset($CObj->FilterValueID)){
												$DataArray = array();
												$DataArray['ProductID'] = $ProductID;
												$DataArray['FilterValueID'] = $f_arr['FilterValueID'];
												$AttDataArray['FilterID'] = $f_arr['FilterID'];
												$ProductFilterObj->tableInsert($DataArray);
											}
										}
									}
								}
								
								/* CategoryCode Table end*/
							
								/* ProductPrice entry start*/
								$ProductType = $this->getProductTypeByID($ProductID);
								$UserTypeID ='1';
								$ProductPriceObj =new DataTable(TABLE_PRODUCT_PRICES);
								$ProductPriceObj->where = "ProductID = ".$ProductID." AND UserTypeID ='".$UserTypeID."' AND 
														   (QtyMin='0' OR QtyMin='1')";
								$CurrentPrice = (object)$ProductPriceObj->tableSelectOne(array("ProductPriceID"));
								$DataArray = array();
								if($ProductType=="Attribute"){
									$DataArray['Price'] = 0;
								}
								elseif($ProductType=="Attribute_2D" || $ProductType=="Simple_Role"){
									
									if(isset($NormalBasePrice1M))
										$DataArray['Price'] = ($NormalBasePrice1M > 0)?$NormalBasePrice1M:0;
					
									if(isset($NormalBasePrice5M))
										$DataArray['SecondPrice'] = ($NormalBasePrice5M > 0)?$NormalBasePrice5M:0;
					
									if(isset($NormalPriceRaisedBy1M))
										$DataArray['PriceRaiseBy'] = ($NormalPriceRaisedBy1M > 0)?$NormalPriceRaisedBy1M:0;
					
									if(isset($NormalPriceRaisedBy5M))
										$DataArray['SecondPriceRaiseBy'] = ($NormalPriceRaisedBy5M > 0)?$NormalPriceRaisedBy5M:0;
					
									if(isset($NormalRaisingPrice1M))
										$DataArray['RaisedPrice'] = ($NormalRaisingPrice1M > 0)?$NormalRaisingPrice1M:0;
					
									if(isset($NormalRaisingPrice5M))
										$DataArray['SecondRaisedPrice'] = ($NormalRaisingPrice5M > 0)?$NormalRaisingPrice5M:0;
					
									if(isset($NormalThirdPartyCost))
										$DataArray['ThirdPartyPrice'] = ($NormalThirdPartyCost > 0)?$NormalThirdPartyCost:0;
									
									if(isset($NormalPerRollPrice))
										$DataArray['PerRollPrice'] = ($NormalPerRollPrice > 0)?$NormalPerRollPrice:0;
									
							
								}
								elseif($ProductType=="Simple"){
									if(isset($NormalPrice))
										$DataArray['Price'] = ($NormalPrice > 0)?$NormalPrice:0;
									if(isset($NormalSalePrice))
										$DataArray['SalePrice'] = ($NormalSalePrice > 0)?$NormalSalePrice:0;
									if(isset($NormalSaleActive))
										$DataArray['SaleActive'] = ($NormalSaleActive > 0)?$NormalSaleActive:0;
					
								}
								
										
								if(count($DataArray) > 0){
									if(isset($CurrentPrice->ProductPriceID) && $CurrentPrice->ProductPriceID !="")
									{
										$ProductPriceObj->tableUpdate($DataArray);
									}
									else 
									{
										$DataArray['QtyMin'] = "0";
										$DataArray['QtyMax'] = d("DEFINE_PRODUCT_QTY_MAX");
										$DataArray['PriceType'] = 'Unit';
										$DataArray['UserTypeID'] = $UserTypeID;
										$DataArray['ProductID'] = $ProductID;
										$ProductPriceObj->tableInsert($DataArray);
									}
								}
								
								$UserTypeID ='2';
								$ProductPriceObj->where = "ProductID = ".$ProductID." AND UserTypeID ='".$UserTypeID."' AND 
														   (QtyMin='0' OR QtyMin='1')";
								$CurrentPrice = (object)$ProductPriceObj->tableSelectOne(array("ProductPriceID"));
								$DataArray = array();
								if($ProductType=="Attribute_2D" || $ProductType=="Simple_Role"){
									
									if(isset($WholeSaleBasePrice1M))
										$DataArray['Price'] = ($WholeSaleBasePrice1M > 0)?$WholeSaleBasePrice1M:0;
					
									if(isset($WholeSaleBasePrice5M))
										$DataArray['SecondPrice'] = ($WholeSaleBasePrice5M > 0)?$WholeSaleBasePrice5M:0;
					
									if(isset($WholeSalePriceRaisedBy1M))
										$DataArray['PriceRaiseBy'] = ($WholeSalePriceRaisedBy1M > 0)?$WholeSalePriceRaisedBy1M:0;
					
									if(isset($WholeSalePriceRaisedBy5M))
										$DataArray['SecondPriceRaiseBy'] = ($WholeSalePriceRaisedBy5M > 0)?$WholeSalePriceRaisedBy5M:0;
					
									if(isset($WholeSaleRaisingPrice1M))
										$DataArray['RaisedPrice'] = ($WholeSaleRaisingPrice1M > 0)?$WholeSaleRaisingPrice1M:0;
					
									if(isset($WholeSaleRaisingPrice5M))
										$DataArray['SecondRaisedPrice'] = ($WholeSaleRaisingPrice5M > 0)?$WholeSaleRaisingPrice5M:0;
					
									if(isset($WholeSaleThirdPartyCost))
										$DataArray['ThirdPartyPrice'] = ($WholeSaleThirdPartyCost > 0)?$WholeSaleThirdPartyCost:0;
									
									if(isset($WholeSalePerRollPrice))
										$DataArray['PerRollPrice'] = ($WholeSalePerRollPrice > 0)?$WholeSalePerRollPrice:0;
									
							
								}
								elseif($ProductType=="Simple"){
									if(isset($WholeSalePrice))
										$DataArray['Price'] = ($WholeSalePrice > 0)?$WholeSalePrice:0;
									if(isset($WholeSaleSalePrice))
										$DataArray['SalePrice'] = ($WholeSaleSalePrice > 0)?$WholeSaleSalePrice:0;
									if(isset($WholeSaleSaleActive))
										$DataArray['SaleActive'] = ($WholeSaleSaleActive > 0)?$WholeSaleSaleActive:0;
					
								}
								
										
								if(count($DataArray) > 0){
									if(isset($CurrentPrice->ProductPriceID) && $CurrentPrice->ProductPriceID !="")
									{
										$ProductPriceObj->tableUpdate($DataArray);
									}
									else 
									{
										$DataArray['QtyMin'] = "0";
										$DataArray['QtyMax'] = d("DEFINE_PRODUCT_QTY_MAX");
										$DataArray['PriceType'] = 'Unit';
										$DataArray['UserTypeID'] = $UserTypeID;
										$DataArray['ProductID'] = $ProductID;
										$ProductPriceObj->tableInsert($DataArray);
									}
								}
								/* ProductPriceObj entry end*/
					
							
							}
							/* simple and attribute product end*/
						}
						
						if($ProductID > 0){
							$this->getClass('Catalog\Product\Common')->IndexProductSearch($ProductID);
						}
						
					}
					
			}
		}
		$this->getSession()->setArrVar("alert",array("success","Records updated successfully."));
		MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=".$this->view,true);
		exit;
		
	}
	
	public function ProcessCSVStockFileAction()
	{
		set_time_limit(0);
		if(count($_POST) > 0){
			$File = isset($_GET['File'])?$_GET['File']:"";
			
			$csvdata = $this->getDataFromCSV($File);
			foreach($csvdata as $csv_k=>$data){
				
				
				foreach($this->getCsvHeaderInArray() as $key=>$val):
					$index = "DATA_CSV_".strtoupper(str_replace(array(" "),array("_"), trim($val)));
					if(defined($index)){
						${$key} = isset($data[constant($index)])?trim($data[constant($index)]):"";
					}
				endforeach;
				
					
					
					if(isset($ModelNo) && $ModelNo != ""){
						$checkProduct = $this->checkProductbySKU($ModelNo);
						$ProductID = isset($checkProduct->ProductID)?$checkProduct->ProductID:"0";
						$ProductObj = new DataTable(TABLE_PRODUCT);
						$DataArray = array();
						
						if($ProductID > 0){
							
							if(isset($Stock))
								$DataArray['Stock'] = ($Stock > 0)?$Stock:0;
							
							$ProductObj = new DataTable(TABLE_PRODUCT);
							$ProductObj->where[] = array('=',array('ProductID' => $ProductID));
							$ProductObj->tableUpdate($DataArray);
							
						}
						
					}
			}
		}
		$this->getSession()->setArrVar("alert",array("success","Records updated successfully."));
		MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=".$this->view,true);
		exit;
		
	}
	
	
	public function getDataFromCSV($CSVFile)
	{
		$row =1;
		$csvdata = array();
		$dir = FileHandle::CheckPrivateLogDirectory("tmp");
		$dir = FileHandle::CheckPrivateLogDirectory("tmp/import");
		if(isset($CSVFile) && $CSVFile !="" && file_exists($dir.$CSVFile)){
			if (($handle = fopen($dir.$CSVFile, "r")) !== FALSE) {
				    while (($data = fgetcsv($handle)) !== FALSE) {
						if($row ==1){
							$this->CSVHeaderData($data);
						}
						else{
							$csvdata[] = $data;
						}
						$row++; 
					}
			}
		}
		return $csvdata;
	}
	
	function getProductHeaderInArray()
	{
		$ProductHeader = array("SKU"=>"ItemID",
							   "Status"=>"Status",
							   "ProductName"=>"Description",
							   "FeedID"=>"ItemKey",
							   "WholesalePrice"=>"Wholesale",
							   "RetailPrice"=>"Retail",
							   "SalePrice"=>"SalePrice",
							   //"Qty"=>"QtyAvail",
							   );
					   
		return 	$ProductHeader;		   
	}
	function CSVHeaderData($arr)
	{
			foreach ($arr as $key => $value)
			{
				$prop = "DATA_CSV_".strtoupper(str_replace(array(" "),array("_"), trim($value)));
				if(!defined($prop))	
					define($prop,$key);
			}
			
	}
	
	public function UploadCSVFileAction()
	{
		/* attachment Start*/
		if(isset($_FILES['UploadCSV']) && $_FILES['UploadCSV']['name'] !="")
		{
			$ArrayType = explode(".",$_FILES['UploadCSV']['name']);
			$Type=$ArrayType[count($ArrayType)-1];
			
			$dir = FileHandle::CheckPrivateLogDirectory("tmp");
			$dir = FileHandle::CheckPrivateLogDirectory("tmp/import");
			$FileName=uniqid("i-csv-".date('Y-m-d')."-").".".$Type;
			copy($_FILES['UploadCSV']['tmp_name'],$dir.$FileName);
		}
		
		MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=".$this->view."&File=".$FileName);
		exit;
		/* attachment End*/
	}
	
	function getCsvHeaderInArray()
	{
		$CsvHeader = array("ModelNo"=>"SKU",
						   "ProductName"=>"ProductName",
						   "URLName"=>"URL",
						   "Active"=>"Status",
						   "ProductLine"=>"ProductLine",
						   "CategoryCode"=>"CategoryCode",
						   "FilterCode"=>"FilterCode",
						   "ProductType"=>"ProductType",
						   "MasterID"=>"ParentSKU",
						   "AttributeNames"=>"AttributeNames",
						   "AttributeValues"=>"AttributeValues",
						   "NormalPrice"=>"NormalPrice",
						   "NormalSalePrice"=>"NormalSalePrice",
						   "NormalSaleActive"=>"NormalSaleActive",
						   /*
						   "WholeSalePrice"=>"WholeSalePrice",
						   "WholeSaleSalePrice"=>"WholeSaleSalePrice",
						   "WholeSaleSaleActive"=>"WholeSaleSaleActive",
						   
						   "NormalPerRollPrice"=>"NormalPerRollPrice",
						   "WholesalePerRollPrice"=>"WholesalePerRollPrice",
						   "RoleUnit"=>"RoleUnit",
						   "PerMeterText"=>"PerMeterText",
						   
						   */
						   
						   "EngravingCost"=>"EngravingCost",
						   "SizeGuide"=>"SizeGuide",
						   "EngravingOption"=>"EngravingOption",
						   "MotifOption"=>"MotifOption",
						   "LogoOption"=>"LogoOption",
						   "Image"=>"DefaultImage",
						   "ImageAltText"=>"DefaultImageAltText",
						   //"ProCheckImage"=>"HoverImage",
						   //"ProCheckImageAltText"=>"HoverImageAltText",
						   //"ProAddImage"=>"IconImage",
						   //"ProAddImageAltText"=>"IconImageAltText",
						   "EndStock"=>"ManageStock",
						   "Stock"=>"Stock",
						   "StockTotal"=>"StockTotal",
						   "Weight"=>"Weight",
						   "TaxClass"=>"TaxClass",
						   //"ShippingType"=>"ShippingType",
						   //"Categories"=>"Categories",
						   "MetaTitle"=>"MetaTitle",
						   "MetaKeyword"=>"MetaKeyword",
						   "MetaDescription"=>"MetaDescription",
						   //"ProCheckImageDescription"=>"CheckImageDescription",
						   "SmallDescription"=>"SmallDescription",
						   "LargeDescription"=>"LargeDescription",
						   "YoutubeVideo"=>"YoutubeVideo",
						   //"RelatedProducts"=>"RelatedProducts",
						  // "SimilarProducts"=>"SimilarProducts",
						   );
					   
		return 	$CsvHeader;		   
	}
	
	function getCategoryIDs($Categories,$Sep="|") 
	{
		$CategoryArr = explode($Sep,$Categories);
		$ReturnArray = array();
		if(count($CategoryArr) > 0){
			foreach($CategoryArr as $CategoryName){
				$Obj = new DataTable(array('c'=>TABLE_CATEGORY));
				$where = new Where();
				$where->equalTo('CategoryName',trim($CategoryName));
				//$Obj->displayQuery = true;
				$Obj->where = $where;
				$Cobj = (object)$Obj->tableSelectOne(array("CategoryID"),"CategoryID ASC");
				if(isset($Cobj->CategoryID) && $Cobj->CategoryID != "")
					$ReturnArray[] = $Cobj->CategoryID; 	
			
			}
		}
		return $ReturnArray;
	}
	function getCategoryIdsByCode($CategoryCode,$Sep="|") 
	{
		$CategoryCodeArr = explode($Sep,$CategoryCode);
		$ReturnArray = array();
		if(count($CategoryCodeArr) > 0){
			foreach($CategoryCodeArr as $Code){
				$Obj = new DataTable(array('c'=>TABLE_CATEGORY));
				$where = new Where();
				$where->equalTo('Others',trim($Code));
				//$Obj->displayQuery = true;
				$Obj->where = $where;
				$Cobj = (object)$Obj->tableSelectOne(array("CategoryID"),"CategoryID ASC");
				if(isset($Cobj->CategoryID) && $Cobj->CategoryID != "")
					$ReturnArray[] = $Cobj->CategoryID; 	
			
			}
		}
		return $ReturnArray;
	}
	function getIdsByFilterCode($FilterCode,$Sep="|") 
	{
		$FilterCodeArr = explode($Sep,$FilterCode);
		$ReturnArray = array();
		if(count($FilterCodeArr) > 0){
			foreach($FilterCodeArr as $Code){
				$Obj = new DataTable(array('c'=>TABLE_FILTER_VALUE));
				$where = new Where();
				$where->equalTo('FilterLine',trim($Code));
				//$Obj->displayQuery = true;
				$Obj->where = $where;
				$Cobj = (object)$Obj->tableSelectOne(array("FilterID","FilterValueID"),"FilterValueID ASC");
				if(isset($Cobj->FilterValueID) && $Cobj->FilterValueID != "")
					$ReturnArray[] = array("FilterID"=>$Cobj->FilterID,"FilterValueID"=>$Cobj->FilterValueID); 	
			
			}
		}
		return $ReturnArray;
	}
	
	function ImageAltText($CurrentProduct,$ProductArray) 
	{
		if(isset($CurrentProduct->Image) && $CurrentProduct->Image != ""){
			$SeoObj = new DataTable(TABLE_SEO_IMAGES);
			$SeoObj->where[] = array('=',array('ImageID' => $CurrentProduct->Image));
			$CurrentImage = (object)$SeoObj->tableSelectOne(array("AltText"));
			if(isset($CurrentImage->AltText) && $CurrentImage->AltText != "" && in_array('DefaultImageAltText',$ProductArray[0]))
			{	
				$ProductArray[$CurrentProduct->ProductID]['ImageAltText'] = $CurrentImage->AltText; 	
			}
		}
		if(isset($CurrentProduct->ProCheckImage) && $CurrentProduct->ProCheckImage != ""){
			$SeoObj = new DataTable(TABLE_SEO_IMAGES);
			$SeoObj->where[] = array('=',array('ImageID' => $CurrentProduct->ProCheckImage));
			$CurrentImage = (object)$SeoObj->tableSelectOne(array("AltText"));
			if(isset($CurrentImage->AltText) && $CurrentImage->AltText != "" && in_array('HoverImageAltText',$ProductArray[0]))
			{	
				$ProductArray[$CurrentProduct->ProductID]['ProCheckImageAltText'] = $CurrentImage->AltText; 	
			}
		}
		if(isset($CurrentProduct->ProAddImage) && $CurrentProduct->ProAddImage != ""){
			$SeoObj = new DataTable(TABLE_SEO_IMAGES);
			$SeoObj->where[] = array('=',array('ImageID' => $CurrentProduct->ProAddImage));
			$CurrentImage = (object)$SeoObj->tableSelectOne(array("AltText"));
			if(isset($CurrentImage->AltText) && $CurrentImage->AltText != "" && in_array('IconImageAltText',$ProductArray[0]))
			{	
				$ProductArray[$CurrentProduct->ProductID]['ProAddImageAltText'] = $CurrentImage->AltText; 	
			}
		}
		
		
		return $ProductArray;
	}
	function CategoryList($CurrentProduct,$ProductArray) 
	{
		if(isset($CurrentProduct->ProductID)){
			$Obj = new DataTable(array('c'=>TABLE_CATEGORY));
			$Obj->joinExpression = true;
			$Obj->joinArray[] = array('name'=>array('pr'=>TABLE_PRODUCT_RELATION),
										  'on'=>"(pr.RelationID = c.CategoryID AND pr.RelationType ='catalog_category')",
										  'columns'=>array("ProductID"),
										  'type'=>"left",
										  );
										  
			
			$where = new Where();
			$where->equalTo('pr.ProductID',$CurrentProduct->ProductID);
			//$Obj->displayQuery = true;
			$Obj->where = $where;
			$Obj->columnExpression=true;
			$Cobj = (object)$Obj->tableSelectOne(array("GROUP_CONCAT(DISTINCT CategoryName ORDER BY CategoryName ASC SEPARATOR '|') as Categories","GROUP_CONCAT(DISTINCT Others ORDER BY Others ASC SEPARATOR '|') as CategoryCode"));
			//var_dump("<hr>",$Cobj);
			if(isset($Cobj->Categories) && $Cobj->Categories != "" && in_array('Categories',$ProductArray[0]))
				$ProductArray[$CurrentProduct->ProductID]['Categories'] = $Cobj->Categories; 	
			
			if(isset($Cobj->CategoryCode) && $Cobj->CategoryCode != "" && in_array('CategoryCode',$ProductArray[0]))
				$ProductArray[$CurrentProduct->ProductID]['CategoryCode'] = $Cobj->CategoryCode; 	
			
			
		}
		return $ProductArray;
	}
	
	function FilterList($CurrentProduct,$ProductArray) 
	{
		if(isset($CurrentProduct->ProductID)){
			$Obj = new DataTable(array('c'=>TABLE_FILTER_VALUE));
			$Obj->joinExpression = true;
			$Obj->joinArray[] = array('name'=>array('pr'=>TABLE_PRODUCT_RELATION_FILTER),
										  'on'=>"(pr.FilterValueID = c.FilterValueID)",
										  'columns'=>array("ProductID"),
										  'type'=>"left",
										  );
										  
			
			$where = new Where();
			$where->equalTo('pr.ProductID',$CurrentProduct->ProductID);
			//$Obj->displayQuery = true;
			$Obj->where = $where;
			$Obj->columnExpression=true;
			$Cobj = (object)$Obj->tableSelectOne(array("GROUP_CONCAT(DISTINCT FilterValue ORDER BY FilterValue ASC SEPARATOR '|') as FilterValues","GROUP_CONCAT(DISTINCT FilterLine ORDER BY FilterLine ASC SEPARATOR '|') as FilterCode"));
			if(isset($Cobj->FilterValues) && $Cobj->FilterValues != "" && in_array('FilterValues',$ProductArray[0]))
				$ProductArray[$CurrentProduct->ProductID]['FilterValues'] = $Cobj->FilterValues; 	
			if(isset($Cobj->FilterCode) && $Cobj->FilterCode != "" && in_array('FilterCode',$ProductArray[0]))
				$ProductArray[$CurrentProduct->ProductID]['FilterCode'] = $Cobj->FilterCode; 	
			
			
		}
		return $ProductArray;
	}
	
	function RelatedProducts($CurrentProduct,$ProductArray) 
	{
		if(isset($CurrentProduct->ProductID)){
			$RelArr = $this->getClass('Catalog\Product\Common')->getProductRelationArray();
			foreach($RelArr as $k=>$Arr){
				
				$Obj = new DataTable(array('p'=>TABLE_PRODUCT));
				$Obj->joinExpression = true;
				$Obj->joinArray[] = array('name'=>array('pr'=>TABLE_PRODUCT_RELATION),
											  'on'=>"(pr.RelationID = p.ProductID AND pr.RelationType ='".$k."')",
											  'columns'=>array("ProductID"),
											  'type'=>"left",
											  );
											  
				
				$where = new Where();
				$where->equalTo('pr.ProductID',$CurrentProduct->ProductID);
				$where->notEqualTo('p.ModelNo','');
				$Obj->where = $where;
				$Obj->columnExpression=true;
				$Cobj = (object)$Obj->tableSelectOne(array("GROUP_CONCAT(DISTINCT ModelNo ORDER BY ModelNo ASC SEPARATOR '|') as ModelNos"));
				if(isset($Cobj->ModelNos) && $Cobj->ModelNos != "" && in_array($Arr['name']."Products",$ProductArray[0]))
					$ProductArray[$CurrentProduct->ProductID][$Arr['name']."Products"] = $Cobj->ModelNos; 	
			
			}
			
		}
		return $ProductArray;
	}
	function ProductPrice($CurrentProduct,$ProductArray) 
	{
		if(isset($CurrentProduct->ProductID)){
			$CurrentNPrice = $this->getClass('Catalog\Product\Common')->UserProductPrice($CurrentProduct->ProductID,1);
			$CurrentWPrice = $this->getClass('Catalog\Product\Common')->UserProductPrice($CurrentProduct->ProductID,2);
			
			if(in_array('RoleUnit',$ProductArray[0]))
				$ProductArray[$CurrentProduct->ProductID]["RoleUnit"] = (isset($CurrentProduct->PerRollUnit)?MyStripSlashes($CurrentProduct->PerRollUnit):""); 	
			if(in_array('PerMeterText',$ProductArray[0]))
				$ProductArray[$CurrentProduct->ProductID]["PerMeterText"] = (isset($CurrentRecord->PerMtrText)?MyStripSlashes($CurrentRecord->PerMtrText):""); 	
					
				
			if(isset($CurrentNPrice[0]['ProductPriceID'])){
				
				if(in_array('NormalPerRollPrice',$ProductArray[0]))
					$ProductArray[$CurrentProduct->ProductID]["NormalPerRollPrice"] = (isset($CurrentNPrice[0]['PerRollPrice'])?MyStripSlashes($CurrentNPrice[0]['PerRollPrice']):""); 	
				
				if(in_array('NormalPrice',$ProductArray[0]))
					$ProductArray[$CurrentProduct->ProductID]["NormalPrice"] = (isset($CurrentNPrice[0]['Price'])?MyStripSlashes($CurrentNPrice[0]['Price']):""); 	
				if(in_array('NormalSalePrice',$ProductArray[0]))
					$ProductArray[$CurrentProduct->ProductID]["NormalSalePrice"] = (isset($CurrentNPrice[0]['SalePrice'])?MyStripSlashes($CurrentNPrice[0]['SalePrice']):""); 	
				if(in_array('NormalSaleActive',$ProductArray[0]))
					$ProductArray[$CurrentProduct->ProductID]["NormalSaleActive"] = (isset($CurrentNPrice[0]['SaleActive'])?MyStripSlashes($CurrentNPrice[0]['SaleActive']):"0"); 	
				
				if(in_array('NormalBasePrice1M',$ProductArray[0]))
					$ProductArray[$CurrentProduct->ProductID]["NormalBasePrice1M"] = (isset($CurrentNPrice[0]['Price'])?MyStripSlashes($CurrentNPrice[0]['Price']):""); 	
				if(in_array('NormalBasePrice5M',$ProductArray[0]))
					$ProductArray[$CurrentProduct->ProductID]["NormalBasePrice5M"] = (isset($CurrentNPrice[0]['SecondPrice'])?MyStripSlashes($CurrentNPrice[0]['SecondPrice']):""); 	
				if(in_array('NormalPriceRaisedBy1M',$ProductArray[0]))
					$ProductArray[$CurrentProduct->ProductID]["NormalPriceRaisedBy1M"] = (isset($CurrentNPrice[0]['PriceRaiseBy'])?MyStripSlashes($CurrentNPrice[0]['PriceRaiseBy']):""); 	
				if(in_array('NormalPriceRaisedBy5M',$ProductArray[0]))
					$ProductArray[$CurrentProduct->ProductID]["NormalPriceRaisedBy5M"] = (isset($CurrentNPrice[0]['SecondPriceRaiseBy'])?MyStripSlashes($CurrentNPrice[0]['SecondPriceRaiseBy']):""); 	
				if(in_array('NormalRaisingPrice1M',$ProductArray[0]))
					$ProductArray[$CurrentProduct->ProductID]["NormalRaisingPrice1M"] = (isset($CurrentNPrice[0]['RaisedPrice'])?MyStripSlashes($CurrentNPrice[0]['RaisedPrice']):""); 	
				if(in_array('NormalRaisingPrice5M',$ProductArray[0]))
					$ProductArray[$CurrentProduct->ProductID]["NormalRaisingPrice5M"] = (isset($CurrentNPrice[0]['SecondRaisedPrice'])?MyStripSlashes($CurrentNPrice[0]['SecondRaisedPrice']):""); 	
				if(in_array('NormalThirdPartyCost',$ProductArray[0]))
					$ProductArray[$CurrentProduct->ProductID]["NormalThirdPartyCost"] = (isset($CurrentNPrice[0]['ThirdPartyPrice'])?MyStripSlashes($CurrentNPrice[0]['ThirdPartyPrice']):""); 	
			}
			
			if(isset($CurrentWPrice[0]['ProductPriceID'])){
				
				if(in_array('WholeSalePerRollPrice',$ProductArray[0]))
					$ProductArray[$CurrentProduct->ProductID]["WholeSalePerRollPrice"] = (isset($CurrentWPrice[0]['PerRollPrice'])?MyStripSlashes($CurrentWPrice[0]['PerRollPrice']):""); 	
				
				if(in_array('WholeSalePrice',$ProductArray[0]))
					$ProductArray[$CurrentProduct->ProductID]["WholeSalePrice"] = (isset($CurrentWPrice[0]['Price'])?MyStripSlashes($CurrentWPrice[0]['Price']):""); 	
				if(in_array('WholeSaleSalePrice',$ProductArray[0]))
					$ProductArray[$CurrentProduct->ProductID]["WholeSaleSalePrice"] = (isset($CurrentWPrice[0]['SalePrice'])?MyStripSlashes($CurrentWPrice[0]['SalePrice']):""); 	
				if(in_array('WholeSaleSaleActive',$ProductArray[0]))
					$ProductArray[$CurrentProduct->ProductID]["WholeSaleSaleActive"] = (isset($CurrentWPrice[0]['SaleActive'])?MyStripSlashes($CurrentWPrice[0]['SaleActive']):"0"); 	
				
				if(in_array('WholeSaleBasePrice1M',$ProductArray[0]))
					$ProductArray[$CurrentProduct->ProductID]["WholeSaleBasePrice1M"] = (isset($CurrentWPrice[0]['Price'])?MyStripSlashes($CurrentWPrice[0]['Price']):""); 	
				if(in_array('WholeSaleBasePrice5M',$ProductArray[0]))
					$ProductArray[$CurrentProduct->ProductID]["WholeSaleBasePrice5M"] = (isset($CurrentWPrice[0]['SecondPrice'])?MyStripSlashes($CurrentWPrice[0]['SecondPrice']):""); 	
				if(in_array('WholeSalePriceRaisedBy1M',$ProductArray[0]))
					$ProductArray[$CurrentProduct->ProductID]["WholeSalePriceRaisedBy1M"] = (isset($CurrentWPrice[0]['PriceRaiseBy'])?MyStripSlashes($CurrentWPrice[0]['PriceRaiseBy']):""); 	
				if(in_array('WholeSalePriceRaisedBy5M',$ProductArray[0]))
					$ProductArray[$CurrentProduct->ProductID]["WholeSalePriceRaisedBy5M"] = (isset($CurrentWPrice[0]['SecondPriceRaiseBy'])?MyStripSlashes($CurrentWPrice[0]['SecondPriceRaiseBy']):""); 	
				if(in_array('WholeSaleRaisingPrice1M',$ProductArray[0]))
					$ProductArray[$CurrentProduct->ProductID]["WholeSaleRaisingPrice1M"] = (isset($CurrentWPrice[0]['RaisedPrice'])?MyStripSlashes($CurrentWPrice[0]['RaisedPrice']):""); 	
				if(in_array('WholeSaleRaisingPrice5M',$ProductArray[0]))
					$ProductArray[$CurrentProduct->ProductID]["WholeSaleRaisingPrice5M"] = (isset($CurrentWPrice[0]['SecondRaisedPrice'])?MyStripSlashes($CurrentWPrice[0]['SecondRaisedPrice']):""); 	
				if(in_array('WholeSaleThirdPartyCost',$ProductArray[0]))
					$ProductArray[$CurrentProduct->ProductID]["WholeSaleThirdPartyCost"] = (isset($CurrentWPrice[0]['ThirdPartyPrice'])?MyStripSlashes($CurrentWPrice[0]['ThirdPartyPrice']):""); 	
			}
						   
  
		}
		return $ProductArray;
	}
	
	
	function ProductDataWithFilter() 
	{
		$Keyword = isset($_REQUEST['k'])?$_REQUEST['k']:"";
		$KeywordArr =  explode(" ",$Keyword);
		
		$ProductArray[0] = $this->getCsvHeaderInArray();
		
		$where = new Where();
		$ProductObj = new DataTable(array('p'=>TABLE_PRODUCT));
		$ProductObj->joinExpression = true;
		$ProductObj->joinArray[] = array('name'=>array('s'=>TABLE_SEO),
									  'on'=>"(s.ReferenceID = p.ProductID AND s.MCode='catalog_product')",
									  'columns'=>array("*"),
									  'type'=>"left",
									  );
									  
		
		if(isset($_POST['CategoryArr']) && $_POST['CategoryArr'] !="" && count($_POST['CategoryArr']) >0){
					
			$ProductObj->joinExpression = true;
			$ProductObj->joinArray[] = array('name'=>array('ptc'=>TABLE_PRODUCT_RELATION),
										  'on'=>"(ptc.ProductID=p.ProductID and ptc.RelationType='catalog_category')",
										  'columns'=>array("RelationID","SortOrder"),
										  'type'=>''
										  );
		  $where->in('ptc.RelationID',$_POST['CategoryArr']);
										  
		}
		
		if(count($KeywordArr) > 0 && $Keyword != "")
		{
			foreach ($KeywordArr as $Key=>$Value)
			{
				if($Value != "")
				{
					$where->NEST//start braket
							->like('p.ProductID','%'.$Value.'%')->OR
							->like('p.ProductName','%'.$Value.'%')->OR
							->like('p.ModelNo','%'.$Value.'%')->OR
							->like('p.ProductLine','%'.$Value.'%')->OR
							->UNNEST;
				}
			}
		}
		
		$where->notEqualTo('p.ProductType','Child');
		$where->notEqualTo('p.ProductName','');
		$where->notEqualTo('p.ModelNo','');
		//$where->in('p.ProductType',array('Simple','Attribute','Simple_Role','Attribute_2D'));
		//$where->equalTo('p.Active','1');
		
				
		$ProductObj->where = $where;
		//$ProductObj->displayQuery =true;
		$rows = $ProductObj->tableSelectAll(array("*"),array("p.ProductID DESC","p.ProductName ASC","p.ProductID ASC"));
		if(count($rows) > 0){
			foreach( $rows as $CurrentProduct)
			{
				foreach($ProductArray[0] as $arrKey=>$arrCol){
						$ProductArray[$CurrentProduct->ProductID][$arrKey] = isset($CurrentProduct->{$arrKey})?trim(MyStripSlashes($CurrentProduct->{$arrKey})):""; 	
				}
				
				$ProductArray = $this->ImageAltText($CurrentProduct,$ProductArray);
				$ProductArray = $this->CategoryList($CurrentProduct,$ProductArray);
				$ProductArray = $this->FilterList($CurrentProduct,$ProductArray);
				$ProductArray = $this->RelatedProducts($CurrentProduct,$ProductArray);
				$ProductArray = $this->ProductPrice($CurrentProduct,$ProductArray);
				
				if(strtolower($CurrentProduct->ProductType)=="attribute"){
					$ProductArray[$CurrentProduct->ProductID]['AttributeNames'] = $this->getClass("Catalog\Attribute\Common")->ConvertAttributeIDs($CurrentProduct->ProductAttribute,"name");
					$chrows = $this->getProductChildren($CurrentProduct->ProductID);
					foreach( $chrows as $CurrentChild){
						foreach($ProductArray[0] as $arrKey=>$arrCol){
							$ProductArray[$CurrentChild->ProductID][$arrKey] = ""; 	
						}
						$ProductArray[$CurrentChild->ProductID]['Active'] =isset($CurrentProduct->Active)?trim(MyStripSlashes($CurrentProduct->Active)):"";
						$ProductArray[$CurrentChild->ProductID]['MasterID'] =isset($CurrentProduct->ModelNo)?trim(MyStripSlashes($CurrentProduct->ModelNo)):"";
						$ProductArray[$CurrentChild->ProductID]['ModelNo'] =isset($CurrentChild->ModelNo)?trim(MyStripSlashes($CurrentChild->ModelNo)):"";
						
						$ProductArray[$CurrentChild->ProductID]['EngravingCost'] =isset($CurrentChild->EngravingCost)?trim(MyStripSlashes($CurrentChild->EngravingCost)):"";
						$ProductArray[$CurrentChild->ProductID]['EngravingOption'] =isset($CurrentChild->EngravingOption)?trim(MyStripSlashes($CurrentChild->EngravingOption)):"";
						$ProductArray[$CurrentChild->ProductID]['MotifOption'] =isset($CurrentChild->MotifOption)?trim(MyStripSlashes($CurrentChild->MotifOption)):"";
						$ProductArray[$CurrentChild->ProductID]['LogoOption'] =isset($CurrentChild->LogoOption)?trim(MyStripSlashes($CurrentChild->LogoOption)):"";
						
						//$ProductArray[$CurrentChild->ProductID]['SKU'] =isset($CurrentChild->ModelNo)?trim(MyStripSlashes($CurrentChild->ModelNo)):"";
						$ProductArray[$CurrentChild->ProductID]['ProductName'] =isset($CurrentChild->ProductName)?trim(MyStripSlashes($CurrentChild->ProductName)):"";
						$ProductArray[$CurrentChild->ProductID]['Status'] =isset($CurrentChild->Status)?trim(MyStripSlashes($CurrentChild->Status)):"";
						$ProductArray[$CurrentChild->ProductID]['ProductType'] =isset($CurrentChild->ProductType)?trim(MyStripSlashes($CurrentChild->ProductType)):"";
						$ProductArray[$CurrentChild->ProductID]['EndStock'] =isset($CurrentChild->EndStock)?trim(MyStripSlashes($CurrentChild->EndStock)):"";
						$ProductArray[$CurrentChild->ProductID]['Stock'] =isset($CurrentChild->Stock)?trim(MyStripSlashes($CurrentChild->Stock)):"";
						$ProductArray[$CurrentChild->ProductID]['StockTotal'] =isset($CurrentChild->StockTotal)?trim(MyStripSlashes($CurrentChild->StockTotal)):"";
						$ProductArray[$CurrentChild->ProductID]['Weight'] =isset($CurrentChild->Weight)?trim(MyStripSlashes($CurrentChild->Weight)):"";
						$ProductArray[$CurrentChild->ProductID]['LargeDescription'] =isset($CurrentChild->LargeDescription)?trim(MyStripSlashes($CurrentChild->LargeDescription)):"";
						$ProductArray[$CurrentChild->ProductID]['AttributeNames'] =$this->getClass("Catalog\Attribute\Common")->ConvertAttributeIDs($CurrentProduct->ProductAttribute,"name");
						$ProductArray[$CurrentChild->ProductID]['AttributeValues'] =$this->getClass("Catalog\Attribute\Common")->ConvertAttributeValuesIDs($CurrentChild->ProductAttribute);
						$ProductArray = $this->ImageAltText($CurrentChild,$ProductArray);
						$ProductArray = $this->ProductPrice($CurrentChild,$ProductArray);
						   
						
					}
				}
					
			}
		}
		
		return $ProductArray;
		
	}
	function ProductData($ActiveOnly=false) 
	{
		$ProductArray[0] = $this->getCsvHeaderInArray();
		$ProductObj = new DataTable(array('p'=>TABLE_PRODUCT));
		$ProductObj->joinExpression = true;
		$ProductObj->joinArray[] = array('name'=>array('s'=>TABLE_SEO),
									  'on'=>"(s.ReferenceID = p.ProductID AND s.MCode='catalog_product')",
									  'columns'=>array("*"),
									  'type'=>"left",
									  );
									  
		
		$where = new Where();
		$where->notEqualTo('p.ProductType','Child');
		$where->notEqualTo('p.ProductName','');
		$where->notEqualTo('p.ModelNo','');
		//$where->in('p.ProductType',array('Simple','Attribute','Simple_Role','Attribute_2D'));
		//$where->equalTo('p.Active','1');
		
		if($ActiveOnly)
			$where->equalTo('p.Active','1');
				
		$ProductObj->where = $where;
		$rows = $ProductObj->tableSelectAll(array("*"),array("p.ProductID DESC","p.ProductName ASC","p.ProductID ASC"));
		if(count($rows) > 0){
			foreach( $rows as $CurrentProduct)
			{
				foreach($ProductArray[0] as $arrKey=>$arrCol){
						$ProductArray[$CurrentProduct->ProductID][$arrKey] = isset($CurrentProduct->{$arrKey})?MyStripSlashes($CurrentProduct->{$arrKey}):""; 	
				}
				
				$ProductArray = $this->ImageAltText($CurrentProduct,$ProductArray);
				$ProductArray = $this->CategoryList($CurrentProduct,$ProductArray);
				$ProductArray = $this->FilterList($CurrentProduct,$ProductArray);
				$ProductArray = $this->RelatedProducts($CurrentProduct,$ProductArray);
				$ProductArray = $this->ProductPrice($CurrentProduct,$ProductArray);
				
			}
		}
		
		return $ProductArray;
	}
	
	public function DownloadCSVFileAction()
	{
		$ProductArray = $this->ProductData();
		$dir = FileHandle::CheckPrivateLogDirectory("tmp");
		$dir = FileHandle::CheckPrivateLogDirectory("tmp/import");
		$filename=$dir."d-product-".date("Y-m-d_h-i-s").".csv";
		$csv_resource = fopen($filename, 'w');
		foreach($ProductArray as $ProductID=>$DArr){
			fputcsv($csv_resource, array_values($DArr));
		}
		fclose($csv_resource);
		if(file_exists($filename) && $filename != ""){
			FileHandle::DownloadFile($filename);
			exit;
		}
		
	}
	
	public function DownloadCSVStockFileAction()
	{
		
		$ProductArray[0] = array("SKU","Stock");
		$ProductObj = new DataTable(array('p'=>TABLE_PRODUCT));
		$where = new Where();
		$where->notEqualTo('p.ProductType','Child');
		$where->notEqualTo('p.ProductName','');
		$where->notEqualTo('p.ModelNo','');
		$ProductObj->where = $where;
		$rows = $ProductObj->tableSelectAll(array("ProductID","ModelNo","Stock"),array("p.ModelNo ASC"));
		if(count($rows) > 0){
			foreach( $rows as $CurrentProduct)
			{
				$ProductArray[$CurrentProduct->ProductID] = array($CurrentProduct->ModelNo,$CurrentProduct->Stock);
				
			}
		}
		
		
		
		$dir = FileHandle::CheckPrivateLogDirectory("tmp");
		$dir = FileHandle::CheckPrivateLogDirectory("tmp/import");
		$filename=$dir."d-pro-stock-".date("Y-m-d_h-i-s").".csv";
		$csv_resource = fopen($filename, 'w');
		foreach($ProductArray as $ProductID=>$DArr){
			fputcsv($csv_resource, array_values($DArr));
		}
		fclose($csv_resource);
		if(file_exists($filename) && $filename != ""){
			FileHandle::DownloadFile($filename);
			exit;
		}
		
	}
	
	public function DownloadFilterCSVFileAction()
	{
		if(isset($_POST['Download'])){
			
			
			$ProductArray = $this->ProductDataWithFilter();
			$dir = FileHandle::CheckPrivateLogDirectory("tmp");
			$dir = FileHandle::CheckPrivateLogDirectory("tmp/import");
			$filename=$dir."d-product-".date("Y-m-d_h-i-s").".csv";
			$csv_resource = fopen($filename, 'w');
			foreach($ProductArray as $ProductID=>$DArr){
				fputcsv($csv_resource, array_values($DArr));
			}
			fclose($csv_resource);
			if(file_exists($filename) && $filename != ""){
				FileHandle::DownloadFile($filename);
				exit;
			}
		}
		
		
		
		
	}
	
	public function productCount()
	{
		$where = new Where();
		$ProductObj = new DataTable(array('p'=>TABLE_PRODUCT));
		$where->notEqualTo('p.ProductType','Child');
		$where->notEqualTo('p.ProductName','');
		$where->in('p.ProductType',array('Simple','Attribute'));
		$ProductObj->where = $where;
		$ProductObj->columnExpression=true;
		$Obj = $ProductObj->tableSelectOne(array('Total'=>'Count(*)'));
		
		
		return $Obj['Total'] > 0?$Obj['Total']:0;
	}
	
	public function getProductChildren($MasterID)
	{
		if($MasterID > 0)
		{
			$ProductObj = new DataTable(array('p'=>TABLE_PRODUCT));
			$ProductObj->where[] = array('=',array('p.MasterID' => $MasterID));
			$ProductObj->where[] = array('=',array('p.ProductType' => 'Child'));
			$ProductObj->where[] = array('=',array('pr.UserTypeID' => '1'));
			$ProductObj->joinExpression = true;
			$ProductObj->joinArray[] = array('name'=>array('pr'=>TABLE_PRODUCT_PRICES),
										  'on'=>"(pr.ProductID = p.ProductID)",
										  'columns'=>array("Price","SalePrice","SaleActive"),
										  'type'=>"left",
										  );
			$ProductObj->joinArray[] = array('name'=>array('ut'=>TABLE_USER_TYPE),
										  'on'=>"(ut.UserTypeID = pr.UserTypeID AND IsDefault=1)",
										  'columns'=>array("*"),
										  'type'=>"left",
										  );
			
			//$ProductObj->displayQuery = true;
			return $ProductObj->tableSelectAll(array("*"),array("ProductID ASC"));
		}
		
	
		return ;
	}
	
	function checkProductbySKU($ModelNo)
	{
		$ProductObj = new DataTable(TABLE_PRODUCT);
		$ProductObj->where[] = array('=',array('ModelNo' => $ModelNo));
		return (object)$ProductObj->tableSelectOne(array("ProductID","ModelNo","ProductName"));
	}
	function checkChildProductbySKU($MasterID,$ModelNo)
	{
		$ProductObj = new DataTable(TABLE_PRODUCT);
		$ProductObj->where[] = array('=',array('MasterID' => $MasterID));
		$ProductObj->where[] = array('=',array('ModelNo' => $ModelNo));
		return (object)$ProductObj->tableSelectOne(array("ProductID"));
	}
	function getProductTypeByID($ProductID)
	{
		$ProductObj = new DataTable(TABLE_PRODUCT);
		$ProductObj->where[] = array('=',array('ProductID' => $ProductID));
		$Obj = (object)$ProductObj->tableSelectOne(array("ProductType"));
		
		return isset($Obj->ProductType)?$Obj->ProductType:"";
	}
	
	function getCurrencyList()
	{
		return $this->getClass('Sale\Currency\Admin\Controller\IndexController')->getList();
	}
	
	public function pageTitle()
	{
		return "Import";
	}
	
	public function pageRight()
	{
		$Html = '';
		return $Html;	   
	}
	
	
}	