<?php 
namespace Catalog\Filter\Admin\Controller;
use WebsiteControl\Base\AbstractModule;
use Base\Db\DataTable as DataTable;

class IndexController extends AbstractModule
{
	function __construct()
	{
		
	}
	
	public function AddEditFilterAction()
	{
		if(count($_POST)>0)
		{
			$FilterObj = new DataTable(TABLE_FILTER);
			$SeoObj = new DataTable(TABLE_SEO);
			$FilterID = isset($_GET['FilterID'])?$_GET['FilterID']:0;


			$DataArray = array();
			$DataArray['Active'] = isset($_POST['Active'])?$_POST['Active']:0;
			
			$DataArray['FilterName'] = isset($_POST['FilterName'])?$_POST['FilterName']:"";
			
			if(isset($_POST['Template']) && $_POST['Template'] !="")
				$DataArray['Template'] = $_POST['Template'];
			
			$DataArray['Description'] = isset($_POST['Description'])?$_POST['Description']:"";
			
			/* Filter image added*/
			if(isset($_POST['FilterImage']) && $_POST['FilterImage'] !="" && file_exists(DIR_FS_SITE_UPLOADS."filter/".$_POST['FilterImage']))
			{
				if(isset($_POST['FilterImageDelete']) && $_POST['FilterImageDelete'] == "1")
				{
					@unlink(DIR_FS_SITE_UPLOADS."filter/".$_POST['FilterImage']);
				}
				
			}
			if(isset($_FILES['Upload']) && $_FILES['Upload']['name'] !="")
			{
				$ArrayType = explode(".",$_FILES['Upload']['name']);
				$Type=$ArrayType[count($ArrayType)-1];
				
				$ImageName = uniqid(substr($DataArray['FilterName'],0,5)."_").".".$Type;				
				$OriginalImage =DIR_FS_SITE_UPLOADS."filter/".$ImageName;
				copy($_FILES['Upload']['tmp_name'],$OriginalImage);
				$DataArray['Image'] = $ImageName;
		
				if(isset($_POST['FilterImage']) && $_POST['FilterImage'] !="" && file_exists(DIR_FS_SITE_UPLOADS."filter/".$_POST['FilterImage']))
					@unlink(DIR_FS_SITE_UPLOADS."filter/".$_POST['FilterImage']);
			}
			/* Filter image added end*/	
			
			if($FilterID > 0)
			{
				
				$FilterObj->where[] = array('=',array('FilterID' => $FilterID));
				$FilterObj->tableUpdate($DataArray);
				$this->getSession()->setArrVar("alert",array("success","Filter updated successfully."));
				
			}
			else 
			{
							
				$FilterObj->where ="1";
				$Position = $FilterObj->getMax("Position") + 1;
				
				$DataArray['Position'] = $Position;
				$DataArray['CreatedDate'] =date('Y-m-d H:i:s');
				
				$FilterID = $FilterObj->tableInsert($DataArray);		
				$this->getSession()->setArrVar("alert",array("success","Filter added successfully."));
				
			}
			
			if(isset($_POST['FilterValue'])){
				$FilterValueIDArr = $this->getAllAttrbuteValuesIDs($FilterID);
				$UpdatedFilterValueIDArr = array();
				
				foreach ($_POST['FilterValue'] as $k=>$v){
					$FilterValueObj = new DataTable(TABLE_FILTER_VALUE);
					$SubDataArray = array();
					$FilterValueID = $_POST['FilterValueID'][$k]?:0;
					$SubDataArray['FilterValue'] =$_POST['FilterValue'][$k]?? "";
					$SubDataArray['FilterLine'] =$_POST['FilterLine'][$k]?? "";
					$SubDataArray['Active'] = $_POST['FilterActive'][$k]?: "0"; 
					$SubDataArray['Position'] = $_POST['Position'][$k]?: "0";  
					
					if($SubDataArray['FilterValue'] != ""){
						if($FilterValueID > 0){
							$UpdatedFilterValueIDArr[] = $FilterValueID;
							$FilterValueObj->where[] = array('=',array('FilterID' => $FilterID));
							$FilterValueObj->where[] = array('=',array('FilterValueID' => $FilterValueID));
							$FilterValueObj->tableUpdate($SubDataArray);
							
						}
						else{
							$SubDataArray['FilterID'] =$FilterID;
							$SubDataArray['CreatedDate'] =date('Y-m-d H:i:s');
							$FilterValueObj->tableInsert($SubDataArray);
						}
					}
					//var_dump($FilterValueID,$SubDataArray,"<hr>");
					
				}
				
				/* Delete FilterValueIds*/
				$DeletedFilterValueIDArr = array_diff($FilterValueIDArr,$UpdatedFilterValueIDArr);
				if(is_array($DeletedFilterValueIDArr) && count($DeletedFilterValueIDArr) > 0){
					foreach($DeletedFilterValueIDArr as $DeleteID){
						$FilterValueObj = new DataTable(TABLE_FILTER_VALUE);
						$FilterValueObj->where[] = array('=',array('FilterValueID' => $DeleteID));
						$FilterValueObj->tableDelete();
					}
				}
				/* Delete FilterValueIds END*/
				
			}
		
			if(isset($_POST['Continue'])){	
				MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=AddEditFilter&FilterID=$FilterID");
				exit;
		    }
			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&FilterID=$FilterID");
		    exit;
		}
		
	}
	public function UpdateFilterAction()
	{
		if(count($_POST)>0)
		{
			
			for ($i=1;$i <$_POST['Count'];$i++)
			{
				$FilterObj = new DataTable(TABLE_FILTER);
				$FilterID =$_POST['FilterID_'.$i];
				$DataArray = array();
				$DataArray['Active'] = isset($_POST['Active_'.$i])?$_POST['Active_'.$i]:0;
				$DataArray['Position'] = (isset($_POST['Position_'.$i]) && $_POST['Position_'.$i] > 0)?$_POST['Position_'.$i]:0;
				$FilterObj->where[] = array('=',array('FilterID' => $FilterID));
				$FilterObj->tableUpdate($DataArray);
				
			}
			$this->getSession()->setArrVar("alert",array("success","Filter updated successfully."));
			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&PageNo=".$this->origin->PageNo);
			 exit;
		}
	}
	
	public function DeleteFilterAction()
	{
		$FilterID = isset($_GET['FilterID'])?$_GET['FilterID']:0;
		if($FilterID > 0)
		{
			$FilterObj = new DataTable(TABLE_FILTER);
			$FilterObj->where[] = array('=',array('FilterID' => $FilterID));
			$FilterObj->tableDelete();								
			
			$SeoObj = new DataTable(TABLE_SEO);
			$SeoObj->where = "ReferenceID = ".$FilterID." AND MCode ='catalog_Filter' ";
			$SeoObj->tableDelete();		
		}			
		
		$this->getSession()->setArrVar("alert",array("success","Filter deleted successfully."));
		MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&ParentID=".$this->origin->ParentID);
		 exit;
	}
	public function getList()
	{
		$FilterObj = new DataTable(TABLE_FILTER);
		$FilterObj->where="1";
		
		$FilterObj->AllowPaging =true;
		$FilterObj->PageSize=100;
		$FilterObj->PageTotalDisplay = 15; 
		$FilterObj->PageNo =isset($_GET['PageNo'])?$_GET['PageNo']:1;	
		$this->paging = $FilterObj;
		return $FilterObj->tableSelectAll(array("*"),array("Position ASC","FilterName ASC"));
	
	}
	public function getAllAttrbuteValues($FilterID)
	{
		$FilterValueObj = new DataTable(TABLE_FILTER_VALUE);
		$FilterValueObj->where[] = array('=',array('FilterID' => $FilterID));
		
		return $FilterValueObj->tableSelectAll(array("*"),array("Position ASC","FilterValue ASC"));
	
	}
	public function getAllAttrbuteValuesIDs($FilterID)
	{
		$FilterValueObj = new DataTable(TABLE_FILTER_VALUE);
		$FilterValueObj->where[] = array('=',array('FilterID' => $FilterID));		
		$FilterValueObj->columnExpression = true;
		$Obj  = (object)$FilterValueObj->tableSelectOne(array("GROUP_CONCAT(FilterValueID) as FilterValueIDs"));
		return explode(",",$Obj->FilterValueIDs);
	
	}
	
	public function productCount($FilterID)
	{
		$ProductFilterObj = new DataTable(TABLE_PRODUCT_RELATION);
		$ProductFilterObj->where="Relationtype='Filter' AND RelationID ='".(int)$FilterID."'";
		$ProductFilterObj->columnExpression=true;
		$Obj = $ProductFilterObj->tableSelectOne(array('Total'=>'Count(*)'));
		
		return $Obj['Total'] > 0?$Obj['Total']:0;
	}
	
	public function getDetail($FilterID)
	{
		if($FilterID > 0)
		{
			$FilterObj = new DataTable(array('p'=>TABLE_FILTER));
			$FilterObj->where[] = array('=',array('p.FilterID' => $FilterID));
			return (object)$FilterObj->tableSelectOne();
		
		}
		return ;
	
	}
	
	public function imageFilter($Image)
	{
		if(isset($Image) && $Image !="" && file_exists(DIR_FS_SITE_UPLOADS."filter/".$Image))
			return DIR_FS_SITE_UPLOADS."filter/".$Image;
		
		return false;
	}
	
	public function imageFilterURL($Image)
	{
		if(isset($Image) && $Image !="" && file_exists(DIR_FS_SITE_UPLOADS."filter/".$Image))
			return DIR_WS_SITE_UPLOADS."filter/".$Image;
		
		return false;
	}
	
	public function pageTitle()
	{
		return "Filters";
	}
	
	public function pageRight()
	{
		return '<div class="title_right">
					<div class="pull-right">
						  <a class="btn btn-primary" href="'.DIR_WS_SITE_CONTROL.'index.php?m='.$this->module.'&view=AddEditFilter">Add Filter</a>
					</div>
              </div>		
			   ';
	}
	
	
}	