<?php 
namespace Catalog\Category;
use Frontend\Base\AbstractModule;
use Base\Db\DataTable as DataTable;
use Laminas\Db\Sql\Where;

class Common extends AbstractModule
{
	function __construct()
	{
		
	}
	
	function GetFeaturedCategory($limit=12) 
	{
		$ObjObj = new DataTable(TABLE_CATEGORY);
		$ObjObj->where ="ParentID='0' and Active ='1' and Featured ='1'";
		return $ObjObj->tableSelectAll(array("CategoryID","CategoryName","CategoryTitle","Image"),"Position ASC",$limit);
			
	}
	function GetCategoryHerarcyArray($CategoryID,$PathArr=null) 
	{
		$CategoryObj = new DataTable(TABLE_CATEGORY);
		$CategoryObj->where[] = array('=',array('CategoryID' => $CategoryID));
		$CurrentCategory = $CategoryObj->tableSelectOne(array("ParentID"));
		$ParentID = $CurrentCategory->ParentID;
		if($ParentID =="0")
			return $PathArr;
		else 
		{
			$PathArr[] = $ParentID;
			return GetCategoryHerarcyArray($ParentID,$PathArr);
		}
	}
	function GetCategoryTreeArray($CategoryID,$PathArr=null) 
	{
		$PathArr[] = $CategoryID;
		$CategoryObj = new DataTable(TABLE_CATEGORY);
		
		$CategoryObj->where[] = array('=',array('ParentID' => $CategoryID));
		$CategoryObj->tableSelectAll(array("CategoryID,CategoryName"),"Position");
		while ($CurrentCategory = $CategoryObj->GetObjectFromRecord())
			GetCategoryTreeArray($CurrentCategory->CategoryID,$PathArr);
		return $PathArr;		
	}
	function GetCatLeftNavText($CategoryID,$PathArr,$SubParentID,&$LeftNavText,$Level=0)
	{
		if($Level == 0)
			$LeftNavText = "";
		$CategoryObj = new DataTable(TABLE_CATEGORY);
		$CategoryObj->where ="ParentID ='".$SubParentID."' and Active='1'";
		$CategoryObj->tableSelectAll(array("CategoryID","CategoryName"),"Position ASC");
		if($CategoryObj->GetNumRows() >0)
		{
			if($LeftNavText == "")
				$LeftNavText .= "<ul class='sf-menu sf-vertical flyout$Level'>";
			else 
				$LeftNavText .= "<ul class='flyout$Level'>";
			while ($TempCategory = $CategoryObj->GetObjectFromRecord()) 
			{
				$Space ="";
				//for ($i=1;$i<$Level;$i++)
				//	$Space .= "&nbsp;&nbsp;&nbsp;";
				if($Level == 0)
					$LeftNavText .= "<li><a href='".SKSEOURL('catalog_category','Detail',$TempCategory->CategoryID)."' class='LfLink'>".MyStripSlashes($TempCategory->CategoryName)."</a>";
				else
					$LeftNavText .= "<li><a href='".SKSEOURL('catalog_category','Detail',$TempCategory->CategoryID)."' class='LfLink'>".$Space.MyStripSlashes($TempCategory->CategoryName).(($TempCategory->CategoryID == $CategoryID)?'&nbsp;&raquo;':'')."</a>";
				//if(in_array($TempCategory->CategoryID,$PathArr))
					GetCatLeftNavText($CategoryID,$PathArr,$TempCategory->CategoryID,$LeftNavText,$Level+1);	
				$LeftNavText .= "</li>";				
			}
			$LeftNavText .= "</ul>";
		}
	}
	/*category nav end*/
	/*  Categories Caption start */
	function CategoryChain4Caption($CatID,$LinkPath,$Parm="cID",$LinkClass="",$ActiveOnly=true,$ExtraParm="",$Encoded=true,$Title="",$StartCatID ="")
	{
		$CategoryObj = new DataTable(TABLE_CATEGORY);
		if(!empty($CatID))
		{
			if($StartCatID =="")
			$StartCatID = $CatID;
			$CategoryObj->where = "CategoryID='".(int)$CatID."'";
			$CurrentCategory = (object)$CategoryObj->tableSelectOne(array("CategoryName","ParentID","CategoryID"));
			if(isset($CurrentCategory->CategoryID) && $CurrentCategory->CategoryID !="")
			{
				if(false && $StartCatID == $CurrentCategory->CategoryID)
				{
						if($Parm =="SEOURL")
							$Title="<a class='$LinkClass' href='".SKSEOURL('catalog_category','Detail',$CatID).$ExtraParm."'>".ucwords($CurrentCategory->CategoryName)."</a>".$Title;
						else 
							$Title="<a class='$LinkClass' href='".$LinkPath."?".$Parm."=".($Encoded ? EncodeString($CatID):$CatID).$ExtraParm."'>".ucwords($CurrentCategory->CategoryName)."</a>".$Title;
						
				}
				else 
				{
					if($Parm =="SEOURL")
						$Title="<li><a class='$LinkClass' href='".SKSEOURL('catalog_category','Detail',$CatID).$ExtraParm."'>".ucwords($CurrentCategory->CategoryName)."</a></li>".$Title;
					else 
						 $Title="<a class='$LinkClass' href='".(strstr($LinkPath,'?')?$LinkPath."&":$LinkPath."?").$Parm."=".($Encoded ? EncodeString($CatID):$CatID).$ExtraParm."'>".ucwords($CurrentCategory->CategoryName)."</a>&nbsp;&raquo;&nbsp;".$Title;
				}
				return $this->CategoryChain4Caption($CurrentCategory->ParentID,$LinkPath,$Parm,$LinkClass,$ActiveOnly,$ExtraParm,$Encoded,$Title,$StartCatID);	
			}
			//return $Title;
		}
		else 
		{
			return $Title;
		}
	}
	/*  Categories Caption start */
	/*  Categories Chain start */
	function CategoryChain($ParentID,$CurrentCategoryID=0,$SelectedElementArr=null,$ActiveOnly=false,$Level=0,$hierarchy=0,$DisplayAll=0) 
	{
		$Text = "";
		$LoopIn =0;
		$CategoryObj = new DataTable(TABLE_CATEGORY);
		$CategoryObj->where[] = array('=',array('ParentID' => $ParentID));
		
		if($ActiveOnly)
			$CategoryObj->where[] = array('=',array('Active' => '1'));
				
		$rows = $CategoryObj->tableSelectAll(array("CategoryID","CategoryName"),"Position ASC");
		foreach( $rows as $CurrentCategory)
		{
			if($CurrentCategoryID != $CurrentCategory->CategoryID)
			{
				$Text .=  "<option";
				if($ParentID == 0)
					$Text .= " style='color:#003c6e;background-color:#d5e6f4;'";
				$Text .= " value=".$CurrentCategory->CategoryID.(in_array($CurrentCategory->CategoryID,$SelectedElementArr) ? " selected":"").">";
				for ($i=0;$i<$Level;$i++)
					$Text .= "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
				$Text .= $CurrentCategory->CategoryName."</option>";
				if(($LoopIn >$hierarchy && $LoopIn !=0) OR ($DisplayAll=="1"))
				{
					$Text .= $this->CategoryChain($CurrentCategory->CategoryID,$CurrentCategoryID,$SelectedElementArr,$ActiveOnly,$Level+1,$hierarchy+1,$DisplayAll);     
				}
			}
		}
		return $Text;
	}
	
	
	public function GenerateHTMLSitemapCategoryList($ParentID)
	{
		$Text="";
		$TmpObj = new DataTable(TABLE_CATEGORY);
		$TmpObj->where="Active='1' AND ParentID ='".(int)$ParentID."'";
		$TmpObj->where = $where;
		$rows = $TmpObj->tableSelectAll(array("CategoryID","CategoryName"),"Position ASC");
		 foreach( $rows as $CurrentRecord){
			 
			 $Text .=  '<li>
							<a href="'.SKSEOURL('catalog_category','Detail',$CurrentRecord->CategoryID).'">'.MyStripSlashes($CurrentRecord->CategoryName).'</a>
						</li>';		
			$Text .= $this->GenerateHTMLSitemapCategoryList($CurrentRecord->CategoryID);  		
			
		 }
		 return (string)$Text;
	
	}
	
	public function GenerateHTMLSitemapProductList()
	{
		$Text="";
		$where = new Where();
		$TmpObj = new DataTable(array('p'=>TABLE_PRODUCT));
		$where->notEqualTo('p.ProductType','Child');
		$where->notEqualTo('p.ProductName','');
		$where->in('p.ProductType',array('Simple','Attribute'));
		$where->equalTo('p.Active','1');
		$TmpObj->where = $where;
		$rows = $TmpObj->tableSelectAll(array("ProductID","ProductName"),array("ProductName ASC"));
		 foreach( $rows as $CurrentRecord){
			 
			 		$Text .=  '<li>
							<a href="'.SKSEOURL('catalog_product','Detail',$CurrentRecord->ProductID).'">'.MyStripSlashes($CurrentRecord->ProductName).'</a>
						</li>';	
		 }
		 return (string)$Text;
	
	}
	
	function getCategoryTemplates()
	{
		$rows = array();
		$rows["default.php"] = "Default";
		$rows["subcategory.php"] = "Sub Categories View";
		return $rows;
	}	
	
	function getCatgoriesListByParentID($ReturnArray = array(),$ParentID=0,$GetSubCategory=true,$IsActive=true,$IsTopMenu=false)
	{
		$where = new Where();
		$where->equalTo('ParentID',$ParentID);
		if($IsActive==true)
			$where->equalTo('Active','1');
		if($IsTopMenu==true)
			$where->equalTo('TopMenu','1');
		
		$ObjObj = new DataTable(TABLE_CATEGORY);
		$ObjObj->where = $where;
		//$ObjObj->displayQuery =true;
		$rows = $ObjObj->tableSelectAll(array("CategoryID","CategoryName","ParentID","Image"),"Position ASC");
		
		if(count($rows) > 0){
			foreach( $rows as $current){
				$current =  (array)$current;
				$ReturnArray[$ParentID][$current['CategoryID']] = array("id"=>MyStripSlashes($current['CategoryID']),
																		"parent_id"=>MyStripSlashes($current['ParentID']),
																		"title"=>MyStripSlashes($current['CategoryName']),
																		"href"=>SKSEOURL('catalog_category','Detail',$current['CategoryID']),	
																		"image"=>$current['Image'],	
														 );
				
				if($GetSubCategory == true)										 
					$ReturnArray = $this->getCatgoriesListByParentID($ReturnArray,$current['CategoryID'],$GetSubCategory,$IsActive,$IsTopMenu);
			}
		}
			
		return $ReturnArray;	
		
	}
	function getCompleteCatgoriesList($ParentID=0,$GetSubCategory=true,$IsActive=true,$IsTopMenu=false)
	{
		$ObjObj = new DataTable(TABLE_CATEGORY);
		$ObjObj2 = new DataTable(TABLE_CATEGORY);
		$ObjObj3 = new DataTable(TABLE_CATEGORY);
		$CategoryArray = array();
		$CategoryArray = $this->getCatgoriesListByParentID($CategoryArray,$ParentID,$GetSubCategory,$IsActive,$IsTopMenu);
		return $CategoryArray;
		
	}
   
   
	
	function getCategoryMegaMenuCols()
	{
		$rows = array();
		$rows["3"] = "Default Columns 3";
		$rows["4"] = "Columns 4";
		$rows["6"] = "Columns 6";
		$rows["12"] = "Columns 12";
		return $rows;
	}	
	
	
}	