<?php 
namespace Catalog\Brand\Admin\Controller;
use WebsiteControl\Base\AbstractModule;
use Base\Db\DataTable as DataTable;
use Catalog\Brand\Common as Common;

class IndexController extends AbstractModule
{
	function __construct()
	{
		
	}
	public function getCommon()
	{
		$obj = new Common();
		return $obj;
	}
	
	public function AddEditBrandAction()
	{
		if(count($_POST)>0)
		{
			$BrandObj = new DataTable(TABLE_BRANDS);
			$SeoObj = new DataTable(TABLE_SEO);
			$BrandID = isset($_GET['BrandID'])?$_GET['BrandID']:0;


			$DataArray = array();
			$DataArray['Active'] = isset($_POST['Active'])?$_POST['Active']:0;
			$DataArray['Featured'] = isset($_POST['Featured'])?$_POST['Featured']:0;
			
			$DataArray['BrandName'] = isset($_POST['BrandName'])?$_POST['BrandName']:"";
			
			if(isset($_POST['Template']) && $_POST['Template'] !="")
				$DataArray['Template'] = $_POST['Template'];
			
			$DataArray['Description'] = isset($_POST['Description'])?$_POST['Description']:"";
			$DataArray['FullDescription'] = isset($_POST['FullDescription'])?$_POST['FullDescription']:"";
			$DataArray['UpperBanner1'] = (isset($_POST['UpperBanner1']) && $_POST['UpperBanner1'] !="")?implode(",",$_POST['UpperBanner1']):"";
			 
			/* brand image added*/
			$DataArray['Image'] = $this->getClass("Cms\Pages\Image")->AddEditFile("Upload","catalog_brand",'brand',$DataArray['BrandName']);
			/* brand image end*/
			
			
			
			if($BrandID > 0)
			{
				
				$BrandObj->where[] = array('=',array('BrandID' => $BrandID));
				$BrandObj->tableUpdate($DataArray);
				$this->getSession()->setArrVar("alert",array("success","Brand updated successfully."));
				
			}
			else 
			{
							
				$BrandObj->where ="1";
				$Position = $BrandObj->getMax("Position") + 1;
				
				$DataArray['Position'] = $Position;
				$DataArray['CreatedDate'] =date('Y-m-d H:i:s');
				
				$BrandID = $BrandObj->tableInsert($DataArray);		
				$this->getSession()->setArrVar("alert",array("success","Brand added successfully."));
				
			}
			
			$SeoObj->where = "ReferenceID = ".$BrandID." AND MCode ='catalog_brand' AND MView ='Detail'";
			$CurrentSEO = (object)$SeoObj->tableSelectOne(array("ReferenceID"));
			
			$DataArray = array();
			$URL = 	SkURLCreate((isset($_POST['URLName']) && $_POST['URLName'] !="")?$_POST['URLName']:$_POST['BrandName']);
			$URL = $this->getClass("Cms\Pages\Common")->GetUniqueURL($URL,'catalog_brand','Detail',$BrandID);
			$DataArray['URLName'] = $URL;
			$DataArray['RedirectEnabled'] = isset($_POST['RedirectEnabled'])?$_POST['RedirectEnabled']:0;
			$DataArray['RedirectURL'] = isset($_POST['RedirectURL'])?$_POST['RedirectURL']:"";
			
			if(@constant("DEFINE_SEO_META_ACTIVE") =="1")
			{
				$DataArray['MetaTitle'] = isset($_POST['MetaTitle'])?$_POST['MetaTitle']:"";
				$DataArray['MetaKeyword'] = isset($_POST['MetaKeyword'])?$_POST['MetaKeyword']:"";
				$DataArray['MetaDescription'] = isset($_POST['MetaDescription'])?$_POST['MetaDescription']:"";
			}
			
			if(isset($CurrentSEO->ReferenceID) && $CurrentSEO->ReferenceID !="")
			{
				$SeoObj->tableUpdate($DataArray);
			}
			else 
			{
				$DataArray['MCode'] = "catalog_brand";
				$DataArray['MView'] = "Detail";
				$DataArray['ReferenceID'] = $BrandID;
				$SeoObj->tableInsert($DataArray);
			}
					
			$this->getClass("Base\File\FileHandle")->SKClearPrivateCache();
			
			if(isset($_POST['Continue']))
				MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->origin->m."&view=AddEditBrand&&BrandID=$BrandID");
			else
				MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&");
		    exit;
		}
		
	}
	public function UpdateBrandAction()
	{
		if(count($_POST)>0)
		{
			$BrandObj = new DataTable(TABLE_BRANDS);
			for ($i=1;$i <$_POST['Count'];$i++)
			{
				$BrandID =$_POST['BrandID_'.$i];
				$DataArray = array();
				$DataArray['Active'] = isset($_POST['Active_'.$i])?$_POST['Active_'.$i]:0;
				$DataArray['Featured'] = isset($_POST['Featured_'.$i])?$_POST['Featured_'.$i]:0;
				$DataArray['Position'] = isset($_POST['Position_'.$i])?$_POST['Position_'.$i]:0;
				$BrandObj->where="BrandID ='".(int)$BrandID."'";
				$BrandObj->tableUpdate($DataArray);
				
			}
			
		  	$this->getSession()->setArrVar("alert",array("success","Brand updated successfully."));
			$this->getClass("Base\File\FileHandle")->SKClearPrivateCache();
			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module);
			 exit;
		}
	}
	
	public function DeleteBrandAction()
	{
		$BrandID = isset($_GET['BrandID'])?$_GET['BrandID']:0;
		if($BrandID > 0)
		{
			$Obj = $this->getDetail($BrandID);
			$BrandObj = new DataTable(TABLE_BRANDS);
			$BrandObj->where[] = array('=',array('BrandID' => $BrandID));
			$BrandObj->tableDelete();	

			if(isset($Obj->Image) && $Obj->Image !="")
					$this->getClass("Cms\Pages\Image")->DeleteImage($Obj->Image);
				
			$SeoObj = new DataTable(TABLE_SEO);
			$SeoObj->where = "ReferenceID = ".$BrandID." AND MCode ='catalog_brand' ";
			$SeoObj->tableDelete();	

			$ProductBrandObj = new DataTable(TABLE_PRODUCT_RELATION);
			$ProductBrandObj->where="Relationtype='catalog_brand' AND RelationID ='".(int)$BrandID."'";
			$ProductBrandObj->tableDelete();
			
		}			
		
		$this->getSession()->setArrVar("alert",array("success","Brand deleted successfully."));
		MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module);
		 exit;
	}
	public function getList()
	{
		$BrandObj = new DataTable(TABLE_BRANDS);
		$BrandObj->where="1";
		return $BrandObj->tableSelectAll(array("*"),array("Position ASC","BrandName ASC"));
	
	}
	
	public function productCount($BrandID)
	{
		$ProductBrandObj = new DataTable(TABLE_PRODUCT);
		$ProductBrandObj->where="BrandID ='".(int)$BrandID."'";
		$ProductBrandObj->columnExpression=true;
		$Obj = $ProductBrandObj->tableSelectOne(array('Total'=>'Count(*)'));
		
		return $Obj['Total'] > 0?$Obj['Total']:0;
	}
	
	public function getDetail($BrandID)
	{
		if($BrandID > 0)
		{
			$BrandObj = new DataTable(array('p'=>TABLE_BRANDS));
			$BrandObj->where[] = array('=',array('p.BrandID' => $BrandID));
				
			$BrandObj->joinExpression = true;
			$BrandObj->joinArray[] = array('name'=>array('s'=>TABLE_SEO),
										  'on'=>"(s.ReferenceID = p.BrandID AND s.MCode='catalog_brand')",
										  'columns'=>array("*"),
										  'type'=>"left",
										  );
			return (object)$BrandObj->tableSelectOne();
		
		}
		return ;
	
	}
	
	public function pageTitle()
	{
		return "Brand";
	}
	
	public function pageRight()
	{
		return '<div class="title_right">
					<div class="pull-right">
						  <a class="btn btn-primary" href="'.DIR_WS_SITE_CONTROL.'index.php?m='.$this->module.'&view=AddEditBrand">Add Brand</a>
					</div>
              </div>		
			   ';
	}
	
	
}	