<?php 
namespace Catalog\Attribute;
use Frontend\Base\AbstractModule;
use Base\Db\DataTable as DataTable;
use Base\File\FileHandle as FileHandle;
use Laminas\Db\Sql\Where;

class Common extends AbstractModule 
{
	function __construct()
	{
		
	}
	
	function getAllAttributeIDs($OnlyActive=false,$OnlyIDs=false)
	{
		$ReturnArray = array();
		$where = new Where();
		$AttributeObj = new DataTable(array('p'=>TABLE_ATTRIBUTE));
		if($OnlyActive==true)
			$where->equalTo('p.Active',"1");
		
		$AttributeObj->where = $where;
		$rows = $AttributeObj->tableSelectAll(array("AttributeID","AttributeName"),array("Position ASC","AttributeID ASC"));
		foreach($rows as $CurrentAttribute)
			if($OnlyIDs==true)
				$ReturnArray[] = $CurrentAttribute->AttributeID;
			else
				$ReturnArray[$CurrentAttribute->AttributeID] = $CurrentAttribute->AttributeName;
				
		
		return $ReturnArray;
		
	}
	function getAttributeArrayNames($AttributeIDs=array())
	{
		$ReturnArr = array(); 
		foreach($AttributeIDs as $AttributeID){
			$AttributeObj = new DataTable(array('p'=>TABLE_ATTRIBUTE));
			$AttributeObj->where[] = array('=',array('p.AttributeID' => $AttributeID));
			$CurrentAttribute = (object)$AttributeObj->tableSelectOne(array("AttributeID","AttributeName"));
			if(isset($CurrentAttribute->AttributeID)){
					
					$ReturnArr[$AttributeID] = array('AttributeID'=>MyStripslashes($CurrentAttribute->AttributeID),
													'AttributeName'=>MyStripslashes($CurrentAttribute->AttributeName),
													);
					
					
			}
		
		}
		return $ReturnArr;
	}
	function getAttributeData($AttributeValueID)
	{
		$MainObj = new DataTable(array('m'=>TABLE_ATTRIBUTE_VALUE));
		$MainObj->where[] = array('=',array('m.AttributeValueID' => $AttributeValueID));
		$MainObj->joinExpression = true;
		$MainObj->joinArray[] = array('name'=>array('a'=>TABLE_ATTRIBUTE),
									  'on'=>"(a.AttributeID = m.AttributeID)",
									  'columns'=>array("AttributeName"),
									  'type'=>"left",
									  );
											  
		return (object)$MainObj->tableSelectOne();
		
	}
	function getAttributeArrayWithValues($AttributeIDs=array())
	{
		$dir = FileHandle::CheckPrivateLogDirectory("cache");
		$filename=$dir."ca_att.".md5(serialize($AttributeIDs)).".txt";
		if(file_exists($filename) && d("CACHE_IMPLEMENT")=="1"){
			$ReturnArr =unserialize(file_get_contents($filename));
			return $ReturnArr;
		}
		
		$ReturnArr = array(); 
		foreach($AttributeIDs as $AttributeID){
			$AttributeObj = new DataTable(array('p'=>TABLE_ATTRIBUTE));
			$AttributeObj->where[] = array('=',array('p.AttributeID' => $AttributeID));
			$CurrentAttribute = (object)$AttributeObj->tableSelectOne(array("AttributeID","AttributeName"));
			if(isset($CurrentAttribute->AttributeID)){
					
					$AttributeValueObj = new DataTable(TABLE_ATTRIBUTE_VALUE);
					$AttributeValueObj->where[] = array('=',array('AttributeID' => $AttributeID));		
					$rows = $AttributeValueObj->tableSelectAll(array("AttributeValueID","AttributeValue","AttributeLine"),array("Position ASC","AttributeValue ASC"));
					
					$ReturnArr[$AttributeID] = array('AttributeID'=>MyStripslashes($CurrentAttribute->AttributeID),
													'AttributeName'=>MyStripslashes($CurrentAttribute->AttributeName),
													);
					foreach($rows as $CurrentAttVal){
						
							$ReturnArr[$AttributeID]['Values'][$CurrentAttVal->AttributeValueID] = array('AttributeID'=>$CurrentAttVal->AttributeValueID,
																										 'AttributeValue'=>MyStripslashes($CurrentAttVal->AttributeValue),
																										 'AttributeLine'=>MyStripslashes($CurrentAttVal->AttributeLine),
																										);
				
					}
					
			}
		
		}
		
		$fp2 = fopen($filename, "w");
		fputs($fp2,serialize($ReturnArr));	
		fclose($fp2);
		return $ReturnArr;
	}
	function getProductAttributeWithValues($ProductID, $AttributeIDs=array())
	{
		$ChildIDs = $this->getClass('Catalog\Product\Common')->getProductChildrenIDsActive($ProductID,"array");
		$PrRelObj = new DataTable(array('pr'=>TABLE_PRODUCT_RELATION));
		$where = new Where();
		$where->equalTo('pr.RelationType',"attribute_child");
		$where->in("ProductID",$ChildIDs);
		$PrRelObj->where = $where;
		$PrRelObj->columnExpression = true;
		//$PrRelObj->displayQuery = true;
		$Obj  = (object)$PrRelObj->tableSelectOne(array("GROUP_CONCAT(DISTINCT pr.RelationID) as AttributeValueIDs"));
		$AttributeValueIDs = explode(",",$Obj->AttributeValueIDs);
		
		$ReturnArr = array(); 
		foreach($AttributeIDs as $AttributeID){
			$AttributeObj = new DataTable(array('p'=>TABLE_ATTRIBUTE));
			$AttributeObj->where[] = array('=',array('p.AttributeID' => $AttributeID));
			$CurrentAttribute = (object)$AttributeObj->tableSelectOne(array("AttributeID","AttributeName"));
			if(isset($CurrentAttribute->AttributeID)){
					
					$AttributeValueObj = new DataTable(TABLE_ATTRIBUTE_VALUE);
					$where = new Where();
					$where->equalTo('AttributeID',$AttributeID);
					$where->in("AttributeValueID",$AttributeValueIDs);
					$AttributeValueObj->where = $where;
					//$AttributeValueObj->displayQuery = true;
					$rows = $AttributeValueObj->tableSelectAll(array("AttributeValueID","AttributeValue","AttributeLine","Image"),array("Position ASC","AttributeValue ASC"));
					
					$ReturnArr[$AttributeID] = array('AttributeID'=>MyStripslashes($CurrentAttribute->AttributeID),
													'AttributeName'=>MyStripslashes($CurrentAttribute->AttributeName),
													);
					foreach($rows as $CurrentAttVal){
						
							$ReturnArr[$AttributeID]['Values'][$CurrentAttVal->AttributeValueID] = array('AttributeID'=>$CurrentAttVal->AttributeValueID,
																										 'AttributeValue'=>MyStripslashes($CurrentAttVal->AttributeValue),
																										 'AttributeLine'=>MyStripslashes($CurrentAttVal->AttributeLine),
																										 'Image'=>MyStripslashes($CurrentAttVal->Image),
																										);
				
					}
					
			}
		
		}
		
		return $ReturnArr;
	}
	
	function ConvertAttributeIDs($AttributeIDs,$ReturnType="All",$Sep="|")
	{
		$AttributeIDArr = explode(",",$AttributeIDs);
		$ReturnArr = array();
		if(count($AttributeIDArr) > 0){
			foreach($AttributeIDArr as $AttributeID){
				$AttributeObj = new DataTable(array('p'=>TABLE_ATTRIBUTE));
				$AttributeObj->where[] = array('=',array('p.AttributeID' => $AttributeID));
				$CurrentAttribute = (object)$AttributeObj->tableSelectOne(array("AttributeID","AttributeName"));
				if(isset($CurrentAttribute->AttributeID) && $CurrentAttribute->AttributeName != "")
					$ReturnArr[$CurrentAttribute->AttributeID] = $CurrentAttribute->AttributeName;
			
			}
		}
		
		if(in_array(strtolower($ReturnType),array("name","names")))
			return implode($Sep,array_values($ReturnArr));
		if(in_array(strtolower($ReturnType),array("id","ids")))
			return implode($Sep,array_keys($ReturnArr));
		else 
		  return $ReturnArr;	
	  
		return "";
	}
	
	
	
	function ConvertAttributeNames($AttributeNames,$ReturnType="All",$Sep="|")
	{
		$AttributeNameArr = explode($Sep,$AttributeNames);
		$ReturnArr = array();
		if(count($AttributeNameArr) > 0){
			foreach($AttributeNameArr as $AttributeName){
				$AttributeObj = new DataTable(array('p'=>TABLE_ATTRIBUTE));
				$AttributeObj->where[] = array('=',array('p.AttributeName' => trim($AttributeName)));
				$CurrentAttribute = (object)$AttributeObj->tableSelectOne(array("AttributeID","AttributeName"));
				if(isset($CurrentAttribute->AttributeID) && $CurrentAttribute->AttributeName != "")
					$ReturnArr[$CurrentAttribute->AttributeID] = $CurrentAttribute->AttributeName;
			
			}
		}
		
		if(in_array(strtolower($ReturnType),array("name","names")))
			return implode($Sep,array_values($ReturnArr));
		if(in_array(strtolower($ReturnType),array("id","ids")))
			return implode($Sep,array_keys($ReturnArr));
		else 
		  return $ReturnArr;	
	  
		return "";
	}
	
	function ConvertAttributeValuesIDs($IDs,$Sep="|")
	{
		$dir = FileHandle::CheckPrivateLogDirectory("cache");
		$filename=$dir."co_attval.".md5(serialize($IDs)).".txt";
		if(file_exists($filename) && d("CACHE_IMPLEMENT")=="1"){
			$ReturnArr =unserialize(file_get_contents($filename));
			return implode($Sep,$ReturnArr);
		}
		else{
		
			$IDArr = explode(",",$IDs);
			$ReturnArr = array();
			if(count($IDArr) > 0){
				foreach($IDArr as $AttStr){
					$AttArr = explode("=",$AttStr); 
					if(isset($AttArr[0]) && isset($AttArr[1])){
						$AttributeObj = new DataTable(array('p'=>TABLE_ATTRIBUTE));
						$AttributeObj->where[] = array('=',array('p.AttributeID' => trim($AttArr[0])));
						$CurrentAttribute = (object)$AttributeObj->tableSelectOne(array("AttributeID","AttributeName"));
					
						$AttributeValueObj = new DataTable(array('p'=>TABLE_ATTRIBUTE_VALUE));
						$AttributeValueObj->where[] = array('=',array('p.AttributeValueID' => trim($AttArr[1])));
						$CurrentAttVal = (object)$AttributeValueObj->tableSelectOne(array("AttributeValueID","AttributeValue"));
						if(isset($CurrentAttribute->AttributeName) && isset($CurrentAttVal->AttributeValue))
						$ReturnArr[] = $CurrentAttribute->AttributeName."=".$CurrentAttVal->AttributeValue;
					}
				
				}
			}
			$fp2 = fopen($filename, "w");
			fputs($fp2,serialize($ReturnArr));	
			fclose($fp2);
			
			return implode($Sep,$ReturnArr);
		}
	}
	
	function ConvertAttributeValuesNames($Values,$Sep="|")
	{
		$ValuesArr = explode($Sep,$Values);
		$ReturnArr = array();
		if(count($ValuesArr) > 0){
			foreach($ValuesArr as $AttStr){
				$AttArr = explode("=",$AttStr); 
				
				if(isset($AttArr[0]) && isset($AttArr[1])){
					$AttributeObj = new DataTable(array('p'=>TABLE_ATTRIBUTE));
					$AttributeObj->where[] = array('=',array('p.AttributeName' => trim($AttArr[0])));
					$CurrentAttribute = (object)$AttributeObj->tableSelectOne(array("AttributeID","AttributeName"));
					
					if(isset($CurrentAttribute->AttributeID)){
						$where = new Where();
						$AttributeValueObj = new DataTable(array('p'=>TABLE_ATTRIBUTE_VALUE));
						$where->equalTo('p.AttributeID',$CurrentAttribute->AttributeID);
						$where->NEST//start braket
								->equalTo('p.AttributeValue',trim($AttArr[1]))
								->OR
								->equalTo('p.AttributeLine',trim($AttArr[1]))
							->UNNEST;
		
						$AttributeValueObj->where = $where;
						$CurrentAttVal = (object)$AttributeValueObj->tableSelectOne(array("AttributeValueID","AttributeValue"));
						if(!isset($CurrentAttVal->AttributeValueID) && trim($AttArr[1]) != ""){
							
							$SubDataArray = array();
							$SubDataArray['AttributeValue'] =trim($AttArr[1]);
							$SubDataArray['AttributeLine'] =trim($AttArr[1]);
							$SubDataArray['Active'] = "1"; 
							$SubDataArray['Position'] = "0";  
							$SubDataArray['AttributeID'] =$CurrentAttribute->AttributeID;
							$SubDataArray['CreatedDate'] =date('Y-m-d H:i:s');
							$CurrentAttVal->AttributeValueID = $AttributeValueObj->tableInsert($SubDataArray);
						}
					}
					if(isset($CurrentAttribute->AttributeID) && isset($CurrentAttVal->AttributeValueID))
						$ReturnArr[] = $CurrentAttribute->AttributeID."=".$CurrentAttVal->AttributeValueID;
				}
			
			}
		}
		
		return implode($Sep,$ReturnArr);
		
	}
	
	function getAttributeValueByName($AttributeID,$AttributeValue)
	{
		$ReturnArray = array();
		$where = new Where();
		$Obj = new DataTable(array('p'=>TABLE_ATTRIBUTE_VALUE));
		$where->equalTo('p.AttributeID',$AttributeID);
		$where->equalTo('AttributeValue',$AttributeValue);
		$Obj->where = $where;
		$CurrentAttVal = (object)$Obj->tableSelectOne(array("AttributeValueID"));
		return $CurrentAttVal->AttributeValueID;
		
	}
	
	
}	