<?php 
namespace Blog\Post\Front\Controller;
use Frontend\Base\AbstractModule;
use Base\Db\DataTable as DataTable;
use Blog\Category\Common as CategoryCommon;
use Blog\Post\Common as PostCommon;
use Laminas\Db\Sql\Where;

class SearchController extends AbstractModule
{
	function __construct()
	{
		
	}
	
	public function getCategoryCommon()
	{
		$obj = new CategoryCommon();
		return $obj;
	}
	
	public function getPostCommon()
	{
		$obj = new PostCommon();
		return $obj;
	}
	
	function settings()
	{
		$arr = $this->moduleParam;
		if($arr['code'] && $arr['code'] != "")
		{
			$MainObj = new DataTable(TABLE_SEO);
			$MainObj->where[] = array('=',array('MCode' => $arr['code']));
			$MainObj->where[] = array('=',array('MView' => $arr['view']));
			$obj = (object)$MainObj->tableSelectOne();
			if(isset($obj->URLID))
			{
				$this->origin->setMetaTitle($obj->MetaTitle); 	
				$this->origin->setMetaKeywords($obj->MetaKeyword); 	
				$this->origin->setMetaDescription($obj->MetaDescription); 	
			}
			
			
		}
	}
	
	public function getPostlist()
	{
		$ps = (isset($_GET['ps']) && $_GET['ps'] > 0)?(int)$_GET['ps']:"16";
		$sb = isset($_GET['sb'])?$_GET['sb']:"";
		$Keyword = isset($_REQUEST['k'])?$_REQUEST['k']:"";
		$KeywordArr =  explode(" ",$Keyword);
		$OrderBy = "p.CreatedDate DESC";
		$SortByArray = $this->getSortByArray();
		
		if(isset($SortByArray[$sb]['column']) && $SortByArray[$sb]['column'] != "")
			$OrderBy = $SortByArray[$sb]['column'];

		$where = new Where();
		$PostObj = new DataTable(array('p'=>TABLE_BLOG_POST));
		$where->notEqualTo('p.PostType','Child');
		$where->equalTo('p.Active',"1");
		
		if(count($KeywordArr) > 0)
		{
			foreach ($KeywordArr as $Key=>$Value)
			{
				$where->NEST//start braket
						->like('PostName','%'.$Value.'%')->OR
						->like('PostAuthor','%'.$Value.'%')->OR
						->like('PostLine','%'.$Value.'%')->OR
						->UNNEST;
			}
		}
		$PostObj->where = $where;
	
	
		//$PostObj->displayQuery =true;
		$PostObj->AllowPaging =true;
		if(isset($_GET['ps']) && $_GET['ps']=="ALL")
			$PostObj->AllowPaging =false;
			
		$PostObj->PageSize=$ps;
		$PostObj->PagingPrefix="";
		$PostObj->PageTotalDisplay = 10; 
		$PostObj->PageNo =isset($_GET['PageNo'])?(int)abs($_GET['PageNo']):1;	
		$this->paging = $PostObj;
		$PostObj->orderExpression=true;
		return $PostObj->tableSelectAll(array("*"),$OrderBy);
			 
	}
	
	public function getSortByArray()
	{
		return  array(
					"00"=>array("display"=>"Default","column"=>"p.CreatedDate DESC"),
					"11"=>array("display"=>"Name (A - Z)","column"=>"p.PostName ASC"),
					"12"=>array("display"=>"Name (Z - A)","column"=>"p.PostName DESC"),
					"31"=>array("display"=>"Date (Latest)","column"=>"p.CreatedDate DESC"),
					"32"=>array("display"=>"Date (Oldest)","column"=>"p.CreatedDate ASC"),
					);
	}
	
	function pageTitle()
	{
		echo "Search Results";
	}
	
	
	
}	