<?php 
namespace Blog\Post\Front\Controller;
use Frontend\Base\AbstractModule;
use Base\Db\DataTable as DataTable;
use Blog\Category\Common as CategoryCommon;
use Blog\Post\Common as PostCommon;
use Laminas\Db\Sql\Where;

class LastChanceController extends AbstractModule
{
	function __construct()
	{
		
	}
	
	public function getCategoryCommon()
	{
		$obj = new CategoryCommon();
		return $obj;
	}
	
	public function getPostCommon()
	{
		$obj = new PostCommon();
		return $obj;
	}
	
	function settings()
	{
		$arr = $this->moduleParam;
		if($arr['code'] && $arr['code'] != "")
		{
			$MainObj = new DataTable(TABLE_SEO);
			$MainObj->where[] = array('=',array('MCode' => $arr['code']));
			$MainObj->where[] = array('=',array('MView' => $arr['view']));
			$obj = (object)$MainObj->tableSelectOne();
			if(isset($obj->URLID))
			{
				$this->origin->setMetaTitle($obj->MetaTitle); 	
				$this->origin->setMetaKeywords($obj->MetaKeyword); 	
				$this->origin->setMetaDescription($obj->MetaDescription); 	
			}
			
			
		}
	}
	
	public function getPostlist()
	{
		$OrderBy = "RAND()";
		$where = new Where();
		$PostObj = new DataTable(array('p'=>TABLE_BLOG_POST));
		$where->notEqualTo('p.PostType','Child');
		$where->equalTo('ptc.RelationID','0');
		$where->equalTo('p.Active',"1");
		$PostObj->where = $where;
	
		$PostObj->joinExpression = true;
		$PostObj->joinArray[] = array('name'=>array('ptc'=>TABLE_BLOG_POST_RELATION),
									  'on'=>"(ptc.PostID=p.PostID and ptc.RelationType='last_chance')",
									  'columns'=>array("RelationID","SortOrder"),
									  'type'=>''
									  );
		
		$PostObj->joinExpression = true;
		$PostObj->joinArray[] = array('name'=>array('pr'=>TABLE_BLOG_POST_PRICES),
									  'on'=>"(pr.PostID=p.PostID and pr.QtyMin='0' AND UserTypeID='1')",
									  'columns'=>array("Price","SalePrice","SaleActive"),
									  'type'=>''
									  );
		//$PostObj->displayQuery =true;
		$PostObj->orderExpression =true;
		return $PostObj->tableSelectAll(array("*"),$OrderBy,4);
			 
	}
	
	
	
	function pageTitle()
	{
		echo "Last Chance?";
	}
	
	
	
}	