<?php 
namespace Blog\Post\Front\Controller;
use Frontend\Base\AbstractModule;
use Base\Db\DataTable as DataTable;
use Blog\Category\Common as CategoryCommon;
use Blog\Post\Common as PostCommon;
use Laminas\Db\Sql\Where;

class IndexController extends AbstractModule
{
	function __construct()
	{
		
	}
	
	public function getHeaderCss()
	{
		
		if(is_object($this->currentObj)){
			$obj = $this->currentObj;
			$MetaTag = '
				<meta property="og:url"                content="'.SKSEOURL('blog_post','Detail',$obj->PostID).'" />
				<meta property="og:type"               content="article" />
				<meta property="og:title"              content="'.(isset($obj->PostName)?MyStripSlashes($obj->PostName):"").'" />
				<meta property="og:description"        content="'.(isset($obj->MetaDescription)?MyStripSlashes($obj->MetaDescription):"").'" />
			';
			$ImageFound =false;
			for($i=1;$i<=6;$i++){
				$AreaImage = isset($obj->{"AreaImage".$i})?MyStripSlashes($obj->{"AreaImage".$i}):"";
				if($AreaImage !="" && file_exists(DIR_FS_SITE_UPLOADS."post/".$AreaImage)){
					$MetaTag .= '<meta property="og:image"              content="'.SKImgDisplay(DIR_FS_SITE_UPLOADS."post/".$AreaImage,"600,600,true").'" />';
					$ImageFound =true;
					break;
				}
			}
			
			if($ImageFound ==false && $obj->Image !="" && file_exists(DIR_FS_SITE_UPLOADS."post/".$obj->Image)){
				$MetaTag .= '<meta property="og:image"              content="'.SKImgDisplay(DIR_FS_SITE_UPLOADS."post/".$obj->Image,"600,600,true").'" />';
				$ImageFound =true;
			}
			echo $MetaTag;
		}
	}
	
	public function getFooterJs()
	{
		//SkJsInclude(DIR_WS_SITE."templates/extras/starrating/js/star-rating.min.js");
	}
	
	public function getCategoryCommon()
	{
		$obj = new CategoryCommon();
		return $obj;
	}
	
	
	public function getPostCommon()
	{
		$obj = new PostCommon();
		return $obj;
	}
	
	function settings()
	{
		$arr = $this->moduleParam;
		//var_dump($arr);exit;
		if($arr['ID'] && $arr['ID'] != "")
		{
			$MainObj = new DataTable(array('m'=>TABLE_BLOG_POST));
			$MainObj->where[] = array('=',array('m.PostID' => $arr['ID']));
			$MainObj->where[] = array('=',array('m.Active' => "1"));
			$MainObj->joinExpression = true;
			$MainObj->joinArray[] = array('name'=>array('s'=>TABLE_SEO),
										  'on'=>"(s.ReferenceID = m.PostID AND s.MCode='blog_post')",
										  'columns'=>array("*"),
										  'type'=>"left",
										  );
										  
			$obj = (object)$MainObj->tableSelectOne();
			if(isset($obj->PostID))
			{
					if($obj->Template != ""){
						$this->origin->setView($obj->Template);
					}	
											
					$this->setCurrentObj($obj);
					$this->origin->setMetaTitle($obj->MetaTitle); 	
					$this->origin->setMetaKeywords($obj->MetaKeyword); 	
					$this->origin->setMetaDescription($obj->MetaDescription); 	
			
			
				$this->getMurphysMagicPostStatus($obj);
					
			}
			
		}
	}
	
	function setCurrentObj($obj)
	{
		$this->currentObj = $obj;
	}
	
	public function NotifyMeAction()
	{
		$CurrentPost = $this->getCurrentObj();
		if(isset($CurrentPost->PostID) && $CurrentPost->PostID != ""){
			$this->getClass('Customer\Login\Common')->CheckUserLogin(constant("DEFINE_CURRENT_PAGE_URL"));
			$IsCurrentUser = $this->getClass('Customer\Login\Common')->IsUserLogin();
			
			$PostRelatedObj = new DataTable(TABLE_BLOG_POST_RELATION);
			$PostRelatedObj->where[] = array('=',array('PostID' => $CurrentPost->PostID));
			$PostRelatedObj->where[] = array('=',array('RelationID' => $IsCurrentUser->UserID));
			$PostRelatedObj->where[] = array('=',array('RelationType' => 'post_notify'));
			$Current = (object)$PostRelatedObj->tableSelectOne();
			if(isset($Current->PostID)){
					$DataArray = array();
					$DataArray['Custom'] = "0";
					$PostRelatedObj->tableUpdate($DataArray);
			}
			else{
			
				$DataArray = array();
				$DataArray['PostID'] = $CurrentPost->PostID;
				$DataArray['RelationID'] = $IsCurrentUser->UserID;
				$DataArray['RelationType'] = "post_notify";
				$DataArray['Custom'] = "0";
				$DataArray['SortOrder'] = $this->getClass("Blog\Post\Common")->SKMaxGetRelatedSortOrder($IsCurrentUser->UserID,"post_notify") + 1;
				$PostRelatedObj = new DataTable(TABLE_BLOG_POST_RELATION);
				$PostRelatedObj->tableInsert($DataArray);
			
			}
				
			
			$this->getSession()->setArrVar("alert",array("success","We will notify you once post will be back."));
			MyRedirect(SKSEOURL('blog_post','Detail',$CurrentPost->PostID));
			 exit;
		}
		
		
	}
	public function AddReviewAction()
	{
		if(count($_POST)>0)
		{
			if(empty($_POST['Rating']))
				$this->getSession()->setArrVar("alert",array("danger","Please select your rating"));
			
			$arr = $this->getSession()->getVar("alert");
			if($arr==NULL || count($arr)==0)
			{
				$responseData = $this->getClass('Google\Recaptcha\Recaptcha')->GoogleCaptchaVerificationCheck(d("GOOGLE_CAPTCHA_VERFICATION_SECRET"),@$_POST['g-recaptcha-response']);
				if(isset($responseData->success) && $responseData->success===true)
				{
					
					$PostReviewObj = new DataTable(TABLE_BLOG_POST_REVIEWS);
					$PostID = isset($_GET['ID'])?$_GET['ID']:0;
					$IsCurrentUser = $this->getClass('Customer\Login\Common')->IsUserLogin();
				
					$DataArray = array();
					$DataArray['PostID'] = $PostID;
					$DataArray['Description'] = isset($_POST['Description'])?$_POST['Description']:"";
					$DataArray['Rating'] = (isset($_POST['Rating']) && $_POST['Rating'] > 0)?$_POST['Rating']:"0";
					$DataArray['CName'] = isset($_POST['CName'])?$_POST['CName']:"";
					$DataArray['CEmail'] = isset($_POST['CEmail'])?$_POST['CEmail']:"";
					$DataArray['UserID'] 	= isset($IsCurrentUser->UserID)?$IsCurrentUser->UserID:"";
					$DataArray['Active'] 	= "0";
					$DataArray['CreatedDate'] 	= date('YmdHis');
					$PostReviewObj->tableInsert($DataArray);
					$this->getSession()->setArrVar("alert",array("success","Thank you for your feedback."));
					$this->AllDone = "1";
					
					$CurrentPost = $this->getCurrentObj();
					$Mail_Subject = "A new review has been submitted at ".d('SITE_NAME').":".$CurrentPost->PostName;
					$Mail_ToEmail = d('ADMIN_EMAIL');
					$Mail_FromEmail =isset($_POST['CName'])?$_POST['CName']:d('ADMIN_EMAIL');
					$Mail_FromName = isset($_POST['CEmail'])?$_POST['CEmail']:d('SITE_NAME');
					$MessageBody ="A new review has been submitted at site. ".chr(13).chr(13)."Please check this post at ".d('SITE_NAME').":".$CurrentPost->PostName.chr(13).SKSEOURL('blog_post','Detail',$CurrentPost->PostID).chr(13).chr(13)."Thanks!";
			
					$this->getClass('Cms\Pages\Common')->SendEmail($Mail_Subject,$Mail_ToEmail,$Mail_FromEmail,$Mail_FromName,$MessageBody);;
					
				}
				else
				{
					$this->getSession()->setArrVar("alert",array("danger","Invalid Security Code ! Please try again"));
				}
			}
		}
	}
	
	public function AddQuestionAction()
	{
		if(count($_POST)>0)
		{
			if(empty($_POST['Question']))
				$this->getSession()->setArrVar("alert",array("danger","Please enter Question"));
			
			$arr = $this->getSession()->getVar("alert");
			if($arr==NULL || count($arr)==0)
			{
				$responseData = $this->getClass('Google\Recaptcha\Recaptcha')->GoogleCaptchaVerificationCheck(d("GOOGLE_CAPTCHA_VERFICATION_SECRET"),@$_POST['g-recaptcha-response']);
				if(isset($responseData->success) && $responseData->success===true)
				{
					
					$PostQuestionObj = new DataTable(TABLE_BLOG_POST_QUESTIONS);
					$PostID = isset($_GET['ID'])?$_GET['ID']:0;
					$IsCurrentUser = $this->getClass('Customer\Login\Common')->IsUserLogin();
				
					$DataArray = array();
					$DataArray['PostID'] = $PostID;
					$DataArray['Question'] = isset($_POST['Question'])?$_POST['Question']:"";
					$DataArray['CName'] = isset($_POST['CName'])?$_POST['CName']:"";
					$DataArray['CEmail'] = isset($_POST['CEmail'])?$_POST['CEmail']:"";
					$DataArray['UserID'] 	= isset($IsCurrentUser->UserID)?$IsCurrentUser->UserID:"";
					$DataArray['Active'] 	= "0";
					$DataArray['CreatedDate'] 	= date('YmdHis');
					$PostQuestionObj->tableInsert($DataArray);
					$this->getSession()->setArrVar("alert",array("success","We shall get in touch with you soon."));
					$this->AllDone = "1";
					
					$CurrentPost = $this->getCurrentObj();
					$Mail_Subject = "A new question has been asked at ".d('SITE_NAME').":".$CurrentPost->PostName;
					$Mail_ToEmail = d('ADMIN_EMAIL');
					$Mail_FromEmail =isset($_POST['CName'])?$_POST['CName']:d('ADMIN_EMAIL');
					$Mail_FromName = isset($_POST['CEmail'])?$_POST['CEmail']:d('SITE_NAME');
					$MessageBody ="A new question has been asked at site. ".chr(13).chr(13)."Please check this post at ".d('SITE_NAME').":".$CurrentPost->PostName.chr(13).SKSEOURL('blog_post','Detail',$CurrentPost->PostID).chr(13).chr(13)."Thanks!";
					$this->getClass('Cms\Pages\Common')->SendEmail($Mail_Subject,$Mail_ToEmail,$Mail_FromEmail,$Mail_FromName,$MessageBody);;
					
				}
				else
				{
					$this->getSession()->setArrVar("alert",array("danger","Invalid Security Code ! Please try again"));
				}
			}
		}
	}
	
	public function AddShareFriendAction()
{
	if(count($_POST)>0)
	{
		
		$responseData = $this->getClass('Google\Recaptcha\Recaptcha')->GoogleCaptchaVerificationCheck(d("GOOGLE_CAPTCHA_VERFICATION_SECRET"),@$_POST['g-recaptcha-response']);
		if(isset($responseData->success) && $responseData->success===true)
		{
			
			$CurrentPost = $this->getCurrentObj();
			$this->getSession()->setArrVar("alert",array("success","You have successfully sent email to your friend."));
			$this->AllDone = "1";
			
			$Mail_Subject = "Please check this post at ".d('SITE_NAME').":".$CurrentPost->PostName;
			$Mail_ToEmail = isset($_POST['FEmail'])?$_POST['FEmail']:"";
			
			$Mail_FromEmail =isset($_POST['CName'])?$_POST['CName']:d('ADMIN_EMAIL');
			$Mail_FromName = isset($_POST['CEmail'])?$_POST['CEmail']:d('SITE_NAME');
			$MessageBody =isset($_POST['MessageBody'])?$_POST['MessageBody']:"";
			$this->getClass('Cms\Pages\Common')->SendEmail($Mail_Subject,$Mail_ToEmail,$Mail_FromEmail,$Mail_FromName,$MessageBody);
			
			
		}
		else
		{
			$this->getSession()->setArrVar("alert",array("danger","Invalid Security Code ! Please try again"));
		}
	}
}
	
	public function getPostImages($PostID)
	{
		if($PostID > 0)
		{
			$Obj = new DataTable(TABLE_BLOG_POST_IMAGES);
			$Obj->where[] = array('=',array('PostID' => $PostID));
			$Obj->where[] = array('=',array('Active' => '1'));
			return $Obj->tableSelectAll(array("*"),array("Position ASC","ImageID ASC"));;
		}
		return ;
	
	}
	
	public function getPostRelated($PostID)
	{
		if($PostID > 0)
		{
			$Obj = new DataTable(array('p'=>TABLE_BLOG_POST));
			$Obj->joinExpression = true;
			$Obj->joinArray[] = array('name'=>array('ptc'=>TABLE_BLOG_POST_RELATION),
										  'on'=>"(ptc.RelationID=p.PostID and ptc.RelationType='post_related')",
										  'columns'=>array("id","RelationID","SortOrder"),
										  'type'=>''
										  );
										  
			$Obj->where[] = array('=',array('ptc.PostID' => $PostID));
			$Obj->where[] = array('=',array('p.Active' => '1'));
			return $Obj->tableSelectAll(array("PostName","Image","PostID"),array("SortOrder ASC"));									
			
		}
		return ;
	
	}
	
	
	
	public function getPostReviews($PostID)
	{
		if($PostID > 0)
		{
			$Obj = new DataTable(TABLE_BLOG_POST_REVIEWS);
			$Obj->where[] = array('=',array('PostID' => $PostID));
			$Obj->where[] = array('=',array('Active' => '1'));
			return $Obj->tableSelectAll(array("*"),array("ReviewID DESC"));;
		}
		return ;
	
	}
	
	public function getPostQuestions($PostID)
	{
		if($PostID > 0)
		{
			$Obj = new DataTable(TABLE_BLOG_POST_QUESTIONS);
			$Obj->where[] = array('=',array('PostID' => $PostID));
			$Obj->where[] = array('=',array('Active' => '1'));
			return $Obj->tableSelectAll(array("*"),array("Position ASC","QuestionID ASC"));;
		}
		return ;
	
	}
	
	public function getPostInfos($PostID)
	{
		if($PostID > 0)
		{
			$Obj = new DataTable(TABLE_BLOG_POST_INFO);
			$Obj->where[] = array('=',array('PostID' => $PostID));
			$Obj->where[] = array('=',array('Active' => '1'));
			return $Obj->tableSelectAll(array("*"),array("Position ASC","InfoID ASC"));;
		}
		return ;
	
	}
	
	function getMurphysMagicPostStatus($CurrentPost)
	{
		
			
		/* MurphyScriptStreaming start*/
		if(isset($CurrentPost->UploadType) && $CurrentPost->UploadType == "MurphyScriptStreaming")
		{
			$parameters = array('InternalID' => $CurrentPost->FeedID);
			$obj = $this->getClass('Plugin\MurphysMagic\MMSWebService');
			$return  = $obj->CallRequest("GetDownloadItemByID",$parameters);
			if(isset($obj->ErrorMessages) && $obj->ErrorMessages != "")
			{
				$PostObj = new DataTable(TABLE_BLOG_POST);
				$PostObj->where[] = array('=',array('PostID' => $CurrentPost->PostID));
				$PostObj->where[] = array('=',array('Active' => "1"));
				$PostObj->tableUpdate(array("Active"=>"0"));
				
				$this->getSession()->setArrVar("alert",array("danger",$obj->ErrorMessages));
				MyRedirect(SKSEOURL('cms_pages','Detail',1001));	
				exit;	
			}
			if(isset($return->item->Status) && $return->item->Status != "1")
			{
				$PostObj = new DataTable(TABLE_BLOG_POST);
				$PostObj->where[] = array('=',array('PostID' => $CurrentPost->PostID));
				$PostObj->where[] = array('=',array('Active' => "1"));
				$PostObj->tableUpdate(array("Active"=>"0"));
				
				$this->getSession()->setArrVar("alert",array("danger","Item Not Found."));
				MyRedirect(SKSEOURL('cms_pages','Detail',1001));	
				exit;				
			}
			
			if(isset($return->item->Videos->Video->Filename) && $return->item->Videos->Video->Filename != "" && strpos($return->item->Videos->Video->Filename,".wmv") >0)
			{
				$this->currentObj->YoutubeVideo = $VideoPlay = '<video width="100%" height="auto" controls>
								  <source src="https://www.murphysmagicsupplies.com/video/clips_mp4fs/'.str_replace(".wmv",".mp4",$return->item->Videos->Video->Filename).'" type="video/mp4">
								 Your browser does not support the video tag.
								</video>';
			}
		}
		/* MurphyScriptStreaming end*/
		
		/* MurphyScript start*/
		if(isset($CurrentPost->UploadType) && $CurrentPost->UploadType=="MurphyScript")
		{
			$obj = $this->getClass('Plugin\MurphysMagic\MMSWebService');
			$parameters = array("itemKeys"=>array($CurrentPost->FeedID));
			$return  = $obj->CallRequest("GetInventoryItems",$parameters);
			if(isset($obj->ErrorMessages) && $obj->ErrorMessages != "")
			{
				$PostObj = new DataTable(TABLE_BLOG_POST);
				$PostObj->where[] = array('=',array('PostID' => $CurrentPost->PostID));
				$PostObj->where[] = array('=',array('Active' => "1"));
				$PostObj->tableUpdate(array("Active"=>"0"));
				
				$this->getSession()->setArrVar("alert",array("danger",$obj->ErrorMessages));
				MyRedirect(SKSEOURL('cms_pages','Detail',1001));	
				exit;	
			}
			if(isset($obj->Success) && $obj->Success === true)
			{
				if(isset($return->items->InventoryItem->QuantityAvailable) && $return->items->InventoryItem->QuantityAvailable==0)
				{
					$PostObj = new DataTable(TABLE_BLOG_POST);
					$PostObj->where[] = array('=',array('PostID' => $CurrentPost->PostID));
					$PostObj->where[] = array('=',array('Active' => "1"));
					$PostObj->tableUpdate(array("Active"=>"0"));
					
					$this->getSession()->setArrVar("alert",array("danger","Item Not Found."));
					MyRedirect(SKSEOURL('cms_pages','Detail',1001));	
					exit;
				}
				
			}
			
			/* video link start*/
			if(isset($return->items->InventoryItem->Videos->Video->Filename) && $return->items->InventoryItem->Videos->Video->Filename != "" && strpos($return->items->InventoryItem->Videos->Video->Filename,".wmv") >0)
			{
				$this->currentObj->YoutubeVideo = $VideoPlay = '<video width="100%" height="auto" controls>
								  <source src="https://www.murphysmagicsupplies.com/video/clips_mp4fs/'.str_replace(".wmv",".mp4",$return->items->InventoryItem->Videos->Video->Filename).'" type="video/mp4">
								 Your browser does not support the video tag.
								</video>';
			}
			/* video link end*/
			
		}
		/* MurphyScript end*/
		
	}
	
	
	function pageTitle()
	{
		return isset($this->currentObj->PostName)?MyStripSlashes($this->currentObj->PostName):"";
	}
	function getCurrentObj()
	{
		return $this->currentObj;
	}
	function directFile()
	{
		if(in_array(strtolower($this->view),array("detail")))
			return true;
		else
			return false;
		
	}
	
	
}	