<?php 
namespace Blog\Post;
use Frontend\Base\AbstractModule;
use Base\Db\DataTable as DataTable;
use Base\File\FileHandle as FileHandle;
use Blog\Category\Common as CategoryCommon;
use Blog\Post\Common as PostCommon;
use Laminas\Db\Sql\Where;

class CronController extends AbstractModule
{
	function __construct()
	{
		
	}
	
	
	
	public function getCategoryCommon()
	{
		$obj = new CategoryCommon();
		return $obj;
	}
	
	
	public function getPostCommon()
	{
		$obj = new PostCommon();
		return $obj;
	}
	
	
	public function ImportBTCAction($ScriptTimeLimit,$Obj)
	{
		var_dump($Obj);exit;
		$dir = FileHandle::CheckPrivateLogDirectory("cron");
		$dir = FileHandle::CheckPrivateLogDirectory("cron/murphy");
		$filename=$dir."murphy_".date('Y-m-d').".txt";
		$UniqueID = uniqid("Murphy_");
		
		$fp2 = fopen($filename, "a+");
		fputs($fp2,"======================================================".chr(13));	
		fputs($fp2,"Murphy Start ".$UniqueID."=".date('Y-m-d H:i:s').chr(13));	
	
		
		$sk_timestart = explode(' ', microtime() );
		$sk_timestart = $sk_timestart[1] + $sk_timestart[0];
		
		/* script start here*/	
		if(isset($Obj->CronID) && date('Y-m-d',strtotime($Obj->CronDate))==date('Y-m-d')){
			$Params = (isset($Obj->Params) && $Obj->Params != "")?unserialize(base64_decode($Obj->Params)):array();
			
			
			if(count($Params)==0)
			{
				$Params['Section']="MurphyFile";
				$Params['Action']="Download";
				$Params['StartPoint']="0";				
			}
			$CurrencyValue = $this->getClass('Base\Currency\CurrencyHandler')->GetCurrencyRateFromDB("USD","GBP","1");
			$dir = FileHandle::CheckPrivateLogDirectory("cron");
			$dir = FileHandle::CheckPrivateLogDirectory("cron/murphy");
			$MurphyPostFile=$dir."MurphysPostList.csv";
			
			fputs($fp2,"Params ".$UniqueID."=".print_r($Params,true).chr(13));		
			/* Download MurphyPostFile file start*/
			if($Params['Section']=="MurphyFile" && $Params['Action']=="Download"){
				if(file_exists($MurphyPostFile)==false)
				{
					fputs($fp2,"MurphyFile ".$UniqueID."= START Download MurphysPostList.csv ".chr(13));	
					$this->getClass('Plugin\MurphysMagic\MurphysMagic')->FetchFileFromMurphyServer("ftp://murphysmagic.com/CSV/MurphysPostList.csv",$MurphyPostFile);
					fputs($fp2,"MurphyFile ".$UniqueID."= END Download MurphysPostList.csv ".chr(13));	
				}
				else
				{
					$CronObj = new DataTable(TABLE_MODULE_CRONS);
					$CronObj->where[] = array('=',array('CronID' => $Obj->CronID));
					$Params['Action'] = "Processing";
					$Params['StartPoint']="0";	
					$DataArray = array();
					$DataArray['CronStatus'] = "Processing";
					$DataArray['Params'] = base64_encode(serialize($Params));
					$CronObj->tableUpdate($DataArray);
				}
			}
			/* Download MurphyPostFile file end*/
			
			/* Processing MurphyPostFile file start*/
			if($Params['Section']=="MurphyFile" && $Params['Action']=="Processing"){
				
				if (file_exists($MurphyPostFile)) {
					if (($handle = fopen($MurphyPostFile, "r")) !== FALSE) {
						$csvdata = array();
						while (($data_stream = fgetcsv($handle)) !== FALSE) {
							$csvdata[] = $data_stream;
						}
						fclose($handle);	
						$NumRows = count($csvdata);
						$StartPoint = (isset($Params['StartPoint']) && $Params['StartPoint'] > 0)?$Params['StartPoint']:0;
						
						fputs($fp2,"MurphyPostFile NumRows ".$UniqueID."=".print_r($NumRows,true).chr(13));	
						foreach($csvdata as $csv_k=>$data){
							$num = count($data);
							if($csv_k > 0 && $csv_k >$StartPoint){
							
							 	/* process single data start*/							 	
								$this->MurphyFileNormalData($CurrencyValue,$data);
								/* process single data end*/
								$CronObj = new DataTable(TABLE_MODULE_CRONS);
								$CronObj->where[] = array('=',array('CronID' => $Obj->CronID));
								$Params['StartPoint'] = (int)$csv_k;
								$DataArray = array();
								$DataArray['CronStatus'] = "Processing";
								$DataArray['CronMessage'] = $Params['StartPoint'];
								$DataArray['Params'] = base64_encode(serialize($Params));
								$CronObj->tableUpdate($DataArray);
								//echo "<hr>";
								//var_dump($csv_k);
								//var_dump($Params);
								
								
								$sk_timeend = explode(' ', microtime() );
								$sk_timeend = $sk_timeend[1] + $sk_timeend[0];
								if(number_format($sk_timeend-$sk_timestart) > $ScriptTimeLimit)
									return ;
								
							}
							
						}

						
						if($StartPoint > 0 && ($StartPoint) >= ($NumRows-1))		
						{
							$CronObj = new DataTable(TABLE_MODULE_CRONS);
							$CronObj->where[] = array('=',array('CronID' => $Obj->CronID));
							$Params['Section']="MurphyFileDownload";
							$Params['Action']="Download";
							$Params['StartPoint']="0";		
							$DataArray = array();
							$DataArray['CronStatus'] = "Processing";
							$DataArray['Params'] = base64_encode(serialize($Params));
							$CronObj->tableUpdate($DataArray);
							@rename($MurphyPostFile,str_replace(".csv","-".date("Md-Y-his").".csv",$MurphyPostFile));
						}
						if($NumRows==0)	
						{
							$CronObj = new DataTable(TABLE_MODULE_CRONS);
							$CronObj->where[] = array('=',array('CronID' => $Obj->CronID));
							$Params['Section']="MurphyFile";
							$Params['Action']="Download";
							$Params['StartPoint']="0";		
							$DataArray = array();
							$DataArray['CronStatus'] = "Processing";
							$DataArray['Params'] = base64_encode(serialize($Params));
							$CronObj->tableUpdate($DataArray);
							@unlink($MurphyPostFile);	
						
						}
						
					}		
					
					
				}			
			}
			/* Processing MurphyPostFile file end*/
			
			$MurphyDownloadPostFile=$dir."MurphysDownloadPostsList.csv";
			/* Download MurphyDownloadPostFile file start*/
			if($Params['Section']=="MurphyFileDownload" && $Params['Action']=="Download"){
				if(file_exists($MurphyDownloadPostFile)==false)
				{
					fputs($fp2,"MurphyFile ".$UniqueID."= START Download MurphysDownloadPostsList.csv ".chr(13));	
					
					$this->getClass('Plugin\MurphysMagic\MurphysMagic')->FetchFileFromMurphyServer("ftp://murphysmagic.com/CSV/MurphysDownloadPostsList.csv",$MurphyDownloadPostFile);
					
					fputs($fp2,"MurphyFile ".$UniqueID."= END Download MurphysDownloadPostsList.csv ".chr(13));	
					
				}
				else
				{
					$CronObj = new DataTable(TABLE_MODULE_CRONS);
					$CronObj->where[] = array('=',array('CronID' => $Obj->CronID));
					$Params['Action'] = "Processing";
					$Params['StartPoint']="0";	
					$DataArray = array();
					$DataArray['CronStatus'] = "Processing";
					$DataArray['Params'] = base64_encode(serialize($Params));
					$CronObj->tableUpdate($DataArray);
				}
			}
			/* Download MurphyDownloadPostFile file end*/

			/* Processing MurphyDownloadPostFile file start*/
			if($Params['Section']=="MurphyFileDownload" && $Params['Action']=="Processing"){
				if (file_exists($MurphyDownloadPostFile)) {
					if (($handle = fopen($MurphyDownloadPostFile, "r")) !== FALSE) {
						$csvdata = array();
						while (($data_stream = fgetcsv($handle)) !== FALSE) {
							$csvdata[] = $data_stream;
						}
						fclose($handle);	
						$NumRows = count($csvdata);
						$StartPoint = (isset($Params['StartPoint']) && $Params['StartPoint'] > 0)?$Params['StartPoint']:0;
				
						fputs($fp2,"MurphyDownloadPostFile NumRows ".$UniqueID."=".print_r($NumRows,true).chr(13));	
						foreach($csvdata as $csv_k=>$data){
							$num = count($data);
							if($csv_k > 0 && $csv_k >$StartPoint){
							
								/* process single data start*/							 	
								$this->MurphyFileDownloadData($CurrencyValue,$data);
								/* process single data end*/
								$CronObj = new DataTable(TABLE_MODULE_CRONS);
								$CronObj->where[] = array('=',array('CronID' => $Obj->CronID));
								$Params['StartPoint'] = (int)$csv_k;
								$DataArray = array();
								$DataArray['CronStatus'] = "Processing";
								$DataArray['CronMessage'] = $Params['StartPoint'];
								$DataArray['Params'] = base64_encode(serialize($Params));
								$CronObj->tableUpdate($DataArray);
								//echo "<hr>";
								//var_dump($csv_k);
								//var_dump($Params);
								
								
								$sk_timeend = explode(' ', microtime() );
								$sk_timeend = $sk_timeend[1] + $sk_timeend[0];
								if(number_format($sk_timeend-$sk_timestart) > $ScriptTimeLimit)
									return ;
								
							}
							
						}

						if($StartPoint > 0 && ($StartPoint) >= ($NumRows-1))		
						{
							$CronObj = new DataTable(TABLE_MODULE_CRONS);
							$CronObj->where[] = array('=',array('CronID' => $Obj->CronID));
							$Params['Section']="MurphyFile";
							$Params['Action']="Download";
							$Params['StartPoint']="0";		
							$DataArray = array();
							$DataArray['CronStatus'] = "Processing";
							$DataArray['Params'] = base64_encode(serialize($Params));
							$CronObj->tableUpdate($DataArray);
							@rename($MurphyDownloadPostFile,str_replace(".csv","-".date("Md-Y-his").".csv",$MurphyDownloadPostFile));
						}
						if($NumRows==0)	
						{
							$CronObj = new DataTable(TABLE_MODULE_CRONS);
							$CronObj->where[] = array('=',array('CronID' => $Obj->CronID));
							$Params['Section']="MurphyFileDownload";
							$Params['Action']="Download";
							$Params['StartPoint']="0";		
							$DataArray = array();
							$DataArray['CronStatus'] = "Processing";
							$DataArray['Params'] = base64_encode(serialize($Params));
							$CronObj->tableUpdate($DataArray);
							@unlink($MurphyDownloadPostFile);	
						
						}
						
					}		
					
					
				}			
			}
			/* Processing MurphyDownloadPostFile file end*/
			
		}
		/* script end here*/	
		
		if(isset($Obj->CronID) && strtotime(date('Y-m-d')) > strtotime($Obj->CronDate)){
		
			$CronObj = new DataTable(TABLE_MODULE_CRONS);
			$CronObj->where[] = array('=',array('CronID' => $Obj->CronID));
			$DataArray = array();
			$DataArray['CronDate'] = date('Y-m-d');
			$DataArray['CronStatus'] = "Pending";
			$DataArray['Params'] = "";
			$DataArray['CronMessage'] = "";
			$CronObj->tableUpdate($DataArray);
			
			$dir = FileHandle::CheckPrivateLogDirectory("cron");
			$dir = FileHandle::CheckPrivateLogDirectory("cron/murphy");
			$MurphyPostFile=$dir."MurphysPostList.csv";
			if(file_exists($MurphyPostFile))
				@unlink($MurphyPostFile);	
			
			$MurphyDownloadPostFile=$dir."MurphysDownloadPostsList.csv";
			if(file_exists($MurphyDownloadPostFile))
				@unlink($MurphyDownloadPostFile);	
			
		}

		fputs($fp2,"Murphy End ".$UniqueID." = ".date('Y-m-d H:i:s').chr(13));
		fputs($fp2,"======================================================".chr(13));	
		fclose($fp2);	
			
			
		//http://192.168.0.77/sunil/custom_cms/alakazam/newsite/index.php?m=Blog\Post\Cron&v=Default&action=ImportMurphyMagic
		/*
		$dir = FileHandle::CheckPrivateLogDirectory("cron");
		$filename=$dir."process.txt";
		$fp2 = fopen($filename, "a+");
		while(1){
			fputs($fp2,"ImportMurphyMagicAction=".date('Y-m-d H:i:s').chr(13));	
			
			$sk_timeend = explode(' ', microtime() );
			$sk_timeend = $sk_timeend[1] + $sk_timeend[0];
			if(number_format($sk_timeend-$sk_timestart) > $ScriptTimeLimit)
				return ;
		
		}
		fclose($fp2);
		*/
	}
	
	public function MurphyFileDownloadData($CurrencyValue,$data_stream)
	{
		if(isset($data_stream[0]) && $data_stream[0] != ""){
			
			
			$ManufacturerObj = new DataTable(TABLE_MANUFACTURERS);
			$SeoObj = new DataTable(TABLE_SEO);
			
			/* manufacturer assign start*/
			$ManufacturerObj->where[] = array('=',array('MNName' => $data_stream[9]));
			$CurrentManufacturer = (object)$ManufacturerObj->tableSelectOne(array("MNID"));
			if(isset($CurrentManufacturer->MNID) && $CurrentManufacturer->MNID !="")
			{
				$MNID = $CurrentManufacturer->MNID;
			}
			else 
			{
				$SubDataArray = array();
				$SubDataArray['MNName'] = $data_stream[9];
				$SubDataArray['CreatedDate'] = date('Y-m-d H:i:s');
				$MNID = $ManufacturerObj->tableInsert($SubDataArray);
				
				
				$SeoObj->where = "ReferenceID = ".$MNID." AND MCode ='blog_manufacturer' AND MView ='Detail'";
				$CurrentSEO = (object)$SeoObj->tableSelectOne(array("ReferenceID"));
				
				$MNArray = array();
				$MNArray['URLName'] = str_replace(" ","-",SkURLCreate($SubDataArray['MNName']));
				$MNArray['MetaTitle'] = $SubDataArray['MNName'];
				if(isset($CurrentSEO->ReferenceID) && $CurrentSEO->ReferenceID !="")
				{
					$SeoObj->tableUpdate($MNArray);
				}
				else 
				{
					$MNArray['MCode'] = "blog_manufacturer";
					$MNArray['MView'] = "Detail";
					$MNArray['ReferenceID'] = $MNID;
					$SeoObj->tableInsert($MNArray);
				}
			}
			/* manufacturer assign end*/
			
			if((float)$CurrencyValue >0)
			  $Price = (float)$CurrencyValue * $data_stream[12];
		  
			$DataArray = array();
			$DataArray['FeedID'] = $data_stream[1];
			$DataArray['ModelNo'] = $data_stream[0];
			$DataArray['Stock'] = "0";
			$DataArray['VirtualPost'] = "1";
			$DataArray['Image'] = $data_stream[14];
			$DataArray['Thumbnail'] = $data_stream[15];
			$DataArray['MNID'] = $MNID;		
			
			
			if(d("MURPHY_MAGIC_PRICE_VAT") == "1")
			{
				$DataArray['WithVat'] = "1";
				$DataArray['TaxClass'] = (isset($_POST['TaxClass']) && $_POST['TaxClass'] > 0)?$_POST['TaxClass']:"1";
			
			}
			else
			{
				$DataArray['WithVat'] = "0";
				$DataArray['TaxClass'] = (isset($_POST['TaxClass']) && $_POST['TaxClass'] > 0)?$_POST['TaxClass']:"2";
			
			}
			
			$DataArray['Active'] = "0";
			if($Price > 0)
				$DataArray['Active'] = "1";
			
			
			$DataArray['PostType'] = "Simple";
			
			$DataArray['PostName'] = $data_stream[8];
			$DataArray['LargeDescription'] = $data_stream[3];
			$DataArray['SmallDescription'] = $data_stream[4];
				
			$PostObj = new DataTable(TABLE_BLOG_POST);
			$PostObj->where[] = array('=',array('FeedID' => $DataArray['FeedID']));
			$PostObj->where[] = array('=',array('UploadType' => 'MurphyScriptStreaming'));
			$CurrentPost = (object)$PostObj->tableSelectOne(array("PostID","Image"));
			$NewEntry = false;
			if(isset($CurrentPost->PostID) && $CurrentPost->PostID !="")
			{
				if(isset($CurrentPost->Image) && stristr($CurrentPost->Image,"http") == false)
				{
					$DataArray['Image'] = str_replace("http:","https:",$CurrentPost->Image);
				}
				
				$PostID =$CurrentPost->PostID;
				$PostObj = new DataTable(TABLE_BLOG_POST);
				$PostObj->where[] = array('=',array('PostID' => $PostID));
				$PostObj->tableUpdate($DataArray);
			}
			else 
			{
				/* Extra Fields start*/
				$DataArray['GDiscountOff'] = 0;
				$DataArray['StockStatus'] = 0;
				$DataArray['EndStock'] = 0;
				$DataArray['StockTotal'] = 0;
				$DataArray['WholeSaler'] = 0;
				$DataArray['VIPStatus'] = 0;
				$DataArray['NotForSale'] = 0;
				$DataArray['SignedIn'] = 0;
				$DataArray['IsBundle'] = 0;
				$DataArray['FreeShippingStatus'] = 0;
				$DataArray['DifficultyRating'] = 0;
				$DataArray['GiftVoucherStatus'] = 0;
				
				/* Extra Fields end*/
							  
				$DataArray['UploadType'] = "MurphyScriptStreaming";
				$DataArray['CreatedDate'] = date('Y-m-d');
				
				
				
				$PostObj = new DataTable(TABLE_BLOG_POST);
				$PostID = $PostObj->tableInsert($DataArray);
				$NewEntry = true;
				
				/* SEO START*/
				$SeoObj = new DataTable(TABLE_SEO);
				$SeoObj->where = "ReferenceID = ".$PostID." AND MCode ='blog_post' AND MView ='Detail'";
				$CurrentSEO = (object)$SeoObj->tableSelectOne(array("ReferenceID"));
				
				$SEOArray = array();
				$SEOArray['URLName'] = str_replace(" ","-",SkURLCreate($DataArray['PostName']."-".$DataArray['ModelNo']));
				//$SEOArray['RedirectEnabled'] = isset($_POST['RedirectEnabled'])?$_POST['RedirectEnabled']:0;
				//$SEOArray['RedirectURL'] = isset($_POST['RedirectURL'])?$_POST['RedirectURL']:"";
				
				$SEOArray['MetaTitle'] = @$data_stream[8]." ".@$data_stream[0];
				$SEOArray['MetaKeyword'] = @$data_stream[8].",".@@$data_stream[0].",".@$data_stream[2].",".@$data_stream[9];
				$SEOArray['MetaDescription'] = substr(@$data_stream[4],0,200);
						
				
				
				if(isset($CurrentSEO->ReferenceID) && $CurrentSEO->ReferenceID !="")
				{
					$SeoObj->tableUpdate($SEOArray);
				}
				else 
				{
					$SEOArray['MCode'] = "blog_post";
					$SEOArray['MView'] = "Detail";
					$SEOArray['ReferenceID'] = $PostID;
					$SeoObj->tableInsert($SEOArray);
				}
				/* SEO END*/
				
			}
			
			
			
			/* Additional Images start*/
			if($data_stream[5] !="")
			{
				//SQUISHED_uk-ALT1.jpg|SQUISHED_uk-ALT1-THUMB.jpg,SQUISHED-ALT2.jpg|SQUISHED-ALT2-THUMB.jpg
				$PostImageObj = new DataTable(TABLE_BLOG_POST_IMAGES);
				$PostImageObj->where[] = array('=',array('PostID' => $PostID));
				$PostImageObj->tableDelete();	
				$ImageArray = explode(",",$data_stream[5]);
				foreach ($ImageArray as $k=>$v)
				{
					$TmpImg = explode("|",$v);
					if(isset($TmpImg[0]) && $TmpImg[0] !="")
					{
						$DataSubArray = array();
						$DataSubArray['PostID'] = $PostID;
						$DataSubArray['Image'] = "https://www.murphysmagicsupplies.com/images_alt/".@$TmpImg[0];
						//$DataSubArray['Thumbnail'] = "https://www.murphysmagicsupplies.com/images_alt/".@$TmpImg[1];
						$DataSubArray['Active'] = "1";
						$DataSubArray['Position'] = $k+1;
						$PostImageObj->tableInsert($DataSubArray);	
					}
					
				}
				
			}
			/* Additional Images end*/
			
			/* Additional Video start*/
			if($data_stream[16] !="")
			{
				//DVDAACLASSICACKERMAN-VIDEO1.wmv,DVDAALASVEGASCARD-VIDEO1.wmv,DVDAAPREQUELSEQUEL-VIDEO1.wmv
				$PostInfoObj = new DataTable(TABLE_BLOG_POST_INFO);
				$PostInfoObj->where = "InfoType='WMV' AND PostID='$PostID'";
				$PostInfoObj->tableDelete();	
				$VideoArray = explode(",",$data_stream[16]);
				foreach ($VideoArray as $k=>$v)
				{
					if(isset($v) && $v !="")
					{
						$DataSubArray = array();
						$DataSubArray['PostID'] = $PostID;
						$DataSubArray['Description'] = "https://www.murphysmagicsupplies.com/video/clips/".@$v;
						$DataSubArray['InfoType'] = "WMV";
						$DataSubArray['Active'] = "1";
						$DataSubArray['Position'] = $k+1;
						$PostInfoObj->tableInsert($DataSubArray);	
					}
					
				}
				
			}
			/* Additional Video end*/
			
			/* Category Assign start*/
			$CategoryID = 3;
			if($CategoryID > 0 && $PostID > 0)
			{
				$PostCategoryObj = new DataTable(TABLE_BLOG_POST_RELATION);
				$PostCategoryObj->where = array(array('=',array('RelationType' => 'blog_category')),
												  array('=',array('PostID' => $PostID)),
												  array('=',array('RelationID' => $CategoryID))											  
												  );
				$CurrentObj = (object)$PostCategoryObj->tableSelectOne(array("RelationID"));
				if(!isset($CurrentObj->RelationID))
				{
					$RelationArray = array();
					$RelationArray['PostID'] = $PostID;
					$RelationArray['RelationID'] = $CategoryID;
					$RelationArray['RelationType'] = "blog_category";
					$RelationArray['SortOrder'] = $this->getPostCommon()->SKMaxGetPostSortOrder($CategoryID,"blog_category") + 1;
					$PostCategoryObj->tableInsert($RelationArray);
				}
			}
			/* Category Assign end*/
			
		}
						
	}
	
	public function MurphyFileNormalData($CurrencyValue,$data)
	{
		
		if(isset($data[0]) && $data[0] != "")
		{	
			$ManufacturerObj = new DataTable(TABLE_MANUFACTURERS);
			$SeoObj = new DataTable(TABLE_SEO);
			
			/* manufacturer assign start*/
			$ManufacturerObj->where[] = array('=',array('MNName' => $data[10]));
			$CurrentManufacturer = (object)$ManufacturerObj->tableSelectOne(array("MNID"));
			if(isset($CurrentManufacturer->MNID) && $CurrentManufacturer->MNID !="")
			{
				
				$MNID = $CurrentManufacturer->MNID;
			}
			else 
			{
				$SubDataArray = array();
				$SubDataArray['MNName'] = $data[10];
				$SubDataArray['CreatedDate'] = date('Y-m-d H:i:s');
				$MNID = $ManufacturerObj->tableInsert($SubDataArray);
				
				
				$SeoObj->where = "ReferenceID = ".$MNID." AND MCode ='blog_manufacturer' AND MView ='Detail'";
				$CurrentSEO = (object)$SeoObj->tableSelectOne(array("ReferenceID"));
				
				$MNArray = array();
				$MNArray['URLName'] = str_replace(" ","-",SkURLCreate($SubDataArray['MNName']));
				$MNArray['MetaTitle'] = $SubDataArray['MNName'];
				if(isset($CurrentSEO->ReferenceID) && $CurrentSEO->ReferenceID !="")
				{
					$SeoObj->tableUpdate($MNArray);
				}
				else 
				{
					$MNArray['MCode'] = "blog_manufacturer";
					$MNArray['MView'] = "Detail";
					$MNArray['ReferenceID'] = $MNID;
					$SeoObj->tableInsert($MNArray);
				}
			}
			/* manufacturer assign end*/
			
			$MurphyCategory = $data[8];
			if((float)$CurrencyValue >0)
			  $Price = (float)$CurrencyValue * $data[5];
			
			
			$DataArray = array();
			$DataArray['FeedID'] = $data[0];
			$DataArray['ModelNo'] = $data[2];
			$DataArray['Weight'] = $data[4];
			$DataArray['Stock'] = $data[7];
			$DataArray['Image'] = $data[12];
			$DataArray['Thumbnail'] = $data[13];
			$DataArray['MNID'] = $MNID;	
	
			if(d("MURPHY_MAGIC_PRICE_VAT") == "1")
			{
				$DataArray['WithVat'] = "1";
				$DataArray['TaxClass'] = (isset($_POST['TaxClass']) && $_POST['TaxClass'] > 0)?$_POST['TaxClass']:"1";
			
			}
			else
			{
				$DataArray['WithVat'] = "0";
				$DataArray['TaxClass'] = (isset($_POST['TaxClass']) && $_POST['TaxClass'] > 0)?$_POST['TaxClass']:"2";
			
			}
			
			if(strtolower(trim($MurphyCategory))=="book")
			{
				$DataArray['WithVat'] = "0";
				$DataArray['TaxClass'] = (isset($_POST['TaxClass']) && $_POST['TaxClass'] > 0)?$_POST['TaxClass']:"1";
			
			}
		
			$DataArray['Active'] = "0";
			
			if($Price > 0)
				$DataArray['Active'] = "1";
			
			if($DataArray['Stock'] == 0)
				$DataArray['Active'] = "0";

			
			$DataArray['PostType'] = "Simple";
			$DataArray['PostName'] = $data[3];
			$DataArray['LargeDescription'] = $data[9];
			$DataArray['SmallDescription'] = $DataArray['LargeDescription'];
				
				
			$PostObj = new DataTable(TABLE_BLOG_POST);
			$PostObj->where[] = array('=',array('FeedID' => $DataArray['FeedID']));
			$PostObj->where[] = array('=',array('UploadType' => 'MurphyScript'));
			$CurrentPost = (object)$PostObj->tableSelectOne(array("PostID","Image"));
			$NewEntry = false;
			if(isset($CurrentPost->PostID) && $CurrentPost->PostID !="")
			{
				if(isset($CurrentPost->Image) && stristr($CurrentPost->Image,"http") == false)
				{
					$DataArray['Image'] = str_replace("http:","https:",$CurrentPost->Image);
				}
				
				$PostID =$CurrentPost->PostID;
				$PostObj = new DataTable(TABLE_BLOG_POST);
				$PostObj->where[] = array('=',array('PostID' => $PostID));
				$PostObj->tableUpdate($DataArray);
			}
			else 
			{
				
				/* Extra Fields start*/
				$DataArray['VirtualPost'] = 0;
				$DataArray['StockTotal'] = $data[7];
				
				$DataArray['GDiscountOff'] = 0;
				$DataArray['StockStatus'] = 0;
				$DataArray['EndStock'] = 0;
				$DataArray['WholeSaler'] = 0;
				$DataArray['VIPStatus'] = 0;
				$DataArray['NotForSale'] = 0;
				$DataArray['SignedIn'] = 0;
				$DataArray['IsBundle'] = 0;
				$DataArray['FreeShippingStatus'] = 0;
				$DataArray['DifficultyRating'] = 0;
				$DataArray['GiftVoucherStatus'] = 0;
				
				/* Extra Fields end*/
			
				$DataArray['UploadType'] = "MurphyScript";
				$DataArray['CreatedDate'] = date('Y-m-d');
				
				$PostObj = new DataTable(TABLE_BLOG_POST);
				$PostID = $PostObj->tableInsert($DataArray);
				$NewEntry = true;
				
				/* SEO START*/
				$SeoObj = new DataTable(TABLE_SEO);
				$SeoObj->where = "ReferenceID = ".$PostID." AND MCode ='blog_post' AND MView ='Detail'";
				$CurrentSEO = (object)$SeoObj->tableSelectOne(array("ReferenceID"));
				
				$SEOArray = array();
				$SEOArray['URLName'] = str_replace(" ","-",SkURLCreate($DataArray['PostName']."-".$DataArray['ModelNo']));
				//$SEOArray['RedirectEnabled'] = isset($_POST['RedirectEnabled'])?$_POST['RedirectEnabled']:0;
				//$SEOArray['RedirectURL'] = isset($_POST['RedirectURL'])?$_POST['RedirectURL']:"";
				
				$SEOArray['MetaTitle'] = @$data[3]." ".@$data[2];
				$SEOArray['MetaKeyword'] = @$data[3].",".@$data[2].",".@$data[8].",".@$data[10].",".@$data[11];
				$SEOArray['MetaDescription'] = substr(strip_tags(@$data[9]),0,200);
				
				
				if(isset($CurrentSEO->ReferenceID) && $CurrentSEO->ReferenceID !="")
				{
					$SeoObj->tableUpdate($SEOArray);
				}
				else 
				{
					$SEOArray['MCode'] = "blog_post";
					$SEOArray['MView'] = "Detail";
					$SEOArray['ReferenceID'] = $PostID;
					$SeoObj->tableInsert($SEOArray);
				}
				/* SEO END*/
				
			}
			
			/* PostPrice entry start*/
			if((float)$CurrencyValue >0)
			{
				$PostPriceObj =new DataTable(TABLE_BLOG_POST_PRICES);
				$PostPriceObj->where = "PostID = ".$PostID." AND 
										   UserTypeID ='".(int)(isset($DefaultUserType->UserTypeID)?$DefaultUserType->UserTypeID:"1")."' AND 
										   QtyMin='0'";
				$CurrentPrice = (object)$PostPriceObj->tableSelectOne(array("PostPriceID"));
				$PriceArray = array();
				$PriceArray['Price'] = (float)$CurrencyValue * $data[5];
				
				if(d("MURPHY_MAGIC_PRICE_PERCENT") > 0)
					$PriceArray['Price'] = $PriceArray['Price'] + ($PriceArray['Price']*d("MURPHY_MAGIC_PRICE_PERCENT")/100);
					
				//$PriceArray['SalePrice'] = (isset($_POST['SalePrice']) && $_POST['SalePrice'] !="")?$_POST['SalePrice']:"0";
				//$PriceArray['SaleActive'] = isset($_POST['SaleActive'])?$_POST['SaleActive']:0;
				if(isset($CurrentPrice->PostPriceID) && $CurrentPrice->PostPriceID !="")
				{
					$PostPriceObj->tableUpdate($PriceArray);
				}
				else 
				{
					$PriceArray['QtyMin'] = "0";
					$PriceArray['QtyMax'] = d("DEFINE_PRODUCT_QTY_MAX");
					$PriceArray['PriceType'] = 'Unit';
					$PriceArray['UserTypeID'] = isset($DefaultUserType->UserTypeID)?$DefaultUserType->UserTypeID:"1";
					$PriceArray['PostID'] = $PostID;
					$PostPriceObj->tableInsert($PriceArray);
				}
			}
			/* PostPrice entry end*/
			
			/* Additional Images start*/
			if($data[41] !="")
			{
				//SQUISHED_uk-ALT1.jpg|SQUISHED_uk-ALT1-THUMB.jpg,SQUISHED-ALT2.jpg|SQUISHED-ALT2-THUMB.jpg
				$PostImageObj = new DataTable(TABLE_BLOG_POST_IMAGES);
				$PostImageObj->where[] = array('=',array('PostID' => $PostID));
				$PostImageObj->tableDelete();	
				$ImageArray = explode(",",$data[41]);
				foreach ($ImageArray as $k=>$v)
				{
					$TmpImg = explode("|",$v);
					if(isset($TmpImg[0]) && $TmpImg[0] !="")
					{
						$DataSubArray = array();
						$DataSubArray['PostID'] = $PostID;
						$DataSubArray['Image'] = "https://www.murphysmagicsupplies.com/images_alt/".@$TmpImg[0];
						//$DataSubArray['Thumbnail'] = "https://www.murphysmagicsupplies.com/images_alt/".@$TmpImg[1];
						$DataSubArray['Active'] = "1";
						$DataSubArray['Position'] = $k+1;
						$PostImageObj->tableInsert($DataSubArray);	
					}
					
				}
				
			}
			/* Additional Images end*/
			
			/* Additional Video start*/
			if($data[40] !="")
			{
				//DVDAACLASSICACKERMAN-VIDEO1.wmv,DVDAALASVEGASCARD-VIDEO1.wmv,DVDAAPREQUELSEQUEL-VIDEO1.wmv
				$PostInfoObj = new DataTable(TABLE_BLOG_POST_INFO);
				$PostInfoObj->where = "InfoType='WMV' AND PostID='$PostID'";
				$PostInfoObj->tableDelete();	
				$VideoArray = explode(",",$data[40]);
				foreach ($VideoArray as $k=>$v)
				{
					if(isset($v) && $v !="")
					{
						$DataSubArray = array();
						$DataSubArray['PostID'] = $PostID;
						$DataSubArray['Description'] = "https://www.murphysmagicsupplies.com/video/clips/".@$v;
						$DataSubArray['InfoType'] = "WMV";
						$DataSubArray['Active'] = "1";
						$DataSubArray['Position'] = $k+1;
						$PostInfoObj->tableInsert($DataSubArray);	
					}
					
				}
				
			}
			/* Additional Video end*/
			
			if($MurphyCategory != "")
				$this->AssignMurphyCategory($PostID,$MurphyCategory);
		
		}
		
	}
	
	public function AssignMurphyCategory($PostID,$CategoryName)
	{
		$CategoryObj = new DataTable(TABLE_BLOG_CATEGORY);
		$ParentID = 2;
		
		$where = new Where();
		$where->NEST//start braket
				->equalTo('CategoryName',$CategoryName)
				->OR
				->equalTo('CategoryName',$CategoryName."s")
				->UNNEST;
		$where->equalTo('ParentID',$ParentID);
		
		$CategoryObj->where = $where;
		$CurrentCategory = (object)$CategoryObj->tableSelectOne(array("CategoryID"));
		$CategoryID = isset($CurrentCategory->CategoryID)?$CurrentCategory->CategoryID:0;

		
		if(!isset($CurrentCategory->CategoryID))
		{
				$DataArray = array();
				$DataArray['CategoryName']= $CategoryName;
				$DataArray['CategoryLine']= $CategoryName;
				$DataArray['Description'] = "";
				$DataArray['ParentID'] =$ParentID;
				$DataArray['Active'] = "1";
				$DataArray['Featured'] = 0;
				
				$CategoryObj = new DataTable(TABLE_BLOG_CATEGORY);
				$CategoryObj->where ="ParentID='".$ParentID."'";
				$Position = $CategoryObj->getMax("Position") + 1;
				
				$DataArray['Position'] = $Position;
				$DataArray['CreatedDate'] =date('Y-m-d H:i:s');
				
				$CategoryID = $CategoryObj->tableInsert($DataArray);	
				
				/* SEO Start */
				$SeoObj = new DataTable(TABLE_SEO);
				$SeoObj->where = "ReferenceID = ".$CategoryID." AND MCode ='blog_category' AND MView ='Detail'";
				$CurrentSEO = (object)$SeoObj->tableSelectOne(array("ReferenceID"));
				
				$SEOArray = array();
				$SEOArray['URLName'] = str_replace(" ","-",SkURLCreate("murphy-magic-".$CategoryName));
				//$SEOArray['RedirectEnabled'] = isset($_POST['RedirectEnabled'])?$_POST['RedirectEnabled']:0;
				//$SEOArray['RedirectURL'] = isset($_POST['RedirectURL'])?$_POST['RedirectURL']:"";
				
				$SEOArray['MetaTitle'] = $CategoryName;
				$SEOArray['MetaKeyword'] = "";
				$SEOArray['MetaDescription'] = "";
				
				if(isset($CurrentSEO->ReferenceID) && $CurrentSEO->ReferenceID !="")
				{
					$SeoObj->tableUpdate($SEOArray);
				}
				else 
				{
					$SEOArray['MCode'] = "blog_category";
					$SEOArray['MView'] = "Detail";
					$SEOArray['ReferenceID'] = $CategoryID;
					$SeoObj->tableInsert($SEOArray);
				}
				/* SEO END */
				
		}
		
		
		if($CategoryID > 0 && $PostID > 0)
		{
			$PostCategoryObj = new DataTable(TABLE_BLOG_POST_RELATION);
			$PostCategoryObj->where = array(array('=',array('RelationType' => 'blog_category')),
											  array('=',array('PostID' => $PostID)),
											  array('=',array('RelationID' => $CategoryID))											  
											  );
			$CurrentObj = (object)$PostCategoryObj->tableSelectOne(array("RelationID"));
			if(!isset($CurrentObj->RelationID))
			{
				$RelationArray = array();
				$RelationArray['PostID'] = $PostID;
				$RelationArray['RelationID'] = $CategoryID;
				$RelationArray['RelationType'] = "blog_category";
				$RelationArray['SortOrder'] = $this->getPostCommon()->SKMaxGetPostSortOrder($CategoryID,"blog_category") + 1;
				$PostCategoryObj->tableInsert($RelationArray);
			}
		}
		
	}
	
	public function CronPostStockNotifyAction($ScriptTimeLimit,$Obj)
	{
		$dir = FileHandle::CheckPrivateLogDirectory("cron");
		$dir = FileHandle::CheckPrivateLogDirectory("cron/post_notify");
		$filename=$dir."notify_".date('Y-m-d').".txt";
		$UniqueID = uniqid("Notify_");
		
		$fp2 = fopen($filename, "a+");
		fputs($fp2,"======================================================".chr(13));	
		fputs($fp2,"Notify Start ".$UniqueID."=".date('Y-m-d H:i:s').chr(13));	
	
		
		$sk_timestart = explode(' ', microtime() );
		$sk_timestart = $sk_timestart[1] + $sk_timestart[0];
		
		/* script start here*/	
		if(isset($Obj->CronID) && date('Y-m-d',strtotime($Obj->CronDate))==date('Y-m-d')){
			$Params = (isset($Obj->Params) && $Obj->Params != "")?unserialize(base64_decode($Obj->Params)):array();
			
			fputs($fp2,"Params ".$UniqueID."=".print_r($Params,true).chr(13));		
			if(count($Params)==0)
			{
				$Params['Action']="Processing";
				$Params['Offset']="0";				
			}
			
			$where = new Where();
			$PostObj = new DataTable(array('p'=>TABLE_BLOG_POST));
			
			$where->notEqualTo('p.PostType','Child');
			$where->equalTo('p.Active',"1");
			$where->equalTo('ptc.RelationType','post_notify');
			$where->equalTo('ptc.Custom','0');
			$where->greaterThan('p.Stock','0');
			
			$PostObj->joinExpression = true;
			$PostObj->joinArray[] = array('name'=>array('ptc'=>TABLE_BLOG_POST_RELATION),
									  'on'=>"(ptc.PostID=p.PostID and ptc.RelationType='post_notify')",
									  'columns'=>array("*"),
									  'type'=>''
									  );
									  
			
			$PostObj->where = $where;
			
			if(isset($Params['Offset']) && $Params['Offset'] > 0)
				$PostObj->offset = (int)$Params['Offset'];
			
			//$PostObj->displayQuery = true;
			$rows = $PostObj->tableSelectAll(array("PostID","PostName"),array("ptc.id ASC"));
			$SNo =$Params['Offset'];
			/* for loope start here */
			foreach ($rows as $CurrentPost){
				
				$CurrentUser = $this->getClass('Customer\Login\Common')->getUserByUserID($CurrentPost->RelationID);
				if(isset($CurrentUser->UserID)){
					$Arr = array();
					$Arr['Name'] = $CurrentUser->FirstName." ".$CurrentUser->LastName;
					$Arr['PostID'] = $CurrentPost->PostID;
					$Arr['PostName'] = $CurrentPost->PostName;
					fputs($fp2,"Notify Arr ".$UniqueID."=".print_r($Arr,true).chr(13));	
					
					$MessageBody = $this->getNotifyEmail($Arr);
					$Mail_Subject = $CurrentPost->PostName.": Your favorite post is back at ".d("SITE_NAME");
					$Mail_ToEmail = $CurrentUser->Email;
					$this->getClass('Cms\Pages\Common')->SendEmail($Mail_Subject,$Mail_ToEmail,d('ADMIN_EMAIL'),d('SITE_NAME'),$MessageBody);
				}
				
				$PostRelatedObj = new DataTable(TABLE_BLOG_POST_RELATION);
				$PostRelatedObj->where[] = array('=',array('PostID' => $CurrentPost->PostID));
				$PostRelatedObj->where[] = array('=',array('RelationID' => $CurrentPost->RelationID));
				$PostRelatedObj->where[] = array('=',array('RelationType' => 'post_notify'));
				$Current = (object)$PostRelatedObj->tableSelectOne();
				if(isset($Current->PostID)){
						$DataArray = array();
						$DataArray['Custom'] = "1";
						$PostRelatedObj->tableUpdate($DataArray);
				}
				
				$SNo++;
				$CronObj = new DataTable(TABLE_MODULE_CRONS);
				$CronObj->where[] = array('=',array('CronID' => $Obj->CronID));
				$Params['Offset'] = $SNo;
				$DataArray = array();
				$DataArray['CronStatus'] = "Processing";
				$DataArray['Params'] = base64_encode(serialize($Params));
				$CronObj->tableUpdate($DataArray);
				
				$sk_timeend = explode(' ', microtime() );
				$sk_timeend = $sk_timeend[1] + $sk_timeend[0];
				if(number_format($sk_timeend-$sk_timestart) > $ScriptTimeLimit)
					return ;
				
			}
			/* for loope end here */
			
			/* Increase date for next start*/
			$CronObj = new DataTable(TABLE_MODULE_CRONS);
			$CronObj->where[] = array('=',array('CronID' => $Obj->CronID));
			$DataArray = array();
			$DataArray['CronDate'] = date('Y-m-d',strtotime("+1 day"));
			$DataArray['CronStatus'] = "Pending";
			$DataArray['Params'] = "";
			$CronObj->tableUpdate($DataArray);
			/* Increase date for next end*/
			
			
		}
		/* script end here*/
		
		if(isset($Obj->CronID) && strtotime(date('Y-m-d')) > strtotime($Obj->CronDate)){
		
			$CronObj = new DataTable(TABLE_MODULE_CRONS);
			$CronObj->where[] = array('=',array('CronID' => $Obj->CronID));
			$DataArray = array();
			$DataArray['CronDate'] = date('Y-m-d');
			$DataArray['CronStatus'] = "Pending";
			$DataArray['Params'] = "";
			$DataArray['CronMessage'] = "";
			$CronObj->tableUpdate($DataArray);
			
		}

		fputs($fp2,"Notify End ".$UniqueID." = ".date('Y-m-d H:i:s').chr(13));
		fputs($fp2,"======================================================".chr(13));	
		fclose($fp2);	
			
		//http://192.168.0.77/sunil/custom_cms/alakazam/newsite/index.php?m=Blog\Post\Cron&v=Default&action=CronOrderNotify	
		
	}
	
	function getNotifyEmail($Arr)
	{
		if(file_exists(DIR_FS_SITE."templates/emails/post_notify.php")){
			@ob_start();	
			include(DIR_FS_SITE."templates/emails/post_notify.php");
			$MessageBody = ob_get_clean();
			return $MessageBody;
		}
		return false;
		
	}
	
	public function TestFunction($ScriptTimeLimit,$Obj)
	{
		$sk_timestart = explode(' ', microtime() );
		$sk_timestart = $sk_timestart[1] + $sk_timestart[0];
		
		var_dump("TestFunction"); return; 
		$dir = FileHandle::CheckPrivateLogDirectory("cron");
		$filename=$dir."process.txt";
		$fp2 = fopen($filename, "a+");
		while(1){
			fputs($fp2,"TestFunction=".date('Y-m-d H:i:s').chr(13));	
			$sk_timeend = explode(' ', microtime() );
			$sk_timeend = $sk_timeend[1] + $sk_timeend[0];
			if(number_format($sk_timeend-$sk_timestart) > $ScriptTimeLimit)
				return ;
		}
		fclose($fp2);
	}
}	