<?php 
namespace Blog\Post;
use Frontend\Base\AbstractModule;
use Base\Db\DataTable as DataTable;
use Base\Currency\CurrencyHandler as CurrencyHandler;
use Base\File\FileHandle as FileHandle;
use Laminas\Db\Sql\Where;

class Common extends AbstractModule 
{
	function __construct()
	{
		
	}
	
	function SKMaxGetPostSortOrder($RelationID,$RelationType='blog_category')
	{
		$SortOrder = 0;
		$PostRelationObj = new DataTable(TABLE_BLOG_POST_RELATION);
		$PostRelationObj->where = array(array('=',array('RelationType' => $RelationType)),
												  array('=',array('RelationID' => $RelationID))											  
												  );
		
		$SortOrder = $PostRelationObj->getMax("SortOrder");
		return $SortOrder;
	}
	
	public function getPostlistByCategoryID($CategoryID,$Limit)
	{
		$OrderBy = "ptc.SortOrder ASC,p.CreatedDate DESC";
		
		$where = new Where();
		$PostObj = new DataTable(array('p'=>TABLE_BLOG_POST));
		$where->notEqualTo('p.PostType','Child');
		$where->equalTo('ptc.RelationID',$CategoryID);
		$where->equalTo('p.Active',"1");
		$PostObj->where = $where;
	
		$PostObj->joinExpression = true;
		$PostObj->joinArray[] = array('name'=>array('ptc'=>TABLE_BLOG_POST_RELATION),
									  'on'=>"(ptc.PostID=p.PostID and ptc.RelationType='blog_category')",
									  'columns'=>array("RelationID","SortOrder"),
									  'type'=>''
									  );
		//$PostObj->displayQuery =true;
		$PostObj->orderExpression=true;
		return $PostObj->tableSelectAll(array("*"),$OrderBy,$Limit);
			 
	}
	
	function SKMaxGetRelatedSortOrder($PostID,$RelationType='post_related')
	{
		$SortOrder = 0;
		$PostRelationObj = new DataTable(TABLE_BLOG_POST_RELATION);
		$PostRelationObj->where = array(array('=',array('RelationType' => $RelationType)),
												  array('=',array('PostID' => $PostID))											  
												  );
		
		$SortOrder = $PostRelationObj->getMax("SortOrder");
		return $SortOrder;
	}
	
	
	
	function SKDisplayPrdInfo($CurrentInfo)
	{
		global $MobileDetectObj;
		$Return = '';
		if(isset($CurrentInfo->InfoType) && $CurrentInfo->InfoType !="")
		{
			$Return .= '<div id="Div_Info_'.$CurrentInfo->InfoID.'" title="'.$CurrentInfo->TabTitle.'" class="Bn_dis">';
			switch ($CurrentInfo->InfoType)
			{
				case "WMV":
				 if ($CurrentInfo->Description !="" && stristr($CurrentInfo->Description,"http"))
				 {
					if(stristr($CurrentInfo->Description,"murphysmagicsupplies"))
					 $VideoURL =str_replace(array("/clips/",".wmv"),array("/clips_mp4fs/",".mp4"),$CurrentInfo->Description);
					 else
						 $VideoURL =$CurrentInfo->Description;
				 }
				 else
				 {					 
					$VideoURL =DIR_WS_SITE_DEMO_VIDEO.MyStripSlashes($CurrentInfo->Description);
				 }
				  
				  $ArrayType = explode(".",$VideoURL);
				  $Type=$ArrayType[count($ArrayType)-1];
				  
				//echo $VideoURL;
				switch(strtolower($Type))
				{
					case "mp4":
						$Return .= '<div align="center" class="embed-responsive embed-responsive-16by9">
										<video class="embed-responsive-item" controls>
											<source src="'.$VideoURL.'" type="video/mp4">
										</video>
									</div>';
					break;
					case "wmv":
					/*
					$Return .= '<video width="400" height="300" controls>
								  <source src="'.$VideoURL.'" type="video/wmv">
								</video>';
					*/			
					$Return .= '<object width="400" height="300" codebase="http://www.microsoft.com/Windows/Downloads/Contents/MediaPlayer/" classid="CLSID:6BF52A52-394A-11D3-B153-00C04F79FAA6" selthis="selThis">
						<param name="URL" value="'.$VideoURL.'" />
						<param name="autoStart" value="false" />
						<param name="uiMode" value="full" />
						<param name="playCount" value="32767" />
						<embed type="application/x-mplayer2" pluginspage="http://www.microsoft.com/Windows/Downloads/Contents/MediaPlayer/" src="'.$VideoURL.'" filename="<?php echo $VideoURL?>" autostart="0" showcontrols="1" showstatusbar="0" showdisplay="0" autorewind="1" height="300" width="400">
					</object>';
					break;
					
				}
					
				  
				break;
				case "HTML":
				default:
					 $Return .= MyStripSlashes($CurrentInfo->Description);
				break;
				
			}
			$Return .= '</div>';
		}
		return $Return;
	}
	
	
	
	public function getCategoryNames($PostID,$Active="ALL")
	{
		if($PostID > 0)
		{
		
			$Obj = new DataTable(array("c"=>TABLE_BLOG_CATEGORY));
			$Obj->joinExpression = true;
			$Obj->joinArray[] = array('name'=>array('ptc'=>TABLE_BLOG_POST_RELATION),
								  'on'=>"(c.CategoryID=ptc.RelationID and ptc.RelationType='blog_category')",
								  'columns'=>array("RelationID","SortOrder"),
								  'type'=>''
								  );
										  
			$Obj->where[] = array('=',array('ptc.PostID' => $PostID));
			$Obj->groupBy = array("c.CategoryID");
			$Obj->columnExpression=true;
			$Cobj = (object)$Obj->tableSelectOne(array("GROUP_CONCAT(DISTINCT CategoryName ORDER BY CategoryName ASC SEPARATOR ', ') as CategoryNames"));
			return isset($Cobj->CategoryNames)?$Cobj->CategoryNames:"";
		}
		return ;
	
	}
	public function getCategoriesByBlogIDs($PostID,$Active="ALL")
	{
		if($PostID > 0)
		{
		
			$PostCatgoryArr = array();
			$Obj = new DataTable(array("c"=>TABLE_BLOG_CATEGORY));
			$Obj->joinExpression = true;
			$Obj->joinArray[] = array('name'=>array('ptc'=>TABLE_BLOG_POST_RELATION),
								  'on'=>"(c.CategoryID=ptc.RelationID and ptc.RelationType='blog_category')",
								  'columns'=>array("RelationID","SortOrder"),
								  'type'=>''
								  );
										  
			$Obj->where[] = array('=',array('ptc.PostID' => $PostID));
			$categoryRows = $Obj->tableSelectAll();			
			foreach($categoryRows as $CategoryTmp)
			{
				$PostCatgoryArr[$CategoryTmp->CategoryID] = MyStripSlashes($CategoryTmp->CategoryName);
				
			}
			return $PostCatgoryArr;
		}
		return array();
	
	}
	
	
	
	
	function getBlogTemplate($file,$ControllerObj = "")
	{
		if(!is_object($ControllerObj))
			$ControllerObj = new \Blog\Post\Front\Controller\IndexController;
		
		if(file_exists(dirname(__FILE__)."/Front/View/templates/".basename($file).".php"))
			include(dirname(__FILE__)."/Front/View/templates/".basename($file).".php");
		else
			include(dirname(__FILE__)."/Front/View/templates/default.php");
		
			
	}
	
	function getPostData($CurrentPost,$file="default",$ControllerObj = "")
	{
		if(isset($CurrentPost->PostID))
		{
			if(!is_object($ControllerObj))
				$ControllerObj = new \Blog\Post\Front\Controller\IndexController;
			
			if(file_exists(dirname(__FILE__)."/Front/View/templates/".basename($file).".php"))
				include(dirname(__FILE__)."/Front/View/templates/".basename($file).".php");
			else
				include(dirname(__FILE__)."/Front/View/templates/default.php");
		}
			
	}

	function getPostContentArea($i, $CurrentPost,$file="post-content",$ControllerObj = "")
	{
		if(isset($CurrentPost->PostID))
		{
			if(!is_object($ControllerObj))
				$ControllerObj = new \Blog\Post\Front\Controller\IndexController;
			
			if(file_exists(dirname(__FILE__)."/Front/View/templates/".basename($file).".php"))
				include(dirname(__FILE__)."/Front/View/templates/".basename($file).".php");
			else
				include(dirname(__FILE__)."/Front/View/templates/post-content.php");
		}
			
	}
	public function getPostImages($PostID)
	{
		if($PostID > 0)
		{
			$Obj = new DataTable(TABLE_BLOG_POST_IMAGES);
			$Obj->where[] = array('=',array('PostID' => $PostID));
			$Obj->where[] = array('=',array('Active' => '1'));
			return $Obj->tableSelectAll(array("*"),array("Position ASC","ImageID ASC"));;
		}
		return ;
	
	}
	
	function getGalleryFilter($PostID, $AreaDescription,$CurrentPost)
	{
		if (strpos($AreaDescription, '{Gallery}') !== false) {
				$imageRows = $this->getPostImages($PostID);
				if(count($imageRows) > 0){
					$GalleryContent = '';
					$GalleryContent .= '<div class="row">';
					foreach( $imageRows as $CurrentImage){
						if($CurrentImage->Image !="" && file_exists(DIR_FS_SITE_UPLOADS."post/".$CurrentImage->Image)){
						$GalleryContent .= '<div class="col-sm-3 default-banner">
											<div class="item mb-3">
												<div>
													<a target="" href="'.SKImgDisplay(DIR_FS_SITE_UPLOADS."post/".$CurrentImage->Image,"800,800,true").'"
													data-lightbox-title="'.$CurrentPost->PostName.'"
													data-lightbox-description=""
													data-lightbox-group="post_gallery_'.$PostID.'"
													>
														<img class="img-thumbnail figure-img img-zoom" src="'.SKImgDisplay(DIR_FS_SITE_UPLOADS."post/".$CurrentImage->Image,"400,400,true").'" alt="'.$CurrentPost->PostName.'">
													</a>
												</div>
												
											</div>
										</div>';
						}
					}
					$GalleryContent .= '</div>';
					
					$AreaDescription = str_replace('{Gallery}',$GalleryContent,$AreaDescription);
				}
		}
		
		return $AreaDescription;		
			
	}
	
	public function getPostByIds($IDs,$Active="1",$AllColumns=false)
	{
		if(isset($IDs) && is_array($IDs) && count($IDs) > 0)
			$IDs = implode(",",$IDs);
		
		if($IDs != "")
			$IDArray = explode(",",$IDs);
		
		if(isset($IDArray) && is_array($IDArray) && count($IDArray) > 0){
			$where = new Where();
			$PostObj = new DataTable(array('p'=>TABLE_BLOG_POST));
			$where->notEqualTo('p.PostType','Child');
			if($Active=="1")
				$where->equalTo('p.Active',"1");
			
			$where->in('p.PostID',$IDArray);
			$PostObj->where = $where;
			//$PostObj->displayQuery = true;
			
			$ColumnArray = array("PostID","PostName");
			if($AllColumns==true)
				$ColumnArray = array("*");
				
			$rows = $PostObj->tableSelectAll($ColumnArray,array("CreatedDate DESC"));
			return $rows;
			//return $rows->toArray();
		}
		else{
			return array();
		}
			 
	}
	

	
	public function getHomepagePostlist($limit=6)
	{
		
		$OrderBy = "RAND()";
		$where = new Where();
		$PostObj = new DataTable(array('p'=>TABLE_BLOG_POST));
		$where->notEqualTo('p.PostType','Child');
		$where->equalTo('ptc.RelationID','0');
		$where->equalTo('p.Active',"1");
		$where->equalTo('ptc.Custom',"1");
		$PostObj->where = $where;
	
		$PostObj->joinExpression = true;
		$PostObj->joinArray[] = array('name'=>array('ptc'=>TABLE_BLOG_POST_RELATION),
									  'on'=>"(ptc.PostID=p.PostID and ptc.RelationType='Homepage')",
									  'columns'=>array("RelationID","SortOrder"),
									  'type'=>''
									  );
		
		return $PostObj->tableSelectAll(array("*"),array("ptc.SortOrder"),$limit);
	
	}
	
	public function getFeaturedPostlist($limit=5)
	{
		
		$where = new Where();
		$PostObj = new DataTable(array('p'=>TABLE_BLOG_POST));
		$where->notEqualTo('p.PostType','Child');
		$where->equalTo('p.Active',"1");
		$where->equalTo('p.Featured',"1");
		$PostObj->where = $where;
		return $PostObj->tableSelectAll(array("*"),array("CreatedDate DESC"),$limit);
			 
	}
	
	public function getPostAdditions($PostID)
	{
		$Obj = new DataTable(TABLE_BLOG_POST_ADDITIONS);
		$Obj->where[] = array('=',array('PostID' => $PostID));
		$Obj->columnExpression = true;
		return $Obj->tableSelectAll(array("DISTINCT(AttributeName) as AttributeName","AttributeType as AttributeType","Position as Position"),array("Position ASC","PostAdditionID ASC"));;
			 
	}
	
	public function getPostAdditionValues($PostID,$AttributeName)
	{
		if($PostID > 0)
		{
			$Obj = new DataTable(TABLE_BLOG_POST_ADDITIONS);
			$Obj->where[] = array('=',array('PostID' => $PostID));
			$Obj->where[] = array('=',array('AttributeName' => $AttributeName));
			return $Obj->tableSelectAll(array("*"),array("AttributeValueSort ASC","PostAdditionID ASC"));;
	
		}
		return ;
	
	}
	
	
	function SKStarRating($r=0)
	{
		if($r > 0)
		{
			$ReturnString ='<div class="star-rating">';
			for ($i=1;$i<=5;$i++)
			{
				if($r >=$i)
					$ReturnString .='<span class="fa fa-star"></span>';
				else 
					$ReturnString .='<span class="fa fa-star-o"></span>';
			}
			$ReturnString .='</div>';
			
			return $ReturnString;
		}
		return '<div class="no-rating"></div>';
	}
	
	function SKStarRatingSummary($PostID)
	{
		 $Obj = new DataTable(TABLE_BLOG_POST_REVIEWS);
		 $Obj->where[] = array('=',array('PostID' => $PostID));
		 $Obj->where[] = array('=',array('Active' => '1'));
		 $Obj->columnExpression = true;
		 $Rating = (object)$Obj->tableSelectOne(array("SUM(Rating) as Rating","COUNT(*) as Total"));
		 
		 $r= 0;
		 if(isset($Rating->Total) && $Rating->Total >0)
         	$r = number_format($Rating->Rating/$Rating->Total,0);
         
		 return $this->SKStarRating($r);
	}

	
	
}	