<?php 
namespace Blog\Post\Admin\Controller;
use WebsiteControl\Base\AbstractModule;
use Base\Db\DataTable as DataTable;
use Blog\Category\Common as CategoryCommon;
use Blog\Post\Common as PostCommon;
use Laminas\Db\Sql\Where;

class IndexController extends AbstractModule
{
	var $rpstdt,$rpeddt;
	function __construct()
	{
		$this->rpstdt=isset($_GET['rpstdt'])?MyStripSlashes($_GET['rpstdt']):date('Y-m-d',strtotime("-10 days"));
		$this->rpeddt=isset($_GET['rpeddt'])?MyStripSlashes($_GET['rpeddt']):date('Y-m-d');
	}
	
	function getDateArray()
	{
		$StartDate = $this->rpstdt;
		$EndDate = $this->rpeddt;
		$DataArray = array();
		
		$date1 = new \DateTime($StartDate);
		$date2 = new \DateTime($EndDate);
		$interval = $date1->diff($date2);
		if($interval->days > 0){
			for($i=0;$i<=$interval->days;$i++)
				$DataArray[date('Y-m-d',strtotime($StartDate)+($i*24*60*60))] = ConvertDateFromDb(date('Y-m-d',strtotime($StartDate)+($i*24*60*60)));
		}
		return $DataArray;
	}
	
		
	public function getCategoryCommon()
	{
		$obj = new CategoryCommon();
		return $obj;
	}
	
	public function getPostCommon()
	{
		$obj = new PostCommon();
		return $obj;
	}
	
	public function getHeaderCss()
	{
		SkCssInclude(DIR_WS_SITE."templates/extras/starrating/css/star-rating.css");
		SkJsInclude(DIR_WS_SITE."templates/extras/starrating/js/star-rating.min.js");
		//<script src="http://192.168.0.77/sunil/custom_cms/alakazam/attachment/extras/bootstrap-star-rating-master/bootstrap-star-rating-master/js/star-rating.js" type="text/javascript"></script>
	}
	
	public function getFooterJs()
	{
		SkJsInclude(ADMIN_THEME_URL."assest/vendors/Chart.js/dist/Chart.min.js");
		SkJsInclude(ADMIN_THEME_URL."assest/vendors/echarts/dist/echarts.min.js");
		
		//SkJsInclude(ADMIN_THEME_URL."assest/vendors/jqvmap/dist/jquery.vmap.js");
		//SkJsInclude(ADMIN_THEME_URL."assest/vendors/jqvmap/dist/maps/jquery.vmap.world.js");
		//SkJsInclude(ADMIN_THEME_URL."assest/vendors/jqvmap/examples/js/jquery.vmap.sampledata.js");
	
	}
	
	public function AddEditPostAction()
	{
		if(count($_POST)>0)
		{
			$PostObj = new DataTable(TABLE_BLOG_POST);
			$SeoObj = new DataTable(TABLE_SEO);
			$PostCategoryObj = new DataTable(TABLE_BLOG_POST_RELATION);
			$ParentID = (isset($_GET['ParentID']) && $_GET['ParentID'] > 0)?$_GET['ParentID']:0;
			$PostID = isset($_GET['PostID'])?$_GET['PostID']:0;


			$DataArray = array();
			
			$DataArray['PostName'] = isset($_POST['PostName'])?$_POST['PostName']:"";
			$DataArray['PostLine'] = isset($_POST['PostLine'])?$_POST['PostLine']:"";
			$DataArray['PostAuthor'] = isset($_POST['PostAuthor'])?$_POST['PostAuthor']:"";
			$DataArray['PostDate'] = (isset($_POST['PostDate']) && $_POST['PostDate'] !="")?ConvertDatetoDb($_POST['PostDate']):NULL;
			
			$DataArray['SmallDescription'] = isset($_POST['SmallDescription'])?$_POST['SmallDescription']:"";
			$DataArray['LargeDescription'] = isset($_POST['LargeDescription'])?$_POST['LargeDescription']:"";
			$DataArray['YoutubeVideo'] = isset($_POST['YoutubeVideo'])?$_POST['YoutubeVideo']:"";
			$DataArray['YoutubeVideo2'] = isset($_POST['YoutubeVideo2'])?$_POST['YoutubeVideo2']:"";
			
			
			$DataArray['Homepage'] = isset($_POST['Homepage'])?$_POST['Homepage']:0;
			$DataArray['Featured'] = isset($_POST['Featured'])?$_POST['Featured']:0;
			
			$DataArray['Active'] = isset($_POST['Active'])?$_POST['Active']:0;
			
			
			if(isset($_POST['Template']) && $_POST['Template'] !="")
				$DataArray['Template'] = $_POST['Template'];
			
			$DataArray['UpperBanner1'] = (isset($_POST['UpperBanner1']) && $_POST['UpperBanner1'] !="")?implode(",",$_POST['UpperBanner1']):"";
			
			/* post image added*/
			if(isset($_POST['PostImage']) && $_POST['PostImage'] !="" && file_exists(DIR_FS_SITE_UPLOADS."post/".$_POST['PostImage']))
			{
				if(isset($_POST['PostImageDelete']) && $_POST['PostImageDelete'] == "1")
				{
					@unlink(DIR_FS_SITE_UPLOADS."post/".$_POST['PostImage']);
				}
				
			}
			if(isset($_FILES['Upload']) && $_FILES['Upload']['name'] !="")
			{
				$ArrayType = explode(".",$_FILES['Upload']['name']);
				$Type=$ArrayType[count($ArrayType)-1];
				
				$ImageName = uniqid(substr($DataArray['PostName'],0,5)."_").".".$Type;				
				$OriginalImage =DIR_FS_SITE_UPLOADS."post/".$ImageName;
				copy($_FILES['Upload']['tmp_name'],$OriginalImage);
				$DataArray['Image'] = $ImageName;
		
				if(isset($_POST['PostImage']) && $_POST['PostImage'] !="" && file_exists(DIR_FS_SITE_UPLOADS."post/".$_POST['PostImage']))
					@unlink(DIR_FS_SITE_UPLOADS."post/".$_POST['PostImage']);
			}
			/* post image added end*/	
			
			for($i=1;$i<=6;$i++){
				$DataArray['AreaDescription'.$i] = isset($_POST['AreaDescription'.$i])?$_POST['AreaDescription'.$i]:"";
				$DataArray['AreaDirection'.$i] = isset($_POST['AreaDirection'.$i])?$_POST['AreaDirection'.$i]:"";
			
			/* post image added*/
			if(isset($_POST['AreaImage'.$i]) && $_POST['AreaImage'.$i] !="" && file_exists(DIR_FS_SITE_UPLOADS."post/".$_POST['AreaImage'.$i]))
			{
				if(isset($_POST['AreaImageDelete'.$i]) && $_POST['AreaImageDelete'.$i] == "1")
				{
					@unlink(DIR_FS_SITE_UPLOADS."post/".$_POST['AreaImage'.$i]);
				}
				
			}
			if(isset($_FILES['AreaUpload'.$i]) && $_FILES['AreaUpload'.$i]['name'] !="")
			{
				$ArrayType = explode(".",$_FILES['AreaUpload'.$i]['name']);
				$Type=$ArrayType[count($ArrayType)-1];
				
				$ImageName = uniqid(substr($DataArray['PostName'],0,5)."_").".".$Type;				
				$OriginalImage =DIR_FS_SITE_UPLOADS."post/".$ImageName;
				copy($_FILES['AreaUpload'.$i]['tmp_name'],$OriginalImage);
				$DataArray['AreaImage'.$i] = $ImageName;
		
				if(isset($_POST['AreaImage'.$i]) && $_POST['AreaImage'.$i] !="" && file_exists(DIR_FS_SITE_UPLOADS."post/".$_POST['AreaImage'.$i]))
					@unlink(DIR_FS_SITE_UPLOADS."post/".$_POST['AreaImage'.$i]);
			}
			/* post image added end*/
			
			}
			
			if($PostID > 0)
			{
				$PostObj->where[] = array('=',array('PostID' => $PostID));
				$PostObj->tableUpdate($DataArray);
				$this->getSession()->setArrVar("alert",array("success","Post updated successfully."));
				
			}
			else 
			{
				
				$DataArray['PostType'] = (isset($_POST['PostType']) && $_POST['PostType'] !="")?$_POST['PostType']:"Simple";
				if(isset($_POST['PostAttribute']) && is_array($_POST['PostAttribute']) && count($_POST['PostAttribute']) > 0)
					$DataArray['PostAttribute'] = implode(",",$_POST['PostAttribute']);
						
				$PostObj->where ="1";
				$Position = $PostObj->getMax("Position") + 1;
				
				$DataArray['Position'] = $Position;
				$DataArray['UploadType'] ='';
				$DataArray['CreatedDate'] =date('Y-m-d H:i:s');
				
				$PostID = $PostObj->tableInsert($DataArray);		
				$this->getSession()->setArrVar("alert",array("success","Post added successfully."));
				
			}
			
			/* SEO START*/
			$SeoObj->where = "ReferenceID = ".$PostID." AND MCode ='blog_post' AND MView ='Detail'";
			$CurrentSEO = (object)$SeoObj->tableSelectOne(array("ReferenceID"));
			
			$DataArray = array();
			$DataArray['URLName'] = SkURLCreate((isset($_POST['URLName']) && $_POST['URLName'] !="")?$_POST['URLName']:$_POST['PostName']);
			$DataArray['RedirectEnabled'] = isset($_POST['RedirectEnabled'])?$_POST['RedirectEnabled']:0;
			$DataArray['RedirectURL'] = isset($_POST['RedirectURL'])?$_POST['RedirectURL']:"";
			
			if(@constant("DEFINE_SEO_META_ACTIVE") =="1")
			{
				$DataArray['MetaTitle'] = isset($_POST['MetaTitle'])?$_POST['MetaTitle']:"";
				$DataArray['MetaKeyword'] = isset($_POST['MetaKeyword'])?$_POST['MetaKeyword']:"";
				$DataArray['MetaDescription'] = isset($_POST['MetaDescription'])?$_POST['MetaDescription']:"";
			}
			
			if(isset($CurrentSEO->ReferenceID) && $CurrentSEO->ReferenceID !="")
			{
				$SeoObj->tableUpdate($DataArray);
			}
			else 
			{
				$DataArray['MCode'] = "blog_post";
				$DataArray['MView'] = "Detail";
				$DataArray['ReferenceID'] = $PostID;
				$SeoObj->tableInsert($DataArray);
			}
			/* SEO END*/
			
		
		if(isset($_POST['CategoryArr']) && $_POST['CategoryArr'] !="" && count($_POST['CategoryArr']) >0)
		{			
			$PostCategoryObj->where = "RelationType='blog_category' and PostID='".(int)$PostID."'";
			if(implode(",", $_POST['CategoryArr']) != "")
				 $PostCategoryObj->where .= "and RelationID NOT IN (".implode(",",$_POST['CategoryArr']).")";
			
			$PostCategoryObj->tableDelete();	
			foreach ($_POST['CategoryArr'] as $ck=>$cv)
			{
				if($cv !="")
				{	
					if($ParentID == 0)
						$ParentID =$cv;
					
					$PostCategoryObj->where = array(array('=',array('RelationType' => 'blog_category')),
											  array('=',array('PostID' => $PostID)),
											  array('=',array('RelationID' => $cv))											  
											  );
					$CObj = (object)$PostCategoryObj->tableSelectOne(array("id"));
					if(!isset($CObj->id)){
						$DataArray = array();
						$DataArray['PostID'] = $PostID;
						$DataArray['RelationID'] = $cv;
						$DataArray['RelationType'] = "blog_category";
						$DataArray['SortOrder'] = $this->getPostCommon()->SKMaxGetPostSortOrder($cv,"blog_category") + 1;
						$PostCategoryObj->tableInsert($DataArray);
					}
				}
			}
		}
			
			if(isset($_POST['Continue'])){	
				if($this->origin->rview)
					MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->origin->m."&view=AddEditPost&ParentID=$ParentID&PostID=$PostID&rview=".$this->origin->rview);
				else
					MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->origin->m."&view=AddEditPost&ParentID=$ParentID&PostID=$PostID");
			}
			else{ 
				if($this->origin->rview)
					MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->origin->m."&view=".$this->origin->rview."&ParentID=$ParentID&PostID=$PostID");
				else
					MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->origin->m."&view=Default&ParentID=$ParentID&PostID=$PostID");
			}
			exit;
		}
		
	}
	public function UpdatePostAction()
	{
		if(count($_POST)>0)
		{
			
			/* BulkAllRemoveCategory start*/
			if(isset($_POST['BulkAllRemoveCategory'])){
				$ItemIDArr = isset($_POST['ItemIDArr'])?$_POST['ItemIDArr']:array();
				$ParentID = isset($_GET['ParentID'])?$_GET['ParentID']:0;
				
				if($ParentID > 0)
					{
						$PostCategoryObj = new DataTable(TABLE_BLOG_POST_RELATION);
						$PostCategoryObj->where = array(array('=',array('RelationType' => "blog_category")),
														  array('=',array('RelationID' => $ParentID)));
						$PostCategoryObj->tableDelete();								
					}	
				
				$this->getSession()->setArrVar("alert",array("success","All Posts removed from the category list."));
				MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->origin->m."&ParentID=".$this->origin->ParentID);
			    exit;
			}
			/* BulkAllRemoveCategory end*/
			
			/* BulkRemoveCategory start*/
			if(isset($_POST['BulkRemoveCategory'])){
				$ItemIDArr = isset($_POST['ItemIDArr'])?$_POST['ItemIDArr']:array();
				$ParentID = isset($_GET['ParentID'])?$_GET['ParentID']:0;
				foreach($ItemIDArr as $k=>$PostID){
					if($PostID > 0 && $ParentID > 0)
					{
						$PostCategoryObj = new DataTable(TABLE_BLOG_POST_RELATION);
						$PostCategoryObj->where = array(array('=',array('RelationType' => "blog_category")),
														  array('=',array('RelationID' => $ParentID)),
														  array('=',array('PostID' => $PostID))											  
														  );
						$PostCategoryObj->tableDelete();								
					}			
				}
				$this->getSession()->setArrVar("alert",array("success","Posts removed from the category list."));
				MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->origin->m."&ParentID=".$this->origin->ParentID);
			    exit;
			}
			/* BulkRemoveCategory end*/
			
			/* BulkRemovePermanent start*/
			if(isset($_POST['BulkRemovePermanent'])){
				$ItemIDArr = isset($_POST['ItemIDArr'])?$_POST['ItemIDArr']:array();
				$ParentID = isset($_GET['ParentID'])?$_GET['ParentID']:0;
				foreach($ItemIDArr as $k=>$PostID){
					if($PostID > 0){
							$PostObj = new DataTable(TABLE_BLOG_POST);
							$PostObj->where[] = array('=',array('PostID' => $PostID));
							$PostObj->tableDelete();								
						
							$SeoObj = new DataTable(TABLE_SEO);
							$SeoObj->where[] = array('=',array('ReferenceID' => $PostID));
							$SeoObj->where[] = array('=',array('MCode' => 'blog_post'));
							$SeoObj->tableDelete();					
					}			
				}
				$this->getSession()->setArrVar("alert",array("success","Posts deleted successfully."));
				MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->origin->m."&ParentID=".$this->origin->ParentID);
			    exit;
			}
			/* BulkRemovePermanent end*/
			
			/* BulkSubmit start*/
			if(isset($_POST['BulkSubmit'])){
				$ItemIDArr = isset($_POST['ItemIDArr'])?$_POST['ItemIDArr']:array();
				$ParentID = isset($_GET['ParentID'])?$_GET['ParentID']:0;
				foreach($ItemIDArr as $k=>$PostID){
					if($PostID > 0){
						
						$DataArray = array();		
						if(isset($_POST['NotForSale']) && $_POST['NotForSale'] != "")
							$DataArray['NotForSale'] = isset($_POST['NotForSale'])?$_POST['NotForSale']:0;
						if(isset($_POST['SignedIn']) && $_POST['SignedIn'] != "")
							$DataArray['SignedIn'] = isset($_POST['SignedIn'])?$_POST['SignedIn']:0;
						if(isset($_POST['Homepage']) && $_POST['Homepage'] != "")
							$DataArray['Homepage'] = isset($_POST['Homepage'])?$_POST['Homepage']:0;
						if(isset($_POST['Featured']) && $_POST['Featured'] != "")
							$DataArray['Featured'] = isset($_POST['Featured'])?$_POST['Featured']:0;
						if(isset($_POST['VIPStatus']) && $_POST['VIPStatus'] != "")
							$DataArray['VIPStatus'] = isset($_POST['VIPStatus'])?$_POST['VIPStatus']:0;
						if(isset($_POST['WholeSaler']) && $_POST['WholeSaler'] != "")
							$DataArray['WholeSaler'] = isset($_POST['WholeSaler'])?$_POST['WholeSaler']:0;
						if(isset($_POST['GDiscountOff']) && $_POST['GDiscountOff'] != "")
							$DataArray['GDiscountOff'] = isset($_POST['GDiscountOff'])?$_POST['GDiscountOff']:0;
						if(isset($_POST['FreeShippingStatus']) && $_POST['FreeShippingStatus'] != "")
							$DataArray['FreeShippingStatus'] = isset($_POST['FreeShippingStatus'])?$_POST['FreeShippingStatus']:0;
						if(isset($_POST['Active']) && $_POST['Active'] != "")
							$DataArray['Active'] = isset($_POST['Active'])?$_POST['Active']:0;
						
						if(count($DataArray) > 0){
							$PostObj = new DataTable(TABLE_BLOG_POST);
							$PostObj->where="PostID ='".(int)$PostID."'";
							$PostObj->tableUpdate($DataArray);
						}
						
						if(isset($_POST['CategoryArr']) && $_POST['CategoryArr'] !="" && count($_POST['CategoryArr']) >0)
						{			
							foreach ($_POST['CategoryArr'] as $ck=>$cv)
							{
								$PostCategoryObj = new DataTable(TABLE_BLOG_POST_RELATION);
								if($cv !="")
								{	
									$PostCategoryObj->where = array(array('=',array('RelationType' => 'blog_category')),
															  array('=',array('PostID' => $PostID)),
															  array('=',array('RelationID' => $cv))											  
															  );
									$CObj = (object)$PostCategoryObj->tableSelectOne(array("id"));
									if(!isset($CObj->id)){
										$DataArray = array();
										$DataArray['PostID'] = $PostID;
										$DataArray['RelationID'] = $cv;
										$DataArray['RelationType'] = "blog_category";
										$DataArray['SortOrder'] = $this->getPostCommon()->SKMaxGetPostSortOrder($cv,"blog_category") + 1;
										$PostCategoryObj = new DataTable(TABLE_BLOG_POST_RELATION);
										$PostCategoryObj->tableInsert($DataArray);
									}
								}
							}
						}
						
					
					}			
				}
				$this->getSession()->setArrVar("alert",array("success","Posts updated successfully."));
				MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->origin->m."&ParentID=".$this->origin->ParentID);
			    exit;
			}
			/* BulkSubmit end*/
			
			/* UpdateList start*/
			if(isset($_POST['UpdateList'])){
				$PostObj = new DataTable(TABLE_BLOG_POST);
				$PostCategoryObj = new DataTable(TABLE_BLOG_POST_RELATION);
				for ($i=1;$i <$_POST['Count'];$i++)
				{
					$PostID =$_POST['PostID_'.$i];
					$DataArray = array();
					$DataArray['Featured'] = isset($_POST['Featured_'.$i])?$_POST['Featured_'.$i]:0;
					$DataArray['Active'] = isset($_POST['Active_'.$i])?$_POST['Active_'.$i]:0;
					
					$DataArray['Position'] = (isset($_POST['Position_'.$i]) && $_POST['Position_'.$i] > 0)?$_POST['Position_'.$i]:0;
					$PostObj->where="PostID ='".(int)$PostID."'";
					$PostObj->tableUpdate($DataArray);
					
					$DataArray = array();
					$DataArray['SortOrder'] = (isset($_POST['SortOrder_'.$i]) && $_POST['SortOrder_'.$i] !="")?$_POST['SortOrder_'.$i]:0;			
					
					$PostCategoryObj->where = array(array('=',array('RelationType' => 'blog_category')),
												  array('=',array('RelationID' => $this->origin->ParentID)),
												  array('=',array('PostID' => $PostID))											  
												  );
												  
					$PostCategoryObj->tableUpdate($DataArray);
					
				}
				$this->getSession()->setArrVar("alert",array("success","Post updated successfully."));
				MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->origin->m."&ParentID=".$this->origin->ParentID."&PageNo=".$this->origin->PageNo);
				 exit;
			}
		 /* UpdateList end*/
		
		}
	}
	
	public function BulkPostsStockAction()
	{
		if(count($_POST)>0)
		{
			
			/* BulkRemovePermanent start*/
			if(isset($_POST['BulkRemovePermanent'])){
				$ItemIDArr = isset($_POST['ItemIDArr'])?$_POST['ItemIDArr']:array();
				$ParentID = isset($_GET['ParentID'])?$_GET['ParentID']:0;
				foreach($ItemIDArr as $k=>$PostID){
					if($PostID > 0){
							$PostObj = new DataTable(TABLE_BLOG_POST);
							$PostObj->where[] = array('=',array('PostID' => $PostID));
							$PostObj->tableDelete();								
						
							$SeoObj = new DataTable(TABLE_SEO);
							$SeoObj->where[] = array('=',array('ReferenceID' => $PostID));
							$SeoObj->where[] = array('=',array('MCode' => 'blog_post'));
							$SeoObj->tableDelete();					
					}			
				}
				$this->getSession()->setArrVar("alert",array("success","Posts deleted successfully."));
				MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->origin->m."&view=".$this->origin->view."&orderBy=".$this->origin->orderBy."&k=".$this->origin->k);
			    exit;
			}
			/* BulkRemovePermanent end*/
			
			/* BulkSubmit start*/
			if(isset($_POST['BulkSubmit'])){
				$ItemIDArr = isset($_POST['ItemIDArr'])?$_POST['ItemIDArr']:array();
				$ParentID = isset($_GET['ParentID'])?$_GET['ParentID']:0;
				foreach($ItemIDArr as $k=>$PostID){
					if($PostID > 0){
						
						$DataArray = array();		
						if(isset($_POST['NotForSale']) && $_POST['NotForSale'] != "")
							$DataArray['NotForSale'] = isset($_POST['NotForSale'])?$_POST['NotForSale']:0;
						if(isset($_POST['SignedIn']) && $_POST['SignedIn'] != "")
							$DataArray['SignedIn'] = isset($_POST['SignedIn'])?$_POST['SignedIn']:0;
						if(isset($_POST['Homepage']) && $_POST['Homepage'] != "")
							$DataArray['Homepage'] = isset($_POST['Homepage'])?$_POST['Homepage']:0;
						if(isset($_POST['Featured']) && $_POST['Featured'] != "")
							$DataArray['Featured'] = isset($_POST['Featured'])?$_POST['Featured']:0;
						if(isset($_POST['VIPStatus']) && $_POST['VIPStatus'] != "")
							$DataArray['VIPStatus'] = isset($_POST['VIPStatus'])?$_POST['VIPStatus']:0;
						if(isset($_POST['WholeSaler']) && $_POST['WholeSaler'] != "")
							$DataArray['WholeSaler'] = isset($_POST['WholeSaler'])?$_POST['WholeSaler']:0;
						if(isset($_POST['GDiscountOff']) && $_POST['GDiscountOff'] != "")
							$DataArray['GDiscountOff'] = isset($_POST['GDiscountOff'])?$_POST['GDiscountOff']:0;
						if(isset($_POST['FreeShippingStatus']) && $_POST['FreeShippingStatus'] != "")
							$DataArray['FreeShippingStatus'] = isset($_POST['FreeShippingStatus'])?$_POST['FreeShippingStatus']:0;
						if(isset($_POST['Active']) && $_POST['Active'] != "")
							$DataArray['Active'] = isset($_POST['Active'])?$_POST['Active']:0;
						
						if(count($DataArray) > 0){
							$PostObj = new DataTable(TABLE_BLOG_POST);
							$PostObj->where="PostID ='".(int)$PostID."'";
							$PostObj->tableUpdate($DataArray);
						}
						
						if(isset($_POST['CategoryArr']) && $_POST['CategoryArr'] !="" && count($_POST['CategoryArr']) >0)
						{			
							foreach ($_POST['CategoryArr'] as $ck=>$cv)
							{
								$PostCategoryObj = new DataTable(TABLE_BLOG_POST_RELATION);
								if($cv !="")
								{	
									$PostCategoryObj->where = array(array('=',array('RelationType' => 'blog_category')),
															  array('=',array('PostID' => $PostID)),
															  array('=',array('RelationID' => $cv))											  
															  );
									$CObj = (object)$PostCategoryObj->tableSelectOne(array("id"));
									if(!isset($CObj->id)){
										$DataArray = array();
										$DataArray['PostID'] = $PostID;
										$DataArray['RelationID'] = $cv;
										$DataArray['RelationType'] = "blog_category";
										$DataArray['SortOrder'] = $this->getPostCommon()->SKMaxGetPostSortOrder($cv,"blog_category") + 1;
										$PostCategoryObj = new DataTable(TABLE_BLOG_POST_RELATION);
										$PostCategoryObj->tableInsert($DataArray);
									}
								}
							}
						}
						
					
					}			
				}
				$this->getSession()->setArrVar("alert",array("success","Posts updated successfully."));
				MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->origin->m."&view=".$this->origin->view."&orderBy=".$this->origin->orderBy."&k=".$this->origin->k);
			    exit;
			}
			/* BulkSubmit end*/
			
		}
	}
	
	public function BulkFeaturedPostAction()
	{
		if(count($_POST)>0){
			
			/* BulkSelectedRemove start*/
			if(isset($_POST['BulkSelectedRemove'])){
				$ItemIDArr = isset($_POST['ItemIDArr'])?$_POST['ItemIDArr']:array();
				foreach($ItemIDArr as $k=>$PostID){
					if($PostID > 0)
					{
						$PostObj = new DataTable(TABLE_BLOG_POST);
						$DataArray = array();
						$DataArray['Featured'] = "0";
						$PostObj->where="PostID ='".(int)$PostID."'";
						$PostObj->tableUpdate($DataArray);
					
					}			
				}
				$this->getSession()->setArrVar("alert",array("success","Posts removed from the featured list."));
				MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->origin->m."&view=".$this->origin->view);
			    exit;
			}
			/* BulkSelectedRemove end*/			
		}
	}
	
	public function BulkHomepagePostAction()
	{
		if(count($_POST)>0){
			
			/* BulkSelectedRemove start*/
			if(isset($_POST['BulkSelectedRemove'])){
				$ItemIDArr = isset($_POST['ItemIDArr'])?$_POST['ItemIDArr']:array();
				foreach($ItemIDArr as $k=>$PostID){
					if($PostID > 0)
					{
						$PostRelationObj = new DataTable(TABLE_BLOG_POST_RELATION);
						$PostRelationObj->where = array(array('=',array('RelationType' => 'Homepage')),
																  array('=',array('PostID' => $PostID)),
																  array('=',array('RelationID' => '0'))											  
																  );
						$PostRelationObj->tableDelete();
					
					}			
				}
				$this->getSession()->setArrVar("alert",array("success","Posts removed from the homepage list."));
				MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->origin->m."&view=".$this->origin->view);
			    exit;
			}
			/* BulkSelectedRemove end*/	
			/* UpdateList start*/
			if(isset($_POST['UpdateList'])){
				for ($i=1;$i <$_POST['Count'];$i++)
				{
					$PostID =$_POST['PostID_'.$i];
					$DataArray = array();
					$DataArray['SortOrder'] = (isset($_POST['SortOrder_'.$i]) && $_POST['SortOrder_'.$i] !="")?$_POST['SortOrder_'.$i]:0;			
					$DataArray['Custom'] = (isset($_POST['Custom_'.$i]) && $_POST['Custom_'.$i] !="")?$_POST['Custom_'.$i]:0;			
					$PostCategoryObj = new DataTable(TABLE_BLOG_POST_RELATION);
					$PostCategoryObj->where = array(array('=',array('RelationType' => 'Homepage')),
												  array('=',array('RelationID' => '0')),
												  array('=',array('PostID' => $PostID))											  
												  );
					//echo "<pre>";var_dump($DataArray);							  
					$PostCategoryObj->tableUpdate($DataArray);
					
				}
				$this->getSession()->setArrVar("alert",array("success","Post updated successfully."));
				MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->origin->m."&view=".$this->origin->view);
				 exit;
			}
		 /* UpdateList end*/
			
		}
	}
	
	
	public function DeletePostAction()
	{
		$PostID = isset($_GET['PostID'])?$_GET['PostID']:0;
		$Password = isset($_POST['Password'])?$_POST['Password']:"";
			
			if(empty($Password))
			$this->getSession()->setArrVar("alert",array("danger","Password cannot be left empty."));
			
			
			$check = $this->getClass('WebsiteControl\Login\Common')->CheckAdminPassword($Password);
			if($check != "1")
				$this->getSession()->setArrVar("alert",array("danger","ERROR: Password not correct or you do not have access for this action."));
			
			$arr = $this->getSession()->getVar("alert");
			if($arr==null)
				$arr =array();
			
		if(($arr==NULL || count($arr)==0) && $check == "1"){
		
			if($PostID > 0)
			{
				$PostObj = new DataTable(TABLE_BLOG_POST);
				
				$PostObj->where[] = array('=',array('PostID' => $PostID));
				$PostObj->tableDelete();								
				
				$SeoObj = new DataTable(TABLE_SEO);
				$SeoObj->where[] = array('=',array('ReferenceID' => $PostID));
				$SeoObj->where[] = array('=',array('MCode' => 'blog_post'));
				$SeoObj->tableDelete();		
			}			
			
			$this->getSession()->setArrVar("alert",array("success","Post deleted successfully."));
			if($this->origin->rview)
				MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&ParentID=".$this->origin->ParentID."&view=".$this->origin->rview);
			else
				MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&ParentID=".$this->origin->ParentID);
			exit;
		}
	}
	
	public function DeleteCategoryPostAction()
	{
		$PostID = isset($_GET['PostID'])?$_GET['PostID']:0;
		$ParentID = isset($_GET['ParentID'])?$_GET['ParentID']:0;
		if($PostID > 0 && $ParentID > 0)
		{
			$PostCategoryObj = new DataTable(TABLE_BLOG_POST_RELATION);
			$PostCategoryObj->where = array(array('=',array('RelationType' => "blog_category")),
											  array('=',array('RelationID' => $ParentID)),
											  array('=',array('PostID' => $PostID))											  
											  );
			$PostCategoryObj->tableDelete();								
		}			
		
		$this->getSession()->setArrVar("alert",array("success","Post removed from the category list."));
		MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&ParentID=".$this->origin->ParentID);
		 exit;
	}
	
	
	/* post images section start*/
	public function AddPostImageAction()
	{
		if(count($_POST)>0)
		{
			$PostImageObj = new DataTable(TABLE_BLOG_POST_IMAGES);
			$ParentID = (isset($_GET['ParentID']) && $_GET['ParentID'] > 0)?$_GET['ParentID']:0;
			$PostID = isset($_GET['PostID'])?$_GET['PostID']:0;


			$DataArray = array();
			$DataArray['PostID'] = $PostID;
			$DataArray['Active'] = isset($_POST['Active'])?$_POST['Active']:"0";
			$DataArray['Position'] = (isset($_POST['Position']) && $_POST['Position'] > 0)?$_POST['Position']:"0";
			if(isset($_FILES['Upload']) && $_FILES['Upload']['name'] !="")
			{
				$ArrayType = explode(".",$_FILES['Upload']['name']);
				$Type=$ArrayType[count($ArrayType)-1];
				$ImageName = uniqid("Image".$PostID."_").".".$Type;				
				$OriginalImage =DIR_FS_SITE_UPLOADS."post/".$ImageName;
				copy($_FILES['Upload']['tmp_name'],$OriginalImage);
				$DataArray['Image'] = $ImageName;
				
			}
			
			/*Direct URL Start */
				if(isset($_POST['Image']) && $_POST['Image'] !="" && stristr($_POST['Image'],"http"))
					$DataArray['Image'] = $_POST['Image'];
			//	if(isset($_POST['Thumbnail']) && $_POST['Thumbnail'] !="" && stristr($_POST['Thumbnail'],"http"))
			//		$DataArray['Thumbnail'] = $_POST['Thumbnail'];
			/*Direct URL End */
			$PostImageObj->tableInsert($DataArray);
			$this->getSession()->setArrVar("alert",array("success","Image added successfully."));
			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=AddEditPost&ParentID=$ParentID&PostID=$PostID&tab=images");
			exit;
		}
	}
	public function EditPostImageAction()
	{
		if(count($_POST)>0)
		{
			$PostImageObj = new DataTable(TABLE_BLOG_POST_IMAGES);
			$ParentID = (isset($_GET['ParentID']) && $_GET['ParentID'] > 0)?$_GET['ParentID']:0;
			$PostID = isset($_GET['PostID'])?$_GET['PostID']:0;
			$ImageID = isset($_POST['ImageID'])?$_POST['ImageID']:0;


			$DataArray = array();
			$DataArray['Active'] = isset($_POST['Active'])?$_POST['Active']:"0";
			$DataArray['Position'] = (isset($_POST['Position']) && $_POST['Position'] > 0)?$_POST['Position']:"0";
			if(isset($_FILES['Upload']) && $_FILES['Upload']['name'] !="")
			{
				$ArrayType = explode(".",$_FILES['Upload']['name']);
				$Type=$ArrayType[count($ArrayType)-1];
				$ImageName = uniqid("Image".$PostID."_").".".$Type;				
				$OriginalImage =DIR_FS_SITE_UPLOADS."post/".$ImageName;
				copy($_FILES['Upload']['tmp_name'],$OriginalImage);
				$DataArray['Image'] = $ImageName;
				
				if(isset($_POST['OldImage']) && $_POST['OldImage'] !="" && file_exists(DIR_FS_SITE_UPLOADS."post/".$_POST['OldImage']))
					@unlink(DIR_FS_SITE_UPLOADS."post/".$_POST['OldImage']);
		
			}
			
			/*Direct URL Start */
				if(isset($_POST['Image']) && $_POST['Image'] !="" && stristr($_POST['Image'],"http"))
					$DataArray['Image'] = $_POST['Image'];
			//	if(isset($_POST['Thumbnail']) && $_POST['Thumbnail'] !="" && stristr($_POST['Thumbnail'],"http"))
			//		$DataArray['Thumbnail'] = $_POST['Thumbnail'];
			/*Direct URL End */
			$PostImageObj->where[] = array('=',array('ImageID' => $ImageID));
			$PostImageObj->tableUpdate($DataArray);
			$this->getSession()->setArrVar("alert",array("success","Image updated successfully."));
			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=AddEditPost&ParentID=$ParentID&PostID=$PostID&tab=images");
			exit;
		}
	}
	
	public function DeletePostImageAction()
	{
		$ImageID = isset($_GET['DeleteImage'])?$_GET['DeleteImage']:0;
		if($ImageID > 0)
		{
			$PostImageObj = new DataTable(TABLE_BLOG_POST_IMAGES);
			$ParentID = (isset($_GET['ParentID']) && $_GET['ParentID'] > 0)?$_GET['ParentID']:0;
			$PostID = isset($_GET['PostID'])?$_GET['PostID']:0;
			
			$PostImageObj->where[] = array('=',array('ImageID' => $ImageID));
			$Obj = (object)$PostImageObj->tableSelectOne();
			
			if(isset($Obj->Image) && $Obj->Image !="" && file_exists(DIR_FS_SITE_UPLOADS."post/".$Obj->Image))
				@unlink(DIR_FS_SITE_UPLOADS."post/".$Obj->Image);

			$PostImageObj->where[] = array('=',array('ImageID' => $ImageID));
			$PostImageObj->tableDelete();
			
			$this->getSession()->setArrVar("alert",array("success","Image deleted successfully."));
			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=AddEditPost&ParentID=$ParentID&PostID=$PostID&tab=images");
			exit;
		}
	}
	
	public function getPostImages($PostID)
	{
		if($PostID > 0)
		{
			$Obj = new DataTable(TABLE_BLOG_POST_IMAGES);
			$Obj->where[] = array('=',array('PostID' => $PostID));
			return $Obj->tableSelectAll(array("*"),array("Position ASC","ImageID ASC"));;
		}
		return ;
	
	}
	public function UpdatePostImageAction()
	{
		if(count($_POST)>0)
		{
			$PostImageObj = new DataTable(TABLE_BLOG_POST_IMAGES);
			$ParentID = (isset($_GET['ParentID']) && $_GET['ParentID'] > 0)?$_GET['ParentID']:0;
			$PostID = isset($_GET['PostID'])?$_GET['PostID']:0;
			for ($i=1;$i <$_POST['Count'];$i++)
			{
				$ImageID =$_POST['ImageID_'.$i];
				$DataArray = array();
				$DataArray['Active'] = (isset($_POST['Active_'.$i]) && $_POST['Active_'.$i] > 0)?$_POST['Active_'.$i]:0;
				$DataArray['Position'] = (isset($_POST['Position_'.$i]) && $_POST['Position_'.$i] > 0)?$_POST['Position_'.$i]:0;
				$PostImageObj->where="ImageID ='".(int)$ImageID."'";
				$PostImageObj->tableUpdate($DataArray);
			}
			$this->getSession()->setArrVar("alert",array("success","Image updated successfully."));
			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=AddEditPost&ParentID=$ParentID&PostID=$PostID&tab=images");
			exit;
		}
	}
	
	/* post images section end*/
	
	/* post infos section start*/
	public function AddPostInfoAction()
	{
		if(count($_POST)>0)
		{
			$PostInfoObj = new DataTable(TABLE_BLOG_POST_INFO);
			$ParentID = (isset($_GET['ParentID']) && $_GET['ParentID'] > 0)?$_GET['ParentID']:0;
			$PostID = isset($_GET['PostID'])?$_GET['PostID']:0;
		
			$DataArray = array();
			$DataArray['PostID'] = $PostID;
			$DataArray['Active'] = isset($_POST['Active'])?$_POST['Active']:"0";
			$DataArray['Position'] = (isset($_POST['Position']) && $_POST['Position'] > 0)?$_POST['Position']:"0";
			$DataArray['TabTitle'] = isset($_POST['TabTitle'])?$_POST['TabTitle']:"";
			$DataArray['InfoType'] = isset($_POST['InfoType'])?$_POST['InfoType']:"HTML";
			$DataArray['Description'] = isset($_POST['Description'])?$_POST['Description']:"";
			if($DataArray['InfoType']=="WMV")
			{
				$DataArray['Description'] = isset($_POST['DemoFile'])?$_POST['DemoFile']:"";
				/*Direct URL Start */
				if(isset($_POST['DirectURL']) && $_POST['DirectURL'] !="" && stristr($_POST['DirectURL'],"http"))
					$DataArray['Description'] = $_POST['DirectURL'];
				/*Direct URL End */
			}
		
			$PostInfoObj->tableInsert($DataArray);
			$this->getSession()->setArrVar("alert",array("success","Information added successfully."));
			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=AddEditPost&ParentID=$ParentID&PostID=$PostID&tab=infos");
			exit;
		}
	}
	public function EditPostInfoAction()
	{
		if(count($_POST)>0)
		{
			$PostInfoObj = new DataTable(TABLE_BLOG_POST_INFO);
			$ParentID = (isset($_GET['ParentID']) && $_GET['ParentID'] > 0)?$_GET['ParentID']:0;
			$PostID = isset($_GET['PostID'])?$_GET['PostID']:0;
			$InfoID = isset($_POST['InfoID'])?$_POST['InfoID']:0;


			$DataArray = array();
			$DataArray['Active'] = isset($_POST['Active'])?$_POST['Active']:"0";
			$DataArray['Position'] = (isset($_POST['Position']) && $_POST['Position'] > 0)?$_POST['Position']:"0";
			$DataArray['TabTitle'] = isset($_POST['TabTitle'])?$_POST['TabTitle']:"";
			$DataArray['InfoType'] = isset($_POST['InfoType'])?$_POST['InfoType']:"HTML";
			$DataArray['Description'] = isset($_POST['Description'])?$_POST['Description']:"";
			if($DataArray['InfoType']=="WMV")
			{
				$DataArray['Description'] = isset($_POST['DemoFile'])?$_POST['DemoFile']:"";
				/*Direct URL Start */
				if(isset($_POST['DirectURL']) && $_POST['DirectURL'] !="" && stristr($_POST['DirectURL'],"http"))
					$DataArray['Description'] = $_POST['DirectURL'];
				/*Direct URL End */
			}
			$PostInfoObj->where[] = array('=',array('InfoID' => $InfoID));
			$PostInfoObj->tableUpdate($DataArray);
			$this->getSession()->setArrVar("alert",array("success","Information updated successfully."));
			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=AddEditPost&ParentID=$ParentID&PostID=$PostID&tab=infos");
			exit;
		}
	}
	
	public function DeletePostInfoAction()
	{
		$InfoID = isset($_GET['DeleteInfo'])?$_GET['DeleteInfo']:0;
		if($InfoID > 0)
		{
			$PostInfoObj = new DataTable(TABLE_BLOG_POST_INFO);
			$ParentID = (isset($_GET['ParentID']) && $_GET['ParentID'] > 0)?$_GET['ParentID']:0;
			$PostID = isset($_GET['PostID'])?$_GET['PostID']:0;
			
			$PostInfoObj->where[] = array('=',array('InfoID' => $InfoID));
			$Obj = (object)$PostInfoObj->tableSelectOne();
			
			$PostInfoObj->where[] = array('=',array('InfoID' => $InfoID));
			$PostInfoObj->tableDelete();
			
			$this->getSession()->setArrVar("alert",array("success","Information deleted successfully."));
			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=AddEditPost&ParentID=$ParentID&PostID=$PostID&tab=infos");
			exit;
		}
	}
	
	public function getPostInfos($PostID)
	{
		if($PostID > 0)
		{
			$Obj = new DataTable(TABLE_BLOG_POST_INFO);
			$Obj->where[] = array('=',array('PostID' => $PostID));
			return $Obj->tableSelectAll(array("*"),array("Position ASC","InfoID ASC"));;
		}
		return ;
	
	}
	/* post infos section end*/
	
	/* post questions section start*/
	public function AddPostQuestionAction()
	{
		if(count($_POST)>0)
		{
			$PostQuestionObj = new DataTable(TABLE_BLOG_POST_QUESTIONS);
			$ParentID = (isset($_GET['ParentID']) && $_GET['ParentID'] > 0)?$_GET['ParentID']:0;
			$PostID = isset($_GET['PostID'])?$_GET['PostID']:0;
		
			$DataArray = array();
			$DataArray['PostID'] = $PostID;
			$DataArray['Active'] = isset($_POST['Active'])?$_POST['Active']:"0";
			$DataArray['Position'] = (isset($_POST['Position']) && $_POST['Position'] > 0)?$_POST['Position']:"0";
			$DataArray['Question'] = isset($_POST['Question'])?$_POST['Question']:"";
			$DataArray['Answer'] = isset($_POST['Answer'])?$_POST['Answer']:"";
			$DataArray['CName'] = isset($_POST['CName'])?$_POST['CName']:"";
			$DataArray['CEmail'] = isset($_POST['CEmail'])?$_POST['CEmail']:"";
			
			$PostQuestionObj->tableInsert($DataArray);
			$this->getSession()->setArrVar("alert",array("success","Question added successfully."));
			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=AddEditPost&ParentID=$ParentID&PostID=$PostID&tab=questions");
			exit;
		}
	}
	public function EditPostQuestionAction()
	{
		if(count($_POST)>0)
		{
			$PostQuestionObj = new DataTable(TABLE_BLOG_POST_QUESTIONS);
			$ParentID = (isset($_GET['ParentID']) && $_GET['ParentID'] > 0)?$_GET['ParentID']:0;
			$PostID = isset($_GET['PostID'])?$_GET['PostID']:0;
			$QuestionID = isset($_POST['QuestionID'])?$_POST['QuestionID']:0;


			$DataArray = array();
			$DataArray['Active'] = isset($_POST['Active'])?$_POST['Active']:"0";
			$DataArray['Position'] = (isset($_POST['Position']) && $_POST['Position'] > 0)?$_POST['Position']:"0";
			$DataArray['Question'] = isset($_POST['Question'])?$_POST['Question']:"";
			$DataArray['Answer'] = isset($_POST['Answer'])?$_POST['Answer']:"";
			$DataArray['CName'] = isset($_POST['CName'])?$_POST['CName']:"";
			$DataArray['CEmail'] = isset($_POST['CEmail'])?$_POST['CEmail']:"";
			
			$PostQuestionObj->where[] = array('=',array('QuestionID' => $QuestionID));
			$PostQuestionObj->tableUpdate($DataArray);
			$this->getSession()->setArrVar("alert",array("success","Question updated successfully."));
			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=AddEditPost&ParentID=$ParentID&PostID=$PostID&tab=questions");
			exit;
		}
	}
	
	public function DeletePostQuestionAction()
	{
		$QuestionID = isset($_GET['DeleteQuestion'])?$_GET['DeleteQuestion']:0;
		if($QuestionID > 0)
		{
			$PostQuestionObj = new DataTable(TABLE_BLOG_POST_QUESTIONS);
			$ParentID = (isset($_GET['ParentID']) && $_GET['ParentID'] > 0)?$_GET['ParentID']:0;
			$PostID = isset($_GET['PostID'])?$_GET['PostID']:0;
			
			$PostQuestionObj->where[] = array('=',array('QuestionID' => $QuestionID));
			$Obj = (object)$PostQuestionObj->tableSelectOne();
			
			$PostQuestionObj->where[] = array('=',array('QuestionID' => $QuestionID));
			$PostQuestionObj->tableDelete();
			
			$this->getSession()->setArrVar("alert",array("success","Question deleted successfully."));
			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=AddEditPost&ParentID=$ParentID&PostID=$PostID&tab=questions");
			exit;
		}
	}
	
	public function getPostQuestions($PostID)
	{
		if($PostID > 0)
		{
			$Obj = new DataTable(TABLE_BLOG_POST_QUESTIONS);
			$Obj->where[] = array('=',array('PostID' => $PostID));
			return $Obj->tableSelectAll(array("*"),array("Position ASC","QuestionID ASC"));;
		}
		return ;
	
	}
	/* post questions section end*/
		
	/* post additions section start*/
	
	public function UpdateAdditionalAction()
	{
		if(count($_POST)>0)
		{
			$ParentID = (isset($_GET['ParentID']) && $_GET['ParentID'] > 0)?$_GET['ParentID']:0;
			$PostID = isset($_GET['PostID'])?$_GET['PostID']:0;
			$AdditionID = isset($_POST['AdditionID'])?$_POST['AdditionID']:0;
			
			$PostAdditionObj = new DataTable(TABLE_BLOG_POST_ADDITIONS);
			$PostAdditionObj->where[] = array('=',array('PostID' => $PostID));
			$PostAdditionObj->tableDelete();
			
			if(isset($_POST['AttributeName']))
			{
				foreach ($_POST['AttributeName'] as $k=>$v)
				{
					foreach ($_POST['AttributeValue'][$k] as $kkk=>$vvv)
					{
						if(isset($_POST['AttributeValue'][$k][$kkk]) && $_POST['AttributeValue'][$k][$kkk] !="")
						{
							$PostAdditionObj = new DataTable(TABLE_BLOG_POST_ADDITIONS);
							$DataArray = array();
							$DataArray['PostID'] = $PostID;
							$DataArray['AttributeName'] = isset($_POST['AttributeName'][$k])?$_POST['AttributeName'][$k]:"";
							$DataArray['AttributeType'] = isset($_POST['AttributeType'][$k])?$_POST['AttributeType'][$k]:"";
							$DataArray['Position'] = (isset($_POST['Position'][$k]) && $_POST['Position'][$k] > 0)?$_POST['Position'][$k]:"0";
							
							$DataArray['AttributeValueSort'] = (isset($_POST['AttributeValueSort'][$k][$kkk]) && $_POST['AttributeValueSort'][$k][$kkk] > 0)?$_POST['AttributeValueSort'][$k][$kkk]:0;
							$DataArray['AttributeValue'] = isset($_POST['AttributeValue'][$k][$kkk])?$_POST['AttributeValue'][$k][$kkk]:"";
							$DataArray['ModelNo'] = (isset($_POST['ModelNo'][$k][$kkk]) && $_POST['ModelNo'][$k][$kkk] !="")?$_POST['ModelNo'][$k][$kkk]:"";
							$DataArray['NormalPrice'] = (isset($_POST['NormalPrice'][$k][$kkk]) && $_POST['NormalPrice'][$k][$kkk] !="")?$_POST['NormalPrice'][$k][$kkk]:0;
							$DataArray['Price'] = (isset($_POST['Price'][$k][$kkk]) && $_POST['Price'][$k][$kkk] >0)?$_POST['Price'][$k][$kkk]:0;
							$DataArray['PriceSet'] = isset($_POST['PriceSet'][$k][$kkk])?$_POST['PriceSet'][$k][$kkk]:"+";
							
							$DataArray['CreatedDate'] = date('Y-m-d H:i:s');
							$PostAdditionObj->tableInsert($DataArray);
							
							
						}
					}
					//echo "<br>---------<br>";
				}
			}
			$this->getSession()->setArrVar("alert",array("success","Attributes updated successfully."));
			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=AddEditPost&ParentID=$ParentID&PostID=$PostID&tab=additions");
			exit;
		}
	}
	
	
	
	public function getPostAdditions($PostID)
	{
		if($PostID > 0)
		{
			$Obj = new DataTable(TABLE_BLOG_POST_ADDITIONS);
			$Obj->where[] = array('=',array('PostID' => $PostID));
			$Obj->columnExpression = true;
			return $Obj->tableSelectAll(array("DISTINCT(AttributeName) as AttributeName","AttributeType as AttributeType","Position as Position"),array("Position ASC","PostAdditionID ASC"));;
	
		}
		return ;
	
	}
	public function getPostAdditionValues($PostID,$AttributeName)
	{
		if($PostID > 0)
		{
			$Obj = new DataTable(TABLE_BLOG_POST_ADDITIONS);
			$Obj->where[] = array('=',array('PostID' => $PostID));
			$Obj->where[] = array('=',array('AttributeName' => $AttributeName));
			return $Obj->tableSelectAll(array("*"),array("AttributeValueSort ASC","PostAdditionID ASC"));;
	
		}
		return ;
	
	}
	/* post additions section end*/
	
	/* post reviews section start*/
	public function AddPostReviewAction()
	{
		if(count($_POST)>0)
		{
			$PostReviewObj = new DataTable(TABLE_BLOG_POST_REVIEWS);
			$ParentID = (isset($_GET['ParentID']) && $_GET['ParentID'] > 0)?$_GET['ParentID']:0;
			$PostID = isset($_GET['PostID'])?$_GET['PostID']:0;
		
			$DataArray = array();
			$DataArray['PostID'] = $PostID;
			$DataArray['Active'] = isset($_POST['Active'])?$_POST['Active']:"0";
			$DataArray['Description'] = isset($_POST['Description'])?$_POST['Description']:"";
			$DataArray['Rating'] = (isset($_POST['Rating']) && $_POST['Rating'] > 0)?$_POST['Rating']:"0";
			$DataArray['CName'] = isset($_POST['CName'])?$_POST['CName']:"";
			$DataArray['CEmail'] = isset($_POST['CEmail'])?$_POST['CEmail']:"";
			
			$PostReviewObj->tableInsert($DataArray);
			$this->getSession()->setArrVar("alert",array("success","Review added successfully."));
			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=AddEditPost&ParentID=$ParentID&PostID=$PostID&tab=reviews");
			exit;
		}
	}
	public function EditPostReviewAction()
	{
		if(count($_POST)>0)
		{
			$PostReviewObj = new DataTable(TABLE_BLOG_POST_REVIEWS);
			$ParentID = (isset($_GET['ParentID']) && $_GET['ParentID'] > 0)?$_GET['ParentID']:0;
			$PostID = isset($_GET['PostID'])?$_GET['PostID']:0;
			$ReviewID = isset($_POST['ReviewID'])?$_POST['ReviewID']:0;


			$DataArray = array();
			$DataArray['Active'] = isset($_POST['Active'])?$_POST['Active']:"0";
			$DataArray['Description'] = isset($_POST['Description'])?$_POST['Description']:"";
			$DataArray['Rating'] = (isset($_POST['Rating']) && $_POST['Rating'] > 0)?$_POST['Rating']:"0";
			$DataArray['CName'] = isset($_POST['CName'])?$_POST['CName']:"";
			$DataArray['CEmail'] = isset($_POST['CEmail'])?$_POST['CEmail']:"";
			
			$PostReviewObj->where[] = array('=',array('ReviewID' => $ReviewID));
			$PostReviewObj->tableUpdate($DataArray);
			$this->getSession()->setArrVar("alert",array("success","Review updated successfully."));
			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=AddEditPost&ParentID=$ParentID&PostID=$PostID&tab=reviews");
			exit;
		}
	}
	
	public function DeletePostReviewAction()
	{
		$ReviewID = isset($_GET['DeleteReview'])?$_GET['DeleteReview']:0;
		if($ReviewID > 0)
		{
			$PostReviewObj = new DataTable(TABLE_BLOG_POST_REVIEWS);
			$ParentID = (isset($_GET['ParentID']) && $_GET['ParentID'] > 0)?$_GET['ParentID']:0;
			$PostID = isset($_GET['PostID'])?$_GET['PostID']:0;
			
			$PostReviewObj->where[] = array('=',array('ReviewID' => $ReviewID));
			$Obj = (object)$PostReviewObj->tableSelectOne();
			
			$PostReviewObj->where[] = array('=',array('ReviewID' => $ReviewID));
			$PostReviewObj->tableDelete();
			
			$this->getSession()->setArrVar("alert",array("success","Review deleted successfully."));
			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=AddEditPost&ParentID=$ParentID&PostID=$PostID&tab=reviews");
			exit;
		}
	}
	
	public function getPostReviews($PostID)
	{
		if($PostID > 0)
		{
			$Obj = new DataTable(TABLE_BLOG_POST_REVIEWS);
			$Obj->where[] = array('=',array('PostID' => $PostID));
			return $Obj->tableSelectAll(array("*"),array("ReviewID ASC"));;
		}
		return ;
	
	}
	/* post reviews section end*/
	
	/* post related section start*/
	public function UpdateRelatedAction()
	{
		$ParentID = (isset($_GET['ParentID']) && $_GET['ParentID'] > 0)?$_GET['ParentID']:0;
		$PostID = isset($_GET['PostID'])?$_GET['PostID']:0;
		
		if(count($_POST)>0)
		{
			$PostObj = new DataTable(TABLE_BLOG_POST);
			$PostRelatedObj = new DataTable(TABLE_BLOG_POST_RELATION);
			
			for ($i=1;$i <$_POST['Count'];$i++)
			{
				$id =$_POST['id_'.$i];
				$DataArray = array();
				$DataArray['SortOrder'] = (isset($_POST['Position_'.$i]) && $_POST['Position_'.$i] > 0)?$_POST['Position_'.$i]:0;
				$PostRelatedObj->where="id ='".(int)$id."'";
				$PostRelatedObj->tableUpdate($DataArray);
			}
			$this->getSession()->setArrVar("alert",array("success","Related post(s)  updated successfully."));
			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=AddEditPost&ParentID=$ParentID&PostID=$PostID&tab=related");
			exit;
		}
	}
	public function AddPostRelatedAction()
	{
		if(count($_POST)>0)
		{
			$ParentID = (isset($_GET['ParentID']) && $_GET['ParentID'] > 0)?$_GET['ParentID']:0;
			$PostID = isset($_GET['PostID'])?$_GET['PostID']:0;
		
			$postRelatedArray = $_POST["RelatedID"];
			if (count($postRelatedArray) >0)
			{
				foreach ($postRelatedArray as $value) {
					if(trim($value) != "")
					{
						$PostRelatedObj = new DataTable(TABLE_BLOG_POST_RELATION);
						$DataArray = array();
						$DataArray['PostID'] = $PostID;
						$DataArray['RelationID'] = $value;
						$DataArray['RelationType'] = "post_related";
						$DataArray['SortOrder'] = $this->getPostCommon()->SKMaxGetRelatedSortOrder($PostID,"post_related") + 1;
						$PostRelatedObj->tableInsert($DataArray);
					}
				}
			}
			
			$this->getSession()->setArrVar("alert",array("success","Related post(s)  added successfully."));
			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=AddEditPost&ParentID=$ParentID&PostID=$PostID&tab=related");
			exit;
		}
	}
	
	public function DeletePostRelatedAction()
	{
		$ParentID = (isset($_GET['ParentID']) && $_GET['ParentID'] > 0)?$_GET['ParentID']:0;
		$PostID = isset($_GET['PostID'])?$_GET['PostID']:0;
		$RelationID = isset($_GET['DeleteRelated'])?$_GET['DeleteRelated']:0;
		if($RelationID > 0)
		{
			$PostRelateObj = new DataTable(TABLE_BLOG_POST_RELATION);
			$PostRelateObj->where[] = array('=',array('RelationID' => $RelationID));
			$PostRelateObj->where[] = array('=',array('PostID' => $PostID));
			$PostRelateObj->where[] = array('=',array('RelationType' => 'post_related'));
			$PostRelateObj->tableDelete();
			
			$this->getSession()->setArrVar("alert",array("success","Relate deleted successfully."));
			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=AddEditPost&ParentID=$ParentID&PostID=$PostID&tab=related");
			exit;
		}
	}
	
	public function getPostRelated($PostID)
	{
		if($PostID > 0)
		{
			$Obj = new DataTable(array('p'=>TABLE_BLOG_POST));
			$Obj->joinExpression = true;
			$Obj->joinArray[] = array('name'=>array('ptc'=>TABLE_BLOG_POST_RELATION),
										  'on'=>"(ptc.RelationID=p.PostID and ptc.RelationType='post_related')",
										  'columns'=>array("id","RelationID","SortOrder"),
										  'type'=>''
										  );
										  
			$Obj->where[] = array('=',array('ptc.PostID' => $PostID));
			
			return $Obj->tableSelectAll(array("PostName"),array("SortOrder ASC"));									
			
		}
		return ;
	
	}
	/* post related section end*/
	
	/* post discounted section start*/
	public function UpdateWithDiscountedAction()
	{
		$ParentID = (isset($_GET['ParentID']) && $_GET['ParentID'] > 0)?$_GET['ParentID']:0;
		$PostID = isset($_GET['PostID'])?$_GET['PostID']:0;
		
		if(count($_POST)>0)
		{
			$PostObj = new DataTable(TABLE_BLOG_POST);
			$PostWithDiscountedObj = new DataTable(TABLE_BLOG_POST_RELATION);
			
			for ($i=1;$i <$_POST['Count'];$i++)
			{
				$id =$_POST['id_'.$i];
				$DataArray = array();
				$DataArray['Custom'] = (isset($_POST['Custom_'.$i]) && $_POST['Custom_'.$i] > 0)?$_POST['Custom_'.$i]:0;
				$DataArray['SortOrder'] = (isset($_POST['Position_'.$i]) && $_POST['Position_'.$i] > 0)?$_POST['Position_'.$i]:0;
				$PostWithDiscountedObj->where="id ='".(int)$id."'";
				$PostWithDiscountedObj->tableUpdate($DataArray);
			}
			$this->getSession()->setArrVar("alert",array("success","WithDiscounted post(s)  updated successfully."));
			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=AddEditPost&ParentID=$ParentID&PostID=$PostID&tab=discounted");
			exit;
		}
	}
	
	public function AddPostWithDiscountedAction()
	{
		if(count($_POST)>0)
		{
			$ParentID = (isset($_GET['ParentID']) && $_GET['ParentID'] > 0)?$_GET['ParentID']:0;
			$PostID = isset($_GET['PostID'])?$_GET['PostID']:0;
		
			$postWithDiscountedArray = $_POST["WithDiscountedID"];
			if (count($postWithDiscountedArray) >0)
			{
				foreach ($postWithDiscountedArray as $value) {
					if(trim($value) != "")
					{
						$PostWithDiscountedObj = new DataTable(TABLE_BLOG_POST_RELATION);
						$DataArray = array();
						$DataArray['PostID'] = $PostID;
						$DataArray['Custom'] = "0";
						$DataArray['RelationID'] = $value;
						$DataArray['RelationType'] = "post_discounted";
						$DataArray['SortOrder'] = $this->getPostCommon()->SKMaxGetWithDiscountedSortOrder($PostID,"post_discounted") + 1;
						$PostWithDiscountedObj->tableInsert($DataArray);
					}
				}
			}
			
			$this->getSession()->setArrVar("alert",array("success","Discounted post(s)  added successfully."));
			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=AddEditPost&ParentID=$ParentID&PostID=$PostID&tab=discounted");
			exit;
		}
	}
	
	public function DeletePostWithDiscountedAction()
	{
		$ParentID = (isset($_GET['ParentID']) && $_GET['ParentID'] > 0)?$_GET['ParentID']:0;
		$PostID = isset($_GET['PostID'])?$_GET['PostID']:0;
		$RelationID = isset($_GET['DeleteWithDiscounted'])?$_GET['DeleteWithDiscounted']:0;
		if($RelationID > 0)
		{
			$PostRelateObj = new DataTable(TABLE_BLOG_POST_RELATION);
			$PostRelateObj->where[] = array('=',array('RelationID' => $RelationID));
			$PostRelateObj->where[] = array('=',array('PostID' => $PostID));
			$PostRelateObj->where[] = array('=',array('RelationType' => 'post_discounted'));
			$PostRelateObj->tableDelete();
			
			$this->getSession()->setArrVar("alert",array("success","Discounted deleted successfully."));
			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=AddEditPost&ParentID=$ParentID&PostID=$PostID&tab=discounted");
			exit;
		}
	}
	
	public function getPostWithDiscounted($PostID)
	{
		if($PostID > 0)
		{
			$Obj = new DataTable(array('p'=>TABLE_BLOG_POST));
			$Obj->joinExpression = true;
			$Obj->joinArray[] = array('name'=>array('ptc'=>TABLE_BLOG_POST_RELATION),
										  'on'=>"(ptc.RelationID=p.PostID and ptc.RelationType='post_discounted')",
										  'columns'=>array("id","RelationID","Custom","SortOrder"),
										  'type'=>''
										  );
										  
			$Obj->where[] = array('=',array('ptc.PostID' => $PostID));
			
			return $Obj->tableSelectAll(array("PostName"),array("SortOrder ASC"));									
			
		}
		return ;
	
	}
	/* post discounted section end*/
	
	public function getList()
	{
		$ParentID = (isset($_GET['ParentID']) && $_GET['ParentID'] > 0)?$_GET['ParentID']:0;
		$Keyword = isset($_REQUEST['k'])?$_REQUEST['k']:"";
		$KeywordArr =  explode(" ",$Keyword);
		
		$where = new Where();
		
		if($ParentID > 0)
		{
			$orderBy = (isset($_REQUEST['orderBy']) && $_REQUEST['orderBy'] != "")?$_REQUEST['orderBy']:"SortOrder ASC";
			$PostObj = new DataTable(array('p'=>TABLE_BLOG_POST));
			$where->notEqualTo('p.PostType','Child');
			$where->equalTo('ptc.RelationID',$ParentID);
			
			$PostObj->joinExpression = true;
			$PostObj->joinArray[] = array('name'=>array('ptc'=>TABLE_BLOG_POST_RELATION),
										  'on'=>"(ptc.PostID=p.PostID and ptc.RelationType='blog_category')",
										  'columns'=>array("RelationID","SortOrder"),
										  'type'=>''
										  );
		}
		else
		{
			$orderBy = (isset($_REQUEST['orderBy']) && $_REQUEST['orderBy'] != "")?$_REQUEST['orderBy']:"p.PostID DESC";
			$PostObj = new DataTable(array('p'=>TABLE_BLOG_POST));
			$where->notEqualTo('p.PostType','Child');
			$PostObj->where = "p.PostType != 'Child'  AND PostID NOT IN (select PostID from ".TABLE_BLOG_POST_RELATION. " where RelationType='blog_category')";
			
		}
		
		if(count($KeywordArr) > 0 && $Keyword != "")
		{
			foreach ($KeywordArr as $Key=>$Value)
			{
				if($Value != "")
				{
					$where->NEST//start braket
							->like('p.PostID','%'.$Value.'%')->OR
							->like('p.PostName','%'.$Value.'%')->OR
							->like('p.ModelNo','%'.$Value.'%')->OR
							->like('p.PostLine','%'.$Value.'%')->OR
							->UNNEST;
				}
			}
		}
		$PostObj->where = $where;
		
		//$PostObj->displayQuery = true;
		$PostObj->AllowPaging =true;
		$PostObj->PageSize=25;
		$PostObj->PageTotalDisplay = 15; 
		$PostObj->PageNo =isset($_GET['PageNo'])?$_GET['PageNo']:1;	
		$this->paging = $PostObj;
		
		return $PostObj->tableSelectAll(array("*"),array($orderBy));
	
	}
	
	public function getFeaturedList()
	{
		
		$PostObj = new DataTable(array('p'=>TABLE_BLOG_POST));
		$PostObj->where = "p.PostType != 'Child'  AND Featured ='1'";
		return $PostObj->tableSelectAll(array("PostID","Image","PostName"),array("PostID DESC"));
	
	}

	
	public function getPostAllList()
	{
		$orderBy = (isset($_REQUEST['orderBy']) && $_REQUEST['orderBy'] != "")?$_REQUEST['orderBy']:"PostID DESC";
		$Keyword = isset($_REQUEST['k'])?$_REQUEST['k']:"";
		$KeywordArr =  explode(" ",$Keyword);
		
		$where = new Where();
		$PostObj = new DataTable(array('p'=>TABLE_BLOG_POST));
		//$where->notEqualTo('p.PostType','Child');
		//$where->equalTo('p.VIPStatus',"1");
		
		if(count($KeywordArr) > 0 && $Keyword != "")
		{
			foreach ($KeywordArr as $Key=>$Value)
			{
				if($Value != "")
				{
					$where->NEST//start braket
							->like('PostID','%'.$Value.'%')->OR
							->like('PostName','%'.$Value.'%')->OR
							->like('PostLine','%'.$Value.'%')->OR
							->UNNEST;
				}
			}
		}
		$PostObj->where = $where;
		
		//$PostObj->displayQuery = true;
		$PostObj->AllowPaging =true;
		$PostObj->PageSize=25;
		$PostObj->PageTotalDisplay = 15; 
		$PostObj->PageNo =isset($_GET['PageNo'])?$_GET['PageNo']:1;	
		$this->paging = $PostObj;
		return $PostObj->tableSelectAll(array("*"),array($orderBy));
	
	}
	
	public function BulkReviewsAction()
	{
		if(count($_POST) > 0){
			/* EnableClick button start*/
			if(isset($_POST['EnableClick']) && $_POST['EnableClick']=="1"){
				foreach($_POST['ReviewIDArr'] as $ReviewID){
					
					$PostReviewObj = new DataTable(TABLE_BLOG_POST_REVIEWS);
					$DataArray = array();
					$DataArray['Active'] = "1";
					$PostReviewObj->where[] = array('=',array('ReviewID' => $ReviewID));
					$PostReviewObj->tableUpdate($DataArray);
				}
			}
			/* EnableClick button end*/
			/* DisableClick button start*/
			if(isset($_POST['DisableClick']) && $_POST['DisableClick']=="1"){
				foreach($_POST['ReviewIDArr'] as $ReviewID){
					
					$PostReviewObj = new DataTable(TABLE_BLOG_POST_REVIEWS);
					$DataArray = array();
					$DataArray['Active'] = "0";
					$PostReviewObj->where[] = array('=',array('ReviewID' => $ReviewID));
					$PostReviewObj->tableUpdate($DataArray);
				}
			}
			/* DisableClick button end*/
			
			/* DisableClick button start*/
			if(isset($_POST['DeleteClick']) && $_POST['DeleteClick']=="1"){
				foreach($_POST['ReviewIDArr'] as $ReviewID){
					if($ReviewID > 0){
						$PostReviewObj = new DataTable(TABLE_BLOG_POST_REVIEWS);
						$PostReviewObj->where[] = array('=',array('ReviewID' => $ReviewID));
						$PostReviewObj->tableDelete();
					}
				}
			}
			/* DisableClick button end*/
		
		$this->getSession()->setArrVar("alert",array("success","Reviews(s)  updated successfully."));
		MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=".$this->view."&k=".$this->origin->k."&orderBy=".$this->origin->orderBy);
		exit;	
		}
		
		
	}
	public function getPostReviewsList()
	{
		$orderBy = (isset($_REQUEST['orderBy']) && $_REQUEST['orderBy'] != "")?$_REQUEST['orderBy']:"pr.ReviewID DESC";
		$Keyword = isset($_REQUEST['k'])?$_REQUEST['k']:"";
		$KeywordArr =  explode(" ",$Keyword);
		
		$where = new Where();
		$PostReviewObj = new DataTable(array('pr'=>TABLE_BLOG_POST_REVIEWS));
		$where->notEqualTo('p.PostType','Child');
		
		$PostReviewObj->joinArray[] = array('name'=>array('p'=>TABLE_BLOG_POST),
									  'on'=>"(pr.PostID=p.PostID)",
									  'columns'=>array("PostID","PostName","ModelNo","Stock","StockTotal","StockStatus","PostPoints"),
									  'type'=>''
									  );
									  
		if(count($KeywordArr) > 0 && $Keyword != "")
		{
			foreach ($KeywordArr as $Key=>$Value)
			{
				if($Value != "")
				{
					$where->NEST//start braket
							->like('p.PostID','%'.$Value.'%')->OR
							->like('p.PostName','%'.$Value.'%')->OR
							->like('p.ModelNo','%'.$Value.'%')->OR
							->like('p.PostLine','%'.$Value.'%')->OR
							->like('pr.CName','%'.$Value.'%')->OR
							->like('pr.CEmail','%'.$Value.'%')->OR
							->like('pr.Description','%'.$Value.'%')->OR
							->UNNEST;
				}
			}
		}
		$PostReviewObj->where = $where;
		
		//$PostReviewObj->displayQuery = true;
		$PostReviewObj->AllowPaging =true;
		$PostReviewObj->PageSize=25;
		$PostReviewObj->PageTotalDisplay = 15; 
		$PostReviewObj->PageNo =isset($_GET['PageNo'])?$_GET['PageNo']:1;	
		$this->paging = $PostReviewObj;
		return $PostReviewObj->tableSelectAll(array("*"),array($orderBy));
	
	}
	
	
	public function BulkQuestionsAction()
	{
		if(count($_POST) > 0){
			/* EnableClick button start*/
			if(isset($_POST['EnableClick']) && $_POST['EnableClick']=="1"){
				foreach($_POST['QuestionIDArr'] as $QuestionID){
					
					$PostQuestionObj = new DataTable(TABLE_BLOG_POST_QUESTIONS);
					$DataArray = array();
					$DataArray['Active'] = "1";
					$PostQuestionObj->where[] = array('=',array('QuestionID' => $QuestionID));
					$PostQuestionObj->tableUpdate($DataArray);
				}
			}
			/* EnableClick button end*/
			/* DisableClick button start*/
			if(isset($_POST['DisableClick']) && $_POST['DisableClick']=="1"){
				foreach($_POST['QuestionIDArr'] as $QuestionID){
					
					$PostQuestionObj = new DataTable(TABLE_BLOG_POST_QUESTIONS);
					$DataArray = array();
					$DataArray['Active'] = "0";
					$PostQuestionObj->where[] = array('=',array('QuestionID' => $QuestionID));
					$PostQuestionObj->tableUpdate($DataArray);
				}
			}
			/* DisableClick button end*/
			
			/* DisableClick button start*/
			if(isset($_POST['DeleteClick']) && $_POST['DeleteClick']=="1"){
				foreach($_POST['QuestionIDArr'] as $QuestionID){
					if($QuestionID > 0){
						$PostQuestionObj = new DataTable(TABLE_BLOG_POST_QUESTIONS);
						$PostQuestionObj->where[] = array('=',array('QuestionID' => $QuestionID));
						$PostQuestionObj->tableDelete();
					}
				}
			}
			/* DisableClick button end*/
		
		$this->getSession()->setArrVar("alert",array("success","Questions(s)  updated successfully."));
		MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=".$this->view."&k=".$this->origin->k."&orderBy=".$this->origin->orderBy);
		exit;	
		}
		
		
	}
	
	public function getPostQuestionsList()
	{
		$orderBy = (isset($_REQUEST['orderBy']) && $_REQUEST['orderBy'] != "")?$_REQUEST['orderBy']:"pq.QuestionID DESC";
		$Keyword = isset($_REQUEST['k'])?$_REQUEST['k']:"";
		$KeywordArr =  explode(" ",$Keyword);
		
		$where = new Where();
		$PostQuestionObj = new DataTable(array('pq'=>TABLE_BLOG_POST_QUESTIONS));
		$where->notEqualTo('p.PostType','Child');
		
		$PostQuestionObj->joinArray[] = array('name'=>array('p'=>TABLE_BLOG_POST),
									  'on'=>"(pq.PostID=p.PostID)",
									  'columns'=>array("PostID","PostName","ModelNo","Stock","StockTotal","StockStatus","PostPoints"),
									  'type'=>''
									  );
									  
		if(count($KeywordArr) > 0 && $Keyword != "")
		{
			foreach ($KeywordArr as $Key=>$Value)
			{
				if($Value != "")
				{
					$where->NEST//start braket
							->like('p.PostID','%'.$Value.'%')->OR
							->like('p.PostName','%'.$Value.'%')->OR
							->like('p.ModelNo','%'.$Value.'%')->OR
							->like('p.PostLine','%'.$Value.'%')->OR
							->like('pq.CName','%'.$Value.'%')->OR
							->like('pq.CEmail','%'.$Value.'%')->OR
							->like('pq.Question','%'.$Value.'%')->OR
							->like('pq.Answer','%'.$Value.'%')->OR
							->UNNEST;
				}
			}
		}
		$PostQuestionObj->where = $where;
		
		//$PostQuestionObj->displayQuery = true;
		$PostQuestionObj->AllowPaging =true;
		$PostQuestionObj->PageSize=25;
		$PostQuestionObj->PageTotalDisplay = 15; 
		$PostQuestionObj->PageNo =isset($_GET['PageNo'])?$_GET['PageNo']:1;	
		$this->paging = $PostQuestionObj;
		return $PostQuestionObj->tableSelectAll(array("*"),array($orderBy));
	
	}
	
	public function AddPostFeaturedAction()
	{
		if(count($_POST)>0)
		{
			
			$postArray = $_POST["FeaturedID"];
			if (count($postArray) >0)
			{
				foreach ($postArray as $PostID) {
					if(trim($PostID) != "")
					{
						$PostObj = new DataTable(TABLE_BLOG_POST);
						$DataArray = array();
						$DataArray['Featured'] = "1";
						$PostObj->where="PostID ='".(int)$PostID."'";
						$PostObj->tableUpdate($DataArray);
						
					}
				}
			}
			
			$this->getSession()->setArrVar("alert",array("success","Featured post(s)  added successfully."));
			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=FeaturedPosts");
			exit;
		}
	}
	public function DeletePostFeaturedDeleteAction()
	{
			$PostID = (isset($_GET['FeaturedID']) && $_GET['FeaturedID'] > 0)?$_GET['FeaturedID']:0;
			if(trim($PostID) != "")
			{
				$PostObj = new DataTable(TABLE_BLOG_POST);
				$DataArray = array();
				$DataArray['Featured'] = "0";
				$PostObj->where="PostID ='".(int)$PostID."'";
				$PostObj->tableUpdate($DataArray);
				
			}
			$this->getSession()->setArrVar("alert",array("success","Featured post(s)  removed successfully."));
			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=FeaturedPosts");
			exit;
		
	}

	
	
	public function getHomepageList()
	{
		
		/*
		$PostObj = new DataTable(array('p'=>TABLE_BLOG_POST));
		$PostObj->where = "p.PostType != 'Child'  AND Homepage ='1'";
		return $PostObj->tableSelectAll(array("PostID","PostName"),array("PostID DESC"));
		*/
		$where = new Where();
		$PostObj = new DataTable(array('p'=>TABLE_BLOG_POST));
		$where->notEqualTo('p.PostType','Child');
		$where->equalTo('ptc.RelationID','0');
		$PostObj->where = $where;
	
		$PostObj->joinExpression = true;
		$PostObj->joinArray[] = array('name'=>array('ptc'=>TABLE_BLOG_POST_RELATION),
									  'on'=>"(ptc.PostID=p.PostID and ptc.RelationType='Homepage')",
									  'columns'=>array("RelationID","SortOrder","Custom"),
									  'type'=>''
									  );
		//$PostObj->displayQuery =true;
		return $PostObj->tableSelectAll(array("PostID","Image","PostName"),array("ptc.SortOrder ASC","p.PostID DESC"));
	
	}
	
	public function AddPostHomepageAction()
	{
		if(count($_POST)>0)
		{
			
			$postArray = $_POST["HomepageID"];
			if (count($postArray) >0)
			{
				foreach ($postArray as $PostID) {
					if(trim($PostID) != "")
					{
						
						$PostRelationObj = new DataTable(TABLE_BLOG_POST_RELATION);
						$PostRelationObj->where = array(array('=',array('RelationType' => 'Homepage')),
																  array('=',array('PostID' => $PostID)),
																  array('=',array('RelationID' => '0'))											  
																  );
						$CObj = (object)$PostRelationObj->tableSelectOne(array("id"));
						if(!isset($CObj->id)){
							
							$DataArray = array();
							$DataArray['PostID'] = $PostID;
							$DataArray['RelationID'] = '0';
							$DataArray['Custom'] = '1';
							$DataArray['RelationType'] = "Homepage";
							$DataArray['SortOrder'] = $this->getPostCommon()->SKMaxGetPostSortOrder('0',"Homepage") + 1;
							$PostRelationObj->tableInsert($DataArray);
							
						}
						
					}
				}
			}
			
			$this->getSession()->setArrVar("alert",array("success","Homepage post(s)  added successfully."));
			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=HomepagePosts");
			exit;
		}
		
	}
	public function DeletePostHomepageDeleteAction()
	{
		$PostID = (isset($_GET['HomepageID']) && $_GET['HomepageID'] > 0)?$_GET['HomepageID']:0;
		if(trim($PostID) != "")
		{
			$PostRelationObj = new DataTable(TABLE_BLOG_POST_RELATION);
			$PostRelationObj->where = array(array('=',array('RelationType' => 'Homepage')),
													  array('=',array('PostID' => $PostID)),
													  array('=',array('RelationID' => '0'))											  
													  );
			$PostRelationObj->tableDelete();
		}
		$this->getSession()->setArrVar("alert",array("success","Homepage post(s)  removed successfully."));
		MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&view=HomepagePosts");
		exit;
		
	}
	
	
	public function getDetail($PostID)
	{
		$ParentID = (isset($_GET['ParentID']) && $_GET['ParentID'] > 0)?$_GET['ParentID']:0;
		if($PostID > 0)
		{
			$PostObj = new DataTable(array('p'=>TABLE_BLOG_POST));
			$PostCategoryObj2 = new DataTable(TABLE_BLOG_POST_RELATION);
			$PostObj->where[] = array('=',array('p.PostID' => $PostID));
			$PostObj->joinExpression = true;
			$PostObj->joinArray[] = array('name'=>array('s'=>TABLE_SEO),
										  'on'=>"(s.ReferenceID = p.PostID AND s.MCode='blog_post')",
										  'columns'=>array("*"),
										  'type'=>"left",
										  );
						
			
			$PostCategoryObj2->where ="RelationType ='blog_category' AND PostID='".(int)$PostID."'";
			$categoryRows = $PostCategoryObj2->tableSelectAll();
			$PostCatgoryArr = array();
			foreach($categoryRows as $CategoryTmp)
			{
				$PostCatgoryArr[] = $CategoryTmp->RelationID;
				if($ParentID ==0)
				 $ParentID = $CategoryTmp->RelationID;
			}
			$this->PostCatgoryArr = $PostCatgoryArr;
			return (object)$PostObj->tableSelectOne();
		}
		else{
			$PostCatgoryArr = array();
			$PostCatgoryArr[] = $ParentID;
			$this->PostCatgoryArr = $PostCatgoryArr;
		}
	
		return ;
	
	}
	
	public function imagePost($Image)
	{
		if(isset($Image) && $Image !="" && file_exists(DIR_FS_SITE_UPLOADS."post/".$Image))
			return DIR_FS_SITE_UPLOADS."post/".$Image;
		
		return false;
	}
	
	public function imagePostURL($Image)
	{
		if(isset($Image) && $Image !="" && file_exists(DIR_FS_SITE_UPLOADS."post/".$Image))
			return DIR_WS_SITE_UPLOADS."post/".$Image;
		
		return false;
	}
	
	public function pageTitle()
	{
		return "Post";
	}
	
	public function pageRight()
	{
		$Html = '<div class="title_right">
					<div class="pull-right">';
		if(isset($_GET['PostID']) && $_GET['PostID'] > 0)						
			$Html .= '  <a  href="'.DIR_WS_SITE_CONTROL.'index.php?m='.$this->module.'&ParentID='.$this->origin->ParentID.'&PostID='.$this->origin->PostID.'&rview='.$this->origin->rview.'&view=DeletePost" data-type="iframe" data-title="DELETE Post" class="sk_modal btn btn-danger">Delete Post</a>';

		$Html .= '    <a class="btn btn-primary" href="'.DIR_WS_SITE_CONTROL.'index.php?m='.$this->module.'&ParentID='.$this->origin->ParentID.'&view=AddEditPost">Add Post</a>
					</div>
              </div>		
			   ';
			   
		return $Html;	   
	}
	
	
}	