<?php 
namespace Blog\Category\Front\Controller;
use Frontend\Base\AbstractModule;
use Base\Db\DataTable as DataTable;
use Blog\Category\Common as CategoryCommon;
use Blog\Post\Common as PostCommon;

use Laminas\Db\Sql\Where;

class IndexController extends AbstractModule
{
	var $currentObj = false; 
	var $onlyFile = true; 
	var $onlyPost = false; 
	function __construct()
	{
		
	}
	
	public function getCategoryCommon()
	{
		$obj = new CategoryCommon();
		return $obj;
	}
	
	public function getPostCommon()
	{
		$obj = new PostCommon();
		return $obj;
	}
	
	function settings()
	{
		$arr = $this->moduleParam;
		if($arr['ID'] && $arr['ID'] != "")
		{
			$MainObj = new DataTable(array('m'=>TABLE_BLOG_CATEGORY));
			$MainObj->where[] = array('=',array('m.CategoryID' => $arr['ID']));
			$MainObj->where[] = array('=',array('m.Active' => "1"));
			$MainObj->joinExpression = true;
			$MainObj->joinArray[] = array('name'=>array('s'=>TABLE_SEO),
										  'on'=>"(s.ReferenceID = m.CategoryID AND s.MCode='blog_category')",
										  'columns'=>array("*"),
										  'type'=>"left",
										  );
										  
			$obj = (object)$MainObj->tableSelectOne();
			if(isset($obj->CategoryID))
			{
					/*
					if($obj->Template != ""){
						$this->origin->setView($obj->Template);
						$this->onlyFile = true;
					}
					*/					
											
					$this->setCurrentObj($obj);
					$this->origin->setMetaTitle($obj->MetaTitle); 	
					$this->origin->setMetaKeywords($obj->MetaKeyword); 	
					$this->origin->setMetaDescription($obj->MetaDescription); 	
					
			}
			
		}
	}
	
	public function getSubCategory($CategoryID)
	{
		$CategoryObj = new DataTable(TABLE_BLOG_CATEGORY);
		$CategoryObj->where[] = array('=',array('ParentID' => $CategoryID));
		$CategoryObj->where[] = array('=',array('Active' => "1"));
		return $CategoryObj->tableSelectAll(array("*"),"Position ASC");
	}
	public function getPostlist($CategoryID)
	{
		$ps = (isset($_GET['ps']) && $_GET['ps'] > 0)?(int)$_GET['ps']:"16";
		$sb = isset($_GET['sb'])?$_GET['sb']:"00";
		$Keyword = isset($_REQUEST['k'])?$_REQUEST['k']:"";
		$KeywordArr =  explode(" ",$Keyword);
		$OrderBy = "ptc.SortOrder ASC,p.CreatedDate DESC";
		$SortByArray = $this->getSortByArray();
		
		if(isset($SortByArray[$sb]['column']) && $SortByArray[$sb]['column'] != "")
			$OrderBy = $SortByArray[$sb]['column'];

		
		$where = new Where();
		$PostObj = new DataTable(array('p'=>TABLE_BLOG_POST));
		$where->notEqualTo('p.PostType','Child');
		$where->equalTo('ptc.RelationID',$CategoryID);
		$where->equalTo('p.Active',"1");
		
		if(count($KeywordArr) > 0 && $Keyword != "")
		{
			foreach ($KeywordArr as $Key=>$Value)
			{
				$where->NEST//start braket
						->like('PostName','%'.$Value.'%')->OR
						->like('PostLine','%'.$Value.'%')->OR
						->UNNEST;
			}
		}
		$PostObj->where = $where;
	
		$PostObj->joinExpression = true;
		$PostObj->joinArray[] = array('name'=>array('ptc'=>TABLE_BLOG_POST_RELATION),
									  'on'=>"(ptc.PostID=p.PostID and ptc.RelationType='blog_category')",
									  'columns'=>array("RelationID","SortOrder"),
									  'type'=>''
									  );
		//$PostObj->displayQuery =true;
		$PostObj->AllowPaging =true;
		if(isset($_GET['ps']) && $_GET['ps']=="ALL")
			$PostObj->AllowPaging =false;
			
		$PostObj->PageSize=$ps;
		$PostObj->PagingPrefix="";
		$PostObj->PageTotalDisplay = 10; 
		$PostObj->PageNo =isset($_GET['PageNo'])?(int)abs($_GET['PageNo']):1;	
		$this->paging = $PostObj;
		$PostObj->orderExpression=true;
		return $PostObj->tableSelectAll(array("*"),$OrderBy);
			 
	}
	
	public function getSortByArray()
	{
		return  array(
					"00"=>array("display"=>"Default","column"=>"p.Position ASC","p.CreatedDate DESC"),
					"11"=>array("display"=>"Name (A - Z)","column"=>"p.PostName ASC"),
					"12"=>array("display"=>"Name (Z - A)","column"=>"p.PostName DESC"),
					"31"=>array("display"=>"Date (Latest)","column"=>"p.CreatedDate DESC"),
					"32"=>array("display"=>"Date (Oldest)","column"=>"p.CreatedDate ASC"),
					);
	}
	public function subCategoryCount($CategoryID)
	{
		$CategoryObj = new DataTable(TABLE_BLOG_CATEGORY);
		$CategoryObj->where[] = array('=',array('ParentID' => $CategoryID));
		$CategoryObj->where[] = array('=',array('Active' => "1"));
		$CategoryObj->columnExpression=true;
		$Obj = $CategoryObj->tableSelectOne(array('Total'=>'Count(*)'));
		return $Obj['Total'] > 0?$Obj['Total']:0;
	}
	
	function setCurrentObj($obj)
	{
		$this->currentObj = $obj;
	}
	
	function pageTitle()
	{
		return '';
	}
	function getCurrentObj()
	{
		return $this->currentObj;
	}
	
	
}	