<?php 
namespace Blog\Category\Admin\Controller;
use WebsiteControl\Base\AbstractModule;
use Base\Db\DataTable as DataTable;
use Blog\Category\Common as Common;

class IndexController extends AbstractModule
{
	function __construct()
	{
		
	}
	public function getCommon()
	{
		$obj = new Common();
		return $obj;
	}
	
	public function AddEditCategoryAction()
	{
		if(count($_POST)>0)
		{
			$CategoryObj = new DataTable(TABLE_BLOG_CATEGORY);
			$SeoObj = new DataTable(TABLE_SEO);
			$ParentID = (isset($_GET['ParentID']) && $_GET['ParentID'] > 0)?$_GET['ParentID']:0;
			$CategoryID = isset($_GET['CategoryID'])?$_GET['CategoryID']:0;


			$DataArray = array();
			$DataArray['ParentID'] =$ParentID;
			$DataArray['Active'] = isset($_POST['Active'])?$_POST['Active']:0;
			$DataArray['Featured'] = isset($_POST['Featured'])?$_POST['Featured']:0;
			
			$DataArray['CategoryName'] = isset($_POST['CategoryName'])?$_POST['CategoryName']:"";
			$DataArray['CategoryTitle'] = isset($_POST['CategoryTitle'])?$_POST['CategoryTitle']:"";
			$DataArray['CategoryLine'] = isset($_POST['CategoryLine'])?$_POST['CategoryLine']:"";
			
			if(isset($_POST['Template']) && $_POST['Template'] !="")
				$DataArray['Template'] = $_POST['Template'];
			
			$DataArray['Description'] = isset($_POST['Description'])?$_POST['Description']:"";
			$DataArray['UpperBanner1'] = (isset($_POST['UpperBanner1']) && $_POST['UpperBanner1'] !="")?implode(",",$_POST['UpperBanner1']):"";
			
			/* category image added*/
			if(isset($_POST['CategoryImage']) && $_POST['CategoryImage'] !="" && file_exists(DIR_FS_SITE_UPLOADS."category/".$_POST['CategoryImage']))
			{
				if(isset($_POST['CategoryImageDelete']) && $_POST['CategoryImageDelete'] == "1")
				{
					@unlink(DIR_FS_SITE_UPLOADS."category/".$_POST['CategoryImage']);
				}
				
			}
			if(isset($_FILES['Upload']) && $_FILES['Upload']['name'] !="")
			{
				$ArrayType = explode(".",$_FILES['Upload']['name']);
				$Type=$ArrayType[count($ArrayType)-1];
				
				$ImageName = uniqid(substr($DataArray['URLName'],0,5)."_").".".$Type;				
				$OriginalImage =DIR_FS_SITE_UPLOADS."category/".$ImageName;
				copy($_FILES['Upload']['tmp_name'],$OriginalImage);
				$DataArray['Image'] = $ImageName;
		
				if(isset($_POST['CategoryImage']) && $_POST['CategoryImage'] !="" && file_exists(DIR_FS_SITE_UPLOADS."category/".$_POST['CategoryImage']))
					@unlink(DIR_FS_SITE_UPLOADS."category/".$_POST['CategoryImage']);
			}
			/* category image added end*/	
			
			if($CategoryID > 0)
			{
				
				$CategoryObj->where[] = array('=',array('CategoryID' => $CategoryID));
				$CategoryObj->tableUpdate($DataArray);
				$this->getSession()->setArrVar("alert",array("success","Category updated successfully."));
				
			}
			else 
			{
							
				$CategoryObj->where ="ParentID='".$ParentID."'";
				$Position = $CategoryObj->getMax("Position") + 1;
				
				$DataArray['Position'] = $Position;
				$DataArray['CreatedDate'] =date('Y-m-d H:i:s');
				
				$CategoryID = $CategoryObj->tableInsert($DataArray);		
				$this->getSession()->setArrVar("alert",array("success","Category added successfully."));
				
			}
			
			$SeoObj->where = "ReferenceID = ".$CategoryID." AND MCode ='blog_category' AND MView ='Detail'";
			$CurrentSEO = (object)$SeoObj->tableSelectOne(array("ReferenceID"));
			
			$DataArray = array();
			$DataArray['URLName'] = SkURLCreate((isset($_POST['URLName']) && $_POST['URLName'] !="")?$_POST['URLName']:$_POST['CategoryName']);
			$DataArray['RedirectEnabled'] = isset($_POST['RedirectEnabled'])?$_POST['RedirectEnabled']:0;
			$DataArray['RedirectURL'] = isset($_POST['RedirectURL'])?$_POST['RedirectURL']:"";
			
			if(@constant("DEFINE_SEO_META_ACTIVE") =="1")
			{
				$DataArray['MetaTitle'] = isset($_POST['MetaTitle'])?$_POST['MetaTitle']:"";
				$DataArray['MetaKeyword'] = isset($_POST['MetaKeyword'])?$_POST['MetaKeyword']:"";
				$DataArray['MetaDescription'] = isset($_POST['MetaDescription'])?$_POST['MetaDescription']:"";
			}
			
			if(isset($CurrentSEO->ReferenceID) && $CurrentSEO->ReferenceID !="")
			{
				$SeoObj->tableUpdate($DataArray);
			}
			else 
			{
				$DataArray['MCode'] = "blog_category";
				$DataArray['MView'] = "Detail";
				$DataArray['ReferenceID'] = $CategoryID;
				$SeoObj->tableInsert($DataArray);
			}
					

			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&ParentID=$ParentID");
		    exit;
		}
		
	}
	public function UpdateCategoryAction()
	{
		$ParentID = (isset($_GET['ParentID']) && $_GET['ParentID'] > 0)?$_GET['ParentID']:0;
		if(count($_POST)>0)
		{
			$CategoryObj = new DataTable(TABLE_BLOG_CATEGORY);
			for ($i=1;$i <$_POST['Count'];$i++)
			{
				$CategoryID =$_POST['CategoryID_'.$i];
				$DataArray = array();
				$DataArray['Active'] = isset($_POST['Active_'.$i])?$_POST['Active_'.$i]:0;
				$DataArray['Featured'] = isset($_POST['Featured_'.$i])?$_POST['Featured_'.$i]:0;
				$DataArray['Position'] = isset($_POST['Position_'.$i])?$_POST['Position_'.$i]:0;
				$CategoryObj->where="CategoryID ='".(int)$CategoryID."'";
				$CategoryObj->tableUpdate($DataArray);
				
			}
			
		  	$this->getSession()->setArrVar("alert",array("success","Category updated successfully."));
			MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&ParentID=$ParentID");
			 exit;
		}
	}
	
	public function DeleteCategoryAction()
	{
		$CategoryID = isset($_GET['CategoryID'])?$_GET['CategoryID']:0;
		if($CategoryID > 0)
		{
			$Obj = $this->getDetail($CategoryID);
			$CategoryObj = new DataTable(TABLE_BLOG_CATEGORY);
			$CategoryObj->where[] = array('=',array('CategoryID' => $CategoryID));
			$CategoryObj->tableDelete();	

			if(isset($Obj->Image) && $Obj->Image !="" && file_exists(DIR_FS_SITE_UPLOADS."category/".$Obj->Image))
					@unlink(DIR_FS_SITE_UPLOADS."category/".$Obj->Image);		
			
			$SeoObj = new DataTable(TABLE_SEO);
			$SeoObj->where = "ReferenceID = ".$CategoryID." AND MCode ='blog_category' ";
			$SeoObj->tableDelete();	

			$PostCategoryObj = new DataTable(TABLE_BLOG_POST_RELATION);
			$PostCategoryObj->where="Relationtype='blog_category' AND RelationID ='".(int)$CategoryID."'";
			$PostCategoryObj->tableDelete();
			
		}			
		
		$this->getSession()->setArrVar("alert",array("success","Category deleted successfully."));
		MyRedirect(DIR_WS_SITE_CONTROL."index.php?m=".$this->module."&ParentID=".$this->origin->ParentID);
		 exit;
	}
	public function getList()
	{
		$ParentID = (isset($_GET['ParentID']) && $_GET['ParentID'] > 0)?$_GET['ParentID']:0;
		$CategoryObj = new DataTable(TABLE_BLOG_CATEGORY);
		$CategoryObj->where="ParentID ='".(int)$ParentID."'";
		return $CategoryObj->tableSelectAll(array("*"),"Position ASC");
	
	}
	
	public function subCategoryCount($CategoryID)
	{
		$CategoryObj = new DataTable(TABLE_BLOG_CATEGORY);
		$CategoryObj->where="ParentID ='".(int)$CategoryID."'";
		$CategoryObj->columnExpression=true;
		$Obj = $CategoryObj->tableSelectOne(array('Total'=>'Count(*)'));
		
		return $Obj['Total'] > 0?$Obj['Total']:0;
	}
	
	public function postCount($CategoryID)
	{
		$PostCategoryObj = new DataTable(TABLE_BLOG_POST_RELATION);
		$PostCategoryObj->where="Relationtype='blog_category' AND RelationID ='".(int)$CategoryID."'";
		$PostCategoryObj->columnExpression=true;
		$Obj = $PostCategoryObj->tableSelectOne(array('Total'=>'Count(*)'));
		
		return $Obj['Total'] > 0?$Obj['Total']:0;
	}
	
	public function getDetail($CategoryID)
	{
		if($CategoryID > 0)
		{
			$CategoryObj = new DataTable(array('p'=>TABLE_BLOG_CATEGORY));
			$CategoryObj->where[] = array('=',array('p.CategoryID' => $CategoryID));
				
			$CategoryObj->joinExpression = true;
			$CategoryObj->joinArray[] = array('name'=>array('s'=>TABLE_SEO),
										  'on'=>"(s.ReferenceID = p.CategoryID AND s.MCode='blog_category')",
										  'columns'=>array("*"),
										  'type'=>"left",
										  );
			return (object)$CategoryObj->tableSelectOne();
		
		}
		return ;
	
	}
	
	public function imageCategory($Image)
	{
		if(isset($Image) && $Image !="" && file_exists(DIR_FS_SITE_UPLOADS."category/".$Image))
			return DIR_FS_SITE_UPLOADS."category/".$Image;
		
		return false;
	}
	
	public function imageCategoryURL($Image)
	{
		if(isset($Image) && $Image !="" && file_exists(DIR_FS_SITE_UPLOADS."category/".$Image))
			return DIR_WS_SITE_UPLOADS."category/".$Image;
		
		return false;
	}
	
	public function pageTitle()
	{
		return "Category";
	}
	
	public function pageRight()
	{
		return '<div class="title_right">
					<div class="pull-right">
						  <a class="btn btn-primary" href="'.DIR_WS_SITE_CONTROL.'index.php?m='.$this->module.'&ParentID='.$this->origin->ParentID.'&view=AddEditCategory">Add Category</a>
					</div>
              </div>		
			   ';
	}
	
	
}	