<?php
namespace Base\Session;
use Laminas\Session\SessionManager;
use Laminas\Session\Config\SessionConfig;
use Laminas\Session\Container;

#[AllowDynamicProperties]
class SessionHandler extends SessionManager
{
	var $config; 
	var $sContainer; 
	var $container; 
	function __construct()
	{
		$this->config = array('remember_me_seconds' => 900,
							  'use_cookies' => true,
							  'cookie_lifetime'=> 0,
							  'gc_maxlifetime' => 3600,
							  'cookie_httponly' => true,
							 );
		$this->initSession();
		$this->setContainer(md5(DEFINE_WEBSITE_KEY));
		return true;

	}
	
	public function initSession()
	{
		$sessionConfig = new SessionConfig();
		$sessionConfig->setOptions($this->config);
		$sessionManager = new SessionManager($sessionConfig);
		try {
		  $sessionManager->start();
		}
		catch(\Throwable $e) {
		  $sessionManager->destroy();
		  session_destroy();
		  echo "<a href='".constant("DEFINE_CURRENT_PAGE_URL")."'>Please click here to reload.</a>";
		   
		  //if(defined("DEFINE_CURRENT_PAGE_URL"))
		  // header( "Location: ".constant("DEFINE_CURRENT_PAGE_URL")); 
		 //else
		  //  header( "Location: ".DIR_WS_SITE); 
		  exit;
		}
		Container::setDefaultManager($sessionManager);
	}
	
	public function setContainer($name)
	{
		$this->container = new Container($name);
	}
	public function setVar($name,$val)
	{
		$this->container->offsetSet($name,$val);
		//$this->container->{$name} = $val;
	}

	public function getVar($name)
	{
		//return $this->container->{$name};
		return $this->container->offsetGet($name);
	}
	
	public function setArrVar($name,$val)
	{
		$arr = $this->getArrVar($name);
		if(is_array($arr)){
			array_push($arr,$val);
			$this->container->offsetSet($name,$arr);
			//$this->container->{$name} = $arr;
			
		}
		else{
			$this->container->offsetSet($name,array($val));
			//$this->container->{$name} = array($val);			
		}
		
	}

	public function getArrVar($name)
	{
		return $this->container->offsetGet($name);
		//return $this->container->{$name};
	}
	
	public function deleteVar($name)
	{
		$this->container->offsetSet($name,NULL);
		$this->container->offsetUnset($name);
		//$this->container->{$name} = NULL;
	}
	
	public function getCurrentSID()
	{
		return session_id();
	}
	

	
};
