<?php
namespace Base\File;

class FileHandle 
{
	var $dir;
	public static function CheckPrivateLogDirectory($code)
	{
		$Dir = DIR_FS_SITE_PRIVATE.$code."/";
		if(file_exists ($Dir ))
		{
			return $Dir;
		}
		else
		{
			if (mkdir($Dir, 0777, true)) 
				return $Dir;
			else
				return DIR_FS_SITE_PRIVATE;
		}
	}
	
	public static function CheckUploadLogDirectory($code)
	{
		$Dir = DIR_FS_SITE_UPLOADS.$code."/";
		if(file_exists ($Dir ))
		{
			return $Dir;
		}
		else
		{
			if (mkdir($Dir, 0777, true)) 
				return $Dir;
			else
				return DIR_FS_SITE_UPLOADS;
		}
	}
	
	public static function SKClearPrivateCache()
	{
		self::SKDeleteFolderContent(DIR_FS_SITE_PRIVATE."cache/");	
		//self::SKDeleteFolderContent(DIR_FS_SITE_PRIVATE."errorlog/");	
		//self::SKDeleteFolderContent(DIR_FS_SITE_PRIVATE."cron/");	
		return true;
		
	}
	
	public static function SKClearPrivateSecondaryCache()
	{
		self::SKDeleteFolderContent(DIR_FS_SITE_PRIVATE."cache_seourl/");	
		self::SKDeleteFolderContent(DIR_FS_SITE_PRIVATE."cache_seoimage/");	
		self::SKDeleteFolderContent(DIR_FS_SITE_PRIVATE."cache_keyurl/");	
		self::SKDeleteFolderContent(DIR_FS_SITE_PRIVATE."cache_db/");	
		self::SKDeleteFolderContent(DIR_FS_SITE_UPLOADS."compress/");	
		self::SKDeleteFolderContent(DIR_FS_SITE_PRIVATE."log/");	
		//self::SKDeleteFolderContent(DIR_FS_SITE_PRIVATE."errorlog/");	
		//self::SKDeleteFolderContent(DIR_FS_SITE_PRIVATE."cron/");	
		
		return true;
		
	}
	
	public static function SKClearCronLog()
	{
		self::SKDeleteFolderContent(DIR_FS_SITE_PRIVATE."cron/");	
		return true;
		
	}
	
	public static function SKClearErrorLog()
	{
		self::SKDeleteFolderContent(DIR_FS_SITE_PRIVATE."errorlog/");	
		return true;
		
	}
	
	public static function SKClearImageCache()
	{
		$CurrentPath = DIR_FS_SITE_UPLOADS."thumbnail_cache/";
		self::SKDeleteFolderContent(DIR_FS_SITE_UPLOADS."thumbnail_cache/");	
		$CurrentPath = DIR_FS_SITE."img/";
		self::SKDeleteFolderContent(DIR_FS_SITE."img/");	
		return true;
	}
	
	public static function SKDeleteFolderContent($CurrentPath)
	{
		$DeleteCheck = false;
		if(strpos($CurrentPath,DIR_FS_SITE_PRIVATE) !==false)
			$DeleteCheck = true;
			
		if(strpos($CurrentPath,DIR_FS_SITE_UPLOADS) !==false)
			$DeleteCheck = true;
		
		if(strpos($CurrentPath,DIR_FS_SITE."img/") !==false)
			$DeleteCheck = true;
		
		if($DeleteCheck===true && is_dir($CurrentPath)){
			$dir = dir($CurrentPath);		
			while ($file = $dir->read()) 
				{
					if($file != '..' && $file !='.' && $file !='')
					{ 
						$CurrentDir = $CurrentPath."/".$file; 
						if(is_dir($CurrentDir))
						{
							/* nothing */
							$dir_sub1 = dir($CurrentDir);	
							while ($sub1_file = $dir_sub1->read()) 
							{
								if($sub1_file != '..' && $sub1_file !='.' && $sub1_file !='')
								{
									$CurrentSub1Dir = $CurrentDir."/".$sub1_file; 
									if (is_file($CurrentSub1Dir))
									{
										unlink($CurrentSub1Dir);
									}
								}
							}
							rmdir($CurrentDir);
							$dir_sub1->close();
						}
						if (is_file($CurrentDir))
						{
							unlink($CurrentDir);
						}
					}
				}
				$dir->close();
			return true;
		}
		return false;
	}
	
	public static function DownloadFile($file)
	{
		if(file_exists($file) && $file != ""){
			require_once (dirname(__FILE__)."/httpDownloads.php");
			$DownloadObj = new \httpdownload();
			$DownloadObj->set_byfile($file);
			$DownloadObj->filename = basename($file);
			$DownloadObj->use_resume = true;
			$DownloadObj->download();
			exit;
		}
	}
	public static function getFileListing($DirPath)
	{
		$ReturnArray = array();
		$dir = is_dir($DirPath)?dir($DirPath):"";
		if($dir !=""){
			while ($file = $dir->read()){
				if($file != '..' && $file !='.' && $file !=''){
					$CurrentFile = $DirPath."/".$file; 
					if (is_file($CurrentFile)){
						$ReturnArray[$file] = $CurrentFile; 
					}
				}
			}
			
		}
		return $ReturnArray;	
	}

};
