<?php
namespace Base\Db;

use Base\Db\Connection;
use Base\File\FileHandle as FileHandle;
use Laminas\Db\Adapter\Adapter;
use Laminas\Db\Adapter\Driver\PDO;
use Laminas\Db\TableGateway\TableGateway;
use Laminas\Db\TableGateway\AbstractTableGateway;
use Laminas\Db\ResultSet\HydratingResultSet;
use Laminas\Db\Sql\Sql;
use Laminas\Db\Sql\Expression;
use Laminas\Db\Sql\Select;
use Laminas\Db\Sql\Where;
use Laminas\Db\ResultSet\ResultSet;


class DataTable extends Connection 
{

	var $tableName;
	var $where;
	var $groupBy;
	var $resultSet;
	var $rowType = "object";
	var $resultCount = 0;
	var $joinArray = array();
	var $orderExpression = false;
	var $joinExpression = false;
	var $columnExpression = false;
	var $offset = 0;
	var $PageSize=0, $AllowPaging=false, $PageNo=1, $TotalRecords=0,$TotalPages=0,$PageTotalDisplay=10,$PagingType="both",$PagingPrefix="";
	var $resetPagingGroup = true;
	var $track = false,$noCache = false;
	var $dbQuery = "";
	
	
	function __construct($tableName="")
	{
		if(d("QUERY_FILE_LOG")=="1")
			$this->track = true;
		
		parent::__construct();
		$this->tableName = empty($tableName) ? $this->tableName:$tableName;
		return true;
	
	}

	function tableInsert($data="",$quote=true) 
	{
		
		if($this->tableName =="")
			return ; 
		$this->cleanDbTableCache($this->tableName);
		array_walk_recursive($data,array($this,"mysqlDbEntry"));
		$sampleTable = new TableGateway($this->tableName, $this->adapter);
		
		$sampleTable->insert($data);
		return $sampleTable->lastInsertValue;

  	}

	

  	function tableUpdate($data="") 
	{
		if($this->tableName =="")
			return ; 
		
		$this->cleanDbTableCache($this->tableName);
		array_walk_recursive($data,array($this,"mysqlDbEntry"));
		if(is_array($this->where) && count($this->where) > 0)
		{
			$sql    = new Sql($this->adapter);
			$update = $sql->update();
			$update->table($this->tableName);
			$update->set($data);

			foreach($this->where as $whParms)
			{
				if(isset($whParms[0]) && strtolower($whParms[0])=="or")
				{
					$update->where->OR;
				}
				else if(isset($whParms[0]) && strtolower($whParms[0]) == "=")
				{
					$update->where($whParms[1]);
				}
				else if(isset($whParms[0]) && strtolower($whParms[0]) != "")
				{
					$arguments  = $whParms;
					$first = array_shift($arguments);
					if(method_exists($update->where, $whParms[0])) 
						call_user_func_array(array($update->where,$whParms[0]),$arguments);
					
				}
				
			}
			
			if($this->displayQuery ==true)
				echo $update->getSqlString($this->adapter->getPlatform());
			
			$statement  = $sql->prepareStatementForSqlObject( $update );
			return $statement->execute();
			
		}
		elseif($this->where != "")
		{
			$sampleTable = new TableGateway($this->tableName, $this->adapter);
			return $sampleTable->update($data,$this->where);
		}
		
		var_dump("update fail");exit;
		
  	}

	

  	function tableDelete() 
	{

		if($this->tableName =="")
			return ; 
		$this->cleanDbTableCache($this->tableName);
		if(is_array($this->where) && count($this->where) > 0)
		{
			$sql    = new Sql($this->adapter);
			$delete = $sql->delete($this->tableName);
			foreach($this->where as $whParms)
			{
				if(isset($whParms[0]) && strtolower($whParms[0])=="or")
				{
					$delete->where->OR;
				}
				else if(isset($whParms[0]) && strtolower($whParms[0]) == "=")
				{
					$delete->where($whParms[1]);
				}
				else if(isset($whParms[0]) && strtolower($whParms[0]) != "")
				{
					$arguments  = $whParms;
					$first = array_shift($arguments);
					if(method_exists($delete->where, $whParms[0])) 
						call_user_func_array(array($delete->where,$whParms[0]),$arguments);
					
				}
				
			}
			
			if($this->displayQuery ==true)
			{
				echo $delete->getSqlString($this->adapter->getPlatform());
			}
			
			$statement  = $sql->prepareStatementForSqlObject( $delete );
			return $statement->execute();
			
		}
		elseif($this->where != "")
		{
			$sampleTable = new TableGateway($this->tableName, $this->adapter);
			return $sampleTable->delete($this->where);
		}
		
		var_dump("delete fail");exit;
	
	
 
  	}

	function getTables()
	{
		$tableArray = array ();
		$arr = $this->adapter->query("SHOW tables like '".DB_TABLE_PREFIX."%'", $this->adapter::QUERY_MODE_EXECUTE);
		
		foreach($arr->toArray() as $k=>$arr)
			$tableArray[] = $arr[key($arr)];
		
		return $tableArray;
		
		
	}
	
	function getSelect()
	{
		$sql = new Sql($this->adapter);
		return $sql->select();
	}
	
	function tableSelectAll($from=array(),$orderBy=array(),$limit=0)
	{
		
		$result = $this->getSelectQuery($from,$orderBy,$limit);
		if($this->rowType=="object"){
			$data = array();
			foreach($result as $record){
				$data[] = (object)$record;
			}
			return $data;	
		}
		elseif($this->rowType=="array"){
			return $result;
		}
		
		
	}
	
	function tableSelectOne($from=array(),$orderBy=array())
	{
		$result = $this->getSelectQuery($from,$orderBy,1);
		if(count($result) ==1){
			return $result[0];
		}
		else{
			return false;
		}
		
	}
	
	function putExpression(&$item1, $key)
	{
		if($item1 == "*")
			$item1 =  $item1;
		else
			$item1 =  new Expression($item1);
	}
	function getSelectQuery($from=array(),$orderBy=array(),$limit=0)
	{
		if($this->tableName =="")
			return ; 
		
		$sql = new Sql($this->adapter);
		$select = $sql->select()->from($this->tableName);
		
		if($this->columnExpression===true && is_array($from) && count($from) > 0)
		{
			array_walk($from, array($this,"putExpression"));
			$select->columns($from); //$select->columns(array('num' => new Expression('COUNT(*)')));
		}
		elseif(is_array($from) && count($from) > 0)
			$select->columns($from);
	
		if(is_array($this->joinArray) && count($this->joinArray) > 0)
		{
			foreach($this->joinArray as $jKey=>$jArr)
			{
				if(is_array($jArr))
				{
					if($this->joinExpression===true){
						$select->join($jArr['name'],new Expression($jArr['on']),$jArr['columns'],$jArr['type']);
					}
					else{
						$select->join($jArr['name'],$jArr['on'],$jArr['columns'],$jArr['type']);
					}
					
				}
			}
		}
		if(is_array($this->where) && count($this->where) > 0)
		{
			foreach($this->where as $whParms)
			{
				if(isset($whParms[0]) && in_array(strtolower($whParms[0]),array('or','and',"nest","unnest")))
				{
					$select->where->{strtoupper($whParms[0])};
				}
				else if(isset($whParms[0]) && strtolower($whParms[0]) == "=")
				{
					$select->where($whParms[1]);
				}
				else if(isset($whParms[0]) && strtolower($whParms[0]) != "")
				{
					$arguments  = $whParms;
					$first = array_shift($arguments);
					if(method_exists($select->where, $whParms[0])) 
						call_user_func_array(array($select->where,$whParms[0]),$arguments);
					
				}
				
				//https://framework.zend.com/manual/2.2/en/modules/zend.db.sql.html
				//$select->where(array('MNID' => 1));
				//$select->where->OR;
				//$select->where->like("MNName", "somethin'g%");
			}
		}
		elseif($this->where != '')
			$select->where($this->where);
	
		if($this->orderExpression===true)
			$select->order( new Expression($orderBy));
		elseif(is_array($orderBy) && count($orderBy) > 0)
			$select->order($orderBy);
		elseif($orderBy != '')
			$select->order($orderBy);
			
		if($this->groupBy != "")
			$select->group($this->groupBy);
			
	
		if(is_int($limit) && $limit > 0)
			$select->limit((int)$limit);
	
		if(is_int($this->offset) && $this->offset > 0)
			$select->offset($this->offset);
	
		/*Paging Start */
		if($this->AllowPaging == true && $this->PageSize > 0)
		{
			$this->getPagingStat($select);
			$this->TotalPages = intval($this->TotalRecords/$this->PageSize);
			
			$this->TotalPages = ($this->TotalRecords%$this->PageSize) > 0 ? $this->TotalPages+1:$this->TotalPages;
			$this->PageNo = (empty($this->PageNo) or $this->PageNo==0) ? 1:$this->PageNo;
			
			if($this->PageTotalDisplay > $this->TotalPages)
				$this->PageTotalDisplay = $this->TotalPages;
			
			$select->limit((int)$this->PageSize);
			$select->offset((int)($this->PageNo-1)*$this->PageSize);
			//http://192.168.0.77/sunil/custom_cms/ecommerce/attachment/admin-theme/gentelella-master/gentelella-master/production/form_buttons.html#
			
		}
		/*Paging END */
		
		
		
		
		//echo $select->getSqlString($this->adapter->getPlatform());
		$statement = $sql->prepareStatementForSqlObject($select);
		
		return $this->dbExecuteStatement($select,$statement);
		
		
	}
	
	function getPageLink($URL)
	{
		if($this->AllowPaging == true && $this->PageSize > 0 && $this->TotalRecords > 0 && $this->TotalPages > 1)
		{
			
			$return = "";
			switch($this->PagingType)
			{
				case "type1":
					break;
				case "type1":
					break;
				case "Both":
				default:
					
					$InitialLoop= ceil($this->PageNo/$this->PageTotalDisplay)*$this->PageTotalDisplay -($this->PageTotalDisplay-1);
					$EndLoop = $this->TotalPages >=$InitialLoop+($this->PageTotalDisplay-1)?$InitialLoop+($this->PageTotalDisplay-1):$this->TotalPages;
					$return = $this->PagingPrefix.'<div class="row text-center paging-list justify-content-center">
                      <div class="btn-group justify-content-center">
						';
					
					if($InitialLoop > $this->PageTotalDisplay)
					{		
					
					$return .='
					    <div class="btn-group previous-list">
                          <button data-toggle="dropdown" class="btn btn-primary dropdown-toggle" type="button" data-bs-toggle="dropdown" aria-expanded="false"><span class="caret"></span> Previous </button>
                          <ul class="dropdown-menu" style="max-height:400px;overflow:auto;">
						  ';
						  //for ($i=$InitialLoop-1; $i>=1 ;$i--)	
						  /*for ($i=1; $i< $InitialLoop ;$i++)	
							$return .=' <li><a href="'.str_replace('{PageNo}',$i,$URL).'">'.$i.'</a></li>';
						  */
						for ($i=$InitialLoop-1; $i>=max(1, $InitialLoop-$this->PageTotalDisplay);$i--){	
							$return .=' <li><a href="'.str_replace('{PageNo}',$i,$URL).'">'.$i.'</a></li>';
						}
					
                     $return .='
						  </ul>
                        </div>
						';
					}
					
					if($this->PageNo > 1)
						$return .='<a href="'.str_replace('{PageNo}',$this->PageNo-1,$URL).'" class="btn btn-default">&laquo;</a>';
						
					for ($i=$InitialLoop; $i<= $EndLoop;$i++)	
					{
						$return .='<a href="'.str_replace('{PageNo}',$i,$URL).'" class="btn '.(($i==$this->PageNo)?"btn-warning":"btn-default").'">'.$i.'</a>';
					}
					
					if($this->PageNo < $this->TotalPages)
						$return .='<a href="'.str_replace('{PageNo}',$this->PageNo+1,$URL).'" class="btn btn-default">&raquo;</a>';
					
					if($this->TotalPages > $EndLoop)
					{
                    $return .='<div class="btn-group next-list">
                          <button data-toggle="dropdown" class="btn btn-primary dropdown-toggle" type="button" data-bs-toggle="dropdown" aria-expanded="false"> Next <span class="caret"></span> </button>
                          <ul class="dropdown-menu" style="max-height:400px;overflow:auto;">
						  ';
						  //for ($i=$EndLoop+1; $i<= $this->TotalPages;$i++)	
						  /*
							for ($i=$this->TotalPages; $i>$EndLoop ;$i--)	
							$return .=' <li><a href="'.str_replace('{PageNo}',$i,$URL).'">'.$i.'</a></li>';
						*/
						for ($i=$EndLoop+1; $i<= min($this->TotalPages, $EndLoop+$this->PageTotalDisplay);$i++)
							$return .=' <li><a href="'.str_replace('{PageNo}',$i,$URL).'">'.$i.'</a></li>';
					
                     $return .='
						  </ul>
                        </div>
						';
					}
						
				  $return .='</div>
                    </div>';
				
				  return $return;
				break;
			}
			
		}
	}
	function getPagingStat($select)
	{
		$sql = new Sql($this->adapter);
		$pagingSelect = clone $select;
		$pagingSelect->reset("columns");
		$pagingSelect->reset('joins');
		$joins = $select->joins->getJoins();
		foreach ($joins as $key => $join) {
			//re add join without cols
			$type = $join["type"];
			$pagingSelect->join($join["name"], $join["on"], [], $type);
		}
		
		$pagingSelect->columns(array('TotalRecords' => new Expression('COUNT(*)')));;
		
		if($this->resetPagingGroup == true)
			$pagingSelect->reset("group");
	
		$statement = $sql->prepareStatementForSqlObject($pagingSelect);
		$result = $statement->execute();
		$obj = $result->current();
		$this->resultCount = isset($obj['TotalRecords'])?$obj['TotalRecords']:0;
		$this->TotalRecords = isset($obj['TotalRecords'])?$obj['TotalRecords']:0;
		return ;
		
	}
	
	function getPagingStat_underprocess($select)
	{
		$sql = new Sql($this->adapter);
		$pagingSelect = clone $select;
		$pagingSelect->columns(array('TotalRecords' => new Expression('COUNT(*)')));;
		if($this->resetPagingGroup == true)
			$pagingSelect->reset("group");
	
		$statement = $sql->prepareStatementForSqlObject($pagingSelect);
		
		$result = $this->dbExecuteStatement($pagingSelect,$statement);
		
		$obj = $result->current();
		$this->TotalRecords = isset($obj['TotalRecords'])?$obj['TotalRecords']:0;
		return ;
		
	}
	function getNumRows()
	{
		if($this->resultCount)
			return $this->resultCount;
		else
			return 0;
	}
	
	function executeQuery($select)
	{
		$sql = new Sql($this->adapter);
		$statement = $sql->prepareStatementForSqlObject($select);
		return $this->dbExecuteStatement($select,$statement);
		
	}
	
	function dbExecuteStatement($select,$statement){
		$this->dbQuery =  $select->getSqlString($this->adapter->getPlatform());
		
		$dbtableName = $this->tableName;
		if(isset($dbtableName) && is_array($dbtableName) && count($dbtableName) == 1){
			$dbtableName = array_values($dbtableName)[0];
		}
		$dbCacheStatus = false;
		if(defined("CACHE_TABLES_ARR") && $this->noCache===false && is_array(CACHE_TABLES_ARR) && in_array($dbtableName,CACHE_TABLES_ARR) && d("CACHE_IMPLEMENT")=="1"){
				$dir = FileHandle::CheckPrivateLogDirectory("cache_db");
				$dir = FileHandle::CheckPrivateLogDirectory("cache_db/".$dbtableName);
				$dbCacheFile=$dir.md5($this->dbQuery).".txt";
				if(file_exists($dbCacheFile)){
					$dbData = unserialize(file_get_contents($dbCacheFile));
					$this->resultCount = count($dbData);
					return  $dbData;
				}
				else{
					$dbCacheStatus = true;
				}
				
		
		}
		
				
		if($this->displayQuery ==true)
			echo $this->dbQuery;
		
		if($this->AllowPaging == true)
			$dbCacheStatus = false;
		
		if($this->track===true){
				$dir = FileHandle::CheckPrivateLogDirectory("log");
				$dir = FileHandle::CheckPrivateLogDirectory("log/queries");
				$filename=$dir."queryLog-".date("Y-m-d_H").".txt";
				$fp = fopen($filename, "a+");
				$sk_timestart = explode(' ', microtime() );
				$sk_timestart = $sk_timestart[1] + $sk_timestart[0];
				fputs($fp,$this->dbQuery);
		}
		
		$dbData = array();
		$result = $statement->execute();
		$resultSet = new ResultSet();
		$resultSet->initialize($result);
		$this->resultSet = $resultSet;
		if($this->resultSet->count() > 0){
		foreach($this->resultSet as $record)
			$dbData[] = (array)$record;
		}
		
		$this->resultCount = count($dbData);
		//echo "<hr>".$this->dbQuery;
		//echo "<br>".$dbtableName;
		if($dbCacheStatus){
			$fp2 = fopen($dbCacheFile, "w");
			fputs($fp2,serialize($dbData));	
			fclose($fp2);
		}
		
		
		if($this->track===true){
			$sk_timeend = explode(' ', microtime() );
			$sk_timeend = $sk_timeend[1] + $sk_timeend[0];	
			$total_time= number_format($sk_timeend-$sk_timestart,5);
			fputs($fp,chr(13)."<!--Time: ".$total_time." sec-->".chr(13));
			if($total_time >= 1 && $total_time < 2)
				fputs($fp,chr(13)."===ISSUE:NEEDS ATTENTION===".chr(13));
			
			if($total_time >= 2 && $total_time < 3)
				fputs($fp,chr(13)."===ISSUE:PROBLEM===".chr(13));
			
			if($total_time >= 3)
				fputs($fp,chr(13)."===ISSUE:CRITICAL===".chr(13));
			
			if($total_time >= 1){
				$dir = FileHandle::CheckPrivateLogDirectory("log");
				$dir = FileHandle::CheckPrivateLogDirectory("log/queries");
				$filename2=$dir."Query_".uniqid(number_format($total_time,0)."_")."_".date("Md-Y-his").".txt";
				
				$fp2 = fopen($filename2, "w");
				fputs($fp2,$this->dbQuery);
				fputs($fp2,chr(13)."<!--Time: ".$total_time." sec-->".chr(13));
				fclose($fp2);
			}
							
			fputs($fp,chr(13));
			fclose($fp);
		}
		
	  return $dbData;	
	}
	
	function cleanDbTableCache($dbtableName)
	{
		if($dbtableName != "")
			FileHandle::SKDeleteFolderContent(DIR_FS_SITE_PRIVATE."cache_db/".$dbtableName);
		
	}
	
	function AutoIncrementID(){
		if($this->tableName =="")
			return 0; 
		
		$obj = $this->adapter->query("ANALYZE TABLE ".$this->tableName."", $this->adapter::QUERY_MODE_EXECUTE);
		
		$Query = "SHOW TABLE STATUS WHERE NAME ='".$this->tableName."'";
		$obj = $this->adapter->query($Query, $this->adapter::QUERY_MODE_EXECUTE);
		foreach($obj as $row){
			if(isset($row->Auto_increment) && $row->Auto_increment > 0)
				return $row->Auto_increment;
		}
		
		return 0; 
		
	}
	function getMax($columnName)
	{

		if($this->tableName =="")
			return ; 
		
		$sql = new Sql($this->adapter);
		$select = $sql->select()->from($this->tableName);
		$select->columns([
						'max_count' => new Expression('MAX(?)', [[$columnName => Expression::TYPE_IDENTIFIER]]),
				]);
		
		if(is_array($this->where) && count($this->where) > 0)
		{
			foreach($this->where as $whParms)
			{
				if(isset($whParms[0]) && strtolower($whParms[0])=="or")
				{
					$select->where->OR;
				}
				else if(isset($whParms[0]) && strtolower($whParms[0]) == "=")
				{
					$select->where($whParms[1]);
				}
				else if(isset($whParms[0]) && strtolower($whParms[0]) != "")
				{
					$arguments  = $whParms;
					$first = array_shift($arguments);
					if(method_exists($select->where, $whParms[0])) 
						call_user_func_array(array($select->where,$whParms[0]),$arguments);
					
				}
				
			}
		}
		elseif($this->where != '')
			$select->where($this->where);
			
			
	
		$statement = $sql->prepareStatementForSqlObject($select);
		$result = $this->dbExecuteStatement($select,$statement);
		if(count($result) ==1){
			$row = $result[0];
		}
		else{
			return false;
		}
		
		return isset($row['max_count'])?$row['max_count']:"0";

	}
	
	function beginTransaction()
	{
		$obj = $this->adapter->getDriver()->getConnection()->beginTransaction();
	}
	function commit()
	{
		$obj = $this->adapter->getDriver()->getConnection()->commit();
		
		
	}
	
};
