<?php
namespace Base\Db;
use Laminas\Db\Adapter\Adapter;
use Laminas\Db\Adapter\Driver\PDO;
use Laminas\Db\TableGateway\TableGateway;
use Laminas\Db\TableGateway\TableGatewayInterface;
use Laminas\Db\TableGateway\AbstractTableGateway;
use Laminas\Db\Sql\Select;
use Laminas\Db\ResultSet\HydratingResultSet;
class Connection extends AbstractTableGateway implements TableGatewayInterface

{
	var $displayQuery =false;
	var $track = false;
	private static $conn;
	protected $adapter = null;
	var $clLib = "pdo";
	
	function adapterConnection()
	{
			if(Connection::$conn == null)
			{
				//var_dump("adapter");
				
				/* mysqli library start*/
				if($this->clLib=="mysqli"){
					$this->adapter = Connection::$conn = new Adapter(array(
													'driver'   => 'mysqli',
													'hostname' => DB_HOSTNAME,
													'username' => DB_USERNAME,
													'password' => DB_PASSWORD,
													'database' => DB_DATABASE,
													'active' => '1',
													'driver_options' => array(
															 //PDO::MYSQL_ATTR_INIT_COMMAND => 'SET NAMES \'UTF8\''
															 //if you're using mysqli, 
															 //you can set driver options such as
															 MYSQLI_INIT_COMMAND => 'SET NAMES \'UTF8\'',
														),
														'options' => array(
															//if you're using mysqli driver
															//you should set buffer_results => true 
															'buffer_results' => true
														),        
												));
				}
				/* mysqli library end*/
				
				/* pdo library start*/
				if($this->clLib=="pdo"){
					$this->adapter = Connection::$conn =  new Adapter(array(
												'driver'   => 'Pdo_Mysql',
												'hostname' => DB_HOSTNAME,
												'username' => DB_USERNAME,
												'password' => DB_PASSWORD,
												'database' => DB_DATABASE,
												'charset' => 'utf8',
												'active' => '1',
												'driver_options' => array(
															 \PDO::MYSQL_ATTR_INIT_COMMAND => "SET group_concat_max_len = 16384"
															// \PDO::MYSQL_ATTR_INIT_COMMAND => "SET SQL_MODE = 'STRICT_TRANS_TABLES,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION'"
														),													        
											));
				}
				/* pdo library end*/
				

				
				if(isset($GLOBALS['SKTotalConnCount']))
					$GLOBALS['SKTotalConnCount'] = $GLOBALS['SKTotalConnCount']+1;
				else
					$GLOBALS['SKTotalConnCount'] = 1;
			
			
				/*if($this->adapter)
				{
					//Connection::$conn = $this->adapter;
				}
				else 
				{
					$ParameterArray = array("Host" => DB_HOSTNAME, 
											"User" => DB_USERNAME, 
											"Password" => DB_PASSWORD,
											"DataBase" =>DB_DATABASE);
					
					$this->SendErrorMail(DEFINE_ERROR_EMAIL,mysqli_error($this->adapter),$ParameterArray);
					die(ERROR_MESSAGE);
				}
				*/
			}
			else{
				$this->adapter = Connection::$conn; 
			}
		
		
		return $this;
	}
	function __construct()
	{
		$this->adapterConnection();
	}
	
	
	
	function mysqlEscapeString($Str)
	{
		$this->adapterConnection();
		$Str = $this->adapter->getPlatform()->quoteValue($Str);
		return trim($Str);
	}
	
	function mysqlDbEntry(&$item, $key)
	{
		$this->adapterConnection();
		if(is_null($item) === true)
			$item = NULL;
		else{
			$item = str_replace(DIR_WS_SITE,"<?php echo DIR_WS_SITE?>",$item);
		}
		
		if(d("DEFINE_FRONT_SIDE_INCLUDE")==true && $item != ""){
			$item=str_replace("'","&apos;",$item);
			$item=str_replace('"','&quot;',$item);
			$item=str_replace("<","&lt;",$item);
			$item=str_replace(">","&gt;",$item);
		}
		
	}
	
	
	
};
?>