<?php
namespace Base\Currency;
use Frontend\Base\AbstractModule;
use Base\Db\DataTable as DataTable;
use FrontEnd\Common\Common as FrontEndCommon;
use Base\File\FileHandle as FileHandle;
use Laminas\Db\Sql\Where;
class CurrencyHandler extends AbstractModule
{
	function __construct()
	{
		
	}
	
	public function getActiveCurrencyList()
	{
		$CurrencyObj = new DataTable(TABLE_CURRENCIES);
		$CurrencyObj->where[] = array('=',array('Active' => "1"));
		$CurrencyObj->orderExpression = true;
		return $CurrencyObj->tableSelectAll(array("*"),"DefaultValue=1 DESC,CurrencyID ASC");
	
	}
	
	
	function Change2CurrentCurrency($Price,$ShowSymbol=true,$DecimalPlaces=2,$ThousandSeparator=',',$DecimalSeparator='.')
	{
		if(d("FRONT_SIDE_INCLUDE")==true){
			$Obj = new FrontEndCommon;
			$CurrentCurrency = $Obj->getFrontCurrency();
		}
		if(!isset($CurrentCurrency->CurrencyID)){
			$CurrentCurrency= $this->getDefaultCurrency();
		}
			
		$Price = $CurrentCurrency->Value * $Price;
		if($ShowSymbol)
			if($CurrentCurrency->Prefix)
				$Price = $CurrentCurrency->Symbol."".number_format($Price,$DecimalPlaces,$DecimalSeparator,$ThousandSeparator);
			else 
				$Price = number_format($Price,$DecimalPlaces,$DecimalSeparator,$ThousandSeparator).$CurrentCurrency->Symbol;
		else 
			$Price = number_format($Price,$DecimalPlaces,$DecimalSeparator,$ThousandSeparator);
		
		return $Price;
	}
function Change2OrderCurrency($OrderID,$Price,$ShowSymbol=true,$DecimalPlaces=2,$ThousandSeparator=',',$DecimalSeparator='.')
{
	if ($OrderID !="")
	{
		$OrderCurrencyObj = new DataTable(TABLE_ORDER_CURRENCIES);
		$OrderCurrencyObj->where[] = array('=',array('OrderID' => $OrderID));
		$CurrentCurrency=(object)$OrderCurrencyObj->tableSelectOne();
		if(!isset($CurrentCurrency->CurrencyID))
		{
			$CurrencyObj = new DataTable(TABLE_CURRENCIES);
			$CurrencyObj->where[] = array('=',array('DefaultValue' => 1));
			$CurrentCurrency=(object)$OrderCurrencyObj->tableSelectOne();
		}
		if(!isset($CurrentCurrency->CurrencyID)){
			$CurrentCurrency= $this->getDefaultCurrency();
		}
		$Price = $CurrentCurrency->Value * $Price;
		if($ShowSymbol)
			if($CurrentCurrency->Prefix)
				$Price = $CurrentCurrency->Symbol."".number_format($Price,$DecimalPlaces,$DecimalSeparator,$ThousandSeparator);
			else 
				$Price = number_format($Price,$DecimalPlaces,$DecimalSeparator,$ThousandSeparator).$CurrentCurrency->Symbol;
		else 
			$Price = number_format($Price,$DecimalPlaces,$DecimalSeparator,$ThousandSeparator);
		
		return $Price;
	
	}
}	
function Change2DefaultCurrency($Price,$ShowSymbol=true,$DecimalPlaces=2,$ThousandSeparator=',',$DecimalSeparator='.')
{
	$CurrentCurrency= $this->getDefaultCurrency();
	$Price = $CurrentCurrency->Value * $Price;
	if($ShowSymbol)
		if($CurrentCurrency->Prefix)
			$Price = $CurrentCurrency->Symbol."".number_format($Price,$DecimalPlaces,$DecimalSeparator,$ThousandSeparator);
		else 
			$Price = number_format($Price,$DecimalPlaces,$DecimalSeparator,$ThousandSeparator).$CurrentCurrency->Symbol;
	else 
		$Price = number_format($Price,$DecimalPlaces,$DecimalSeparator,$ThousandSeparator);
	return $Price;
}

function getDefaultCurrency()
	{
		/* Default Currency start here */
		$Obj = new DataTable(TABLE_CURRENCIES);
		$Obj->where[] = array('=',array('DefaultValue' => 1));
		$Obj->where[] = array('=',array('Active' => 1));
		return (object)$Obj->tableSelectOne(array("*"));
		/* Default Currency start end */
	}
	
function CronCurrencyUpdate($ScriptTimeLimit,$Obj)
{
	$dir = FileHandle::CheckPrivateLogDirectory("cron");
	$dir = FileHandle::CheckPrivateLogDirectory("cron/currency");
	$filename=$dir."currency_".date('Y-m-d').".txt";
	$UniqueID = uniqid("Currency_");
	
	$fp2 = fopen($filename, "a+");
	fputs($fp2,"======================================================".chr(13));	
	fputs($fp2,"Currency Start ".$UniqueID."=".date('Y-m-d H:i:s').chr(13));	
	
	
	$sk_timestart = explode(' ', microtime() );
	$sk_timestart = $sk_timestart[1] + $sk_timestart[0];
	
	/* script start here*/		
	if(isset($Obj->CronID) && date('Y-m-d',strtotime($Obj->CronDate))==date('Y-m-d')){
		$Params = (isset($Obj->Params) && $Obj->Params != "")?unserialize(base64_decode($Obj->Params)):array();
	
		fputs($fp2,"Params ".$UniqueID."=".print_r($Params,true).chr(13));		
	
		if(count($Params)==0)
		{
			$Params['Action']="Processing";
			$Params['Offset']="0";				
		}		
		$CurrencyObj = new DataTable(TABLE_CURRENCIES);
		$CurrencyObj2 = new DataTable(TABLE_CURRENCIES);
		$CurrencyObj->where[] = array('=',array('DefaultValue' => 1));
		$DefaultCurrency=(object)$CurrencyObj->tableSelectOne();
		$base = isset($DefaultCurrency->Code)?$DefaultCurrency->Code:"";

		if($base != "")
		{
			$CurrencyObj = new DataTable(TABLE_CURRENCIES);
			$CurrencyObj->where[] = array('=',array('DefaultValue' => 1));
			$where = new Where();
			$where->equalTo('Active',"1");
			$where->notEqualTo('DefaultValue',"1");
			$CurrencyObj->where = $where;
			if(isset($Params['Offset']) && $Params['Offset'] > 0)
				$CurrencyObj->offset = $Params['Offset'];
			
			$rows = $CurrencyObj->tableSelectAll("",array("CurrencyID ASC"));
			$SNo =$Params['Offset'];
			foreach ($rows as $CurrentCurrency)
			{
				fputs($fp2,"CurrentCurrency ".$UniqueID."=".print_r($CurrentCurrency,true).chr(13));		
				fputs($fp2,"DefaultCurrency ".$UniqueID."=".print_r($DefaultCurrency,true).chr(13));	
				
				$Value = $this->sk_get_currency($CurrentCurrency->Code,$DefaultCurrency->Code);
				if($Value >0)
				{
					
					fputs($fp2,"Value ".$UniqueID."=".print_r($Value,true).chr(13));	
					
					echo $CurrentCurrency->Code."===".$Value."<br>";
					$DataArray = array();
					$DataArray['Value'] = $Value;
					$CurrencyObj2 = new DataTable(TABLE_CURRENCIES);
					$CurrencyObj2->where[] = array('=',array('CurrencyID' => $CurrentCurrency->CurrencyID));
					$CurrencyObj2->tableUpdate($DataArray);
					
					$SNo++;
					$CronObj = new DataTable(TABLE_MODULE_CRONS);
					$CronObj->where[] = array('=',array('CronID' => $Obj->CronID));
					$Params['Offset'] = $SNo;
					$DataArray = array();
					$DataArray['CronStatus'] = "Processing";
					$DataArray['Params'] = base64_encode(serialize($Params));
					$CronObj->tableUpdate($DataArray);
					
					$sk_timeend = explode(' ', microtime() );
					$sk_timeend = $sk_timeend[1] + $sk_timeend[0];
					if(number_format($sk_timeend-$sk_timestart) > $ScriptTimeLimit)
						return ;
					
				}
			}
			
			/* Increase date for next start*/
			$CronObj = new DataTable(TABLE_MODULE_CRONS);
			$CronObj->where[] = array('=',array('CronID' => $Obj->CronID));
			$DataArray = array();
			$DataArray['CronDate'] = date('Y-m-d',strtotime("+1 day"));
			$DataArray['CronStatus'] = "Pending";
			$DataArray['Params'] = "";
			$CronObj->tableUpdate($DataArray);
			/* Increase date for next end*/
			
	
		}
	}
	/* script end here*/		
	
	if(isset($Obj->CronID) && strtotime(date('Y-m-d')) > strtotime($Obj->CronDate)){
		
		$CronObj = new DataTable(TABLE_MODULE_CRONS);
		$CronObj->where[] = array('=',array('CronID' => $Obj->CronID));
		$DataArray = array();
		$DataArray['CronDate'] = date('Y-m-d');
		$DataArray['CronStatus'] = "Pending";
		$DataArray['Params'] = "";
		$CronObj->tableUpdate($DataArray);
	}

	fputs($fp2,"Currency End ".$UniqueID." = ".date('Y-m-d H:i:s').chr(13));
	fputs($fp2,"======================================================".chr(13));	
	fclose($fp2);	
	
}

function GetCurrencyRateFromDB($from, $to,$Amount=1)
{
	$Obj = new DataTable(TABLE_CURRENCIES);
	$Obj->where[] = array('=',array('DefaultValue' => "1"));
	$BaseObj = (object)$Obj->tableSelectOne(array("Value"));
	
	
	$Obj = new DataTable(TABLE_CURRENCIES);
	$Obj->where[] = array('=',array('Code' => $from));
	$FromObj = (object)$Obj->tableSelectOne(array("Value"));
	
	$Obj = new DataTable(TABLE_CURRENCIES);
	$Obj->where[] = array('=',array('Code' => $to));
	$ToObj = (object)$Obj->tableSelectOne(array("Value"));
	
	return $Amount * ($ToObj->Value/$FromObj->Value);
	
	
}

function sk_get_currency($code, $base = "GBP")
{
	if($code==$base)
		return 1; 
	
	$function_array = array("quote_europe_currency",
							//"quote_apifixer_currency",
							//"quote_currencyconverterapi_currency"
							);
	shuffle($function_array);
	$rate =false;
	
	/* priority function start*/
	//$rate = call_user_func('quote_europe_currency', $code, $base);
	$rate = call_user_func(array($this, 'quote_europe_currency'), $code, $base);
	if(isset($rate) && $rate > 0)
			return $rate;
		
	/* priority function end*/
	
	foreach($function_array as $k=>$value)
	{
		$rate = call_user_func(array($this, $value), $code, $base);
		if(isset($rate) && $rate > 0)
			return $rate;
	}
	return $rate;
}


/* Currency function*/

function FetchFileFromHttp($ServerFile,$LocalFile)
{
	$ch = curl_init ($ServerFile);
	curl_setopt($ch, CURLOPT_HEADER, 0);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	curl_setopt($ch, CURLOPT_BINARYTRANSFER,1);
	$raw=curl_exec($ch);
	if(curl_errno($ch) == false){
		$fp = fopen($LocalFile,'x');
		fwrite($fp, $raw);
		fclose($fp);
			
	}
	else{
		curl_errno($ch);
	}
	curl_close ($ch);
			
}


function quote_europe_currency($code, $base = "GBP")
{
	$dir = FileHandle::CheckPrivateLogDirectory("currency");
	$xml_file=$dir."ecb_europa_".date('Y-m-d').".xml";
	//https://www.ecb.europa.eu/stats/eurofxref/eurofxref-daily.xml
	if(file_exists($xml_file)==false)
	{
		$this->FetchFileFromHttp("https://www.ecb.europa.eu/stats/eurofxref/eurofxref-daily.xml",$xml_file);
	}
	
	$page = file_get_contents($xml_file);
	
	$xml = simplexml_load_string($page);
	
	$EURate = "1";
	$BaseRate = "0";
	$CodeRate = "0";
	if($code=="EUR")
		$CodeRate="1";
	
	$Rate = 0;
	foreach($xml->Cube->Cube->Cube as $v)
	{
		if(isset($v['currency']) && isset($v['rate']) && $v['rate'] != "" && $v['currency']==$base)
			$BaseRate = (float)$v['rate'];
	
		if(isset($v['currency']) && isset($v['rate']) && $v['rate'] != "" && $v['currency']==$code)
			$CodeRate = (float)$v['rate'];
		
	}
	
	if($BaseRate > 0 && $CodeRate> 0 && $EURate > 0)
	{
			$TmpRate = (1/$CodeRate)*$BaseRate;	
			$Rate = (1/$TmpRate);	
	}
	
	if($Rate > 0)
		return $Rate;
	else 
		return false;
	
}

function quote_apifixer_currency($code, $base = "GBP")
{
	//https://api.fixer.io/latest?base=GBP&symbols=USD
	$httpPath = 'https://api.fixer.io/latest?base='.$base.'&symbols='.$code.'';
	$ch = curl_init($httpPath);
	curl_setopt ($ch, CURLOPT_HEADER, 0) ;
	curl_setopt ($ch, CURLOPT_RETURNTRANSFER, 1) ;
	$page = curl_exec($ch);
	$data = json_decode($page);
	if(isset($data->rates->{$code}) && $data->rates->{$code} > 0)
			return $data->rates->{$code};
	else 
		return false;
}

function quote_currencyconverterapi_currency($code, $base = "GBP")
{
	//https://free.currencyconverterapi.com/api/v4/convert?q=GBP_USD&compact=y
	$httpPath = 'https://free.currencyconverterapi.com/api/v4/convert?q='.$base.'_'.$code.'&compact=y';
	$ch = curl_init($httpPath);
	curl_setopt ($ch, CURLOPT_HEADER, 0) ;
	curl_setopt ($ch, CURLOPT_RETURNTRANSFER, 1) ;
	$page = curl_exec($ch);
	$data = json_decode($page);
	if(isset($data->{$base.'_'.$code}->val) && $data->{$base.'_'.$code}->val > 0)
			return $data->{$base.'_'.$code}->val;
	else 
		return false;
}


function quote_yahoo_currency_discontinued($code, $base = "GBP")
{
	$httpPath = 'http://query.yahooapis.com/v1/public/yql';
	$data = urlencode('q=select * from yahoo.finance.xchange where pair in ("USDEUR")&env=store://datatables.org/alltableswithkeys');
	$data = 'q=select%20*%20from%20yahoo.finance.xchange%20where%20pair%20in%20%28%22'.$base.$code.'%22%29&env=store://datatables.org/alltableswithkeys';
	$ch = curl_init($httpPath."?".$data);
	curl_setopt ($ch, CURLOPT_HEADER, 0) ;
	curl_setopt ($ch, CURLOPT_RETURNTRANSFER, 1) ;
	$page = curl_exec($ch);
	curl_close($ch);
	if(isset($page) && $page != "")
	{
		$xml = simplexml_load_string($page);
		return  isset($xml->results->rate->Rate)?$xml->results->rate->Rate:false;
	}
	return false;
}
function quote_oanda_currency_discontinued($code, $base = "GBP") {
	$httpPath = 'http://www.oanda.com/convert/fxdaily';
    $data = 'value=1&redirected=1&exch=' . $code .  '&format=CSV&dest=Get+Table&sel_list=' . $base;
	//$page = @file('http://www.oanda.com/convert/fxdaily?value=1&redirected=1&exch=' . $code .  '&format=CSV&dest=Get+Table&sel_list=' . $base);
	 $ch = curl_init($httpPath."?".$data);
	curl_setopt ($ch, CURLOPT_HEADER, 0) ;
	curl_setopt ($ch, CURLOPT_RETURNTRANSFER, 1) ;
	$page = curl_exec($ch);
	curl_close($ch);
	$match = array();
    preg_match('/(.+),(\w{3}),([0-9.]+),([0-9.]+)/i', $page, $match);
	if (sizeof($match) > 0) {
      return $match[3];
    } else {
      return false;
    }
  }
    function quote_xe_currency_discontinued($to, $from = "GBP") {
    $httpPath = 'http://www.xe.net/ucc/convert.cgi';
    $data = 'Amount=1&From=' . $from . '&To=' . $to;
    //$page = @file($httpPath."?".$data);
    $ch = curl_init($httpPath);
	curl_setopt ($ch, CURLOPT_HEADER, 0) ;
	curl_setopt ($ch, CURLOPT_RETURNTRANSFER, 1) ;
	curl_setopt($ch, CURLOPT_POST, 1); 
	curl_setopt($ch, CURLOPT_POSTFIELDS, $data); 
	curl_setopt($ch, CURLOPT_HTTPHEADER, array("Content-Type: text/html","Content-length: ".strlen($data))); 
	$page = curl_exec($ch);
	curl_close($ch);
    $match = array();
    @preg_match('/[0-9.]+\s*' . $from . '\s*=\s*([0-9.]+)\s*' . $to . '/', @implode('', $page), $match);
    if (sizeof($match) > 0) {
      return $match[1];
    } else {
      return false;
    }
  }
	
};
