<?php
use Base\Db\DataTable as DataTable;
use Base\File\FileHandle as FileHandle;

$dir = FileHandle::CheckPrivateLogDirectory("cache");
$filename=$dir."cache.table.txt";
if(file_exists($filename) && d("CACHE_IMPLEMENT")=="1")
{
	$tableArray =unserialize(file_get_contents($filename));
}
else
{
		$tableObj = new DataTable();
		$tableArray = $tableObj->getTables(); 
		$fp2 = fopen($filename, "w");
		try{
			fputs($fp2,serialize($tableArray));	
		}finally {
			if ($fp2 !== null && is_resource($fp2)) {	
				fclose($fp2);
			}	
		}
}

foreach($tableArray as $val)
	define('TABLE_'.strtoupper(substr($val,strlen(DB_TABLE_PREFIX))),$val);

#########Define Start ##########
	$defineArray = array();
			
	$dir = FileHandle::CheckPrivateLogDirectory("cache");
	$filename=$dir."cache.define.txt";

	if(file_exists($filename) && d("CACHE_IMPLEMENT")=="1")
	{
		$defineArray =unserialize(file_get_contents($filename));
		
	}
	else
	{
			$Obj = new DataTable(TABLE_CONF_GROUP_DEFINE);
			$Obj->where="FrontDisplay='1'";
			$Record = $Obj->tableSelectAll(array("DefineKey","DefineValue"),array("GroupID ASC","SortOrder ASC"));
			
			if(count($Record) > 0)
			{	
				foreach( $Record as $Define)
					$defineArray[$Define->DefineKey] = $Define->DefineValue;
					
				
				$fp2 = fopen($filename, "w");
				fputs($fp2,serialize($defineArray));	
				fclose($fp2);
			}
	}
	foreach($defineArray as $k=>$val)
		define('DEFINE_'.strtoupper($k),$val);
	#########Define End ##########
	