<?php
use Base\File\FileHandle as FileHandle;
function SaveErrorLog($errno, $errstr, $errfile, $errline){
	$dir = FileHandle::CheckPrivateLogDirectory("errorlog");
	$filename=$dir.'errorlog_'.date('Y-m-d').'.txt';
	$UniqueID = uniqid("Log_");
	$fp2 = fopen($filename, "a+");
	fputs($fp2,"======================================================".chr(13));	
	fputs($fp2,"Log Start ".$UniqueID."=".date('Y-m-d H:i:s').chr(13));	
	
	fputs($fp2,"errno =".$errno.chr(13));	
	fputs($fp2,"errstr =".$errstr.chr(13));	
	fputs($fp2,"errfile =".$errfile.chr(13));	
	fputs($fp2,"errline =".$errline.chr(13));	
	//fputs($fp2,"SERVER =".print_r($_SERVER,true).chr(13));	
	
	
	fputs($fp2,"Log End ".$UniqueID."=".date('Y-m-d H:i:s').chr(13));	
	fputs($fp2,"======================================================".chr(13));	
	fclose($fp2);
		
}

function SaveErrorFatal(){
	$last_error = error_get_last();
	if(isset($last_error)){
		$dir = FileHandle::CheckPrivateLogDirectory("errorlog");
		$filename=$dir.'errorfatal_'.date('Y-m-d').'.txt';
		$UniqueID = uniqid("Log_");
		$fp2 = fopen($filename, "a+");
		fputs($fp2,"======================================================".chr(13));	
		fputs($fp2,"Log Start ".$UniqueID."=".date('Y-m-d H:i:s').chr(13));	
		
		fputs($fp2,"ERROR =".print_r($last_error,true).chr(13));	
		fputs($fp2,"GET =".print_r($_GET,true).chr(13));	
		fputs($fp2,"POST =".print_r($_POST,true).chr(13));	
		fputs($fp2,"SERVER =".print_r($_SERVER,true).chr(13));	
		
		fputs($fp2,"Log End ".$UniqueID."=".date('Y-m-d H:i:s').chr(13));	
		fputs($fp2,"======================================================".chr(13));	
		fclose($fp2);
	}
	
}

set_error_handler("SaveErrorLog",E_ALL);
register_shutdown_function('SaveErrorFatal');

	