<?php
use Base\Db\DataTable as DataTable;
use Cms\Pages\Common as PagesCommon;
use Base\File\FileHandle as FileHandle;

use Laminas\Db\Sql\Where;
	
function MyRedirect($URL,$htmlRedirect=false)
{
	if (ob_get_length())
		@ob_clean();
	
	if($htmlRedirect===true)
	{
		?>
		<html>
		<head>
			<META HTTP-EQUIV="refresh" content="0; url=<?php echo $URL?>">
		<title></title>
		<script type="text/javascript">
		function sk_redirect()
		{
			//document.location.href='<?php echo $URL?>';
		}
		</script>
		</head>
			<body onload="return sk_redirect();">
				If this page appears for more than five seconds <a href="<?php echo $URL?>">click here</a> to reload.
			</body>
		</html>
		<?php
	}
	else
		header("Location: ".$URL);
	exit;
}

function d($s)
{
	if(defined($s))
	{
		return constant($s);
	}
	else
	{
		if(defined("DEFINE_".$s))
			return constant("DEFINE_".$s);
		
	}
	return "";
}

function SKGetCountryByCodeFull($Code)
{
	$CountryName = $Code;
	if($Code != "")
	{
		$CountryObj = new DataTable(TABLE_COUNTRIES);
		$where = new Where();
		$where->NEST//start braket
				->equalTo('CountryISOCode1',trim($Code))
				->OR
				->equalTo('CountryISOCode2',trim($Code))
				->UNNEST;
		
		$CountryObj->where = $where;
		$Obj = (object)$CountryObj->tableSelectOne(array("CountryName"));
			if(isset($Obj->CountryName) && $Obj->CountryName != "")
				$CountryName = MyStripSlashes($Obj->CountryName); 
	}
	return $CountryName;
	
}
function SKGetCountryCodeByCountry($Code,$digit =2)
{
	$ReturnName = $Code;
	if($Code != "")
	{
		$CountryObj = new DataTable(TABLE_COUNTRIES);
		$where = new Where();
		$where->NEST//start braket
				->equalTo('CountryISOCode1',trim($Code))
				->OR
				->equalTo('CountryISOCode2',trim($Code))
				->OR
				->equalTo('CountryName',trim($Code))
				->UNNEST;
		
		$CountryObj->where = $where;
		if($digit == "3"){
			$Obj = (object)$CountryObj->tableSelectOne(array("CountryISOCode2"));
			if(isset($Obj->CountryISOCode2) && $Obj->CountryISOCode2 != "")
				$ReturnName = MyStripSlashes($Obj->CountryISOCode2); 
		}
		
		if($digit == "2"){
			$Obj = (object)$CountryObj->tableSelectOne(array("CountryISOCode1"));
			if(isset($Obj->CountryISOCode1) && $Obj->CountryISOCode1 != "")
				$ReturnName = MyStripSlashes($Obj->CountryISOCode1); 
		}
			
		
		
			
	}
	return $ReturnName;
	
}


function SKSEOURL($MCode,$MView="Default",$ID='',$Parms="")
{
	if($ID > 0)
		$URLHref = "index.php?m=$MCode&v=$MView&ID=$ID".(empty($Parms) ? "":"&$Parms");
	else
		$URLHref = "index.php?m=$MCode&v=$MView".(empty($Parms) ? "":"&$Parms");
	
	if(d("SEO_URL_ACTIVE")=="1")
	{
		$CacheKey = $ID."@@@".$MCode."@@@".$MView."@@@".$Parms;
		$SeourlDir = FileHandle::CheckPrivateLogDirectory("cache_seourl");
		$filename=$SeourlDir .md5($CacheKey).".txt";
		
		if(d("CACHE_IMPLEMENT")=="1")
		{
			if(file_exists($filename) && d("CACHE_IMPLEMENT")=="1")
				return  file_get_contents($filename);
		
			/* check define value and return from here*/
			
		}
		
		$SeoObj = new DataTable(TABLE_SEO);
		$SeoObj->where[] = array('=',array('ReferenceID' => $ID));
		$SeoObj->where[] = array('=',array('MCode' => $MCode));
		$SeoObj->where[] = array('=',array('MView' => $MView));
		$CurrentPage = (object)$SeoObj->tableSelectOne(array("URLName","RedirectEnabled","RedirectURL"));
		$CurrentValue = isset($CurrentPage->URLName)?$CurrentPage->URLName:"";
		
		/* module key check start*/
		if($MCode=="cms_pages" && $MView=="Detail" && $ID > 0 && $ID< 1000)
		{
			$obj = new PagesCommon();
			$CurrentPage = $obj->getPageByPageID($ID);
			if(isset($CurrentPage->ModuleKey) && $CurrentPage->ModuleKey > 1)
			{
				$MObj = new DataTable(TABLE_MODULE_KEY);
				$MObj->where="ModuleKeyID ='".(int)$CurrentPage->ModuleKey."'";
				$TmpObj  = (object)$MObj->tableSelectOne();
				
				if(isset($TmpObj->ModuleKeyID))
				{
					$SeoObj = new DataTable(TABLE_SEO);
					$SeoObj->where[] = array('=',array('ReferenceID' => $ID));
					$SeoObj->where[] = array('=',array('MCode' => $TmpObj->SCode));
					$SeoObj->where[] = array('=',array('MView' => $TmpObj->SView));
					$CurrentPage = (object)$SeoObj->tableSelectOne(array("URLName","RedirectEnabled","RedirectURL"));
					$CurrentValue = isset($CurrentPage->URLName)?$CurrentPage->URLName:"";
				}
			}
			
		}
		/* module key check end */
		
		if($ID==="")
		{
			$SeoObj = new DataTable(TABLE_SEO);
			$SeoObj->where[] = array('=',array('MCode' => $MCode));
			$SeoObj->where[] = array('=',array('MView' => $MView));
			$CurrentPage = (object)$SeoObj->tableSelectOne(array("URLName","RedirectEnabled","RedirectURL"));
			$CurrentValue = isset($CurrentPage->URLName)?$CurrentPage->URLName:"";
		}
		
		if($CurrentValue !="" && d("SEO_URL_ACTIVE")=="1")
		{
			//$URLHref = $CurrentValue.".html".(empty($Parms) ? "":"?$Parms");
			$URLHref = $CurrentValue."".(empty($Parms) ? "":"?$Parms");
		}
		if(isset($CurrentPage->RedirectEnabled) && $CurrentPage->RedirectEnabled =="1")
		{
			$DirectURLHref =  MyStripSlashes($CurrentPage->RedirectURL);
			if(d("CACHE_IMPLEMENT")=="1"){
					$fp2 = fopen($filename, "w");
					try{
						fputs($fp2,$DirectURLHref);	
					}finally {
						if ($fp2 !== null && is_resource($fp2)) {	
							fclose($fp2);
						}	
					}
					
				}
			return $DirectURLHref;	
		}
		
	}
	
	if($MCode=="cms_pages" && $MView=="Detail" && $ID==d('DEFAULT_PAGEID') && $Parms==""){
		$URLHref = "";
	}
	
	if(d("CACHE_IMPLEMENT")=="1"){
		$fp2 = fopen($filename, "w");
		try{
			fputs($fp2,DIR_WS_SITE.$URLHref);	
		}finally {
			if ($fp2 !== null && is_resource($fp2)) {	
				fclose($fp2);
			}	
		}
	}
		
    return DIR_WS_SITE.$URLHref;	
		 
}

function SKSrcImage($ImageID,$Size="",$Param="")
{
	if($ImageID =="")
		return ;
	
	$return = "";
	if(d("CACHE_IMPLEMENT")=="1")
	{
		$CacheKey = $ImageID.$Size.serialize($Param).serialize(d("DEFINE_FRONT_SIDE_INCLUDE"));
		$SeourlDir = FileHandle::CheckPrivateLogDirectory("cache_seoimage");
		$filename=$SeourlDir .md5($CacheKey).".txt";
	}
	if(isset($filename) && file_exists($filename) && d("CACHE_IMPLEMENT")=="1")
	{
		$return = file_get_contents($filename);
	}
	else{
		
		$AltText = "";
		$ext = "jpg";
		$SeoObj = new DataTable(TABLE_SEO_IMAGES);
		$SeoObj->where[] = array('=',array('ImageID' => $ImageID));
		$CurrentImage = (object)$SeoObj->tableSelectOne(array("*"));
		if(isset($CurrentImage->URLName))
		{	
			$ext = pathinfo(DIR_FS_SITE_UPLOADS.$CurrentImage->DirPath."/".$CurrentImage->ImageID, PATHINFO_EXTENSION);
			$ImagePath = $CurrentImage->URLName."_".$Size.($Param!='' ?"_".$Param:"");
		}		
			
		if(!$ImagePath)
				$return ="";
			
			$StaticPath = DIR_WS_STATIC_SITE."img/index.php?i=";
			if(d("SEO_URL_ACTIVE")=="1")
				$StaticPath = DIR_WS_STATIC_SITE."img/".substr(pathinfo($ImageID)['filename'],-4)."/";
			
			$return = $StaticPath.$ImagePath.".jpg";
			
			if(isset($filename) && $filename != "" && d("CACHE_IMPLEMENT")=="1"){
				$fp2 = fopen($filename, "w");
				try{
					fputs($fp2,$return);	
				}finally {
					if ($fp2 !== null && is_resource($fp2)) {	
						fclose($fp2);
					}	
				}			
			}
	}
		return $return;
	
}

function SKSeoImage($ImageID,$Size="",$ImageTag=false,$Param="")
{
	if($ImageID =="")
		return ;
	
	$return = "";
	if(d("CACHE_IMPLEMENT")=="1")
	{
		$CacheKey = $ImageID.$Size.serialize($ImageTag).serialize($Param).serialize(d("DEFINE_FRONT_SIDE_INCLUDE"));
		$SeourlDir = FileHandle::CheckPrivateLogDirectory("cache_seoimage");
		$filename=$SeourlDir .md5($CacheKey).".txt";
	}
	if(isset($filename) && file_exists($filename) && d("CACHE_IMPLEMENT")=="1")
	{
		$return = file_get_contents($filename);
	}
	else{
		$AltText = "";$ext = "jpg";$ImagePath = "no-image_".$Size.($Param!='' ?"_".$Param:"");		
		$SeoObj = new DataTable(TABLE_SEO_IMAGES);
		$SeoObj->where[] = array('=',array('ImageID' => $ImageID));
		$CurrentImage = (object)$SeoObj->tableSelectOne(array("*"));
		if(isset($CurrentImage->URLName))
		{	
			$AltText = $CurrentImage->AltText;
			$ext = pathinfo(DIR_FS_SITE_UPLOADS.$CurrentImage->DirPath."/".$CurrentImage->ImageID, PATHINFO_EXTENSION);
			$ImagePath = $CurrentImage->URLName."_".$Size.($Param!='' ?"_".$Param:"");
		}		
		
		$SizeArray = array(320,480,640,1024,1400,1920,2500);
		$LoadingPath = "loading_".$Size.($Param!='' ?"_".$Param:"");
		$StaticPath = DIR_WS_STATIC_SITE."img/index.php?i=";
		if(d("SEO_URL_ACTIVE")=="1")
			$StaticPath = DIR_WS_STATIC_SITE."img/".substr(pathinfo($ImageID)['filename'],-4)."/";
		
		$SourceTag = array();
		$SourceTag['webp']= array("type"=>"image/webp",
								 "src"=>$StaticPath.$ImagePath.".webp",
								 "loading"=>$StaticPath.$LoadingPath.".webp",
								 "srcset"=>"");
		if(strtolower($ext) == "jpg"  || 
		   strtolower($ext) == "jpeg" ||
		   strtolower($ext) == "png" ||
		   strtolower($ext) == "gif" 
		   ){
			$SourceTag[$ext]= array("type"=>"image/".$ext,
								 "src"=>$StaticPath.$ImagePath.".".$ext,
								 "loading"=>$StaticPath.$LoadingPath.".".$ext,
								 "srcset"=>"");
			
		}
		
		if($Size == ""){				
			foreach(array(320,480,640,1024,1400,1920,2500) as $res){
				$SourceTag['webp']["srcset"] .= $StaticPath.$ImagePath.".webp ".$res."w,";
				$SourceTag[$ext]["srcset"] .= $StaticPath.$ImagePath.".".$ext." ".$res."w,";
			}				
		}		
		
		$return = $SourceTag['webp']['src'];	
		if($ImageTag !=false)
		{	
			$SizeArr = explode("x",$Size);
			$wh = "";
			if(isset($SizeArr[0]) && $SizeArr[0] > 0 && isset($SizeArr[1]) && $SizeArr[1] > 0){
			$wh .=' width="'.$SizeArr[0].'"';
			$wh .=' height="'.$SizeArr[1].'"';
			}
			else if(isset($SizeArr[0]) && $SizeArr[0] > 0){
				$wh .=' width="'.$SizeArr[0].'"';
				$wh .=' height="'.$SizeArr[0].'"';
			}
			
			If(isset($ImageTag) && is_array($ImageTag) && count($ImageTag) > 0){
				foreach($ImageTag as $k=>$v){
					if(d("DEFINE_IMAGE_LAZYSIZES")=="1" && strtolower($k)=="class")
						$wh .=' '.$k.'="lazyload '.$v.'"';
					else 
						$wh .=' '.$k.'="'.$v.'"';
				}
			}
			if(d("DEFINE_FRONT_SIDE_INCLUDE")===true && d("DEFINE_IMAGE_LAZYSIZES")=="1" && stripos($wh ,"myzoom")==false){
				
				if(true){
					$return = '<img '.((isset($SourceTag['webp']['srcset']) && $SourceTag['webp']['srcset'] != "")?'data-sizes="auto" data-srcset="'.substr($SourceTag['webp']['srcset'],0,-1).'" ':'').' 
								data-src="'.$SourceTag['webp']['src'].'" src="'.$SourceTag['webp']['loading'].'" '.$wh.' alt="'.$AltText.'" />';
				
				}
				else{
					$return = '<picture>';
					foreach($SourceTag as $ty=>$arr){
					$return .= '<source
									src="'.$arr['src'].'"
									data-src="'.$arr['src'].'"
									'.((isset($arr['srcset']) && $arr['srcset'] != "")?'data-sizes="auto" data-srcset="'.substr($arr['srcset'],0,-1).'" ':'').'
									 />
								';
					}
					$return .= '<img '.((isset($SourceTag['webp']['srcset']) && $SourceTag['webp']['srcset'] != "")?'data-sizes="auto" data-srcset="'.substr($SourceTag['webp']['srcset'],0,-1).'" ':'').' 
									data-src="'.$SourceTag['webp']['src'].'" src="'.$SourceTag['webp']['loading'].'" '.$wh.' alt="'.$AltText.'" />';
					$return .= '</picture>';
				}
				
				
				
			}
			else{
				$return = '<img src="'.$SourceTag['webp']['src'].'" '.$wh.' alt="'.$AltText.'" />';
			}				
		}
	}
	
	if(isset($filename) && $filename != "" && d("CACHE_IMPLEMENT")=="1"){
			$fp2 = fopen($filename, "w");
			try{
				fputs($fp2,$return);	
			}finally {
				if ($fp2 !== null && is_resource($fp2)) {	
					fclose($fp2);
				}	
			}			
	}
	
	return $return;
	
}
function SKImgDisplay($Path,$Size="",$URLOnly=false)
{
	if($URLOnly===true)
	{
			return $Path;
	}
	else 
	{
		if(strstr($Size,","))
		{
			$SizeArray = explode(",",$Size);
			$W= @$SizeArray[0];
			$H= @$SizeArray[1];
			if(isset($SizeArray[2]) && $SizeArray[2]=="C"){
				
				$HeightMode = "1";
				$Canvas = "1";
			}
			else{
				$HeightMode = isset($SizeArray[2])?$SizeArray[2]:"1";
				$Canvas = "0";
			}
		}
		else 
		{
			$W= $Size;
			$H= $Size;
			$HeightMode = "true";
		}
		if(!file_exists($Path) OR substr($Path,-1) =="/")
			$Path = DIR_FS_SITE_UPLOADS."no-image.jpg";
		$sk_id = base64_encode("OriginalPath=".$Path."&w=".$W."&h=".$H."&HeightMode=".$HeightMode."&C=".$Canvas."&st=11");
		$ArrayType = explode(".",$Path);
		$Type=$ArrayType[count($ArrayType)-1];
		if(d("SEO_URL_ACTIVE")=="1")
			$ImgSrc=  DIR_WS_SITE."skimm-".$sk_id.'.'.$Type;
		else 
			$ImgSrc=  DIR_WS_SITE."image.php?sk_id=$sk_id";
		
		return $ImgSrc;
		
	}		
	
}


function ConvertDateFromDbInput($date,$withtime=false)
{
	if(substr($date,0,10) == '0000-00-00' OR $date =="")
		return "-";
	
	if($withtime==true)
		return date('n/j/Y g:ia',strtotime($date));
	else
		return date('n/j/Y',strtotime($date));
}

function ConvertDateFromDb($date,$withtime=false)
{
	/*$return_date = $date;
	If($date != "" && substr($date,4,1)=="-" && substr($date,7,1)=="-")
		$return_date = substr($date,8,2)."/".substr($date,5,2)."/".substr($date,0,4);
    
	return $return_date;
	*/
	if(substr($date,0,10) == '0000-00-00' OR $date =="")
		return "-";
	
	if($withtime==true)
		return date('M j, Y g:ia',strtotime($date));
	else
		return date('M j, Y',strtotime($date));
}

function ConvertTimeFromDb($time)
{
	//echo $time;
	return date('g:ia',strtotime($time));
	/*$return_time = $time;
	$timeTmpArray = explode(" ",$time);
	
	if(isset($timeTmpArray[1]) && $timeTmpArray[1] != "")
		$time = $timeTmpArray[1];

	 $timeArray = explode(":",$time);
	 
	 if(isset($timeArray[0]) && $timeArray[0] > 12)
		 $return_time = sprintf('%2d',$timeArray[0]-12).":".sprintf('%02d',$timeArray[1])."pm";
	else
		$return_time = sprintf('%2d',$timeArray[0]).":".sprintf('%02d',$timeArray[1])."am";
	
	return $return_time;
	*/
}


function ConvertDatetoDb($date,$withtime=false)
{
	$return_date = $date;
	
	$dataArr = explode(" ",$date);
	if(isset($dataArr[0])){
			$ElArr = explode("/",$dataArr[0]);
			
		if(count($ElArr) < 1)	
			$ElArr = explode("-",$dataArr[0]);
		
		if(strlen($ElArr[2])==2)
			$ElArr[2] = "20".$ElArr[2];
			
			$return_date = sprintf('%04d',$ElArr[2])."-".sprintf('%02d',$ElArr[0])."-".sprintf('%02d',$ElArr[1]); // m/d/Y
			//$return_date = sprintf('%04d',$ElArr[2])."-".sprintf('%02d',$ElArr[1])."-".sprintf('%02d',$ElArr[0]); // d/m/Y	
	}
	
	// d/m/Y
	//If($date != "" && substr($date,2,1)=="/" && substr($date,5,1)=="/")
	//	$return_date = substr($date,6,4)."-".substr($date,3,2)."-".substr($date,0,2);
	
	// m/d/y
	//If($date != "" && substr($date,2,1)=="/" && substr($date,5,1)=="/")
	//	$return_date = substr($date,6,4)."-".substr($date,0,2)."-".substr($date,3,2);
	
	$return_time = "00:00:00";
	 if(isset($dataArr[1]) && isset($dataArr[2]) && strpos($date,"M") > 0)
	 {
		 $timeArray = explode(":",$dataArr[1]);
		 
		 if(isset($dataArr[2]) && $dataArr[2] != "")
		 {
			 if(strtolower(trim($dataArr[2]))=="pm")
			 {
				if($timeArray[0]==12) 
					$return_time =  sprintf('%02d',$timeArray[0]).":".sprintf('%02d',$timeArray[1]).":00";
				else
					$return_time =  sprintf('%02d',$timeArray[0]+12).":".sprintf('%02d',$timeArray[1]).":00";
			 }
			 else
			 {
				 if($timeArray[0]==12) 
					 $return_time =  sprintf('%02d',"00").":".sprintf('%02d',$timeArray[1]).":00";
				else
					$return_time =  sprintf('%02d',$timeArray[0]).":".sprintf('%02d',$timeArray[1]).":00";
			 }
		 }
		 
	 }
	 
	 if($withtime==true)
		return $return_date." ".$return_time;
	else
		return $return_date;
}

function SkParseGetVar($text)
{
	$exclude_key = array("'",'"',"union","table",'information_schema','database',"schema_name","join","column");
	foreach($exclude_key as $k=>$v)
		$text = str_ireplace($v,'', $text);
	return $text;
}

function NeoCryptedPassword($plaintext, $salt = '')
{
	$encrypted = ($salt) ? md5($plaintext.$salt) : md5($plaintext);
	return $encrypted;
}

function MyEncryptData($data, $key,$iv)
{
	$iv = substr($iv,0,16);
	return base64_encode(openssl_encrypt($data ,'AES-128-CBC' , $key,0,$iv));
}

function MyDecryptData($data, $key,$iv)
{
	$iv = substr($iv,0,16);
	return openssl_decrypt (base64_decode($data) ,'AES-128-CBC' , $key,0,$iv);
}


function MyStripSlashes($Str,$EditorMode=false)
{
	if($Str != ""){
		$Str = str_replace('<?php echo DIR_WS_SITE?>',DIR_WS_SITE,$Str);
		$Str = str_replace('<?=DIR_WS_SITE?>',DIR_WS_SITE,$Str);
		$Str = str_replace('<?=DTS_WS_SITE?>',DIR_WS_SITE,$Str);
		$Str = str_replace('<?php echo DTS_WS_SITE?>',DIR_WS_SITE,$Str);
		$Str = str_replace('<?php  echo DTS_WS_SITE?>',DIR_WS_SITE,$Str);
		$Str = str_replace('<?php   echo DTS_WS_SITE?>',DIR_WS_SITE,$Str);
		$Str = str_replace('<?php    echo DTS_WS_SITE?>',DIR_WS_SITE,$Str);
		$Str = str_replace('<?php     echo DTS_WS_SITE?>',DIR_WS_SITE,$Str);
		$Str  = str_replace ( array('&apos;','Â', "{SITE_NAME}","{{SITENAME}}"), 
							  array( "'"    , "",d("SITE_NAME"),d("SITE_NAME")), $Str);
		if(strpos(DIR_WS_SITE,"http:")===false)
			$Str  = str_replace ( array('http:/'), array('https:/'), $Str);
		
		
		$Str = stripslashes($Str);
		if($EditorMode===false){
			//$Str  = str_replace ( array('"'), array( "&quot;"), $Str);
			//$Str  = str_replace ( array("'"), array( "&apos;"), $Str);
		}
		
		if(function_exists("SKExtraContent") && ($EditorMode===false))
			$Str = SKExtraContent($Str);
		if(function_exists("SKEditorInject") && ($EditorMode===false))
		{
			$Str = SKEditorInject($Str);
		}
	}
	return $Str;		
}

function SKEditorInject($Str)
{
	/* CustomObjectImage start*/
	preg_match_all("/{%(.*)_(.*)%}/Uis", $Str, $matches);
	if (is_array($matches) && count($matches) >0) 
	{
		for ($m = 0; $m < count($matches); $m++) 
		 {
			if(isset($matches[0][$m]) && $matches[0][$m]  != "" && 
			   isset($matches[1][$m]) && $matches[1][$m]  != "" &&
			   isset($matches[2][$m]) && $matches[2][$m]  != ""){
				
				$obj = new PagesCommon();
				$Customcontent = $obj->SKEditorTags($matches[0][$m],$matches[1][$m],$matches[2][$m]);
		 		$Str = str_replace($matches[0][$m],$Customcontent,$Str);
			}
			
		 }
	}
	/* CustomObjectImage end*/
	
	
	return $Str;
}

function SKRemoveSpecialChars($text)
{
	/*
	  48 through 57
	  65 through 90
	  97 through 122
	 192 through 246
	*/
	$text = preg_replace('/[^\x30-\x39\x41-\x5a\x61-\x7a\xc0-\xf6]/', '', $text);
	return $text;
}

function SkURLCreate($text)
{
	$text=strtolower(trim($text));
	$text = str_replace(array(" "),array("-"), $text);
	$text = preg_replace('/[^a-zA-Z0-9_-]/s', '', $text);
	//$text= preg_replace('/[^\w\d_ -]/si', '', $text);
	$text = str_replace(array("--"),array("-"), $text);
	$text = str_replace(array("--"),array("-"), $text);
	return $text;
}

function CheckHacking()
{
	array_walk_recursive($_GET,"SKStringSave");
	array_walk_recursive($_POST,"SKStringSave");
}

function SKStringSave(&$item, $key)
{
	$apply =true;					   
	$TextAreaArray = array("Description",
						   "SmallDescription",
						   "Message",
						   "MessageBody",
						   "g-recaptcha-response",
						   "EKEY",
						   "code",
						   );

	if(strpos($key,"Mail_") !== false)
		 $apply =false;	
	else if(in_array($key,$TextAreaArray))
		 $apply =false;	
	
	
	if($apply==true)
		 $item = substr($item,0,500);
	
}

