<?php get_header(); ?>

<div class="container my-5">
    <div class="row">
        <div class="col-lg-8">
            <?php while (have_posts()) : the_post(); ?>
                <article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
                    <header class="entry-header mb-4">
                        <h1 class="entry-title section-title"><?php the_title(); ?></h1>
                        <?php
                        $subtitle = get_post_meta(get_the_ID(), '_subtitle', true);
                        if ($subtitle) {
                            echo '<h2 class="section-subtitle">' . esc_html($subtitle) . '</h2>';
                        }
                        ?>
                        <div class="entry-meta text-muted mb-3">
                            <span class="posted-on">Published on <?php echo get_the_date(); ?></span>
                        </div>
                    </header>

                    <?php if (has_post_thumbnail()) : ?>
                        <div class="entry-thumbnail mb-4">
                            <?php the_post_thumbnail('large', array('class' => 'img-fluid section-image')); ?>
                        </div>
                    <?php endif; ?>

                    <div class="entry-content">
                        <?php the_content(); ?>
                    </div>

                    <?php
                    $button_text = get_post_meta(get_the_ID(), '_button_text', true);
                    $button_link = get_post_meta(get_the_ID(), '_button_link', true);
                    if ($button_text && $button_link) {
                        echo '<div class="entry-actions mt-4">';
                        echo '<a href="' . esc_url($button_link) . '" class="btn btn-dark-custom">' . esc_html($button_text) . '</a>';
                        echo '</div>';
                    }
                    ?>
                </article>
            <?php endwhile; ?>
        </div>
        
        <div class="col-lg-4">
            <?php get_sidebar(); ?>
        </div>
    </div>
</div>

<?php get_footer(); ?>
