<?php get_header(); ?>

<!-- Hero Banner -->
<section class="hero-banner">
  <div class="container-fluid">
    <div class="row align-items-center">
      <div class="col-lg-6">
        <img src="<?php echo get_template_directory_uri(); ?>/assets/image-3.png" alt="Trevor Lyttleton" class="hero-image">
      </div>
      <div class="col-lg-6">
        <div class="hero-content">
          <h1 class="hero-title">Trevor Lyttleton MBE</h1>
          <p class="hero-subtitle">LAWYER GAMECHANGER CAMPAIGNER AND COMPOSER HAS LEFT AN INDELIBLE MARK IN MANY FIELDS</p>
          <button class="btn btn-custom">Find out more</button>
        </div>
      </div>
    </div>
  </div>
</section>

<!-- Legal Trailblazer Section -->
<section class="content-section py-5">
  <div class="container">
    <div class="row align-items-center">
      <div class="col-lg-6">
        <h2 class="section-title">LEGAL TRAILBLAZER AND REFORMER</h2>
        <p class="section-text">Trevor Lyttleton's 50 year legal career started at Freshfields in 1961. He later specialized in music copyright, elder law and handled challenging Court of Protection cases. He has consistently campaigned for the legal protection of music rights and dignified care for the elderly and most vulnerable.</p>
        <button class="btn btn-dark-custom">Find out more</button>
      </div>
      <div class="col-lg-6">
        <img src="<?php echo get_template_directory_uri(); ?>/assets/trevor-producing-at--audio-international--1.png" alt="Trevor at Audio International" class="section-image">
      </div>
    </div>
  </div>
</section>

<!-- Elderly Isolation Campaign -->
<section class="dark-section">
  <div class="container-fluid">
    <div class="row align-items-center">
      <div class="col-lg-6">
        <img src="<?php echo get_template_directory_uri(); ?>/assets/image-6.png" alt="Elderly Campaign" class="section-image">
      </div>
      <div class="col-lg-6">
        <div class="dark-content">
          <h2 class="section-title-white">60 YEAR CAMPAIGN AGAINST<br>ELDERLY ISOLATION</h2>
          <p class="section-text-white">Trevor Lyttleton is well known as Founder of Contact the Elderly (now Reengage), the groundbreaking charity he established in 1965 to combat elderly isolation. The charity's regular tea parties have since provided a vital lifeline for many tens of thousands of older people across the UK.</p>
          <button class="btn btn-outline-light">Find out more</button>
        </div>
      </div>
    </div>
  </div>
</section>

<!-- PRS Campaign Section -->
<section class="content-section py-5">
  <div class="container">
    <div class="row">
      <div class="col-lg-6">
        <h2 class="section-title mb-4">CAMPAIGN TO REFORM THE PERFORMING<br>RIGHT SOCIETY (PRS)</h2>
        <h3 class="section-subtitle mb-4">CAMPAIGNS TO PROTECT MUSIC<br>& COPYRIGHT IN UK KOREA JAPAN & CHINA</h3>
        <p class="section-text">Trevor Lyttleton's successful campaign in the 70s to make The Performing Right Society (PRS) accountable to its composer and publisher members, highlighted the need for transparency and fairness that left a lasting legacy on PRS and the music industry.<br><br>His widely acknowledged efforts changed Company law with 'The PRS amendment to the Companies Act 1982' that compelled PRS and all Guarantee Companies to provide members with voting lists.</p>
        <button class="btn btn-dark-custom">Find out more</button>
      </div>
      <div class="col-lg-6">
        <img src="<?php echo get_template_directory_uri(); ?>/assets/image-5.png" alt="PRS Campaign" class="section-image">
      </div>
    </div>
  </div>
</section>

<!-- Grammy Composer Section -->
<section class="dark-section">
  <div class="container-fluid">
    <div class="row align-items-center">
      <div class="col-lg-6">
        <img src="<?php echo get_template_directory_uri(); ?>/assets/image-9.png" alt="Grammy Composer" class="section-image">
      </div>
      <div class="col-lg-6">
        <div class="dark-content">
          <h2 class="section-title-white">GRAMMY NOMINATED COMPOSER</h2>
          <p class="section-text-white">Trevor Lyttleton is a Grammy nominated composer with 23 albums and 345 of his wide repertoire of recorded compositions played on major streaming platforms worldwide.<br><br>His contributions to music and the protection of copyright have earned him international recognition and respect within the music industry.</p>
          <button class="btn btn-outline-light">Find out more</button>
        </div>
      </div>
    </div>
  </div>
</section>

<!-- Legal Reformer Section -->
<section class="content-section py-5">
  <div class="container">
    <div class="row align-items-center">
      <div class="col-lg-6">
        <h2 class="section-title">LEGAL TRAILBLAZER AND REFORMER</h2>
        <p class="section-text">Trevor Lyttleton's 50 year legal career started at Freshfields in 1961. He later specialized in music copyright, elder law and handled challenging Court of Protection cases. He has consistently campaigned for the legal protection of music rights and dignified care for the elderly and most vulnerable.</p>
        <button class="btn btn-dark-custom">Find out more</button>
      </div>
      <div class="col-lg-6">
        <img src="<?php echo get_template_directory_uri(); ?>/assets/image-10.png" alt="Legal Reformer" class="section-image">
      </div>
    </div>
  </div>
</section>

<!-- National Lottery Section -->
<section class="dark-section">
  <div class="container-fluid">
    <div class="row align-items-center">
      <div class="col-lg-6">
        <div class="dark-content">
          <h2 class="section-title-white">NATIONAL LOTTERY GAME CHANGER<br>AWARD 2024</h2>
          <p class="section-text-white">Trevor Lyttleton was honoured with The National Lottery Game Changer Communities Award 2024 for his visionary 60 year Campaign against Elderly isolation.</p>
          <button class="btn btn-dark-custom">Find out more</button>
        </div>
      </div>
      <div class="col-lg-6">
        <img src="<?php echo get_template_directory_uri(); ?>/assets/image-12.png" alt="National Lottery Award" class="section-image">
      </div>
    </div>
  </div>
</section>

<!-- Water Walking Quote Section -->
<section class="quote-section" style="background-image: url('<?php echo get_template_directory_uri(); ?>/assets/image-13.png');">
  <div class="container-fluid">
    <div class="quote-overlay">
      <div class="container">
        <div class="row">
          <div class="col-12">
            <h2 class="quote-title">Trevor Lyttleton Gamechanger and 3x2m portrait in the<br>St James's Park Lake.</h2>
            <p class="quote-text">"I never thought I'd walk on water!"</p>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>

<!-- Mission Section -->
<section class="content-section py-5">
  <div class="container">
    <div class="row align-items-center">
      <div class="col-lg-6">
        <img src="<?php echo get_template_directory_uri(); ?>/assets/image-14.png" alt="Trevor Mission" class="section-image">
      </div>
      <div class="col-lg-6">
        <h2 class="section-title">TREVOR LIFETIME MISSION</h2>
        <p class="section-text">"Speak truth to power" and "Help make the world a better place".<br><br>His mission is built on an unwavering commitment to fairness, dignity, and innovation. His work has not only reformed the law and the world of music but has also provided a lifeline to those most in need.<br><br>Through this project, we invite you to explore his groundbreaking campaigns, music, and enduring contributions to society.</p>
        <button class="btn btn-outline-primary">Find out more</button>
      </div>
    </div>
  </div>
</section>

<?php get_footer(); ?>
