<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
  <meta charset="<?php bloginfo('charset'); ?>">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title><?php wp_title('|', true, 'right'); ?><?php bloginfo('name'); ?></title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://fonts.googleapis.com/css2?family=Lato:wght@400;600;700&display=swap" rel="stylesheet">
  <?php wp_head(); ?>
</head>
<body <?php body_class(); ?>>

<!-- Header -->
<header class="header-section">
  <div class="container-fluid">
    <nav class="navbar navbar-expand-lg">
      <div class="row w-100 align-items-center">
        <div class="col-md-6">
          <img src="<?php echo get_template_directory_uri(); ?>/assets/logo-1@2x.png" alt="Trevor Lyttleton Logo" class="logo">
        </div>
        <div class="col-md-6">
          <div class="d-flex justify-content-end align-items-center">
            <?php
            wp_nav_menu(array(
              'theme_location' => 'primary',
              'menu_class' => 'd-flex align-items-center',
              'container' => false,
              'fallback_cb' => false,
              'items_wrap' => '%3$s',
              'walker' => new class extends Walker_Nav_Menu {
                function start_el(&$output, $item, $depth = 0, $args = null, $id = 0) {
                  $output .= '<a href="' . $item->url . '" class="nav-link me-4">' . $item->title . '</a>';
                }
              }
            ));
            ?>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
              <img src="<?php echo get_template_directory_uri(); ?>/assets/menu@2x.png" alt="Menu" class="menu-icon">
            </button>
          </div>
        </div>
      </div>
    </nav>
  </div>
</header>
