# Trevor Lyttleton MBE WordPress Theme

This is a complete WordPress theme for the Trevor Lyttleton MBE website, converted from the original Figma design.

## Theme Structure

```
trevor-lyttleton-theme/
├── style.css              # Main theme stylesheet with Bootstrap 5
├── index.php              # Homepage template
├── header.php             # Site header template
├── footer.php             # Site footer template
├── functions.php          # Theme functions and custom post types
├── single.php             # Single post template
├── page.php               # Page template
├── archive.php            # Archive template
├── sidebar.php            # Sidebar template
├── assets/                # All theme images
│   ├── logo-1@2x.png
│   ├── logo@2x.png
│   ├── menu@2x.png
│   ├── image-3.png
│   ├── image-5.png
│   ├── image-6.png
│   ├── image-9.png
│   ├── image-10.png
│   ├── image-12.png
│   ├── image-13.png
│   ├── image-14.png
│   ├── trevor-producing-at--audio-international--1.png
│   ├── fb.png
│   ├── vector.png
│   └── insta.png
└── README.md              # This file
```

## Installation

1. Upload the entire `trevor-lyttleton-theme` folder to your WordPress `/wp-content/themes/` directory
2. Activate the theme in WordPress Admin > Appearance > Themes
3. Import the content using the `trevor-lyttleton-content.xml` file

## Features

- **Bootstrap 5 Integration**: Fully responsive design
- **Custom Post Types**: Campaigns, Music, Legal Cases
- **Custom Fields**: Subtitle, button text/links, section types
- **Widget Support**: Sidebar widget area
- **Menu Support**: Primary and footer navigation menus
- **All Assets Included**: All images are included in the assets folder

## Custom Post Types

The theme includes three custom post types:

1. **Campaigns** - For Trevor's social and legal campaigns
2. **Music** - For his musical compositions and albums  
3. **Legal Cases** - For significant legal work and cases

Each post type includes custom meta fields for enhanced content management.

## Content Import

Use the included `trevor-lyttleton-content.xml` file to import all the sample content, including pages and custom post type entries.

## Support

This theme was created by Anima for the Trevor Lyttleton MBE website project.
