<?php
// Theme setup
function trevor_lyttleton_setup() {
    // Add theme support for various features
    add_theme_support('post-thumbnails');
    add_theme_support('title-tag');
    add_theme_support('custom-logo');
    add_theme_support('html5', array('search-form', 'comment-form', 'comment-list', 'gallery', 'caption'));
    
    // Register navigation menus
    register_nav_menus(array(
        'primary' => __('Primary Menu', 'trevor-lyttleton'),
        'footer' => __('Footer Menu', 'trevor-lyttleton'),
    ));
}
add_action('after_setup_theme', 'trevor_lyttleton_setup');

// Enqueue styles and scripts
function trevor_lyttleton_scripts() {
    wp_enqueue_style('trevor-lyttleton-style', get_stylesheet_uri());
    wp_enqueue_style('bootstrap', 'https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css');
    wp_enqueue_style('lato-font', 'https://fonts.googleapis.com/css2?family=Lato:wght@400;600;700&display=swap');
    
    wp_enqueue_script('bootstrap-js', 'https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js', array(), '5.3.0', true);
}
add_action('wp_enqueue_scripts', 'trevor_lyttleton_scripts');

// Register widget areas
function trevor_lyttleton_widgets_init() {
    register_sidebar(array(
        'name'          => __('Sidebar', 'trevor-lyttleton'),
        'id'            => 'sidebar-1',
        'description'   => __('Add widgets here.', 'trevor-lyttleton'),
        'before_widget' => '<section id="%1$s" class="widget %2$s">',
        'after_widget'  => '</section>',
        'before_title'  => '<h2 class="widget-title">',
        'after_title'   => '</h2>',
    ));
}
add_action('widgets_init', 'trevor_lyttleton_widgets_init');

// Custom post types
function create_custom_post_types() {
    // Campaigns post type
    register_post_type('campaigns',
        array(
            'labels' => array(
                'name' => __('Campaigns'),
                'singular_name' => __('Campaign')
            ),
            'public' => true,
            'has_archive' => true,
            'supports' => array('title', 'editor', 'thumbnail', 'excerpt'),
            'menu_icon' => 'dashicons-megaphone',
        )
    );
    
    // Music post type
    register_post_type('music',
        array(
            'labels' => array(
                'name' => __('Music'),
                'singular_name' => __('Music')
            ),
            'public' => true,
            'has_archive' => true,
            'supports' => array('title', 'editor', 'thumbnail', 'excerpt'),
            'menu_icon' => 'dashicons-format-audio',
        )
    );
    
    // Legal Cases post type
    register_post_type('legal_cases',
        array(
            'labels' => array(
                'name' => __('Legal Cases'),
                'singular_name' => __('Legal Case')
            ),
            'public' => true,
            'has_archive' => true,
            'supports' => array('title', 'editor', 'thumbnail', 'excerpt'),
            'menu_icon' => 'dashicons-portfolio',
        )
    );
}
add_action('init', 'create_custom_post_types');

// Add custom fields support
function trevor_lyttleton_add_meta_boxes() {
    add_meta_box(
        'section_details',
        'Section Details',
        'trevor_lyttleton_section_details_callback',
        array('campaigns', 'music', 'legal_cases'),
        'normal',
        'high'
    );
}
add_action('add_meta_boxes', 'trevor_lyttleton_add_meta_boxes');

function trevor_lyttleton_section_details_callback($post) {
    wp_nonce_field('trevor_lyttleton_save_meta_box_data', 'trevor_lyttleton_meta_box_nonce');
    
    $subtitle = get_post_meta($post->ID, '_subtitle', true);
    $button_text = get_post_meta($post->ID, '_button_text', true);
    $button_link = get_post_meta($post->ID, '_button_link', true);
    $section_type = get_post_meta($post->ID, '_section_type', true);
    
    echo '<table class="form-table">';
    echo '<tr><th><label for="subtitle">Subtitle</label></th>';
    echo '<td><input type="text" id="subtitle" name="subtitle" value="' . esc_attr($subtitle) . '" size="50" /></td></tr>';
    echo '<tr><th><label for="button_text">Button Text</label></th>';
    echo '<td><input type="text" id="button_text" name="button_text" value="' . esc_attr($button_text) . '" size="25" /></td></tr>';
    echo '<tr><th><label for="button_link">Button Link</label></th>';
    echo '<td><input type="url" id="button_link" name="button_link" value="' . esc_attr($button_link) . '" size="50" /></td></tr>';
    echo '<tr><th><label for="section_type">Section Type</label></th>';
    echo '<td><select id="section_type" name="section_type">';
    echo '<option value="light"' . selected($section_type, 'light', false) . '>Light</option>';
    echo '<option value="dark"' . selected($section_type, 'dark', false) . '>Dark</option>';
    echo '</select></td></tr>';
    echo '</table>';
}

function trevor_lyttleton_save_meta_box_data($post_id) {
    if (!isset($_POST['trevor_lyttleton_meta_box_nonce'])) {
        return;
    }
    
    if (!wp_verify_nonce($_POST['trevor_lyttleton_meta_box_nonce'], 'trevor_lyttleton_save_meta_box_data')) {
        return;
    }
    
    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
        return;
    }
    
    if (isset($_POST['subtitle'])) {
        update_post_meta($post_id, '_subtitle', sanitize_text_field($_POST['subtitle']));
    }
    
    if (isset($_POST['button_text'])) {
        update_post_meta($post_id, '_button_text', sanitize_text_field($_POST['button_text']));
    }
    
    if (isset($_POST['button_link'])) {
        update_post_meta($post_id, '_button_link', esc_url_raw($_POST['button_link']));
    }
    
    if (isset($_POST['section_type'])) {
        update_post_meta($post_id, '_section_type', sanitize_text_field($_POST['section_type']));
    }
}
add_action('save_post', 'trevor_lyttleton_save_meta_box_data');
?>
