<?php get_header(); ?>

<div class="container my-5">
    <div class="row">
        <div class="col-12">
            <header class="page-header mb-5">
                <h1 class="page-title section-title">
                    <?php
                    if (is_post_type_archive()) {
                        post_type_archive_title();
                    } else {
                        the_archive_title();
                    }
                    ?>
                </h1>
                <?php the_archive_description('<div class="archive-description section-text">', '</div>'); ?>
            </header>
        </div>
    </div>

    <div class="row">
        <?php if (have_posts()) : ?>
            <?php while (have_posts()) : the_post(); ?>
                <div class="col-md-6 col-lg-4 mb-4">
                    <article id="post-<?php the_ID(); ?>" <?php post_class('card h-100'); ?>>
                        <?php if (has_post_thumbnail()) : ?>
                            <div class="card-img-top">
                                <?php the_post_thumbnail('medium', array('class' => 'img-fluid')); ?>
                            </div>
                        <?php endif; ?>
                        
                        <div class="card-body d-flex flex-column">
                            <h2 class="card-title h5">
                                <a href="<?php the_permalink(); ?>" class="text-decoration-none">
                                    <?php the_title(); ?>
                                </a>
                            </h2>
                            
                            <div class="card-text flex-grow-1">
                                <?php the_excerpt(); ?>
                            </div>
                            
                            <div class="mt-auto">
                                <a href="<?php the_permalink(); ?>" class="btn btn-dark-custom">Read More</a>
                            </div>
                        </div>
                    </article>
                </div>
            <?php endwhile; ?>
        <?php else : ?>
            <div class="col-12">
                <p class="section-text">No posts found.</p>
            </div>
        <?php endif; ?>
    </div>

    <?php
    // Pagination
    the_posts_pagination(array(
        'mid_size' => 2,
        'prev_text' => __('Previous', 'trevor-lyttleton'),
        'next_text' => __('Next', 'trevor-lyttleton'),
    ));
    ?>
</div>

<?php get_footer(); ?>
