# Trevor Lyttleton MBE WordPress Theme

This package contains a complete WordPress theme and content for the Trevor Lyttleton MBE website.

## Package Contents

### WordPress Theme (`trevor-lyttleton-theme/`)
- `style.css` - Main theme stylesheet with Bootstrap 5 integration
- `index.php` - Homepage template
- `header.php` - Site header template
- `footer.php` - Site footer template
- `functions.php` - Theme functions and custom post types
- `single.php` - Single post template
- `page.php` - Page template
- `archive.php` - Archive template
- `sidebar.php` - Sidebar template

### Content Import (`trevor-lyttleton-content.xml`)
- WordPress WXR file containing all pages and posts
- Custom post types: Campaigns, Music, Legal Cases
- Categories and metadata
- Ready for WordPress import

### Assets Folder (`assets/`)
Contains all images used in the theme:
- Logo files (logo-1@2x.png, logo@2x.png)
- Hero and section images (image-3.png through image-14.png)
- Navigation icons (menu@2x.png)
- Social media icons (fb.png, vector.png, insta.png)
- Campaign and music related images

## Installation Instructions

### 1. Install WordPress Theme
1. Upload the `trevor-lyttleton-theme` folder to your WordPress `/wp-content/themes/` directory
2. Copy the `assets` folder to the theme directory: `/wp-content/themes/trevor-lyttleton-theme/assets/`
3. Activate the theme in WordPress Admin > Appearance > Themes

### 2. Import Content
1. Go to WordPress Admin > Tools > Import
2. Install the WordPress Importer if not already installed
3. Upload and import the `trevor-lyttleton-content.xml` file
4. Assign posts to existing user or create new author

### 3. Configure Menus
1. Go to WordPress Admin > Appearance > Menus
2. Create a new menu and assign it to "Primary Menu" location
3. Add the imported pages (Home, Background, Contact) to the menu

### 4. Set Homepage
1. Go to WordPress Admin > Settings > Reading
2. Set "A static page" as your homepage
3. Select "Home" as the homepage

## Theme Features

- **Bootstrap 5 Integration**: Fully responsive design using Bootstrap 5
- **Custom Post Types**: Campaigns, Music, Legal Cases
- **Custom Fields**: Subtitle, button text/links, section types
- **Widget Support**: Sidebar widget area
- **Menu Support**: Primary and footer navigation menus
- **SEO Ready**: Proper HTML5 structure and meta tags

## Customization

The theme includes custom post types and fields that can be managed through the WordPress admin:

- **Campaigns**: For Trevor's various social and legal campaigns
- **Music**: For his musical compositions and albums
- **Legal Cases**: For significant legal work and cases

Each post type includes custom fields for subtitles, button text/links, and section styling options.

## Support

For theme support or customization requests, please contact the development team.
