<?php get_header(); ?>

<div class="container py-5">
    <div class="row">
        <div class="col-8">
            <?php while (have_posts()) : the_post(); ?>
                <article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
                    <header class="entry-header mb-4">
                        <h1 class="entry-title display-4 fw-bold"><?php the_title(); ?></h1>
                        <div class="entry-meta text-muted mb-3">
                            <span>Published on <?php echo get_the_date(); ?></span>
                            <span> by <?php the_author(); ?></span>
                        </div>
                        <hr>
                    </header>

                    <?php if (has_post_thumbnail()) : ?>
                        <div class="entry-thumbnail mb-4">
                            <?php the_post_thumbnail('large', array('class' => 'img-fluid rounded')); ?>
                        </div>
                    <?php endif; ?>

                    <div class="entry-content">
                        <?php the_content(); ?>
                    </div>

                    <footer class="entry-footer mt-4">
                        <?php
                        $categories = get_the_category();
                        if ($categories) {
                            echo '<div class="categories mb-3"><strong>Categories:</strong> ';
                            foreach ($categories as $category) {
                                echo '<a href="' . get_category_link($category->term_id) . '" class="badge bg-primary me-1">' . $category->name . '</a>';
                            }
                            echo '</div>';
                        }
                        
                        $tags = get_the_tags();
                        if ($tags) {
                            echo '<div class="tags"><strong>Tags:</strong> ';
                            foreach ($tags as $tag) {
                                echo '<a href="' . get_tag_link($tag->term_id) . '" class="badge bg-secondary me-1">' . $tag->name . '</a>';
                            }
                            echo '</div>';
                        }
                        ?>
                    </footer>
                </article>
            <?php endwhile; ?>
        </div>
        
        <div class="col-4">
            <?php get_sidebar(); ?>
        </div>
    </div>
</div>

<?php get_footer(); ?>
