<?php get_header(); ?>

<!-- Hero Carousel Section -->
<section class="hero-section">
    <div id="heroCarousel" class="carousel slide" data-bs-ride="carousel" data-bs-interval="5000">
        <!-- Carousel Indicators -->
        <div class="carousel-indicators">
            <button type="button" data-bs-target="#heroCarousel" data-bs-slide-to="0" class="active" aria-current="true" aria-label="Slide 1"></button>
            <button type="button" data-bs-target="#heroCarousel" data-bs-slide-to="1" aria-label="Slide 2"></button>
            <button type="button" data-bs-target="#heroCarousel" data-bs-slide-to="2" aria-label="Slide 3"></button>
        </div>

        <!-- Carousel Inner -->
        <div class="carousel-inner">
            <!-- Slide 1 -->
            <div class="carousel-item active">
                <div class="carousel-slide d-flex align-items-center" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);">
                    <div class="container">
                        <div class="row align-items-center">
                            <div class="col-6">
                                <div class="hero-content text-white">
                                    <h1 class="fw-bold mb-4" style="font-size: 3rem; text-shadow: 0px 4px 4px rgba(0,0,0,0.4);">NEW AND REFURBISHED PHONES, COMPUTERS AND ACCESSORIES</h1>
                                    <a href="<?php echo get_permalink(wc_get_page_id('shop')); ?>" class="btn-outline-light">SHOP NOW</a>
                                </div>
                            </div>
                            <div class="col-6">
                                <div class="text-center">
                                    <img src="https://images.unsplash.com/photo-1511707171634-5f897ff02aa9?w=500&h=400&fit=crop&crop=center" alt="Smartphones" style="max-height: 400px; object-fit: cover; border-radius: 10px;">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Slide 2 -->
            <div class="carousel-item">
                <div class="carousel-slide d-flex align-items-center" style="background: linear-gradient(135deg, #ff6b6b 0%, #ee5a24 100%);">
                    <div class="container">
                        <div class="row align-items-center">
                            <div class="col-6">
                                <div class="hero-content text-white">
                                    <h1 class="fw-bold mb-4" style="font-size: 3rem; text-shadow: 0px 4px 4px rgba(0,0,0,0.4);">PREMIUM LAPTOPS & TABLETS AT UNBEATABLE PRICES</h1>
                                    <a href="<?php echo get_permalink(wc_get_page_id('shop')); ?>" class="btn-outline-light">EXPLORE DEALS</a>
                                </div>
                            </div>
                            <div class="col-6">
                                <div class="text-center">
                                    <img src="https://images.unsplash.com/photo-1496181133206-80ce9b88a853?w=500&h=400&fit=crop&crop=center" alt="Laptops" style="max-height: 400px; object-fit: cover; border-radius: 10px;">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Slide 3 -->
            <div class="carousel-item">
                <div class="carousel-slide d-flex align-items-center" style="background: linear-gradient(135deg, #74b9ff 0%, #0984e3 100%);">
                    <div class="container">
                        <div class="row align-items-center">
                            <div class="col-6">
                                <div class="hero-content text-white">
                                    <h1 class="fw-bold mb-4" style="font-size: 3rem; text-shadow: 0px 4px 4px rgba(0,0,0,0.4);">SMART WATCHES & ACCESSORIES FOR MODERN LIFE</h1>
                                    <a href="<?php echo get_permalink(wc_get_page_id('shop')); ?>" class="btn-outline-light">DISCOVER MORE</a>
                                </div>
                            </div>
                            <div class="col-6">
                                <div class="text-center">
                                    <img src="https://images.unsplash.com/photo-1523275335684-37898b6baf30?w=500&h=400&fit=crop&crop=center" alt="Smart Watches" style="max-height: 400px; object-fit: cover; border-radius: 10px;">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Carousel Controls -->
        <button class="carousel-control-prev" type="button" data-bs-target="#heroCarousel" data-bs-slide="prev">
            <span class="carousel-control-prev-icon" aria-hidden="true"></span>
            <span class="visually-hidden">Previous</span>
        </button>
        <button class="carousel-control-next" type="button" data-bs-target="#heroCarousel" data-bs-slide="next">
            <span class="carousel-control-next-icon" aria-hidden="true"></span>
            <span class="visually-hidden">Next</span>
        </button>
    </div>
</section>

<!-- Categories Section -->
<section class="py-5">
    <div class="container">
        <div class="row">
            <div class="col-6">
                <div class="category-card">
                    <h2 class="fw-bold mb-4" style="font-size: 2.5rem;">WHY BUY REFURBISHED MOBILES WITH US?</h2>
                    <p class="mb-4">The impact of well-crafted website content cannot be overstated and can be the difference between a thriving online presence and a lackluster one. If you find yourself unsure about writing your own content or simply don't have the time, we have just the thing for you.</p>
                    <p class="mb-4">Our ContentWriter package is designed to elevate your website content, our team skilfully create all text content for your website, ensuring an engaging user experience for your website visitors. Countless clients have already benefited from this service, and as a valued ElevateOM client, you can enjoy exclusive discounted rates!</p>
                    <a href="<?php echo get_permalink(wc_get_page_id('shop')); ?>" class="btn-primary">SHOP NOW</a>
                </div>
            </div>
            <div class="col-6">
                <div class="row">
                    <div class="col-6 mb-3">
                        <div class="category-card text-center">
                            <div class="category-image mb-3">📱</div>
                            <h5 class="text-danger fw-bold">PHONES</h5>
                        </div>
                    </div>
                    <div class="col-6 mb-3">
                        <div class="category-card text-center">
                            <div class="category-image mb-3">📱</div>
                            <h5 class="text-danger fw-bold">TABLETS</h5>
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="category-card text-center">
                            <div class="category-image mb-3">⌚</div>
                            <h5 class="text-danger fw-bold">SMART WATCHES</h5>
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="category-card text-center">
                            <div class="category-image mb-3">💻</div>
                            <h5 class="text-danger fw-bold">TECH</h5>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Offers Section -->
<section class="py-5">
    <div class="container">
        <div class="row gap-3">
            <div class="col-6">
                <div class="offer-section">
                    <h2 class="fw-bold mb-4">TOP PICKS PRICED BELOW<br><span style="font-size: 4rem;">£150</span></h2>
                    <a href="<?php echo get_permalink(wc_get_page_id('shop')); ?>" class="btn-outline-light">SHOP NOW</a>
                </div>
            </div>
            <div class="col-6">
                <div class="offer-section">
                    <h2 class="fw-bold mb-4">WE SELL REFURBISHED TABLETS, MACBOOKS, CONSOLES, AND WEARABLES.</h2>
                    <a href="<?php echo get_permalink(wc_get_page_id('shop')); ?>" class="btn-outline-light">SHOP NOW</a>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Best Selling Items -->
<section class="py-5">
    <div class="container">
        <h2 class="text-center fw-bold mb-5" style="font-size: 3rem;">BEST SELLING ITEMS</h2>
        
        <?php if (class_exists('WooCommerce')): ?>
            <?php
            $args = array(
                'post_type' => 'product',
                'posts_per_page' => 8,
                'meta_key' => 'total_sales',
                'orderby' => 'meta_value_num',
                'order' => 'DESC'
            );
            $products = new WP_Query($args);
            ?>
            
            <?php if ($products->have_posts()): ?>
                <div class="row">
                    <?php while ($products->have_posts()): $products->the_post(); ?>
                        <div class="col-3 mb-4">
                            <div class="product-card" style="position: relative;">
                                <?php if (has_post_thumbnail()): ?>
                                    <img src="<?php echo get_the_post_thumbnail_url(get_the_ID(), 'medium'); ?>" alt="<?php the_title(); ?>" class="product-image">
                                <?php else: ?>
                                    <div class="product-image d-flex align-items-center justify-content-center" style="background: #f8f9fa; font-size: 3rem;">📱</div>
                                <?php endif; ?>
                                
                                <div class="discount-badge">
                                    <div>
                                        <div class="fw-bold"><?php echo rand(15, 70); ?>%</div>
                                        <div style="font-size: 0.7rem;">LESS</div>
                                    </div>
                                </div>
                                
                                <div style="padding: 15px; text-align: center;">
                                    <h6><?php the_title(); ?></h6>
                                    <p class="fw-bold"><?php echo get_woocommerce_currency_symbol() . get_post_meta(get_the_ID(), '_price', true); ?></p>
                                </div>
                            </div>
                        </div>
                    <?php endwhile; ?>
                </div>
            <?php endif; ?>
            <?php wp_reset_postdata(); ?>
        <?php else: ?>
            <!-- Fallback if WooCommerce is not active -->
            <div class="row">
                <?php for ($i = 1; $i <= 8; $i++): ?>
                    <div class="col-3 mb-4">
                        <div class="product-card" style="position: relative;">
                            <div class="product-image d-flex align-items-center justify-content-center" style="background: #f8f9fa; font-size: 3rem;">📱</div>
                            <div class="discount-badge">
                                <div>
                                    <div class="fw-bold"><?php echo rand(15, 70); ?>%</div>
                                    <div style="font-size: 0.7rem;">LESS</div>
                                </div>
                            </div>
                            <div style="padding: 15px; text-align: center;">
                                <h6>Product name goes here - <?php echo sprintf('%02d', $i); ?></h6>
                                <p class="fw-bold">£<?php echo rand(50, 500); ?>.00</p>
                            </div>
                        </div>
                    </div>
                <?php endfor; ?>
            </div>
        <?php endif; ?>
        
        <div class="text-center">
            <a href="<?php echo get_permalink(wc_get_page_id('shop')); ?>" class="btn-primary" style="font-size: 1.2rem; padding: 15px 40px;">SHOP NOW</a>
        </div>
    </div>
</section>

<!-- Special Offer -->
<section class="py-5" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-6">
                <div class="text-white">
                    <h2 class="fw-bold mb-4" style="font-size: 4rem; text-shadow: 0px 4px 4px rgba(0,0,0,0.4);">GET UP TO 20% DISCOUNT ON ALL PRODUCTS</h2>
                    <a href="<?php echo get_permalink(wc_get_page_id('shop')); ?>" class="btn-primary" style="font-size: 1.2rem;">SHOP NOW</a>
                </div>
            </div>
            <div class="col-6">
                <div class="text-center">
                    <div style="font-size: 8rem; opacity: 0.75;">🎁</div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- USP Section -->
<section class="py-5" style="background: #f0f0f0;">
    <div class="container">
        <div class="row gap-3">
            <div class="col-4">
                <div class="usp-card">
                    <div style="font-size: 3rem; color: var(--primary-red); margin-bottom: 20px;">🚚</div>
                    <h5 class="fw-bold">£2.99 Delivery | Free Over £100*</h5>
                </div>
            </div>
            <div class="col-4">
                <div class="usp-card">
                    <div style="font-size: 3rem; color: var(--primary-red); margin-bottom: 20px;">🛡️</div>
                    <h5 class="fw-bold">Professionally Refurbished</h5>
                </div>
            </div>
            <div class="col-4">
                <div class="usp-card">
                    <div style="font-size: 3rem; color: var(--primary-red); margin-bottom: 20px;">⚡</div>
                    <h5 class="fw-bold">Fast & Reliable Delivery Guaranteed*</h5>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Newsletter Section -->
<section class="py-5">
    <div class="container">
        <div class="newsletter-section text-center">
            <h2 class="fw-bold mb-4" style="font-size: 3rem;">SIGN UP TO OUR NEWSLETTER</h2>
            <form class="d-flex justify-content-center align-items-center gap-3 mb-3">
                <input type="email" placeholder="Your email Address" required style="padding: 15px; border-radius: 10px; border: 1px solid #000; width: 400px;">
                <button type="submit" style="background: #000; color: white; padding: 15px 30px; border: none; border-radius: 10px;">SUBMIT</button>
            </form>
            <div class="d-flex justify-content-center align-items-center gap-3">
                <input type="checkbox" id="marketingConsent">
                <label for="marketingConsent">Yes, I agree to receive marketing communications from HolaFone.</label>
            </div>
        </div>
    </div>
</section>

<?php get_footer(); ?>
