<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
    <meta charset="<?php bloginfo('charset'); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php wp_title('|', true, 'right'); ?><?php bloginfo('name'); ?></title>
    
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Bootstrap Icons -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700&display=swap" rel="stylesheet">
    
    <?php wp_head(); ?>
</head>
<body <?php body_class(); ?>>

<!-- Header -->
<header>
    <!-- Top Bar -->
    <div class="top-bar bg-white py-2">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-md-6">
                    <nav class="d-flex gap-4">
                        <a href="<?php echo get_permalink(get_page_by_path('trade-in')); ?>" class="text-dark">Trade-in</a>
                        <a href="<?php echo get_permalink(get_page_by_path('verified-refurbished')); ?>" class="text-dark">Verified Refurbished</a>
                        <a href="<?php echo get_permalink(get_page_by_path('holafone-stories')); ?>" class="text-dark">HolaFoneStories</a>
                        <a href="<?php echo get_permalink(get_page_by_path('need-help')); ?>" class="text-dark">Need help?</a>
                    </nav>
                </div>
                <div class="col-md-6">
                    <div class="d-flex align-items-center justify-content-end gap-3">
                        <!-- Search -->
                        <div class="position-relative">
                            <?php if (class_exists('WooCommerce')): ?>
                                <?php get_product_search_form(); ?>
                            <?php else: ?>
                                <form role="search" method="get" action="<?php echo home_url('/'); ?>">
                                    <input type="search" class="form-control search-box pe-5" placeholder="What are you looking for?" value="<?php echo get_search_query(); ?>" name="s" style="width: 300px;">
                                    <i class="bi bi-search position-absolute top-50 end-0 translate-middle-y me-3"></i>
                                </form>
                            <?php endif; ?>
                        </div>
                        <!-- Icons -->
                        <div class="d-flex align-items-center gap-3">
                            <span class="d-flex align-items-center gap-1">
                                <img src="https://flagcdn.com/w20/gb.png" alt="UK Flag" width="20">
                                <span>GB</span>
                            </span>
                            <a href="<?php echo get_permalink(get_page_by_path('my-account')); ?>"><i class="bi bi-person fs-5"></i></a>
                            <?php if (class_exists('WooCommerce')): ?>
                                <a href="<?php echo wc_get_cart_url(); ?>"><i class="bi bi-bag fs-5"></i></a>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Main Navigation -->
    <nav class="navbar navbar-expand-lg navbar-light bg-white">
        <div class="container">
            <a class="navbar-brand d-flex align-items-center gap-2" href="<?php echo home_url(); ?>">
                <div class="bg-primary text-white rounded d-flex align-items-center justify-content-center" style="width: 55px; height: 42px; font-weight: bold;">HF</div>
                HolaFone
            </a>
            
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                <span class="navbar-toggler-icon"></span>
            </button>
            
            <div class="collapse navbar-collapse" id="navbarNav">
                <?php
                wp_nav_menu(array(
                    'theme_location' => 'primary',
                    'menu_class' => 'navbar-nav ms-auto category-nav',
                    'container' => false,
                    'fallback_cb' => 'holafone_fallback_menu'
                ));
                ?>
            </div>
        </div>
    </nav>
</header>
