<?php
// Theme setup
function holafone_theme_setup() {
    // Add theme support for various features
    add_theme_support('post-thumbnails');
    add_theme_support('title-tag');
    add_theme_support('custom-logo');
    add_theme_support('html5', array('search-form', 'comment-form', 'comment-list', 'gallery', 'caption'));
    
    // WooCommerce support
    add_theme_support('woocommerce');
    add_theme_support('wc-product-gallery-zoom');
    add_theme_support('wc-product-gallery-lightbox');
    add_theme_support('wc-product-gallery-slider');
    
    // Register navigation menus
    register_nav_menus(array(
        'primary' => __('Primary Menu', 'holafone'),
    ));
}
add_action('after_setup_theme', 'holafone_theme_setup');

// Enqueue styles and scripts
function holafone_scripts() {
    wp_enqueue_style('holafone-style', get_stylesheet_uri());
    wp_enqueue_script('holafone-script', get_template_directory_uri() . '/js/main.js', array('jquery'), '1.0.0', true);
}
add_action('wp_enqueue_scripts', 'holafone_scripts');

// Fallback menu function
function holafone_fallback_menu() {
    echo '<ul class="navbar-nav ms-auto category-nav">';
    echo '<li class="nav-item"><a class="nav-link text-danger fw-bold" href="#">Good deals</a></li>';
    echo '<li class="nav-item"><a class="nav-link" href="#">Smartphones</a></li>';
    echo '<li class="nav-item"><a class="nav-link" href="#">Laptops</a></li>';
    echo '<li class="nav-item"><a class="nav-link" href="#">Tablets</a></li>';
    echo '<li class="nav-item"><a class="nav-link" href="#">Gaming consoles</a></li>';
    echo '<li class="nav-item"><a class="nav-link" href="#">Smartwatches</a></li>';
    echo '<li class="nav-item"><a class="nav-link" href="#">Audio</a></li>';
    echo '<li class="nav-item"><a class="nav-link" href="#">Home Appliances</a></li>';
    echo '<li class="nav-item"><a class="nav-link" href="#">More</a></li>';
    echo '</ul>';
}

// Custom post type for testimonials
function holafone_custom_post_types() {
    register_post_type('testimonial', array(
        'labels' => array(
            'name' => 'Testimonials',
            'singular_name' => 'Testimonial',
        ),
        'public' => true,
        'supports' => array('title', 'editor', 'thumbnail'),
        'menu_icon' => 'dashicons-format-quote',
    ));
}
add_action('init', 'holafone_custom_post_types');

// Customize WooCommerce
function holafone_woocommerce_support() {
    add_theme_support('woocommerce', array(
        'thumbnail_image_width' => 300,
        'single_image_width' => 600,
        'product_grid' => array(
            'default_rows' => 3,
            'min_rows' => 2,
            'max_rows' => 8,
            'default_columns' => 4,
            'min_columns' => 2,
            'max_columns' => 5,
        ),
    ));
}
add_action('after_setup_theme', 'holafone_woocommerce_support');

// Remove WooCommerce default styles
add_filter('woocommerce_enqueue_styles', '__return_empty_array');

// Custom WooCommerce hooks
remove_action('woocommerce_before_main_content', 'woocommerce_output_content_wrapper', 10);
remove_action('woocommerce_after_main_content', 'woocommerce_output_content_wrapper_end', 10);

add_action('woocommerce_before_main_content', 'holafone_wrapper_start', 10);
add_action('woocommerce_after_main_content', 'holafone_wrapper_end', 10);

function holafone_wrapper_start() {
    echo '<div class="container py-5"><div class="row"><div class="col-12">';
}

function holafone_wrapper_end() {
    echo '</div></div></div>';
}

// Widget areas
function holafone_widgets_init() {
    register_sidebar(array(
        'name' => 'Sidebar',
        'id' => 'sidebar-1',
        'before_widget' => '<div class="widget %2$s">',
        'after_widget' => '</div>',
        'before_title' => '<h3 class="widget-title">',
        'after_title' => '</h3>',
    ));
}
add_action('widgets_init', 'holafone_widgets_init');

// Customizer options
function holafone_customize_register($wp_customize) {
    // Hero section
    $wp_customize->add_section('holafone_hero', array(
        'title' => 'Hero Section',
        'priority' => 30,
    ));
    
    $wp_customize->add_setting('hero_title', array(
        'default' => 'NEW AND REFURBISHED PHONES, COMPUTERS AND ACCESSORIES',
        'sanitize_callback' => 'sanitize_text_field',
    ));
    
    $wp_customize->add_control('hero_title', array(
        'label' => 'Hero Title',
        'section' => 'holafone_hero',
        'type' => 'text',
    ));
}
add_action('customize_register', 'holafone_customize_register');

// Add custom fields for products
function holafone_product_custom_fields() {
    global $post;
    
    echo '<div class="options_group">';
    
    woocommerce_wp_text_input(array(
        'id' => '_discount_percentage',
        'label' => 'Discount Percentage',
        'placeholder' => 'e.g. 25',
        'desc_tip' => 'true',
        'description' => 'Enter the discount percentage for the badge'
    ));
    
    echo '</div>';
}
add_action('woocommerce_product_options_general_product_data', 'holafone_product_custom_fields');

// Save custom fields
function holafone_save_product_custom_fields($post_id) {
    $discount_percentage = $_POST['_discount_percentage'];
    if (!empty($discount_percentage)) {
        update_post_meta($post_id, '_discount_percentage', esc_attr($discount_percentage));
    }
}
add_action('woocommerce_process_product_meta', 'holafone_save_product_custom_fields');
?>
