# HolaFone WordPress Theme

A modern, responsive WordPress theme designed for HolaFone - New and Refurbished Phones, Computers and Accessories.

## Features

- **WooCommerce Compatible**: Full integration with WooCommerce for e-commerce functionality
- **Responsive Design**: Mobile-first approach with Bootstrap 5 framework
- **Modern UI**: Clean, professional design with HolaFone branding
- **SEO Optimized**: Proper HTML structure and meta tags
- **Fast Loading**: Optimized CSS and JavaScript
- **Accessibility**: WCAG compliant design elements

## Installation

### Theme Installation

1. Download the `holafone-theme` folder
2. Upload it to your WordPress `/wp-content/themes/` directory
3. Activate the theme in WordPress Admin > Appearance > Themes

### Content Import

1. Go to WordPress Admin > Tools > Import
2. Install the WordPress Importer plugin if not already installed
3. Upload the `holafone-content.xml` file
4. Import all content including pages and media

## Theme Structure

```
holafone-theme/
├── style.css          # Main stylesheet with theme information
├── index.php          # Homepage template
├── header.php         # Header template
├── footer.php         # Footer template
├── functions.php      # Theme functions and WooCommerce support
├── page.php           # Single page template
├── single.php         # Single post template
├── sidebar.php        # Sidebar template
├── woocommerce.php    # WooCommerce template
└── js/
    └── main.js        # Custom JavaScript
```

## Required Plugins

- **WooCommerce**: For e-commerce functionality
- **WordPress Importer**: For importing demo content

## Customization

### Theme Options

The theme includes customizer options for:
- Hero section content
- Logo and branding
- Color schemes
- Typography settings

### WooCommerce Integration

- Custom product layouts
- Shopping cart integration
- Checkout process styling
- Product gallery support

### Custom Post Types

- Testimonials for customer reviews
- Custom fields for product discount badges

## Pages Included

The theme comes with pre-built pages:

### Main Pages
- **Home**: Homepage with carousel and product showcase
- **About Us**: Company information and story
- **Contact Us**: Contact form and company details

### Product & Service Pages
- **Our Grades**: Device grading system explanation
- **Our Quality Story**: Quality assurance process
- **Sustainability**: Environmental commitment
- **Trade-In**: Trade-in program details
- **Work With Us**: Career opportunities
- **Customer Reviews**: Customer testimonials
- **FAQs**: Frequently asked questions

### Legal Pages
- **Warranty**: Warranty terms and conditions
- **Terms & Conditions**: Website terms of use
- **Privacy Policy**: Data protection and privacy
- **Shipping**: Delivery information and policies

## Styling

### Color Scheme
- Primary Red: #c00000
- Dark Red: #a00000
- Light Gray: #f3f3f3
- Medium Gray: #474747
- Border Gray: #d9d9d9

### Typography
- Primary Font: Poppins (Google Fonts)
- Fallback: Sans-serif system fonts

## Browser Support

- Chrome (latest)
- Firefox (latest)
- Safari (latest)
- Edge (latest)
- Internet Explorer 11+

## Performance

- Optimized CSS and JavaScript
- Lazy loading for images
- Minified assets in production
- CDN support for external libraries

## SEO Features

- Proper HTML5 semantic structure
- Meta tags and Open Graph support
- Schema markup ready
- Sitemap compatibility
- Fast loading times

## Accessibility

- WCAG 2.1 AA compliant
- Keyboard navigation support
- Screen reader friendly
- High contrast ratios
- Alt text for images

## Support

For theme support and customization:
- Email: support@holafone.com
- Documentation: Available in theme files
- Updates: Regular updates for compatibility

## License

This theme is proprietary to HolaFone/iQom Mobile Ltd. All rights reserved.

## Changelog

### Version 1.0
- Initial release
- WooCommerce integration
- Responsive design
- Complete page templates
- Custom post types
- SEO optimization

## Credits

- Bootstrap 5: https://getbootstrap.com/
- Google Fonts: https://fonts.google.com/
- Bootstrap Icons: https://icons.getbootstrap.com/
- Unsplash Images: https://unsplash.com/
