<?php
/**
 * The main template file
 *
 * @package HolaFone
 */

get_header(); ?>

<!-- Hero Banner -->
<section class="hero-banner" style="background-image: url('<?php echo get_template_directory_uri(); ?>/assets/images/hero-bg.jpg');">
    <div class="container">
        <div class="row align-items-center min-vh-50">
            <div class="col-lg-6 offset-lg-6">
                <div class="hero-content text-white text-end">
                    <h2 class="hero-title mb-4"><?php echo get_theme_mod('hero_title', 'NEW AND REFURBISHED PHONES, COMPUTERS AND ACCESSORIES'); ?></h2>
                    <a href="<?php echo get_permalink(wc_get_page_id('shop')); ?>" class="btn btn-outline-light btn-lg">SHOP NOW</a>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Categories Section -->
<section class="categories-section py-5">
    <div class="container">
        <div class="row">
            <div class="col-lg-6">
                <div class="category-content bg-light rounded p-5">
                    <h2 class="mb-4"><?php echo get_theme_mod('why_buy_title', 'WHY BUY REFURBISHED MOBILES WITH US?'); ?></h2>
                    <p class="mb-4"><?php echo get_theme_mod('why_buy_content', 'The impact of well-crafted website content cannot be overstated and can be the difference between a thriving online presence and a lackluster one.'); ?></p>
                    <a href="<?php echo get_permalink(wc_get_page_id('shop')); ?>" class="btn btn-dark">SHOP NOW</a>
                </div>
            </div>
            <div class="col-lg-6">
                <div class="row g-3">
                    <?php
                    $product_categories = get_terms(array(
                        'taxonomy' => 'product_cat',
                        'hide_empty' => false,
                        'number' => 4,
                        'parent' => 0
                    ));
                    
                    $category_images = array(
                        'phones' => get_template_directory_uri() . '/assets/images/phones-category.jpg',
                        'tablets' => get_template_directory_uri() . '/assets/images/tablets-category.jpg',
                        'smart-watches' => get_template_directory_uri() . '/assets/images/watches-category.jpg',
                        'tech' => get_template_directory_uri() . '/assets/images/tech-category.jpg'
                    );
                    
                    foreach ($product_categories as $index => $category) :
                        $category_image = isset($category_images[$category->slug]) ? $category_images[$category->slug] : get_template_directory_uri() . '/assets/images/default-category.jpg';
                    ?>
                    <div class="col-6">
                        <a href="<?php echo get_term_link($category); ?>" class="category-card" style="background-image: url('<?php echo $category_image; ?>');">
                            <div class="category-overlay">
                                <h3 class="category-title"><?php echo strtoupper($category->name); ?></h3>
                            </div>
                        </a>
                    </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Offers Section -->
<section class="offers-section py-5">
    <div class="container">
        <div class="row g-4">
            <div class="col-lg-6">
                <div class="offer-card bg-danger text-white rounded p-5 position-relative">
                    <h3 class="offer-title mb-3">TOP PICKS PRICED BELOW<br><span class="display-4">£150</span></h3>
                    <a href="<?php echo add_query_arg(array('max_price' => '150'), get_permalink(wc_get_page_id('shop'))); ?>" class="btn btn-dark">SHOP NOW</a>
                </div>
            </div>
            <div class="col-lg-6">
                <div class="offer-card bg-danger text-white rounded p-5 position-relative">
                    <h3 class="offer-title mb-3">WE SELL REFURBISHED TABLETS, MACBOOKS, CONSOLES, AND WEARABLES.</h3>
                    <a href="<?php echo get_permalink(wc_get_page_id('shop')); ?>" class="btn btn-dark">SHOP NOW</a>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Best Selling Items -->
<section class="products-section py-5">
    <div class="container">
        <h2 class="text-center mb-5">BEST SELLING ITEMS</h2>
        
        <?php
        // Get best selling products
        $args = array(
            'post_type' => 'product',
            'posts_per_page' => 8,
            'meta_key' => 'total_sales',
            'orderby' => 'meta_value_num',
            'order' => 'DESC',
            'post_status' => 'publish',
            'meta_query' => array(
                array(
                    'key' => '_visibility',
                    'value' => array('catalog', 'visible'),
                    'compare' => 'IN'
                )
            )
        );
        
        $best_selling_products = new WP_Query($args);
        
        if ($best_selling_products->have_posts()) :
        ?>
        <div class="row g-4 mb-4">
            <?php
            $count = 0;
            while ($best_selling_products->have_posts() && $count < 4) : 
                $best_selling_products->the_post();
                global $product;
                $count++;
            ?>
            <div class="col-lg-3 col-md-6">
                <div class="product-card">
                    <div class="product-image position-relative">
                        <a href="<?php the_permalink(); ?>">
                            <?php echo woocommerce_get_product_thumbnail(); ?>
                        </a>
                        <?php if ($product->is_on_sale()) : ?>
                        <div class="discount-badge">
                            <?php
                            $regular_price = $product->get_regular_price();
                            $sale_price = $product->get_sale_price();
                            if ($regular_price && $sale_price) {
                                $discount_percent = round((($regular_price - $sale_price) / $regular_price) * 100);
                                echo '<span class="discount-percent">' . $discount_percent . '%</span>';
                                echo '<span class="discount-text">LESS</span>';
                            }
                            ?>
                        </div>
                        <?php endif; ?>
                    </div>
                    <div class="product-info text-center mt-3">
                        <h5><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h5>
                        <p class="price"><?php echo $product->get_price_html(); ?></p>
                    </div>
                </div>
            </div>
            <?php endwhile; ?>
        </div>
        
        <?php if ($best_selling_products->post_count > 4) : ?>
        <div class="row g-4">
            <?php
            $count = 0;
            $best_selling_products->rewind_posts();
            while ($best_selling_products->have_posts()) : 
                $best_selling_products->the_post();
                global $product;
                $count++;
                if ($count <= 4) continue; // Skip first 4
                if ($count > 8) break; // Stop after 8 total
            ?>
            <div class="col-lg-3 col-md-6">
                <div class="product-card">
                    <div class="product-image position-relative">
                        <a href="<?php the_permalink(); ?>">
                            <?php echo woocommerce_get_product_thumbnail(); ?>
                        </a>
                        <?php if ($product->is_on_sale()) : ?>
                        <div class="discount-badge">
                            <?php
                            $regular_price = $product->get_regular_price();
                            $sale_price = $product->get_sale_price();
                            if ($regular_price && $sale_price) {
                                $discount_percent = round((($regular_price - $sale_price) / $regular_price) * 100);
                                echo '<span class="discount-percent">' . $discount_percent . '%</span>';
                                echo '<span class="discount-text">LESS</span>';
                            }
                            ?>
                        </div>
                        <?php endif; ?>
                    </div>
                    <div class="product-info text-center mt-3">
                        <h5><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h5>
                        <p class="price"><?php echo $product->get_price_html(); ?></p>
                    </div>
                </div>
            </div>
            <?php endwhile; ?>
        </div>
        <?php endif; ?>
        
        <?php wp_reset_postdata(); ?>
        
        <div class="text-center mt-5">
            <a href="<?php echo get_permalink(wc_get_page_id('shop')); ?>" class="btn btn-dark btn-lg">SHOP NOW</a>
        </div>
        
        <?php endif; ?>
    </div>
</section>

<!-- FAQ Section -->
<section class="faq-section py-5 bg-light">
    <div class="container">
        <h2 class="text-center mb-5">FREQUENTLY ASKED QUESTIONS</h2>
        <div class="row justify-content-center">
            <div class="col-lg-10">
                <div class="accordion  " id="faqAccordion">
                    <?php
                    $faqs = array(
                        array(
                            'question' => 'HOW WILL MY DEVICE BE PROTECTED DURING THE SHIPMENT?',
                            'answer' => 'Your device will be carefully packaged with protective materials to ensure safe delivery.'
                        ),
                        array(
                            'question' => 'WHAT ARE OUR GRADES?',
                            'answer' => 'We offer different grades based on the condition of the device.'
                        ),
                        array(
                            'question' => 'WHAT IS THE WARRANTY?',
                            'answer' => 'All our refurbished devices come with a comprehensive warranty.'
                        ),
                        array(
                            'question' => 'WHAT IS A REFURBISHED DEVICE?',
                            'answer' => 'A refurbished device is a pre-owned device that has been professionally restored to working condition.',
                            'open' => true
                        )
                    );
                    
                    foreach ($faqs as $index => $faq) :
                        $faq_id = 'faq' . ($index + 1);
                        $is_open = isset($faq['open']) && $faq['open'];
                    ?>
                    <div class="accordion-item mb-3">
                        <h3 class="accordion-header">
                            <button class="accordion-button <?php echo $is_open ? '' : 'collapsed'; ?>" type="button" data-bs-toggle="collapse" data-bs-target="#<?php echo $faq_id; ?>">
                                <?php echo $faq['question']; ?>
                            </button>
                        </h3>
                        <div id="<?php echo $faq_id; ?>" class="accordion-collapse collapse <?php echo $is_open ? 'show' : ''; ?>" data-bs-parent="#faqAccordion">
                            <div class="accordion-body">
                                <?php echo $faq['answer']; ?>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Special Offer -->
<section class="special-offer py-5" style="background-image: url('<?php echo get_template_directory_uri(); ?>/assets/images/special-offer-bg.jpg');">
    <div class="container">
        <div class="row">
            <div class="col-lg-6">
                <div class="offer-content text-white">
                    <h2 class="display-4 mb-4">GET UP TO 20% DISCOUNT ON ALL PRODUCTS</h2>
                    <a href="<?php echo get_permalink(wc_get_page_id('shop')); ?>" class="btn btn-dark btn-lg">SHOP NOW</a>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- USP Section -->
<section class="usp-section py-4 bg-light">
    <div class="container">
        <div class="row g-4">
            <div class="col-lg-4">
                <div class="usp-card bg-white p-4 text-center shadow-sm">
                    <i class="fas fa-truck mb-3 text-primary"></i>
                    <h5>£2.99 Delivery | Free Over £100*</h5>
                </div>
            </div>
            <div class="col-lg-4">
                <div class="usp-card bg-white p-4 text-center shadow-sm">
                    <i class="fas fa-tools mb-3 text-primary"></i>
                    <h5>Professionally Refurbished</h5>
                </div>
            </div>
            <div class="col-lg-4">
                <div class="usp-card bg-white p-4 text-center shadow-sm">
                    <i class="fas fa-shipping-fast mb-3 text-primary"></i>
                    <h5>Fast & Reliable Delivery Guaranteed*</h5>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Newsletter -->
<section class="newsletter-section py-5 bg-danger text-white">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-8 text-center">
                <h2 class="mb-4">SIGN UP TO OUR NEWSLETTER</h2>
                <form class="newsletter-form" method="post" action="<?php echo admin_url('admin-ajax.php'); ?>">
                    <input type="hidden" name="action" value="newsletter_signup">
                    <?php wp_nonce_field('newsletter_signup', 'newsletter_nonce'); ?>
                    <div class="row g-3 justify-content-center">
                        <div class="col-lg-8">
                            <input type="email" name="email" class="form-control form-control-lg" placeholder="Your email Address" required>
                        </div>
                        <div class="col-lg-4">
                            <button type="submit" class="btn btn-dark btn-lg w-100">SUBMIT</button>
                        </div>
                    </div>
                    <div class="form-check mt-3">
                        <input class="form-check-input" type="checkbox" name="marketing_consent" id="marketing-consent" required>
                        <label class="form-check-label" for="marketing-consent">
                            Yes, I agree to receive marketing communications from HolaFone.
                        </label>
                    </div>
                </form>
            </div>
        </div>
    </div>
</section>

<?php get_footer(); ?>
