<?php
/**
 * HolaFone Theme Customizer
 *
 * @package HolaFone
 */

function holafone_customize_register($wp_customize) {
    
    // Hero Section
    $wp_customize->add_section('holafone_hero', array(
        'title'    => __('Hero Section', 'holafone'),
        'priority' => 30,
    ));

    $wp_customize->add_setting('hero_title', array(
        'default'           => 'NEW AND REFURBISHED PHONES, COMPUTERS AND ACCESSORIES',
        'sanitize_callback' => 'sanitize_text_field',
    ));

    $wp_customize->add_control('hero_title', array(
        'label'    => __('Hero Title', 'holafone'),
        'section'  => 'holafone_hero',
        'type'     => 'text',
    ));

    $wp_customize->add_setting('hero_background', array(
        'default'           => '',
        'sanitize_callback' => 'esc_url_raw',
    ));

    $wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, 'hero_background', array(
        'label'    => __('Hero Background Image', 'holafone'),
        'section'  => 'holafone_hero',
    )));

    // About Section
    $wp_customize->add_section('holafone_about', array(
        'title'    => __('About Section', 'holafone'),
        'priority' => 31,
    ));

    $wp_customize->add_setting('why_buy_title', array(
        'default'           => 'WHY BUY REFURBISHED MOBILES WITH US?',
        'sanitize_callback' => 'sanitize_text_field',
    ));

    $wp_customize->add_control('why_buy_title', array(
        'label'    => __('Why Buy Title', 'holafone'),
        'section'  => 'holafone_about',
        'type'     => 'text',
    ));

    $wp_customize->add_setting('why_buy_content', array(
        'default'           => 'The impact of well-crafted website content cannot be overstated and can be the difference between a thriving online presence and a lackluster one.',
        'sanitize_callback' => 'sanitize_textarea_field',
    ));

    $wp_customize->add_control('why_buy_content', array(
        'label'    => __('Why Buy Content', 'holafone'),
        'section'  => 'holafone_about',
        'type'     => 'textarea',
    ));

    // Colors
    $wp_customize->add_section('holafone_colors', array(
        'title'    => __('Theme Colors', 'holafone'),
        'priority' => 32,
    ));

    $wp_customize->add_setting('primary_color', array(
        'default'           => '#c00000',
        'sanitize_callback' => 'sanitize_hex_color',
    ));

    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'primary_color', array(
        'label'    => __('Primary Color', 'holafone'),
        'section'  => 'holafone_colors',
    )));

    $wp_customize->add_setting('secondary_color', array(
        'default'           => '#000000',
        'sanitize_callback' => 'sanitize_hex_color',
    ));

    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'secondary_color', array(
        'label'    => __('Secondary Color', 'holafone'),
        'section'  => 'holafone_colors',
    )));

    // Footer
    $wp_customize->add_section('holafone_footer', array(
        'title'    => __('Footer Settings', 'holafone'),
        'priority' => 33,
    ));

    $wp_customize->add_setting('footer_copyright', array(
        'default'           => '"HolaFone" is a Marketing Brand of iQom Mobile Ltd. | Registered in England and Wales. Company Number 13675306 | Registered Office Address: 167-169 Great Portland Street, 5th Floor, W1W 5PF, London | VAT GB4526811778<br>Copyright 2025 All rights reserved. | iQom Mobile Ltd.',
        'sanitize_callback' => 'wp_kses_post',
    ));

    $wp_customize->add_control('footer_copyright', array(
        'label'    => __('Footer Copyright Text', 'holafone'),
        'section'  => 'holafone_footer',
        'type'     => 'textarea',
    ));
}
add_action('customize_register', 'holafone_customize_register');

// Output custom CSS
function holafone_customizer_css() {
    $primary_color = get_theme_mod('primary_color', '#c00000');
    $secondary_color = get_theme_mod('secondary_color', '#000000');
    
    ?>
    <style type="text/css">
        :root {
            --primary-color: <?php echo esc_attr($primary_color); ?>;
            --secondary-color: <?php echo esc_attr($secondary_color); ?>;
        }
        
        .navbar-nav .nav-link.text-danger,
        .category-title,
        .woocommerce ul.products li.product .price,
        .woocommerce-page ul.products li.product .price {
            color: <?php echo esc_attr($primary_color); ?> !important;
        }
        
        .discount-badge,
        .offer-card {
            background: linear-gradient(225deg, <?php echo esc_attr($primary_color); ?> 0%, <?php echo esc_attr($primary_color); ?> 100%);
        }
        
        .btn-dark,
        .logo-text,
        .woocommerce a.button,
        .woocommerce button.button,
        .woocommerce input.button {
            background-color: <?php echo esc_attr($secondary_color); ?>;
            border-color: <?php echo esc_attr($secondary_color); ?>;
            color: white;
        }
    </style>
    <?php
}
add_action('wp_head', 'holafone_customizer_css');
