<?php
/**
 * Bootstrap Nav Walker for WordPress
 *
 * @package HolaFone
 */

if (!class_exists('Bootstrap_Nav_Walker')) {
    class Bootstrap_Nav_Walker extends Walker_Nav_Menu {
        
        function start_lvl(&$output, $depth = 0, $args = null) {
            $indent = str_repeat("\t", $depth);
            $output .= "\n$indent<ul class=\"dropdown-menu\">\n";
        }

        function end_lvl(&$output, $depth = 0, $args = null) {
            $indent = str_repeat("\t", $depth);
            $output .= "$indent</ul>\n";
        }

        function start_el(&$output, $item, $depth = 0, $args = null, $id = 0) {
            $indent = ($depth) ? str_repeat("\t", $depth) : '';

            $classes = empty($item->classes) ? array() : (array) $item->classes;
            $classes[] = 'menu-item-' . $item->ID;

            $class_names = join(' ', apply_filters('nav_menu_css_class', array_filter($classes), $item, $args));

            if (in_array('menu-item-has-children', $classes)) {
                $class_names .= ' dropdown';
            }

            if (in_array('current-menu-item', $classes)) {
                $class_names .= ' active';
            }

            $class_names = $class_names ? ' class="nav-item ' . esc_attr($class_names) . '"' : ' class="nav-item"';

            $id = apply_filters('nav_menu_item_id', 'menu-item-'. $item->ID, $item, $args);
            $id = $id ? ' id="' . esc_attr($id) . '"' : '';

            $output .= $indent . '<li' . $id . $class_names .'>';

            $attributes = ! empty($item->attr_title) ? ' title="'  . esc_attr($item->attr_title) .'"' : '';
            $attributes .= ! empty($item->target)     ? ' target="' . esc_attr($item->target     ) .'"' : '';
            $attributes .= ! empty($item->xfn)        ? ' rel="'    . esc_attr($item->xfn        ) .'"' : '';
            $attributes .= ! empty($item->url)        ? ' href="'   . esc_attr($item->url        ) .'"' : '';

            $link_class = 'nav-link';
            
            if (in_array('menu-item-has-children', $classes)) {
                $link_class .= ' dropdown-toggle';
                $attributes .= ' data-bs-toggle="dropdown" role="button" aria-haspopup="true" aria-expanded="false"';
            }

            if ($depth > 0) {
                $link_class = 'dropdown-item';
            }

            $attributes .= ' class="' . $link_class . '"';

            $item_output = isset($args->before) ? $args->before : '';
            $item_output .= '<a' . $attributes .'>';
            $item_output .= (isset($args->link_before) ? $args->link_before : '') . apply_filters('the_title', $item->title, $item->ID) . (isset($args->link_after) ? $args->link_after : '');
            $item_output .= '</a>';
            $item_output .= isset($args->after) ? $args->after : '';

            $output .= apply_filters('walker_nav_menu_start_el', $item_output, $item, $depth, $args);
        }

        function end_el(&$output, $item, $depth = 0, $args = null) {
            $output .= "</li>\n";
        }
    }
}
