<?php
/**
 * The header for our theme
 *
 * @package HolaFone
 */
?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
    <meta charset="<?php bloginfo('charset'); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="profile" href="https://gmpg.org/xfn/11">
    
    <?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
<?php wp_body_open(); ?>

<div id="page" class="site">
    <!-- Header -->
    <header class="header-section">
        <!-- Top Bar -->
        <div class="top-bar bg-white border-bottom">
            <div class="container-fluid">
                <div class="row align-items-center py-2">
                    <div class="col-md-6">
                        <nav class="d-none d-md-block">
                            <?php
                            wp_nav_menu(array(
                                'theme_location' => 'top-menu',
                                'menu_class' => 'top-nav-menu',
                                'container' => false,
                                'fallback_cb' => function() {
                                    echo '<span class="me-4">Trade-in</span>';
                                    echo '<span class="me-4">Verified Refurbished</span>';
                                    echo '<span class="me-4">HolaFoneStories</span>';
                                    echo '<span>Need help?</span>';
                                }
                            ));
                            ?>
                        </nav>
                    </div>
                    <div class="col-md-6">
                        <div class="d-flex justify-content-end align-items-center">
                            <div class="search-box me-3">
                                <?php if (class_exists('WooCommerce')) : ?>
                                <form role="search" method="get" class="woocommerce-product-search" action="<?php echo esc_url(home_url('/')); ?>">
                                    <div class="input-group">
                                        <input type="search" class="form-control" placeholder="<?php echo esc_attr__('What are you looking for?', 'holafone'); ?>" value="<?php echo get_search_query(); ?>" name="s" />
                                        <input type="hidden" name="post_type" value="product" />
                                        <button class="btn btn-outline-secondary" type="submit">
                                            <i class="fas fa-search"></i>
                                        </button>
                                    </div>
                                </form>
                                <?php else : ?>
                                <form role="search" method="get" action="<?php echo esc_url(home_url('/')); ?>">
                                    <div class="input-group">
                                        <input type="search" class="form-control" placeholder="<?php echo esc_attr__('Search...', 'holafone'); ?>" value="<?php echo get_search_query(); ?>" name="s" />
                                        <button class="btn btn-outline-secondary" type="submit">
                                            <i class="fas fa-search"></i>
                                        </button>
                                    </div>
                                </form>
                                <?php endif; ?>
                            </div>
                            <div class="d-flex align-items-center">
                                <img src="<?php echo get_template_directory_uri(); ?>/assets/images/flag.png" alt="UK Flag" class="flag-icon me-1">
                                <span class="me-3">GB</span>
                                <?php if (class_exists('WooCommerce')) : ?>
                                <a href="<?php echo get_permalink(get_option('woocommerce_myaccount_page_id')); ?>" class="me-3">
                                    <i class="fas fa-user"></i>
                                </a>
                                <a href="<?php echo wc_get_cart_url(); ?>" class="cart-contents">
                                    <i class="fas fa-shopping-cart"></i>
                                    <?php if (WC()->cart->get_cart_contents_count() > 0) : ?>
                                    <span class="cart-count badge bg-danger"><?php echo WC()->cart->get_cart_contents_count(); ?></span>
                                    <?php endif; ?>
                                </a>
                                <?php else : ?>
                                <i class="fas fa-user me-3"></i>
                                <i class="fas fa-shopping-cart"></i>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Main Header -->
        <div class="main-header bg-white">
            <div class="container-fluid">
                <div class="row align-items-center py-3">
                    <div class="col-md-3">
                        <div class="logo d-flex align-items-center">
                            <a href="<?php echo esc_url(home_url('/')); ?>">
                                <?php
                                $custom_logo_id = get_theme_mod('custom_logo');
                                if ($custom_logo_id) {
                                    echo wp_get_attachment_image($custom_logo_id, 'full', false, array('class' => 'logo-img me-2'));
                                } else {
                                    echo '<img src="' . get_template_directory_uri() . '/assets/images/logo.png" alt="' . get_bloginfo('name') . '" class="logo-img me-2">';
                                }
                                ?>
                                <h1 class="logo-text mb-0"><?php bloginfo('name'); ?></h1>
                            </a>
                        </div>
                    </div>
                    <div class="col-md-9">
                        <nav class="navbar navbar-expand-lg">
                            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav" aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
                                <span class="navbar-toggler-icon"></span>
                            </button>
                            <div class="collapse navbar-collapse" id="navbarNav">
                                <?php
                                wp_nav_menu(array(
                                    'theme_location' => 'primary',
                                    'menu_class' => 'navbar-nav ms-auto',
                                    'container' => false,
                                    'walker' => new Bootstrap_Nav_Walker(),
                                    'fallback_cb' => function() {
                                        echo '<ul class="navbar-nav ms-auto">';
                                        echo '<li class="nav-item"><a class="nav-link text-danger" href="#">Good deals</a></li>';
                                        echo '<li class="nav-item"><a class="nav-link" href="#">Smartphones</a></li>';
                                        echo '<li class="nav-item"><a class="nav-link" href="#">Laptops</a></li>';
                                        echo '<li class="nav-item"><a class="nav-link" href="#">Tablets</a></li>';
                                        echo '<li class="nav-item"><a class="nav-link" href="#">Gaming consoles</a></li>';
                                        echo '<li class="nav-item"><a class="nav-link" href="#">Smartwatches</a></li>';
                                        echo '<li class="nav-item"><a class="nav-link" href="#">Audio</a></li>';
                                        echo '<li class="nav-item"><a class="nav-link" href="#">Home Appliances</a></li>';
                                        echo '<li class="nav-item"><a class="nav-link" href="#">More</a></li>';
                                        echo '</ul>';
                                    }
                                ));
                                ?>
                            </div>
                        </nav>
                    </div>
                </div>
            </div>
        </div>
    </header>

    <div id="content" class="site-content">
