<?php
/**
 * The template for displaying the footer
 *
 * @package HolaFone
 */
?>

    </div><!-- #content -->

    <!-- Footer -->
    <footer class="footer-section bg-dark text-white py-5">
        <div class="container">
            <div class="row g-4">
                <div class="col-lg-3">
                    <h5 class="text-uppercase mb-3">QUICK LINKS</h5>
                    <?php
                    wp_nav_menu(array(
                        'theme_location' => 'footer-links',
                        'menu_class' => 'list-unstyled footer-menu',
                        'container' => false,
                        'fallback_cb' => function() {
                            echo '<ul class="list-unstyled">';
                            echo '<li><a href="#" class="text-danger">Home</a></li>';
                            echo '<li><a href="#" class="text-white-50">About us</a></li>';
                            echo '<li><a href="#" class="text-white-50">Our Grades</a></li>';
                            echo '<li><a href="#" class="text-white-50">Our Quality Story</a></li>';
                            echo '<li><a href="#" class="text-white-50">Sustainability</a></li>';
                            echo '<li><a href="#" class="text-white-50">Trade-In</a></li>';
                            echo '<li><a href="#" class="text-white-50">Work With Us</a></li>';
                            echo '<li><a href="#" class="text-white-50">Customer Reviews</a></li>';
                            echo '<li><a href="#" class="text-white-50">FAQs</a></li>';
                            echo '<li><a href="#" class="text-white-50">Contact us</a></li>';
                            echo '</ul>';
                        }
                    ));
                    ?>
                </div>
                <div class="col-lg-3">
                    <h5 class="text-uppercase mb-3">CATEGORIES</h5>
                    <?php
                    if (class_exists('WooCommerce')) {
                        $product_categories = get_terms(array(
                            'taxonomy' => 'product_cat',
                            'hide_empty' => false,
                            'number' => 7,
                            'parent' => 0
                        ));
                        
                        if (!empty($product_categories)) {
                            echo '<ul class="list-unstyled">';
                            foreach ($product_categories as $category) {
                                echo '<li><a href="' . get_term_link($category) . '" class="text-white-50">' . $category->name . '</a></li>';
                            }
                            echo '</ul>';
                        }
                    } else {
                        echo '<ul class="list-unstyled">';
                        echo '<li><a href="#" class="text-white-50">Best Selling</a></li>';
                        echo '<li><a href="#" class="text-white-50">Refurbished iPhones</a></li>';
                        echo '<li><a href="#" class="text-white-50">Refurbished Dyson</a></li>';
                        echo '<li><a href="#" class="text-white-50">Refurbished MacBooks</a></li>';
                        echo '<li><a href="#" class="text-white-50">Refurbished iPads</a></li>';
                        echo '<li><a href="#" class="text-white-50">Refurbished Apple Watches</a></li>';
                        echo '<li><a href="#" class="text-white-50">New Accessories</a></li>';
                        echo '</ul>';
                    }
                    ?>
                </div>
                <div class="col-lg-3">
                    <h5 class="text-uppercase mb-3">LEGAL</h5>
                    <?php
                    wp_nav_menu(array(
                        'theme_location' => 'footer-legal',
                        'menu_class' => 'list-unstyled footer-menu',
                        'container' => false,
                        'fallback_cb' => function() {
                            echo '<ul class="list-unstyled">';
                            echo '<li><a href="#" class="text-white-50">Warranty</a></li>';
                            echo '<li><a href="#" class="text-white-50">Terms & Conditions</a></li>';
                            echo '<li><a href="#" class="text-white-50">Trade-In Terms & Conditions</a></li>';
                            echo '<li><a href="#" class="text-white-50">Returns & Refund Policies</a></li>';
                            echo '<li><a href="#" class="text-white-50">Privacy Policy</a></li>';
                            echo '<li><a href="#" class="text-white-50">Cookie Policy</a></li>';
                            echo '<li><a href="#" class="text-white-50">Shipping</a></li>';
                            echo '</ul>';
                        }
                    ));
                    ?>
                </div>
                <div class="col-lg-3">
                    <h5 class="text-uppercase mb-3">PAYMENT METHOD</h5>
                    <img src="<?php echo get_template_directory_uri(); ?>/assets/images/payments.png" alt="Payment methods" class="img-fluid mb-3">
                    <div class="social-icons">
                        <img src="<?php echo get_template_directory_uri(); ?>/assets/images/social-media.png" alt="Social media" class="img-fluid">
                    </div>
                </div>
            </div>
            <hr class="my-4">
            <div class="row">
                <div class="col-12">
                    <p class="text-center text-white-50 mb-0">
                        <?php echo get_theme_mod('footer_copyright', '"HolaFone" is a Marketing Brand of iQom Mobile Ltd. | Registered in England and Wales. Company Number 13675306 | Registered Office Address: 167-169 Great Portland Street, 5th Floor, W1W 5PF, London | VAT GB4526811778<br>Copyright 2025 All rights reserved. | iQom Mobile Ltd.'); ?>
                    </p>
                </div>
            </div>
        </div>
    </footer>

</div><!-- #page -->

<?php wp_footer(); ?>

</body>
</html>
