/**
 * HolaFone Theme JavaScript
 */

(function($) {
    'use strict';

    // Document ready
    $(document).ready(function() {
        
        // Initialize tooltips
        var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
        var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
            return new bootstrap.Tooltip(tooltipTriggerEl);
        });

        // Smooth scrolling for anchor links
        $('a[href*="#"]:not([href="#"])').click(function() {
            if (location.pathname.replace(/^\//, '') == this.pathname.replace(/^\//, '') && location.hostname == this.hostname) {
                var target = $(this.hash);
                target = target.length ? target : $('[name=' + this.hash.slice(1) + ']');
                if (target.length) {
                    $('html, body').animate({
                        scrollTop: target.offset().top - 100
                    }, 1000);
                    return false;
                }
            }
        });

        // Newsletter form submission
        $('.newsletter-form').on('submit', function(e) {
            e.preventDefault();
            
            var form = $(this);
            var submitBtn = form.find('button[type="submit"]');
            var originalText = submitBtn.text();
            
            // Disable submit button
            submitBtn.prop('disabled', true).text('Submitting...');
            
            $.ajax({
                url: holafone_ajax.ajax_url,
                type: 'POST',
                data: form.serialize(),
                success: function(response) {
                    alert('Thank you for subscribing to our newsletter!');
                    form[0].reset();
                },
                error: function() {
                    alert('There was an error. Please try again.');
                },
                complete: function() {
                    submitBtn.prop('disabled', false).text(originalText);
                }
            });
        });

        // Product image hover effect
        $('.product-card').hover(
            function() {
                $(this).find('.product-image img').addClass('hover-zoom');
            },
            function() {
                $(this).find('.product-image img').removeClass('hover-zoom');
            }
        );

        // Search form enhancement
        $('.search-box input[type="search"]').on('focus', function() {
            $(this).parent().addClass('search-focused');
        }).on('blur', function() {
            $(this).parent().removeClass('search-focused');
        });

        // Mobile menu enhancements
        $('.navbar-toggler').on('click', function() {
            $(this).toggleClass('active');
        });

        // Sticky header on scroll
        var header = $('.header-section');
        var headerHeight = header.outerHeight();
        
        $(window).scroll(function() {
            if ($(this).scrollTop() > headerHeight) {
                header.addClass('sticky-header');
            } else {
                header.removeClass('sticky-header');
            }
        });

        // Back to top button
        var backToTop = $('<button class="back-to-top btn btn-primary position-fixed" style="bottom: 20px; right: 20px; z-index: 1000; display: none;"><i class="fas fa-arrow-up"></i></button>');
        $('body').append(backToTop);
        
        $(window).scroll(function() {
            if ($(this).scrollTop() > 300) {
                backToTop.fadeIn();
            } else {
                backToTop.fadeOut();
            }
        });
        
        backToTop.on('click', function() {
            $('html, body').animate({scrollTop: 0}, 600);
        });

        // WooCommerce specific enhancements
        if (typeof wc_add_to_cart_params !== 'undefined') {
            
            // Update cart count after adding to cart
            $(document.body).on('added_to_cart', function() {
                $.ajax({
                    url: holafone_ajax.ajax_url,
                    type: 'POST',
                    data: {
                        action: 'update_cart_count'
                    },
                    success: function(response) {
                        $('.cart-count').text(response);
                        if (response > 0) {
                            $('.cart-count').show();
                        } else {
                            $('.cart-count').hide();
                        }
                    }
                });
            });

            // Product gallery enhancements
            $('.woocommerce-product-gallery').each(function() {
                $(this).addClass('enhanced-gallery');
            });
        }

        // FAQ accordion enhancements
        $('.accordion-button').on('click', function() {
            var icon = $(this).find('.accordion-icon');
            if ($(this).hasClass('collapsed')) {
                icon.removeClass('fa-minus').addClass('fa-plus');
            } else {
                icon.removeClass('fa-plus').addClass('fa-minus');
            }
        });

        // Category cards hover effect
        $('.category-card').hover(
            function() {
                $(this).find('.category-overlay').addClass('hover-effect');
            },
            function() {
                $(this).find('.category-overlay').removeClass('hover-effect');
            }
        );

        // Lazy loading for images
        if ('IntersectionObserver' in window) {
            var imageObserver = new IntersectionObserver(function(entries, observer) {
                entries.forEach(function(entry) {
                    if (entry.isIntersecting) {
                        var img = entry.target;
                        img.src = img.dataset.src;
                        img.classList.remove('lazy');
                        imageObserver.unobserve(img);
                    }
                });
            });

            document.querySelectorAll('img[data-src]').forEach(function(img) {
                imageObserver.observe(img);
            });
        }

        // Form validation enhancements
        $('form').each(function() {
            $(this).on('submit', function(e) {
                var form = $(this);
                var isValid = true;
                
                form.find('input[required], textarea[required], select[required]').each(function() {
                    if (!$(this).val()) {
                        $(this).addClass('is-invalid');
                        isValid = false;
                    } else {
                        $(this).removeClass('is-invalid').addClass('is-valid');
                    }
                });
                
                if (!isValid) {
                    e.preventDefault();
                    form.find('.is-invalid').first().focus();
                }
            });
        });

        // Price filter for WooCommerce
        if ($('.price-filter').length) {
            $('.price-filter input').on('change', function() {
                var minPrice = $('#min-price').val();
                var maxPrice = $('#max-price').val();
                var currentUrl = new URL(window.location);
                
                if (minPrice) {
                    currentUrl.searchParams.set('min_price', minPrice);
                } else {
                    currentUrl.searchParams.delete('min_price');
                }
                
                if (maxPrice) {
                    currentUrl.searchParams.set('max_price', maxPrice);
                } else {
                    currentUrl.searchParams.delete('max_price');
                }
                
                window.location.href = currentUrl.toString();
            });
        }

        // Product quick view (if implemented)
        $('.quick-view-btn').on('click', function(e) {
            e.preventDefault();
            var productId = $(this).data('product-id');
            
            // Implementation for quick view modal
            // This would require additional backend support
        });

        // Wishlist functionality (if implemented)
        $('.wishlist-btn').on('click', function(e) {
            e.preventDefault();
            var productId = $(this).data('product-id');
            var btn = $(this);
            
            $.ajax({
                url: holafone_ajax.ajax_url,
                type: 'POST',
                data: {
                    action: 'toggle_wishlist',
                    product_id: productId,
                    nonce: holafone_ajax.nonce
                },
                success: function(response) {
                    if (response.success) {
                        btn.toggleClass('active');
                        btn.find('i').toggleClass('far fas');
                    }
                }
            });
        });

    });

    // Window load
    $(window).on('load', function() {
        // Hide loading spinner if present
        $('.loading-spinner').fadeOut();
        
        // Initialize any plugins that need to wait for  full page load
        
        // Masonry layout for product grids (if needed)
        if ($('.products').length && typeof $.fn.masonry !== 'undefined') {
            $('.products').masonry({
                itemSelector: '.product',
                columnWidth: '.product',
                percentPosition: true
            });
        }
        
        // Initialize AOS (Animate On Scroll) if included
        if (typeof AOS !== 'undefined') {
            AOS.init({
                duration: 800,
                easing: 'ease-in-out',
                once: true
            });
        }
    });

    // Window resize
    $(window).on('resize', function() {
        // Recalculate any responsive elements
        if ($('.products').length && typeof $.fn.masonry !== 'undefined') {
            $('.products').masonry('layout');
        }
    });

})(jQuery);

// Vanilla JavaScript for performance-critical operations
document.addEventListener('DOMContentLoaded', function() {
    
    // Service Worker registration for PWA (if implemented)
    if ('serviceWorker' in navigator) {
        navigator.serviceWorker.register('/sw.js')
            .then(function(registration) {
                console.log('SW registered: ', registration);
            })
            .catch(function(registrationError) {
                console.log('SW registration failed: ', registrationError);
            });
    }
    
    // Performance monitoring
    if ('performance' in window) {
        window.addEventListener('load', function() {
            setTimeout(function() {
                var perfData = performance.getEntriesByType('navigation')[0];
                if (perfData.loadEventEnd - perfData.loadEventStart > 3000) {
                    console.warn('Page load time is slow');
                }
            }, 0);
        });
    }
    
    // Critical CSS loading optimization
    var criticalCSS = document.querySelector('style[data-critical]');
    if (criticalCSS) {
        var link = document.createElement('link');
        link.rel = 'stylesheet';
        link.href = criticalCSS.dataset.href;
        document.head.appendChild(link);
    }
});
