# HolaFone WordPress Theme

A modern, responsive WordPress theme designed specifically for HolaFone - a refurbished electronics store with full WooCommerce compatibility.

## Features

### Design & Layout
- **Responsive Design**: Mobile-first approach using Bootstrap 5
- **Modern UI**: Clean, professional design with custom color scheme
- **Hero Banner**: Eye-catching banner with customizable content
- **Product Showcase**: Dedicated sections for best-selling items
- **Category Display**: Visual product category cards
- **FAQ Section**: Collapsible FAQ accordion

### WooCommerce Integration
- **Full WooCommerce Support**: Complete e-commerce functionality
- **Custom Product Fields**: Refurbishment grade, battery health, accessories
- **Discount Badges**: Visual sale indicators on products
- **Enhanced Product Pages**: Additional refurbishment information
- **Custom Checkout**: Bootstrap-styled checkout process
- **Cart Integration**: Header cart with live count updates

### Performance & SEO
- **Optimized Loading**: Lazy loading, minified assets
- **SEO Friendly**: Proper heading structure, meta tags
- **Fast Performance**: Optimized code and assets
- **Security Headers**: Built-in security enhancements
- **Clean Code**: Well-structured, commented code

### Customization
- **WordPress Customizer**: Easy theme customization
- **Custom Colors**: Brand color management
- **Logo Support**: Custom logo integration
- **Menu Locations**: Multiple navigation areas
- **Widget Areas**: Flexible sidebar options

## Installation

### Requirements
- WordPress 5.0 or higher
- PHP 7.4 or higher
- WooCommerce 5.0 or higher (recommended)

### Installation Steps
1. Download the theme files
2. Upload to `/wp-content/themes/holafone/`
3. Activate the theme in WordPress admin
4. Install and activate WooCommerce
5. Configure theme settings in Customizer

## Theme Structure

```
holafone/
├── style.css                 # Main stylesheet & theme info
├── index.php                 # Homepage template
├── header.php                # Header template
├── footer.php                # Footer template
├── functions.php             # Theme functions
├── woocommerce.php           # WooCommerce template
├── screenshot.png            # Theme screenshot
├── inc/
│   ├── bootstrap-nav-walker.php  # Bootstrap navigation
│   ├── customizer.php            # Theme customizer
│   └── woocommerce.php           # WooCommerce customizations
└── assets/
    ├── js/
    │   └── theme.js              # Theme JavaScript
    ├── css/
    │   └── admin.css             # Admin styles
    └── images/                   # Theme images
```

## Customization

### Theme Customizer Options
- **Hero Section**: Title, background image
- **About Section**: Content customization
- **Colors**: Primary and secondary colors
- **Footer**: Copyright text

### Menu Locations
- **Primary Menu**: Main navigation
- **Top Menu**: Secondary top navigation
- **Footer Links**: Footer navigation
- **Footer Legal**: Legal links

### Custom Post Types
- **FAQ**: Frequently asked questions management

### WooCommerce Customizations
- **Product Grades**: Excellent, Very Good, Good, Fair
- **Battery Health**: Percentage indicator
- **Accessories**: Included items tracking
- **Custom Tabs**: Refurbishment information

## Development

### CSS Framework
- Bootstrap 5.3.0
- Custom CSS variables for theming
- Responsive breakpoints
- Utility classes

### JavaScript Libraries
- jQuery (WordPress default)
- Bootstrap JS
- Custom theme scripts
- AJAX functionality

### PHP Features
- Object-oriented approach
- WordPress coding standards
- Security best practices
- Performance optimization

## Browser Support
- Chrome (latest)
- Firefox (latest)
- Safari (latest)
- Edge (latest)
- Internet Explorer 11+

## Changelog

### Version 1.0
- Initial release
- Bootstrap 5 integration
- WooCommerce compatibility
- Custom product fields
- Responsive design
- Theme customizer options

## Support

For support and customization requests, please contact the HolaFone development team.

## License

This theme is proprietary software developed specifically for HolaFone. All rights reserved.

## Credits

- **Bootstrap**: https://getbootstrap.com/
- **Font Awesome**: https://fontawesome.com/
- **Google Fonts**: https://fonts.google.com/
- **WordPress**: https://wordpress.org/
- **WooCommerce**: https://woocommerce.com/
